#include "rheolef.h"
using namespace std;
using namespace rheolef;
#include "sphere.icc"
int main (int argc, char**argv) {
  environment rheolef(argc, argv);
  Float tol = (argc > 1) ? atof(argv[1]) : 1e+38;
  field uh; din >> uh;
  const space& Wh = uh.get_space();
  quadrature_option_type qopt;
  trial u (Wh); test v (Wh);
  form m = integrate (u*v);
  form a = integrate (dot(grad_s(u),grad_s(v)));
  size_t d = Wh.get_geo().dimension();
  field pi_h_u = interpolate(Wh, u_exact(d));
  field eh = uh - pi_h_u;
  dout << "err_l2   " << sqrt(m(eh,eh)) << endl
       << "err_h1   " << sqrt(a(eh,eh)) << endl
       << "err_linf " << eh.max_abs()   << endl;
  return (eh.max_abs() < tol) ? 0 : 1;
}
