# -*- coding: utf-8 -*-

# Copyright 2012 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# In addition, as a special exception, the copyright holders give
# permission to link the code of portions of this program with the
# OpenSSL library under certain conditions as described in each
# individual source file, and distribute linked combinations
# including the two.
# You must obey the GNU General Public License in all respects
# for all of the code used other than OpenSSL.  If you modify
# file(s) with this exception, you may extend this exception to your
# version of the file(s), but you are not obligated to do so.  If you
# do not wish to do so, delete this exception statement from your
# version.  If you delete this exception statement from all source
# files in the program, then also delete it here.
"""The test suite for Network Detection UI."""

from PyQt4 import QtGui

from ubuntu_sso.qt import network_detection_page
from ubuntu_sso.qt.tests import (
    FakeSignal,
    PageBaseTestCase,
    FakeWizardButtonStyle,
)

# is ok to access private method/attrs in tests
# pylint: disable=W0212, E1101


class NetworkDetectionTestCase(PageBaseTestCase):

    """Test the CurrentUserController."""

    ui_class = network_detection_page.NetworkDetectionPage
    ui_wizard_class = FakeWizardButtonStyle

    def test_initialize_page(self):
        """Check Network detection initialize page."""
        self.ui.initializePage()
        self.assertEqual(self.wizard._next_id, -1)
        self.assertTrue(('setButtonLayout', ([
            QtGui.QWizard.Stretch,
            QtGui.QWizard.CustomButton1,
            QtGui.QWizard.CancelButton], {})),
            self.wizard.called)

    def test_initialize_page_button_property(self):
        """Test the Try Again button properties."""
        self.ui.initializePage()
        self.assertTrue(self.ui.btn_try_again.isDefault())

    def test_try_again_with_connection(self):
        """Check try again method with connection."""
        self.patch(network_detection_page.networkstate, 'is_machine_connected',
            lambda: True)
        fake_signal = FakeSignal()
        fake_signal.target = self._set_called
        self.patch(self.ui, 'connectionDetected', fake_signal)
        self.ui.try_again()
        self.assertEqual(self._called, ((), {}))

    def test_try_again_without_connection(self):
        """Check try again method without connection."""
        self.patch(network_detection_page.networkstate, 'is_machine_connected',
            lambda: False)
        fake_signal = FakeSignal()
        fake_signal.target = self._set_called
        self.patch(self.ui, 'connectionDetected', fake_signal)
        self.ui.try_again()
        self.assertFalse(self._called)
