(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     84880,       1468]
NotebookOptionsPosition[     84356,       1446]
NotebookOutlinePosition[     84691,       1461]
CellTagsIndexPosition[     84648,       1458]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
This file is a sample file used to plot the output of ' highdim.xmds' in the \
latest version of Mathematica.  After running the program, use the command :
  > xsil2graphics - e highdim.xsil

Then run the cell below after altering the directory path to your local \
directory.\
\>", "Text",
 CellChangeTimes->{{3.406765836414184*^9, 3.406765938748354*^9}, 
   3.40676597339749*^9},
 FormatType->"TextForm",
 FontSize->18],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
   "SetDirectory", "[", 
    "\"\</Users/joe/Applications/xmds/xmds-devel/examples\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"<<", "highdim.nb"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot3D", "[", 
   RowBox[{"atoms1", ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"DataRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Min", "[", "x1", "]"}], ",", 
         RowBox[{"Max", "[", "x1", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Min", "[", "t1", "]"}], ",", 
         RowBox[{"Max", "[", "t1", "]"}]}], "}"}]}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ListPlot3D", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"atomsr3", "[", 
        RowBox[{"[", 
         RowBox[{"t", ",", "x", ",", "i", ",", "j"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "y3", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", 
         RowBox[{"Length", "[", "z3", "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", 
     RowBox[{"Length", "[", "x3", "]"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "1", ",", 
     RowBox[{"Length", "[", "t3", "]"}], ",", "1"}], "}"}]}], "]"}]}], "Input",\

 CellChangeTimes->{{3.406765646091586*^9, 3.40676571725424*^9}, {
   3.406765979399116*^9, 3.406765982285563*^9}, {3.407313044049749*^9, 
   3.407313047910437*^9}, 3.407313173983762*^9, {3.40731524453581*^9, 
   3.407315246107214*^9}, {3.4073163620522203`*^9, 3.407316379036456*^9}, {
   3.407316414749365*^9, 3.407316423965391*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nHk4Vdv7wE2VpDIXITKUqAyRVKvsbUqRDNEhwjmhJGQslUqzBs0paZBG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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwt2HW8VUUXxvHZMwcLEBXp7gaD7u4GaUQR6ZSW7u4WMJAGERURUUTFQrAD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         "]], Polygon3DBox[CompressedData["
1:eJw1mQfYVMUVhu/O/IJIBztIUxQQUJoNkGaviL0hgtgVEBVFRbrYFaWDGmOJ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         "]], 
        Polygon3DBox[CompressedData["
1:eJwt13f8iFUbx/Gf330bZbaXQlPSJlEeoT20rYZQD5VIj8gokZJCkrY90yZk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         "]]}]}, {}, {}, {}}, {
     {GrayLevel[0], 
      Line3DBox[{177, 1, 493, 17, 510, 511, 33, 541, 49, 558, 559, 65, 589, 
       81, 606, 607, 97, 638, 639, 113, 669, 129, 686, 687, 145, 717, 161, 
       327, 162, 328, 163, 329, 164, 330, 165, 331, 166, 332, 167, 333, 168, 
       334, 169, 335, 170, 336, 171, 337, 172, 338, 173, 339, 174, 340, 175, 
       341, 176, 731, 160, 715, 714, 144, 683, 128, 667, 666, 112, 635, 634, 
       96, 603, 80, 587, 586, 64, 555, 48, 539, 538, 32, 507, 16, 205, 15, 
       203, 14, 201, 13, 199, 12, 197, 11, 195, 10, 193, 9, 191, 8, 189, 7, 
       187, 6, 185, 5, 183, 4, 181, 3, 179, 2, 177}]}, {
      Line3DBox[{493, 844, 1069, 492, 845, 1070, 494, 846, 1071, 495, 847, 
       1072, 496, 848, 1073, 497, 957, 732, 498, 958, 733, 499, 959, 734, 500,
        960, 735, 501, 961, 736, 502, 962, 737, 503, 963, 738, 504, 964, 739, 
       505, 965, 740, 506, 966, 741, 507}], 
      Line3DBox[{511, 850, 1075, 509, 967, 742, 513, 968, 743, 515, 969, 744, 
       517, 970, 745, 519, 971, 746, 521, 972, 747, 523, 973, 748, 525, 974, 
       749, 527, 975, 750, 529, 976, 751, 531, 978, 753, 533, 980, 755, 535, 
       982, 757, 537, 984, 759, 539}], 
      Line3DBox[{538, 758, 983, 536, 756, 981, 534, 754, 979, 532, 752, 977, 
       530, 1085, 860, 528, 1084, 859, 526, 1083, 858, 524, 1082, 857, 522, 
       1081, 856, 520, 1080, 855, 518, 1079, 854, 516, 1078, 853, 514, 1077, 
       852, 512, 1076, 851, 508, 1074, 849, 510}], 
      Line3DBox[{541, 861, 1086, 540, 862, 1087, 542, 863, 1088, 543, 864, 
       1089, 544, 865, 1090, 545, 866, 1091, 546, 867, 1092, 547, 985, 760, 
       548, 986, 761, 549, 987, 762, 550, 988, 763, 551, 989, 764, 552, 990, 
       765, 553, 991, 766, 554, 992, 767, 555}], 
      Line3DBox[{559, 869, 1094, 557, 871, 1096, 561, 873, 1098, 563, 993, 
       768, 565, 994, 769, 567, 995, 770, 569, 996, 771, 571, 997, 772, 573, 
       998, 773, 575, 999, 774, 577, 1000, 775, 579, 1001, 776, 581, 1002, 
       777, 583, 1004, 779, 585, 1006, 781, 587}], 
      Line3DBox[{586, 780, 1005, 584, 778, 1003, 582, 1108, 883, 580, 1107, 
       882, 578, 1106, 881, 576, 1105, 880, 574, 1104, 879, 572, 1103, 878, 
       570, 1102, 877, 568, 1101, 876, 566, 1100, 875, 564, 1099, 874, 562, 
       1097, 872, 560, 1095, 870, 556, 1093, 868, 558}], 
      Line3DBox[{589, 884, 1109, 588, 885, 1110, 590, 886, 1111, 591, 887, 
       1112, 592, 888, 1113, 593, 889, 1114, 594, 890, 1115, 595, 891, 1116, 
       596, 892, 1117, 597, 1007, 782, 598, 1008, 783, 599, 1009, 784, 600, 
       1010, 785, 601, 1011, 786, 602, 1012, 787, 603}], 
      Line3DBox[{607, 894, 1119, 605, 896, 1121, 609, 898, 1123, 611, 900, 
       1125, 613, 902, 1127, 615, 1013, 788, 617, 1014, 789, 619, 1015, 790, 
       621, 1016, 791, 623, 1017, 792, 625, 1018, 793, 627, 1019, 794, 629, 
       1020, 795, 631, 1021, 796, 633, 1022, 797, 635}], 
      Line3DBox[{634, 1137, 912, 632, 1136, 911, 630, 1135, 910, 628, 1134, 
       909, 626, 1133, 908, 624, 1132, 907, 622, 1131, 906, 620, 1130, 905, 
       618, 1129, 904, 616, 1128, 903, 614, 1126, 901, 612, 1124, 899, 610, 
       1122, 897, 608, 1120, 895, 604, 1118, 893, 606}], 
      Line3DBox[{639, 914, 1139, 637, 1023, 798, 641, 1024, 799, 643, 1025, 
       800, 645, 1026, 801, 647, 1027, 802, 649, 1028, 803, 651, 1029, 804, 
       653, 1030, 805, 655, 1031, 806, 657, 1032, 807, 659, 1034, 809, 661, 
       1036, 811, 663, 1038, 813, 665, 1040, 815, 667}], 
      Line3DBox[{666, 814, 1039, 664, 812, 1037, 662, 810, 1035, 660, 808, 
       1033, 658, 1149, 924, 656, 1148, 923, 654, 1147, 922, 652, 1146, 921, 
       650, 1145, 920, 648, 1144, 919, 646, 1143, 918, 644, 1142, 917, 642, 
       1141, 916, 640, 1140, 915, 636, 1138, 913, 638}], 
      Line3DBox[{669, 925, 1150, 668, 926, 1151, 670, 927, 1152, 671, 928, 
       1153, 672, 929, 1154, 673, 930, 1155, 674, 931, 1156, 675, 1041, 816, 
       676, 1042, 817, 677, 1043, 818, 678, 1044, 819, 679, 1045, 820, 680, 
       1046, 821, 681, 1047, 822, 682, 1048, 823, 683}], 
      Line3DBox[{687, 933, 1158, 685, 935, 1160, 689, 937, 1162, 691, 1049, 
       824, 693, 1050, 825, 695, 1051, 826, 697, 1052, 827, 699, 1053, 828, 
       701, 1054, 829, 703, 1055, 830, 705, 1056, 831, 707, 1057, 832, 709, 
       1058, 833, 711, 1060, 835, 713, 1062, 837, 715}], 
      Line3DBox[{714, 836, 1061, 712, 834, 1059, 710, 1172, 947, 708, 1171, 
       946, 706, 1170, 945, 704, 1169, 944, 702, 1168, 943, 700, 1167, 942, 
       698, 1166, 941, 696, 1165, 940, 694, 1164, 939, 692, 1163, 938, 690, 
       1161, 936, 688, 1159, 934, 684, 1157, 932, 686}], 
      Line3DBox[{717, 948, 1173, 716, 949, 1174, 718, 950, 1175, 719, 951, 
       1176, 720, 952, 1177, 721, 953, 1178, 722, 954, 1179, 723, 955, 1180, 
       724, 956, 1181, 725, 1063, 838, 726, 1064, 839, 727, 1065, 840, 728, 
       1066, 841, 729, 1067, 842, 730, 1068, 843, 731}]}, {
      Line3DBox[{177, 1069, 342, 178, 1074, 1075, 357, 207, 1086, 372, 222, 
       1093, 1094, 387, 237, 1109, 402, 252, 1118, 1119, 417, 267, 1138, 1139,
        432, 282, 1150, 447, 297, 1157, 1158, 462, 312, 1173, 477, 327}], 
      Line3DBox[{179, 1070, 343, 180, 1076, 358, 967, 208, 1087, 373, 223, 
       1095, 1096, 388, 238, 1110, 403, 253, 1120, 1121, 418, 268, 1140, 433, 
       1023, 283, 1151, 448, 298, 1159, 1160, 463, 313, 1174, 478, 328}], 
      Line3DBox[{181, 1071, 344, 182, 1077, 359, 968, 209, 1088, 374, 224, 
       1097, 1098, 389, 239, 1111, 404, 254, 1122, 1123, 419, 269, 1141, 434, 
       1024, 284, 1152, 449, 299, 1161, 1162, 464, 314, 1175, 479, 329}], 
      Line3DBox[{183, 1072, 345, 184, 1078, 360, 969, 210, 1089, 375, 225, 
       1099, 390, 993, 240, 1112, 405, 255, 1124, 1125, 420, 270, 1142, 435, 
       1025, 285, 1153, 450, 300, 1163, 465, 1049, 315, 1176, 480, 330}], 
      Line3DBox[{185, 1073, 346, 186, 1079, 361, 970, 211, 1090, 376, 226, 
       1100, 391, 994, 241, 1113, 406, 256, 1126, 1127, 421, 271, 1143, 436, 
       1026, 286, 1154, 451, 301, 1164, 466, 1050, 316, 1177, 481, 331}], 
      Line3DBox[{187, 347, 957, 188, 1080, 362, 971, 212, 1091, 377, 227, 
       1101, 392, 995, 242, 1114, 407, 257, 1128, 422, 1013, 272, 1144, 437, 
       1027, 287, 1155, 452, 302, 1165, 467, 1051, 317, 1178, 482, 332}], 
      Line3DBox[{189, 348, 958, 190, 1081, 363, 972, 213, 1092, 378, 228, 
       1102, 393, 996, 243, 1115, 408, 258, 1129, 423, 1014, 273, 1145, 438, 
       1028, 288, 1156, 453, 303, 1166, 468, 1052, 318, 1179, 483, 333}], 
      Line3DBox[{191, 349, 959, 192, 1082, 364, 973, 214, 379, 985, 229, 1103,
        394, 997, 244, 1116, 409, 259, 1130, 424, 1015, 274, 1146, 439, 1029, 
       289, 454, 1041, 304, 1167, 469, 1053, 319, 1180, 484, 334}], 
      Line3DBox[{193, 350, 960, 194, 1083, 365, 974, 215, 380, 986, 230, 1104,
        395, 998, 245, 1117, 410, 260, 1131, 425, 1016, 275, 1147, 440, 1030, 
       290, 455, 1042, 305, 1168, 470, 1054, 320, 1181, 485, 335}], 
      Line3DBox[{195, 351, 961, 196, 1084, 366, 975, 216, 381, 987, 231, 1105,
        396, 999, 246, 411, 1007, 261, 1132, 426, 1017, 276, 1148, 441, 1031, 
       291, 456, 1043, 306, 1169, 471, 1055, 321, 486, 1063, 336}], 
      Line3DBox[{197, 352, 962, 198, 1085, 367, 976, 217, 382, 988, 232, 1106,
        397, 1000, 247, 412, 1008, 262, 1133, 427, 1018, 277, 1149, 442, 1032,
        292, 457, 1044, 307, 1170, 472, 1056, 322, 487, 1064, 337}], 
      Line3DBox[{199, 353, 963, 200, 368, 977, 978, 218, 383, 989, 233, 1107, 
       398, 1001, 248, 413, 1009, 263, 1134, 428, 1019, 278, 443, 1033, 1034, 
       293, 458, 1045, 308, 1171, 473, 1057, 323, 488, 1065, 338}], 
      Line3DBox[{201, 354, 964, 202, 369, 979, 980, 219, 384, 990, 234, 1108, 
       399, 1002, 249, 414, 1010, 264, 1135, 429, 1020, 279, 444, 1035, 1036, 
       294, 459, 1046, 309, 1172, 474, 1058, 324, 489, 1066, 339}], 
      Line3DBox[{203, 355, 965, 204, 370, 981, 982, 220, 385, 991, 235, 400, 
       1003, 1004, 250, 415, 1011, 265, 1136, 430, 1021, 280, 445, 1037, 1038,
        295, 460, 1047, 310, 475, 1059, 1060, 325, 490, 1067, 340}], 
      Line3DBox[{205, 356, 966, 206, 371, 983, 984, 221, 386, 992, 236, 401, 
       1005, 1006, 251, 416, 1012, 266, 1137, 431, 1022, 281, 446, 1039, 1040,
        296, 461, 1048, 311, 476, 1061, 1062, 326, 491, 1068, 
       341}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJxcvHk81c/7Pi6htMiWrc2+70vlzJMhQqQosq9lLWVfy15SSqgIkZJQkuzC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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  ImageSize->{360., 262.27713832694536`},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  ViewPoint->{2.1491248020917535`, -2.117032254415456, 1.5327873364556128`},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{{3.406765675863799*^9, 3.406765686746913*^9}, 
   3.406765720280673*^9, 3.407312947506917*^9, 3.4073130489365788`*^9, 
   3.407313175541992*^9, 3.407313380393078*^9, 3.407315084108781*^9, 
   3.407315142183584*^9, 3.4073163157572927`*^9, 3.407316380529451*^9, 
   3.4073164440393763`*^9, 3.407316490406719*^9, 3.408743219472472*^9, 
   3.408744633940255*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 2, $CellContext`x$$ = 4, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 1, 4, 1}, {
      Hold[$CellContext`t$$], 1, 2, 1}}, Typeset`size$$ = {
    360., {132., 137.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`x$1676$$ = 
    0, $CellContext`t$1677$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`t$$ = 1, $CellContext`x$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$1676$$, 0], 
        Hold[$CellContext`t$$, $CellContext`t$1677$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ListPlot3D[
        Table[
         Part[$CellContext`atomsr3, $CellContext`t$$, $CellContext`x$$, \
$CellContext`i, $CellContext`j], {$CellContext`i, 1, 
          Length[$CellContext`y3]}, {$CellContext`j, 1, 
          Length[$CellContext`z3]}], PlotRange -> All], 
      "Specifications" :> {{$CellContext`x$$, 1, 4, 1}, {$CellContext`t$$, 1, 
         2, 1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{402., {189.375, 194.625}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.406765675863799*^9, 3.406765686746913*^9}, 
   3.406765720280673*^9, 3.407312947506917*^9, 3.4073130489365788`*^9, 
   3.407313175541992*^9, 3.407313380393078*^9, 3.407315084108781*^9, 
   3.407315142183584*^9, 3.4073163157572927`*^9, 3.407316380529451*^9, 
   3.4073164440393763`*^9, 3.407316490406719*^9, 3.408743219472472*^9, 
   3.408744634105131*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ListPlot3D", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"moleculesr3", "[", 
        RowBox[{"[", 
         RowBox[{"t", ",", "x", ",", "i", ",", "j"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "y3", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", 
         RowBox[{"Length", "[", "z3", "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", 
     RowBox[{"Length", "[", "x3", "]"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "1", ",", 
     RowBox[{"Length", "[", "t3", "]"}], ",", "1"}], "}"}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.4067657617113113`*^9, 3.4067657659534473`*^9}, {
  3.407312993921043*^9, 3.407313014398695*^9}, {3.407313194375691*^9, 
  3.407313231564951*^9}, {3.407316328991769*^9, 3.407316331456567*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 2, $CellContext`x$$ = 4, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 1, 4, 1}, {
      Hold[$CellContext`t$$], 1, 2, 1}}, Typeset`size$$ = {
    360., {132., 137.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`x$1765$$ = 
    0, $CellContext`t$1766$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`t$$ = 1, $CellContext`x$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$1765$$, 0], 
        Hold[$CellContext`t$$, $CellContext`t$1766$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ListPlot3D[
        Table[
         Part[$CellContext`moleculesr3, $CellContext`t$$, $CellContext`x$$, \
$CellContext`i, $CellContext`j], {$CellContext`i, 1, 
          Length[$CellContext`y3]}, {$CellContext`j, 1, 
          Length[$CellContext`z3]}], PlotRange -> All], 
      "Specifications" :> {{$CellContext`x$$, 1, 4, 1}, {$CellContext`t$$, 1, 
         2, 1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{402., {189.375, 194.625}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.40676576688666*^9, 3.4073130157133293`*^9, 
  3.40731323290305*^9, 3.407315095681476*^9, 3.407316332751369*^9, 
  3.408744698917877*^9}]
}, Open  ]]
},
WindowSize->{811, 1074},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (June 19, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 431, 11, 116, "Text"],
Cell[CellGroupData[{
Cell[1024, 36, 1980, 53, 133, "Input"],
Cell[3007, 91, 75893, 1230, 277, "Output"],
Cell[78903, 1323, 2287, 45, 402, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81227, 1373, 1039, 26, 43, "Input"],
Cell[82269, 1401, 2071, 42, 402, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
