/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nwjs;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.debugger.CommandLineDebugConfigurator;
import com.intellij.javascript.debugger.DebugPortConfigurator;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import com.intellij.javascript.debugger.execution.DebuggableProcessState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.Url;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import com.jetbrains.nwjs.NwjsProcessHandler;
import com.jetbrains.nwjs.NwjsProcessStateKt;
import com.jetbrains.nwjs.NwjsRunConfiguration;
import com.jetbrains.nwjs.NwjsVmConnection;
import java.io.File;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J+\u0010\u000f\u001a\u0015\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0010H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u001a\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0014R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/nwjs/NwjsProcessState;", "Lcom/intellij/javascript/debugger/execution/DebuggableProcessState;", "Lcom/jetbrains/nwjs/NwjsRunConfiguration;", "configuration", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "<init>", "(Lcom/jetbrains/nwjs/NwjsRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "url", "Lcom/intellij/util/Url;", "vmConnection", "Lcom/jetbrains/debugger/wip/WipRemoteVmConnection;", "programParametersList", "", "", "startProcess", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/process/ProcessHandler;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "debugPort", "", "prepareDebug", "", "configureCommandLine", "", "initProgramParameters", "createProcessHandler", "configurator", "Lcom/intellij/javascript/debugger/CommandLineDebugConfigurator;", "intellij.javascript.chrome.connector"})
@SourceDebugExtension(value={"SMAP\nNwjsProcessState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NwjsProcessState.kt\ncom/jetbrains/nwjs/NwjsProcessState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n1#2:208\n*E\n"})
public final class NwjsProcessState
extends DebuggableProcessState<NwjsRunConfiguration> {
    @Nullable
    private Url url;
    @Nullable
    private WipRemoteVmConnection vmConnection;
    @Nullable
    private List<String> programParametersList;

    public NwjsProcessState(@NotNull NwjsRunConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super((DebuggableProcessRunConfiguration)configuration, environment);
    }

    @NotNull
    protected Promise<ProcessHandler> startProcess(@NotNull GeneralCommandLine commandLine, int debugPort) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Promise promise = this.prepareDebug().thenAsync(arg_0 -> NwjsProcessState.startProcess$lambda$0(this, commandLine, debugPort, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"thenAsync(...)");
        return promise;
    }

    private final Promise<Object> prepareDebug() {
        this.initProgramParameters();
        String rawUrl = null;
        Collection collection = this.programParametersList;
        if (!(collection == null || collection.isEmpty())) {
            List<String> list = this.programParametersList;
            Intrinsics.checkNotNull(list);
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String param = iterator.next();
                if (StringsKt.startsWith$default((String)param, (String)"--remote-debugging-port=", (boolean)false, (int)2, null)) {
                    iterator.remove();
                    continue;
                }
                if (!StringsKt.startsWith$default((String)param, (String)"--rawUrl=", (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)param.substring(9), (String)"substring(...)");
                iterator.remove();
            }
        }
        if (rawUrl == null) {
            File file = new File(this.getInputPath());
            if (file.isDirectory()) {
                rawUrl = NwjsProcessStateKt.access$getMainUrlFromManifest(file);
            } else {
                Object[] objectArray;
                if (file.isFile()) {
                    AsyncPromise callback = new AsyncPromise();
                    Project project = this.getEnvironment().getProject();
                    String string = JSDebuggerBundle.message((String)"nwjs.progress.title.unpacking.nw.js.app", (Object[])new Object[0]);
                    ProgressManager.getInstance().run((Task)new Task.Backgroundable(file, this, (AsyncPromise<Object>)callback, project, string){
                        final /* synthetic */ File $file;
                        final /* synthetic */ NwjsProcessState this$0;
                        final /* synthetic */ AsyncPromise<Object> $callback;
                        {
                            this.$file = $file;
                            this.this$0 = $receiver;
                            this.$callback = $callback;
                            super($super_call_param$1, $super_call_param$2);
                        }

                        public void run(ProgressIndicator indicator) {
                            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                            try {
                                File file = FileUtil.createTempDirectory((String)"NW.js", (String)"idea");
                                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
                                File tempDirectory = file;
                                ZipUtil.unzip((ProgressIndicator)indicator, (File)tempDirectory, (File)this.$file, null, null, (boolean)true);
                                String string = NwjsProcessStateKt.access$getMainUrlFromManifest(tempDirectory);
                                String string2 = tempDirectory.getPath();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                                NwjsProcessState.access$setUrl$p(this.this$0, NwjsProcessStateKt.access$parseRawUrl(string, string2));
                            }
                            catch (Exception e) {
                                this.$callback.setError((Throwable)e);
                                NwjsProcessStateKt.access$getLOG$p().error("Cannot unpack packaged app " + this.$file.getPath(), (Throwable)e);
                            }
                        }

                        public void onCancel() {
                            this.$callback.setError("canceled");
                        }

                        public void onSuccess() {
                            this.$callback.setResult(null);
                        }
                    });
                    return (Promise)callback;
                }
                if (!file.exists()) {
                    objectArray = new Object[]{file.getPath()};
                    throw new ExecutionException(JSDebuggerBundle.message((String)"nwjs.error.app.doesnt.exist", (Object[])objectArray));
                }
                objectArray = new Object[]{file.getPath()};
                throw new ExecutionException(JSDebuggerBundle.message((String)"nwjs.error.unknown.file", (Object[])objectArray));
            }
        }
        this.url = NwjsProcessStateKt.access$parseRawUrl(rawUrl, this.getInputPath());
        return Promises.resolvedPromise();
    }

    protected void configureCommandLine(@NotNull GeneralCommandLine commandLine, int debugPort) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        super.configureCommandLine(commandLine, debugPort);
        if (debugPort == -1) {
            this.initProgramParameters();
        } else {
            NwjsProcessStateKt.access$getLOG$p().assertTrue(this.url != null);
            commandLine.addParameter("--remote-debugging-port=" + debugPort);
            if (SystemProperties.getBooleanProperty((String)"nodewebkit.use.bootstrap", (boolean)false)) {
                Base64.Encoder encoder = Base64.getEncoder();
                String string = "<!DOCTYPE html><title>Loading " + this.url + "</title>";
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                String bootstrapUrl = "data:text/html;base64," + encoder.encodeToString(byArray);
                commandLine.addParameter("--url=" + bootstrapUrl);
                this.vmConnection = new WipRemoteVmConnection(this.url, bootstrapUrl);
            } else {
                this.vmConnection = new NwjsVmConnection();
            }
        }
        List<String> list = this.programParametersList;
        if (list != null) {
            List<String> it = list;
            boolean bl = false;
            commandLine.addParameters(it);
        }
        this.addInputPathArg(commandLine);
    }

    private final void initProgramParameters() {
        List list;
        NwjsProcessState nwjsProcessState = this;
        String string = ((NwjsRunConfiguration)this.getConfiguration()).getProgramParameters();
        if (string != null) {
            String it = string;
            NwjsProcessState nwjsProcessState2 = nwjsProcessState;
            boolean bl = false;
            list = ParametersListUtil.parse((String)it);
            nwjsProcessState = nwjsProcessState2;
        } else {
            list = null;
        }
        nwjsProcessState.programParametersList = list;
    }

    @NotNull
    protected ProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine, @Nullable CommandLineDebugConfigurator configurator) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        if (!(configurator instanceof DebugPortConfigurator)) {
            return super.createProcessHandler(commandLine, configurator);
        }
        WipRemoteVmConnection wipRemoteVmConnection = this.vmConnection;
        Intrinsics.checkNotNull((Object)((Object)wipRemoteVmConnection));
        return (ProcessHandler)new NwjsProcessHandler(commandLine, wipRemoteVmConnection);
    }

    private static final Promise startProcess$lambda$0(NwjsProcessState this$0, GeneralCommandLine $commandLine, int $debugPort, Object it) {
        return super.startProcess($commandLine, $debugPort);
    }

    public static final /* synthetic */ void access$setUrl$p(NwjsProcessState $this, Url url) {
        $this.url = url;
    }
}

