/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.Function;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ExceptionData;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SuspendContextBase;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.wip.WipAsyncCallFrame;
import org.jetbrains.wip.WipBreakpoint;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipExceptionData;
import org.jetbrains.wip.WipReaderService;
import org.jetbrains.wip.WipScript;
import org.jetbrains.wip.WipSuspendContext;
import org.jetbrains.wip.WipSuspendContextKt;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.PausedEventAdditionalData;
import org.jetbrains.wip.protocol.WipProtocolReader;
import org.jetbrains.wip.protocol.debugger.LocationValue;
import org.jetbrains.wip.protocol.debugger.PausedEventData;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008f\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001/\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u00101\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020\u00062\b\u00102\u001a\u0004\u0018\u000103H\u0002J\u0010\u00104\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u00102\b\u00109\u001a\u0004\u0018\u00010:J\n\u0010A\u001a\u0006\u0012\u0002\b\u00030*R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0013\u001a\u0004\u0018\u00010\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0018\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010&R\u0011\u0010'\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010&R\u0010\u0010(\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u00190*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0010\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00100R\u0014\u0010;\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010&R\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0016\u0010B\u001a\u0004\u0018\u00010C8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010E\u00a8\u0006F"}, d2={"Lorg/jetbrains/wip/WipSuspendContext;", "Lorg/jetbrains/debugger/SuspendContextBase;", "Lorg/jetbrains/wip/WipCallFrame;", "vm", "Lorg/jetbrains/wip/WipVm;", "data", "Lorg/jetbrains/wip/protocol/debugger/PausedEventData;", "<init>", "(Lorg/jetbrains/wip/WipVm;Lorg/jetbrains/wip/protocol/debugger/PausedEventData;)V", "getVm", "()Lorg/jetbrains/wip/WipVm;", "valueManager", "Lorg/jetbrains/wip/WipValueManager;", "getValueManager", "()Lorg/jetbrains/wip/WipValueManager;", "hitBreakpoints", "", "", "value", "topFrame", "getTopFrame", "()Lorg/jetbrains/wip/WipCallFrame;", "setTopFrame", "(Lorg/jetbrains/wip/WipCallFrame;)V", "_frames", "", "[Lorg/jetbrains/wip/WipCallFrame;", "_asyncFrames", "Lorg/jetbrains/wip/WipAsyncCallFrame;", "[Lorg/jetbrains/wip/WipAsyncCallFrame;", "exceptionData", "Lorg/jetbrains/debugger/ExceptionData;", "getExceptionData", "()Lorg/jetbrains/debugger/ExceptionData;", "setExceptionData", "(Lorg/jetbrains/debugger/ExceptionData;)V", "isBreakOnStart", "", "()Z", "isBreakOnFirstStatement", "instrumentationBreakpointScriptId", "frames", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/CallFrame;", "getFrames", "()Lorg/jetbrains/concurrency/Promise;", "framesLoader", "org/jetbrains/wip/WipSuspendContext$framesLoader$1", "Lorg/jetbrains/wip/WipSuspendContext$framesLoader$1;", "isInstrumentationBreakpoint", "additionalDataObject", "Lorg/jetbrains/wip/protocol/PausedEventAdditionalData;", "isMeteorOnStartDebuggerStatement", "setFrames", "", "frameDataList", "Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;", "asyncFrameDataList", "Lorg/jetbrains/wip/protocol/runtime/StackTraceValue;", "hasUnresolvedBreakpointsHit", "getHasUnresolvedBreakpointsHit", "breakpointsHit", "Lorg/jetbrains/debugger/Breakpoint;", "getBreakpointsHit", "()Ljava/util/List;", "reloadFrames", "script", "Lorg/jetbrains/debugger/Script;", "getScript", "()Lorg/jetbrains/debugger/Script;", "intellij.javascript.wip.backend"})
@SourceDebugExtension(value={"SMAP\nWipSuspendContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WipSuspendContext.kt\norg/jetbrains/wip/WipSuspendContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1872#2,3:193\n37#3,2:196\n123#4:198\n1#5:199\n*S KotlinDebug\n*F\n+ 1 WipSuspendContext.kt\norg/jetbrains/wip/WipSuspendContext\n*L\n116#1:193,3\n121#1:196,2\n178#1:198\n*E\n"})
public final class WipSuspendContext
extends SuspendContextBase<WipCallFrame> {
    @NotNull
    private final WipVm vm;
    @NotNull
    private final WipValueManager valueManager;
    @Nullable
    private final List<String> hitBreakpoints;
    @Nullable
    private volatile WipCallFrame topFrame;
    @Nullable
    private volatile WipCallFrame[] _frames;
    @Nullable
    private volatile WipAsyncCallFrame[] _asyncFrames;
    @Nullable
    private ExceptionData exceptionData;
    private final boolean isBreakOnStart;
    private final boolean isBreakOnFirstStatement;
    @Nullable
    private final String instrumentationBreakpointScriptId;
    @NotNull
    private final framesLoader.1 framesLoader;

    public WipSuspendContext(@NotNull WipVm vm, @NotNull PausedEventData data) {
        String string;
        boolean isFirstPause;
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.vm = vm;
        this.valueManager = new WipValueManager(this.getVm(), "suspendContext");
        this.framesLoader = new AsyncValueLoader<CallFrame[]>(this){
            final /* synthetic */ WipSuspendContext this$0;
            {
                this.this$0 = $receiver;
            }

            protected Promise<CallFrame[]> load(AsyncPromise<CallFrame[]> result) {
                Intrinsics.checkNotNullParameter(result, (String)"result");
                WipCallFrame[] wipCallFrameArray = WipSuspendContext.access$get_frames$p(this.this$0);
                Intrinsics.checkNotNull((Object)wipCallFrameArray);
                int n = wipCallFrameArray.length;
                WipAsyncCallFrame[] wipAsyncCallFrameArray = WipSuspendContext.access$get_asyncFrames$p(this.this$0);
                Intrinsics.checkNotNull((Object)wipAsyncCallFrameArray);
                int n2 = n + wipAsyncCallFrameArray.length;
                CallFrame[] callFrameArray = new CallFrame[n2];
                for (int i = 0; i < n2; ++i) {
                    CallFrame callFrame;
                    int n3 = i;
                    WipCallFrame[] wipCallFrameArray2 = WipSuspendContext.access$get_frames$p(this.this$0);
                    Intrinsics.checkNotNull((Object)wipCallFrameArray2);
                    if (n3 < wipCallFrameArray2.length) {
                        WipCallFrame[] wipCallFrameArray3 = WipSuspendContext.access$get_frames$p(this.this$0);
                        Intrinsics.checkNotNull((Object)wipCallFrameArray3);
                        callFrame = wipCallFrameArray3[n3];
                    } else {
                        WipAsyncCallFrame[] wipAsyncCallFrameArray2 = WipSuspendContext.access$get_asyncFrames$p(this.this$0);
                        Intrinsics.checkNotNull((Object)wipAsyncCallFrameArray2);
                        WipCallFrame[] wipCallFrameArray4 = WipSuspendContext.access$get_frames$p(this.this$0);
                        Intrinsics.checkNotNull((Object)wipCallFrameArray4);
                        callFrame = wipAsyncCallFrameArray2[n3 - wipCallFrameArray4.length];
                    }
                    callFrameArray[n3] = callFrame;
                }
                return Promises.resolvedPromise((Object)callFrameArray);
            }
        };
        PausedEventData.Data additionalData = data.getData();
        PausedEventAdditionalData additionalDataObject = null;
        if ((data.reason() == PausedEventData.Reason.EXCEPTION || data.reason() == PausedEventData.Reason.PROMISE_REJECTION) && additionalData != null) {
            WipValueManager wipValueManager = this.getValueManager();
            WipProtocolReader wipProtocolReader = WipReaderService.get();
            JsonReaderEx jsonReaderEx = additionalData.getDeferredReader();
            Intrinsics.checkNotNullExpressionValue((Object)jsonReaderEx, (String)"getDeferredReader(...)");
            this.setExceptionData(new WipExceptionData(wipValueManager.createValue(wipProtocolReader.parseRemoteObjectValue(jsonReaderEx))));
            additionalDataObject = null;
        } else {
            PausedEventAdditionalData pausedEventAdditionalData;
            this.setExceptionData(null);
            if (additionalData != null) {
                WipProtocolReader wipProtocolReader = WipReaderService.get();
                JsonReaderEx jsonReaderEx = additionalData.getDeferredReader();
                Intrinsics.checkNotNullExpressionValue((Object)jsonReaderEx, (String)"getDeferredReader(...)");
                pausedEventAdditionalData = wipProtocolReader.parsePausedEventAdditionalData(jsonReaderEx);
            } else {
                pausedEventAdditionalData = null;
            }
            additionalDataObject = pausedEventAdditionalData;
        }
        Object isFirstPauseMarker = new Object();
        Collection collection = data.getHitBreakpoints();
        boolean bl = isFirstPause = (collection == null || collection.isEmpty()) && Intrinsics.areEqual((Object)this.getVm().putUserDataIfAbsent(WipSuspendContextKt.access$getIS_FIRST_PAUSE$p(), isFirstPauseMarker), (Object)isFirstPauseMarker);
        this.isBreakOnStart = data.reason() == PausedEventData.Reason.BREAK_ON_START || data.reason() == PausedEventData.Reason.DEBUG_COMMAND && ((collection = (Collection)data.getHitBreakpoints()) == null || collection.isEmpty()) || isFirstPause && Intrinsics.areEqual((Object)this.getVm().getUserData(WipSuspendContextKt.getSKIP_FIRST_PAUSE()), (Object)true);
        boolean isInstrumentationBreakpoint = this.isInstrumentationBreakpoint(data, additionalDataObject);
        boolean bl2 = this.isBreakOnFirstStatement = isInstrumentationBreakpoint || this.isMeteorOnStartDebuggerStatement(data);
        if (isInstrumentationBreakpoint) {
            PausedEventAdditionalData pausedEventAdditionalData = additionalDataObject;
            string = pausedEventAdditionalData != null ? pausedEventAdditionalData.scriptId() : null;
        } else {
            string = null;
        }
        this.instrumentationBreakpointScriptId = string;
        List<org.jetbrains.wip.protocol.debugger.CallFrameValue> callFrames = data.callFrames();
        this.setFrames(callFrames, data.getAsyncStackTrace());
        this.hitBreakpoints = data.getHitBreakpoints();
    }

    @NotNull
    public WipVm getVm() {
        return this.vm;
    }

    @NotNull
    public WipValueManager getValueManager() {
        return this.valueManager;
    }

    @Nullable
    public WipCallFrame getTopFrame() {
        return this.topFrame;
    }

    private void setTopFrame(WipCallFrame value) {
        this.topFrame = value;
    }

    @Nullable
    public ExceptionData getExceptionData() {
        return this.exceptionData;
    }

    public void setExceptionData(@Nullable ExceptionData exceptionData) {
        this.exceptionData = exceptionData;
    }

    public final boolean isBreakOnStart() {
        return this.isBreakOnStart;
    }

    public final boolean isBreakOnFirstStatement() {
        return this.isBreakOnFirstStatement;
    }

    @NotNull
    public Promise<CallFrame[]> getFrames() {
        Promise promise = this.framesLoader.get();
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"get(...)");
        return promise;
    }

    private final boolean isInstrumentationBreakpoint(PausedEventData data, PausedEventAdditionalData additionalDataObject) {
        if (data.reason() == PausedEventData.Reason.INSTRUMENTATION) {
            return true;
        }
        return data.reason() == PausedEventData.Reason.EVENT_LISTENER && additionalDataObject != null && Intrinsics.areEqual((Object)additionalDataObject.eventName(), (Object)"instrumentation:scriptFirstStatement");
    }

    private final boolean isMeteorOnStartDebuggerStatement(PausedEventData data) {
        WipScript script;
        org.jetbrains.wip.protocol.debugger.CallFrameValue topFrame;
        if (!Intrinsics.areEqual((Object)this.getVm().getUserData(WipSuspendContextKt.getIS_METEOR()), (Object)true)) {
            return false;
        }
        List<org.jetbrains.wip.protocol.debugger.CallFrameValue> callFrames = data.callFrames();
        if (!callFrames.isEmpty() && Intrinsics.areEqual((Object)(topFrame = callFrames.get(0)).functionName(), (Object)"exports.pause") && (script = (WipScript)this.getVm().getScriptManager().findScriptById(topFrame.location().scriptId())) != null) {
            String string = script.getUrl().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (StringsKt.endsWith$default((String)string, (String)"/debug.js", (boolean)false, (int)2, null)) {
                Thread.sleep(102L);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFrames(@NotNull List<? extends org.jetbrains.wip.protocol.debugger.CallFrameValue> frameDataList, @Nullable StackTraceValue asyncFrameDataList) {
        Intrinsics.checkNotNullParameter(frameDataList, (String)"frameDataList");
        int n = 0;
        int n2 = frameDataList.size();
        WipCallFrame[] wipCallFrameArray = new WipCallFrame[n2];
        while (n < n2) {
            int n3 = n++;
            wipCallFrameArray[n3] = new WipCallFrame(this.getValueManager(), frameDataList.get(n3));
        }
        WipCallFrame[] frames = wipCallFrameArray;
        if (!(frames.length == 0)) {
            this.setTopFrame(frames[0]);
        }
        this._frames = frames;
        List asyncFrames = new ArrayList();
        for (StackTraceValue currentStackTrace = asyncFrameDataList; currentStackTrace != null; currentStackTrace = currentStackTrace.getParent()) {
            String description = currentStackTrace.getDescription();
            Iterable $this$forEachIndexed$iv = currentStackTrace.callFrames();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void callFrameValue;
                int n4;
                if ((n4 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                CallFrameValue callFrameValue2 = (CallFrameValue)item$iv;
                int i = n4;
                boolean bl = false;
                asyncFrames.add(new WipAsyncCallFrame((CallFrameValue)callFrameValue, i == 0 ? description : null));
            }
        }
        Collection $this$toTypedArray$iv = asyncFrames;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this._asyncFrames = thisCollection$iv.toArray(new WipAsyncCallFrame[0]);
        int n5 = frames.length + asyncFrames.size();
        CallFrame[] callFrameArray = new CallFrame[n5];
        for (int i = 0; i < n5; ++i) {
            int n6 = i;
            callFrameArray[n6] = n6 < frames.length ? (CallFrame)frames[n6] : (CallFrame)asyncFrames.get(n6 - frames.length);
        }
        CallFrame[] result = callFrameArray;
        this.framesLoader.set(result);
    }

    public boolean getHasUnresolvedBreakpointsHit() {
        Collection collection = this.hitBreakpoints;
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        HashSet hitVmBreakpoints = new HashSet(this.hitBreakpoints);
        for (WipBreakpoint breakpoint : this.getValueManager().getVm().getBreakpointManager().getBreakpoints()) {
            hitVmBreakpoints.remove(breakpoint.getVmIdImmediately());
        }
        return !((Collection)hitVmBreakpoints).isEmpty();
    }

    @NotNull
    public List<Breakpoint> getBreakpointsHit() {
        Set breakpoints = this.getValueManager().getVm().getBreakpointManager().getBreakpoints();
        if (this.hitBreakpoints != null) {
            SmartList result = new SmartList();
            for (WipBreakpoint breakpoint : breakpoints) {
                String vmId = breakpoint.getVmIdImmediately();
                if (vmId == null || !this.hitBreakpoints.contains(vmId)) continue;
                result.add((Object)breakpoint);
            }
            return (List)result;
        }
        WipCallFrame wipCallFrame = this.getTopFrame();
        if (wipCallFrame == null) {
            return CollectionsKt.emptyList();
        }
        WipCallFrame topFrame = wipCallFrame;
        int line = topFrame.getLine();
        int column = topFrame.getColumn();
        List result = null;
        block1: for (WipBreakpoint breakpoint : breakpoints) {
            for (LocationValue actualLocation : breakpoint.getActualLocations()) {
                int actualColumnNumber = actualLocation.getColumnNumber();
                if (!Intrinsics.areEqual((Object)actualLocation.scriptId(), (Object)topFrame.getScriptId()) || actualLocation.getLineNumber() != line || actualColumnNumber != column && actualColumnNumber > 0) continue;
                if (result == null) {
                    result = (List)new SmartList();
                }
                result.add(breakpoint);
                continue block1;
            }
        }
        List list = result;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Promise<?> reloadFrames() {
        this.framesLoader.markDirty();
        Promise promise = this.framesLoader.get();
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"get(...)");
        Promise $this$thenRun$iv = promise;
        boolean $i$f$thenRun = false;
        Promise promise2 = $this$thenRun$iv.then(new Function(this){
            final /* synthetic */ WipSuspendContext this$0;
            {
                this.this$0 = wipSuspendContext;
            }

            public final Unit fun(Object it) {
                boolean bl = false;
                this.this$0.getValueManager().clearCaches();
                return Unit.INSTANCE;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    @Nullable
    public Script getScript() {
        Script script = super.getScript();
        if (script == null) {
            WipScript wipScript;
            String string = this.instrumentationBreakpointScriptId;
            if (string != null) {
                String it = string;
                boolean bl = false;
                wipScript = (WipScript)this.getVm().getScriptManager().findScriptById(it);
            } else {
                wipScript = null;
            }
            script = (Script)wipScript;
        }
        return script;
    }

    public static final /* synthetic */ WipCallFrame[] access$get_frames$p(WipSuspendContext $this) {
        return $this._frames;
    }

    public static final /* synthetic */ WipAsyncCallFrame[] access$get_asyncFrames$p(WipSuspendContext $this) {
        return $this._asyncFrames;
    }
}

