/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.xdebugger.XDebuggerBundle;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.debugger.VmBase;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipBreakpointManager;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipGlobalEvaluateContext;
import org.jetbrains.wip.WipNetworkManager;
import org.jetbrains.wip.WipScriptManager;
import org.jetbrains.wip.WipSuspendContextManager;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipWorkerManager;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.debugger.BreakpointResolvedEventData;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.EnableResult;
import org.jetbrains.wip.protocol.debugger.ScriptParsedEventData;
import org.jetbrains.wip.protocol.debugger.State;
import org.jetbrains.wip.protocol.network.NetworkKt;
import org.jetbrains.wip.protocol.page.FrameNavigatedEventData;
import org.jetbrains.wip.protocol.page.FrameValue;
import org.jetbrains.wip.protocol.page.PageKt;
import org.jetbrains.wip.protocol.runtime.ExecutionContextDestroyedEventData;
import org.jetbrains.wip.protocol.runtime.RuntimeKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010$\u001a\u00020\u0005H\u0014J\b\u0010%\u001a\u00020!H\u0014J\b\u0010&\u001a\u00020'H\u0014J\u0014\u0010B\u001a\u00020C2\n\u0010D\u001a\u0006\u0012\u0002\b\u00030EH$J\f\u0010F\u001a\u0006\u0012\u0002\b\u00030GH\u0016J\u000e\u0010H\u001a\b\u0012\u0004\u0012\u00020I0GH\u0002J\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\f0GJ\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\f0GJ\n\u0010L\u001a\u0006\u0012\u0002\b\u00030GJ\u0018\u0010M\u001a\u00020\f2\u0006\u0010N\u001a\u00020\u001b2\u0006\u0010O\u001a\u00020CH\u0002J\u0014\u0010P\u001a\u0006\u0012\u0002\b\u00030G2\u0006\u0010Q\u001a\u000204H\u0016J\u0010\u0010R\u001a\u00020S2\u0006\u0010Q\u001a\u000204H\u0002J\n\u0010T\u001a\u0004\u0018\u00010UH\u0014J\n\u0010=\u001a\u0006\u0012\u0002\b\u00030GJ\u0014\u0010V\u001a\u00020\f2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\f0XJ\u0010\u0010Y\u001a\u00020C2\b\u0010Z\u001a\u0004\u0018\u00010\u001bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\f0\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010(\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0017\u0010/\u001a\u00020\b\u00a2\u0006\u000e\n\u0000\u0012\u0004\b0\u0010\u0014\u001a\u0004\b1\u00102R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u00107\u001a\u0004\u0018\u0001062\b\u00105\u001a\u0004\u0018\u000106@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0010\u0010<\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010=\u001a\b\u0012\u0004\u0012\u00020\f0>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010?\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u001d\"\u0004\bA\u0010\u001f\u00a8\u0006["}, d2={"Lorg/jetbrains/wip/WipVm;", "Lorg/jetbrains/debugger/VmBase;", "tabListener", "Lorg/jetbrains/debugger/DebugEventListener;", "wipCommandProcessor", "Lorg/jetbrains/wip/WipCommandProcessor;", "workerManagerFactory", "Lkotlin/Function1;", "Lorg/jetbrains/wip/WipWorkerManager;", "<init>", "(Lorg/jetbrains/debugger/DebugEventListener;Lorg/jetbrains/wip/WipCommandProcessor;Lkotlin/jvm/functions/Function1;)V", "registerVmPrintEvents", "", "getRegisterVmPrintEvents", "()Lkotlin/jvm/functions/Function1;", "setRegisterVmPrintEvents", "(Lkotlin/jvm/functions/Function1;)V", "scriptManager", "Lorg/jetbrains/wip/WipScriptManager;", "getScriptManager$annotations", "()V", "getScriptManager", "()Lorg/jetbrains/wip/WipScriptManager;", "commandProcessor", "getCommandProcessor", "()Lorg/jetbrains/wip/WipCommandProcessor;", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "setPresentableName", "(Ljava/lang/String;)V", "breakpointManager", "Lorg/jetbrains/wip/WipBreakpointManager;", "getBreakpointManager", "()Lorg/jetbrains/wip/WipBreakpointManager;", "createCommandProcessor", "createBreakpointManager", "createSuspendManager", "Lorg/jetbrains/wip/WipSuspendContextManager;", "suspendContextManager", "getSuspendContextManager", "()Lorg/jetbrains/wip/WipSuspendContextManager;", "networkManager", "Lorg/jetbrains/wip/WipNetworkManager;", "getNetworkManager", "()Lorg/jetbrains/wip/WipNetworkManager;", "workerManager", "getWorkerManager$annotations", "getWorkerManager", "()Lorg/jetbrains/wip/WipWorkerManager;", "breakOnExceptionMode", "Lorg/jetbrains/debugger/ExceptionCatchMode;", "value", "Lcom/intellij/util/Url;", "currentUrl", "getCurrentUrl", "()Lcom/intellij/util/Url;", "setCurrentUrl", "(Lcom/intellij/util/Url;)V", "frameId", "ready", "Ljava/util/concurrent/CompletableFuture;", "title", "getTitle", "setTitle", "write", "", "message", "Lorg/jetbrains/jsonProtocol/Request;", "initDomains", "Lorg/jetbrains/concurrency/Promise;", "enableDebugger", "Lorg/jetbrains/wip/protocol/debugger/EnableResult;", "enablePage", "enableNetwork", "enableWorkers", "updateUrl", "url", "silent", "setBreakOnException", "catchMode", "sdkToWipCatchMode", "Lorg/jetbrains/wip/protocol/debugger/State;", "computeEvaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "addReadyListener", "handler", "Lkotlin/Function0;", "hasWorker", "workerId", "intellij.javascript.wip.backend"})
public abstract class WipVm
extends VmBase {
    @Nullable
    private final WipCommandProcessor wipCommandProcessor;
    public Function1<? super WipVm, Unit> registerVmPrintEvents;
    @NotNull
    private final WipScriptManager scriptManager;
    @NotNull
    private final WipCommandProcessor commandProcessor;
    @NotNull
    private String presentableName;
    @NotNull
    private final WipBreakpointManager breakpointManager;
    @NotNull
    private final WipSuspendContextManager suspendContextManager;
    @NotNull
    private final WipNetworkManager networkManager;
    @NotNull
    private final WipWorkerManager workerManager;
    @NotNull
    private ExceptionCatchMode breakOnExceptionMode;
    @Nullable
    private volatile Url currentUrl;
    @Nullable
    private String frameId;
    @NotNull
    private final CompletableFuture<Unit> ready;
    @Nullable
    private volatile String title;

    public WipVm(@NotNull DebugEventListener tabListener, @Nullable WipCommandProcessor wipCommandProcessor, @NotNull Function1<? super WipVm, ? extends WipWorkerManager> workerManagerFactory) {
        Intrinsics.checkNotNullParameter((Object)tabListener, (String)"tabListener");
        Intrinsics.checkNotNullParameter(workerManagerFactory, (String)"workerManagerFactory");
        super(tabListener);
        this.wipCommandProcessor = wipCommandProcessor;
        this.scriptManager = new WipScriptManager(this);
        this.commandProcessor = this.createCommandProcessor();
        String string = XDebuggerBundle.message((String)"debugger.session.tab.frames.thread.main", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.presentableName = string;
        this.breakpointManager = this.createBreakpointManager();
        this.suspendContextManager = this.createSuspendManager();
        this.networkManager = new WipNetworkManager(this.commandProcessor.getEventMap());
        this.workerManager = (WipWorkerManager)workerManagerFactory.invoke((Object)this);
        this.breakOnExceptionMode = ExceptionCatchMode.NONE;
        this.ready = new CompletableFuture();
        EventMap<ProtocolResponseReader> eventMap = this.commandProcessor.getEventMap();
        eventMap.add((EventType)FrameNavigatedEventData.TYPE, arg_0 -> WipVm._init_$lambda$1(this, arg_0));
        eventMap.add((EventType)ScriptParsedEventData.TYPE, arg_0 -> WipVm._init_$lambda$2(this, arg_0));
        eventMap.add((EventType)BreakpointResolvedEventData.TYPE, arg_0 -> WipVm._init_$lambda$3(this, arg_0));
        eventMap.add((EventType)ExecutionContextDestroyedEventData.TYPE, arg_0 -> WipVm._init_$lambda$4(this, arg_0));
        this.workerManager.registerWorkerEvents(eventMap);
    }

    public /* synthetic */ WipVm(DebugEventListener debugEventListener, WipCommandProcessor wipCommandProcessor, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            wipCommandProcessor = null;
        }
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(debugEventListener, wipCommandProcessor, (Function1<? super WipVm, ? extends WipWorkerManager>)function1);
    }

    @NotNull
    public final Function1<WipVm, Unit> getRegisterVmPrintEvents() {
        Function1<? super WipVm, Unit> function1 = this.registerVmPrintEvents;
        if (function1 != null) {
            return function1;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"registerVmPrintEvents");
        return null;
    }

    public final void setRegisterVmPrintEvents(@NotNull Function1<? super WipVm, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.registerVmPrintEvents = function1;
    }

    @NotNull
    public final WipScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public static /* synthetic */ void getScriptManager$annotations() {
    }

    @NotNull
    public final WipCommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    @NotNull
    public String getPresentableName() {
        return this.presentableName;
    }

    public void setPresentableName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.presentableName = string;
    }

    @NotNull
    public WipBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    @NotNull
    protected WipCommandProcessor createCommandProcessor() {
        WipCommandProcessor wipCommandProcessor = this.wipCommandProcessor;
        if (wipCommandProcessor == null) {
            wipCommandProcessor = new WipCommandProcessor(arg_0 -> WipVm.createCommandProcessor$lambda$0(this, arg_0));
        }
        return wipCommandProcessor;
    }

    @NotNull
    protected WipBreakpointManager createBreakpointManager() {
        return new WipBreakpointManager(this);
    }

    @NotNull
    protected WipSuspendContextManager createSuspendManager() {
        return new WipSuspendContextManager(this);
    }

    @NotNull
    public WipSuspendContextManager getSuspendContextManager() {
        return this.suspendContextManager;
    }

    @NotNull
    public final WipNetworkManager getNetworkManager() {
        return this.networkManager;
    }

    @NotNull
    public final WipWorkerManager getWorkerManager() {
        return this.workerManager;
    }

    public static /* synthetic */ void getWorkerManager$annotations() {
    }

    @Nullable
    public final Url getCurrentUrl() {
        return this.currentUrl;
    }

    protected final void setCurrentUrl(@Nullable Url url) {
        this.currentUrl = url;
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@Nullable String string) {
        this.title = string;
    }

    protected abstract boolean write(@NotNull Request<?> var1);

    @NotNull
    public Promise<?> initDomains() {
        this.enableDebugger();
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            this.commandProcessor.send((Request)NetworkKt.SetCacheDisabled(true));
        }
        return Promises.resolvedPromise();
    }

    private final Promise<EnableResult> enableDebugger() {
        return this.commandProcessor.send((Request)DebuggerKt.Enable$default(null, 1, null));
    }

    @NotNull
    public final Promise<Unit> enablePage() {
        return this.commandProcessor.send((Request)PageKt.Enable());
    }

    @NotNull
    public final Promise<Unit> enableNetwork() {
        return this.networkManager.enable(this.commandProcessor);
    }

    @NotNull
    public final Promise<?> enableWorkers() {
        return this.workerManager.enableWorkers();
    }

    private final void updateUrl(String url, boolean silent) {
        this.currentUrl = Urls.newFromEncoded((String)url);
        if (silent) {
            return;
        }
        this.scriptManager.clear(this.getDebugListener());
        this.getBreakpointManager().clearNonProvisionalBreakpoints();
        this.getDebugListener().navigated(url);
        this.getSuspendContextManager().getEvaluateHack$intellij_javascript_wip_backend().pageReloaded$intellij_javascript_wip_backend();
    }

    @NotNull
    public Promise<?> setBreakOnException(@NotNull ExceptionCatchMode catchMode) {
        Intrinsics.checkNotNullParameter((Object)catchMode, (String)"catchMode");
        this.breakOnExceptionMode = catchMode;
        return this.commandProcessor.send((Request)DebuggerKt.SetPauseOnExceptions(this.sdkToWipCatchMode(catchMode)));
    }

    private final State sdkToWipCatchMode(ExceptionCatchMode catchMode) {
        switch (WhenMappings.$EnumSwitchMapping$0[catchMode.ordinal()]) {
            case 1: {
                return State.ALL;
            }
            case 2: {
                return State.UNCAUGHT;
            }
            case 3: {
                return State.NONE;
            }
        }
        throw new IllegalArgumentException(catchMode.name());
    }

    @Nullable
    protected EvaluateContext computeEvaluateContext() {
        return (EvaluateContext)new WipGlobalEvaluateContext(new WipValueManager(this, "ce"));
    }

    @NotNull
    public final Promise<?> ready() {
        this.ready.complete(Unit.INSTANCE);
        return this.commandProcessor.send((Request)RuntimeKt.RunIfWaitingForDebugger());
    }

    public final void addReadyListener(@NotNull Function0<Unit> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        this.ready.thenApply(arg_0 -> WipVm.addReadyListener$lambda$6(arg_0 -> WipVm.addReadyListener$lambda$5(handler2, arg_0), arg_0));
    }

    public final boolean hasWorker(@Nullable String workerId) {
        return this.workerManager.hasWorker(workerId);
    }

    private static final boolean createCommandProcessor$lambda$0(WipVm this$0, Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.write(it);
    }

    private static final Unit _init_$lambda$1(WipVm this$0, FrameNavigatedEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FrameValue frame = it.frame();
        if (frame.getParentId() == null) {
            this$0.frameId = frame.id();
            this$0.updateUrl(frame.url(), false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(WipVm this$0, ScriptParsedEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.scriptManager.scriptParsed(it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(WipVm this$0, BreakpointResolvedEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.getBreakpointManager().breakpointReportedResolved(it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(WipVm this$0, ExecutionContextDestroyedEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.scriptManager.executionContextDestroyed(it);
        return Unit.INSTANCE;
    }

    private static final Unit addReadyListener$lambda$5(Function0 $handler, Unit it) {
        $handler.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit addReadyListener$lambda$6(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExceptionCatchMode.values().length];
            try {
                nArray[ExceptionCatchMode.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionCatchMode.UNCAUGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionCatchMode.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

