/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.fasterxml.jackson.jr.ob.JSON;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.impl.util.CssBrowserData;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssCompatibilityData {
    private static final Logger LOG = Logger.getInstance(CssCompatibilityData.class);
    private static final Map<String, Map<String, Object>> PROPERTIES_CACHE = new HashMap<String, Map<String, Object>>();
    private static final Map<String, Map<String, Object>> PSEUDO_SELECTOR_CACHE = new HashMap<String, Map<String, Object>>();
    private static final Map<String, CssBrowserData> BROWSERS_CACHE = new HashMap<String, CssBrowserData>();

    @Nullable
    public static Map<String, Object> getPropertyData(@NotNull String propertyName) {
        if (propertyName == null) {
            CssCompatibilityData.$$$reportNull$$$0(0);
        }
        return CssCompatibilityData.getCssCompatData(PROPERTIES_CACHE, "properties", propertyName);
    }

    @Nullable
    public static Map<String, Object> getPseudoSelectorData(@NotNull String selectorName) {
        if (selectorName == null) {
            CssCompatibilityData.$$$reportNull$$$0(1);
        }
        return CssCompatibilityData.getCssCompatData(PSEUDO_SELECTOR_CACHE, "selectors", selectorName);
    }

    @Nullable
    private static Map<String, Object> getCssCompatData(Map<String, Map<String, Object>> cache, String cssCompatDataType, @NotNull String name) {
        if (name == null) {
            CssCompatibilityData.$$$reportNull$$$0(2);
        }
        if (cache.containsKey(name)) {
            return cache.get(name);
        }
        URL resource = CssCompatibilityData.class.getResource("/cssCompatData/" + cssCompatDataType + "/" + name + ".json");
        if (resource == null) {
            cache.put(name, null);
            return null;
        }
        try {
            Map json = JSON.std.mapFrom((Object)new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));
            Map propertyHolder = (Map)json.get("css");
            Map properties = (Map)propertyHolder.get(cssCompatDataType);
            Map data = (Map)properties.get(name);
            cache.put(name, data);
            return data;
        }
        catch (IOException e) {
            LOG.error("Compatibility data from " + resource + " was not obtained.");
            cache.put(name, null);
            return null;
        }
    }

    public static BrowserVersion @NotNull [] getBrowserDataForProperty(String propertyName) {
        return CssCompatibilityData.getBrowserCompatibilityData(CssCompatibilityData.getPropertyData(propertyName));
    }

    public static BrowserVersion[] getBrowserDataForPseudoSelector(String selectorName) {
        return CssCompatibilityData.getBrowserCompatibilityData(CssCompatibilityData.getPseudoSelectorData(selectorName));
    }

    private static BrowserVersion @NotNull [] getBrowserCompatibilityData(Map<String, Object> mdnCompatData) {
        if (mdnCompatData == null) {
            if (BrowserVersion.EMPTY_ARRAY == null) {
                CssCompatibilityData.$$$reportNull$$$0(3);
            }
            return BrowserVersion.EMPTY_ARRAY;
        }
        Map compat = (Map)mdnCompatData.get("__compat");
        if (compat == null) {
            if (BrowserVersion.EMPTY_ARRAY == null) {
                CssCompatibilityData.$$$reportNull$$$0(4);
            }
            return BrowserVersion.EMPTY_ARRAY;
        }
        Map support = (Map)compat.get("support");
        if (support == null) {
            if (BrowserVersion.EMPTY_ARRAY == null) {
                CssCompatibilityData.$$$reportNull$$$0(5);
            }
            return BrowserVersion.EMPTY_ARRAY;
        }
        ArrayList<BrowserVersion> result = new ArrayList<BrowserVersion>();
        for (Object key : support.keySet()) {
            Object browserInfos;
            String browserVersion;
            String browserId = key.toString();
            BrowserVersion.Browser browser = CssCompatibilityData.getBrowserByMdnId(browserId);
            if (browser == null || StringUtil.isEmpty((String)(browserVersion = CssCompatibilityData.getBrowserVersion(support, browserId, browserInfos = support.get(key)))) || "false".equals(browserVersion)) continue;
            result.add(new BrowserVersion(browser, browserVersion));
        }
        BrowserVersion[] browserVersionArray = result.toArray(BrowserVersion.EMPTY_ARRAY);
        if (browserVersionArray == null) {
            CssCompatibilityData.$$$reportNull$$$0(6);
        }
        return browserVersionArray;
    }

    @NotNull
    private static CssBrowserData getBrowserData(@NotNull String browserId) {
        if (browserId == null) {
            CssCompatibilityData.$$$reportNull$$$0(7);
        }
        URL resource = CssBrowserData.class.getResource("/cssCompatData/browsers/" + browserId + ".json");
        String upstream = null;
        boolean acceptsFlags = false;
        String previewName = null;
        HashMap<String, CssBrowserData.EngineInfo> releases = new HashMap<String, CssBrowserData.EngineInfo>();
        try {
            Map releasesData;
            Object previewNameData;
            Object flagsData;
            assert (resource != null);
            Map json = JSON.std.mapFrom((Object)new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));
            Map browserHolder = (Map)json.get("browsers");
            Map browserData = (Map)browserHolder.get(browserId);
            Object upstreamData = browserData.get("upstream");
            if (upstreamData != null) {
                upstream = upstreamData.toString();
            }
            if ((flagsData = browserData.get("accepts_flags")) != null) {
                acceptsFlags = Boolean.parseBoolean(flagsData.toString());
            }
            if ((previewNameData = browserData.get("preview_name")) != null) {
                previewName = previewNameData.toString();
            }
            if ((releasesData = (Map)browserData.get("releases")) != null) {
                Set releaseKeys = releasesData.keySet();
                for (Object releaseKey : releaseKeys) {
                    Map releaseInfo = (Map)releasesData.get(releaseKey.toString());
                    String engineName = (String)releaseInfo.get("engine");
                    String engineVersion = (String)releaseInfo.get("engine_version");
                    CssBrowserData.EngineInfo engine = new CssBrowserData.EngineInfo(engineName, engineVersion);
                    releases.put(releaseKey.toString(), engine);
                }
            }
            return new CssBrowserData(browserId, upstream, previewName, acceptsFlags, releases);
        }
        catch (IOException e) {
            LOG.error("Browser data from " + resource + " was not fully obtained.", (Throwable)e);
            return new CssBrowserData(browserId, upstream, previewName, acceptsFlags, releases);
        }
    }

    @Nullable
    private static BrowserVersion.Browser getBrowserByMdnId(String mdnBrowserId) {
        return switch (mdnBrowserId) {
            case "chrome" -> BrowserVersion.Browser.CHROME;
            case "firefox" -> BrowserVersion.Browser.FIREFOX;
            case "ie" -> BrowserVersion.Browser.IE;
            case "opera" -> BrowserVersion.Browser.OPERA;
            case "safari" -> BrowserVersion.Browser.SAFARI;
            case "edge" -> BrowserVersion.Browser.EDGE;
            default -> null;
        };
    }

    @NotNull
    private static String getBrowserVersion(@NotNull Map support, @NotNull String browserId, @NotNull Object browserInfos) {
        ArrayList<String> versionAdded;
        if (support == null) {
            CssCompatibilityData.$$$reportNull$$$0(8);
        }
        if (browserId == null) {
            CssCompatibilityData.$$$reportNull$$$0(9);
        }
        if (browserInfos == null) {
            CssCompatibilityData.$$$reportNull$$$0(10);
        }
        if (browserInfos.equals("mirror")) {
            versionAdded = CssCompatibilityData.getMirroredVersionAdded(support, browserId);
        } else {
            Map browserInfo = (Map)(browserInfos instanceof ArrayList ? ((ArrayList)browserInfos).get(0) : browserInfos);
            versionAdded = browserInfo.get("version_added");
        }
        String version = versionAdded == null ? "" : (versionAdded instanceof ArrayList ? versionAdded.get(0).toString() : ((Object)versionAdded).toString());
        String string = version;
        if (string == null) {
            CssCompatibilityData.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    private static ArrayList<String> getMirroredVersionAdded(@NotNull Map mdnSupportData, @NotNull String browserId) {
        CssBrowserData targetBrowser;
        if (mdnSupportData == null) {
            CssCompatibilityData.$$$reportNull$$$0(12);
        }
        if (browserId == null) {
            CssCompatibilityData.$$$reportNull$$$0(13);
        }
        if ((targetBrowser = CssCompatibilityData.getCachedBrowserData(browserId)) == null || targetBrowser.upstream == null) {
            return null;
        }
        Object upstreamSupportData = mdnSupportData.get(targetBrowser.upstream);
        if (upstreamSupportData.equals("mirror")) {
            upstreamSupportData = CssCompatibilityData.getMirroredVersionAdded(mdnSupportData, targetBrowser.upstream);
        }
        if (upstreamSupportData == null) {
            return null;
        }
        return CssCompatibilityData.getVersionAddedInfo(upstreamSupportData, targetBrowser.upstream, targetBrowser, browserId);
    }

    @Nullable
    public static CssBrowserData getCachedBrowserData(@NotNull String browserId) {
        if (browserId == null) {
            CssCompatibilityData.$$$reportNull$$$0(14);
        }
        if (BROWSERS_CACHE.containsKey(browserId)) {
            return BROWSERS_CACHE.get(browserId);
        }
        CssBrowserData browserData = CssCompatibilityData.getBrowserData(browserId);
        BROWSERS_CACHE.put(browserId, browserData);
        return browserData;
    }

    @Nullable
    private static ArrayList<String> getVersionAddedInfo(@NotNull Object upstreamSupportData, @NotNull String upstreamBrowser, @NotNull CssBrowserData targetBrowserData, @NotNull String targetBrowser) {
        if (upstreamSupportData == null) {
            CssCompatibilityData.$$$reportNull$$$0(15);
        }
        if (upstreamBrowser == null) {
            CssCompatibilityData.$$$reportNull$$$0(16);
        }
        if (targetBrowserData == null) {
            CssCompatibilityData.$$$reportNull$$$0(17);
        }
        if (targetBrowser == null) {
            CssCompatibilityData.$$$reportNull$$$0(18);
        }
        if (upstreamSupportData instanceof List) {
            ArrayList<String> targetVersionAdded = new ArrayList<String>();
            for (Object supportStatement : (List)upstreamSupportData) {
                ArrayList<String> versions = CssCompatibilityData.getVersionAddedInfo(supportStatement, upstreamBrowser, targetBrowserData, targetBrowser);
                if (versions == null) continue;
                targetVersionAdded.add(versions.get(0));
            }
            return targetVersionAdded.isEmpty() ? null : targetVersionAdded;
        }
        Map upstreamInfo = (Map)upstreamSupportData;
        Object upstreamVersionAdded = upstreamInfo.get("version_added");
        if (upstreamVersionAdded != null && upstreamVersionAdded.toString().equals("false")) {
            return null;
        }
        Object targetVersionAdded = null;
        Object targetVersionRemoved = null;
        if (upstreamVersionAdded instanceof String) {
            targetVersionAdded = CssCompatibilityData.getMatchingBrowserVersion(targetBrowserData, upstreamBrowser, (String)upstreamVersionAdded);
        }
        if (targetVersionAdded == null) {
            return null;
        }
        Object upstreamVersionRemoved = upstreamInfo.get("version_removed");
        if (upstreamVersionRemoved instanceof String) {
            targetVersionRemoved = CssCompatibilityData.getMatchingBrowserVersion(targetBrowserData, upstreamBrowser, (String)upstreamVersionRemoved);
        }
        if (targetBrowserData.acceptsFlags.equals(Boolean.FALSE) && upstreamInfo.get("flags") != null) {
            return null;
        }
        if (targetVersionAdded.equals(targetVersionRemoved)) {
            return null;
        }
        return new ArrayList<String>(Collections.singletonList(targetVersionAdded.toString()));
    }

    @Nullable
    public static Object getMatchingBrowserVersion(@NotNull CssBrowserData targetBrowserData, @NotNull String upstreamBrowser, @NotNull String upstreamVersion) {
        if (targetBrowserData == null) {
            CssCompatibilityData.$$$reportNull$$$0(19);
        }
        if (upstreamBrowser == null) {
            CssCompatibilityData.$$$reportNull$$$0(20);
        }
        if (upstreamVersion == null) {
            CssCompatibilityData.$$$reportNull$$$0(21);
        }
        if (upstreamVersion.equals("preview")) {
            return targetBrowserData.previewName;
        }
        CssBrowserData upstreamBrowserData = CssCompatibilityData.getCachedBrowserData(upstreamBrowser);
        if (upstreamBrowserData == null) {
            return null;
        }
        CssBrowserData.EngineInfo upstreamReleaseEngine = upstreamBrowserData.releases.get(upstreamVersion);
        if (upstreamReleaseEngine == null || upstreamReleaseEngine.name == null) {
            return null;
        }
        for (Object targetReleaseKey : Arrays.stream(targetBrowserData.releases.keySet().toArray()).sorted((v1, v2) -> StringUtil.compareVersionNumbers((String)v1.toString(), (String)v2.toString())).toArray()) {
            CssBrowserData.EngineInfo targetReleaseEngine = targetBrowserData.releases.get(targetReleaseKey);
            if (targetReleaseEngine.name == null) continue;
            if (CssCompatibilityData.isPreBlinkCase(upstreamBrowser, targetBrowserData.name, upstreamReleaseEngine.name, targetReleaseEngine.name).booleanValue()) {
                return upstreamVersion.contains("\u2264") ? "\u2264" + targetReleaseKey : targetReleaseKey;
            }
            if (!CssCompatibilityData.hasTargetOlderEngineVersion(upstreamReleaseEngine, targetReleaseEngine).booleanValue()) continue;
            return targetReleaseKey;
        }
        return null;
    }

    private static Boolean isPreBlinkCase(@NotNull String upstreamBrowser, @NotNull String targetBrowser, @NotNull String upstreamEngine, @NotNull String targetReleaseEngine) {
        if (upstreamBrowser == null) {
            CssCompatibilityData.$$$reportNull$$$0(22);
        }
        if (targetBrowser == null) {
            CssCompatibilityData.$$$reportNull$$$0(23);
        }
        if (upstreamEngine == null) {
            CssCompatibilityData.$$$reportNull$$$0(24);
        }
        if (targetReleaseEngine == null) {
            CssCompatibilityData.$$$reportNull$$$0(25);
        }
        return (upstreamBrowser.equals("chrome") || upstreamBrowser.equals("chrome_android")) && !targetBrowser.equals("chrome_android") && upstreamEngine.equals("WebKit") && targetReleaseEngine.equals("Blink");
    }

    private static Boolean hasTargetOlderEngineVersion(@NotNull CssBrowserData.EngineInfo upstreamEngine, @NotNull CssBrowserData.EngineInfo targetReleaseEngine) {
        if (upstreamEngine == null) {
            CssCompatibilityData.$$$reportNull$$$0(26);
        }
        if (targetReleaseEngine == null) {
            CssCompatibilityData.$$$reportNull$$$0(27);
        }
        if (upstreamEngine.name == null || !upstreamEngine.name.equals(targetReleaseEngine.name)) {
            return false;
        }
        return StringUtil.compareVersionNumbers((String)targetReleaseEngine.version, (String)upstreamEngine.version) >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/CssCompatibilityData";
                break;
            }
            case 7: 
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserInfos";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mdnSupportData";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upstreamSupportData";
                break;
            }
            case 16: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upstreamBrowser";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetBrowserData";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetBrowser";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upstreamVersion";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upstreamEngine";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetReleaseEngine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/CssCompatibilityData";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowserCompatibilityData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowserVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPseudoSelectorData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCssCompatData";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBrowserData";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBrowserVersion";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMirroredVersionAdded";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCachedBrowserData";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getVersionAddedInfo";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingBrowserVersion";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isPreBlinkCase";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasTargetOlderEngineVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 11 -> new IllegalStateException(string);
        };
    }
}

