/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.index;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lexer.FilterLexer;
import com.intellij.lexer.HtmlLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.XHtmlLexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssHighlighterLexer;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import com.intellij.psi.css.index.CssIndexValue;
import com.intellij.psi.css.index.CssSupportedFileTypesProvider;
import com.intellij.psi.css.index.CssSupportedFileTypesProviderEP;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssIndex
extends FileBasedIndexExtension<String, IntList> {
    public static final ID<String, IntList> CSS_INDEX = ID.create((String)"CssIndex");
    private final DataExternalizer<IntList> myValueExternalizer = new DataExternalizer<IntList>(){

        public void save(@NotNull DataOutput out, IntList values) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            int size = values.size();
            DataInputOutputUtil.writeINT((DataOutput)out, (int)size);
            for (int i = 0; i < size; ++i) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)values.getInt(i));
            }
        }

        public IntList read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            int count = DataInputOutputUtil.readINT((DataInput)in);
            IntArrayList result = new IntArrayList(count);
            for (int i = 0; i < count; ++i) {
                result.add(DataInputOutputUtil.readINT((DataInput)in));
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/css/index/CssIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    static boolean isHtmlLikeOrSupportedTemplateLanguage(FileType fileType) {
        Language language;
        return fileType instanceof LanguageFileType && fileType != HtmlFileType.INSTANCE && ((language = ((LanguageFileType)fileType).getLanguage()) instanceof TemplateLanguage || language.isKindOf((Language)HTMLLanguage.INSTANCE)) && LanguageParserDefinitions.INSTANCE.forLanguage(language) != null;
    }

    public static boolean isFontOrFontFamily(String s) {
        return s.equalsIgnoreCase("font-family") || s.equalsIgnoreCase("font");
    }

    @NotNull
    public ID<String, IntList> getName() {
        ID<String, IntList> iD = CSS_INDEX;
        if (iD == null) {
            CssIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, IntList, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            FileViewProvider provider;
            final Map result = FactoryMap.create(key -> new IntArrayList());
            FileType fileType = inputData.getFileType();
            if (!(fileType instanceof LanguageFileType)) {
                return result;
            }
            Language language = ((LanguageFileType)fileType).getLanguage();
            if (language instanceof TemplateLanguage && (provider = inputData.getPsiFile().getViewProvider()) instanceof TemplateLanguageFileViewProvider) {
                language = ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage();
            }
            final boolean indexingCss = language == CSSLanguage.INSTANCE;
            CssIndex.indexValues(language, inputData.getContentAsText(), new CssIndexCallback(){

                @Override
                public void index(int offset, CssIndexValue type, @NotNull String value) {
                    if (value == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    this.addValue(offset, (CssIndexValue)((Object)ObjectUtils.notNull((Object)((Object)type), (Object)((Object)CssIndexValue.COLOR))), value, type);
                }

                private void addValue(int offset, CssIndexValue type, String value, CssIndexValue originalValueType) {
                    IntList list = (IntList)result.get(type.indexKey(value));
                    if (indexingCss && (originalValueType == null || originalValueType == CssIndexValue.ANIMATION) && !list.isEmpty()) {
                        return;
                    }
                    list.add(offset);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/index/CssIndex$2", "index"));
                }
            });
            return result;
        };
        if (dataIndexer == null) {
            CssIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            CssIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<IntList> getValueExternalizer() {
        DataExternalizer<IntList> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            CssIndex.$$$reportNull$$$0(3);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new FileBasedIndex.FileTypeSpecificInputFilter(){

            public void registerFileTypesUsedForIndexing(@NotNull Consumer<? super FileType> fileTypeSink) {
                if (fileTypeSink == null) {
                    3.$$$reportNull$$$0(0);
                }
                fileTypeSink.consume((Object)XHtmlFileType.INSTANCE);
                fileTypeSink.consume((Object)HtmlFileType.INSTANCE);
                for (CssSupportedFileTypesProvider cssSupportedFileTypesProvider : CssSupportedFileTypesProvider.getProviders()) {
                    fileTypeSink.consume((Object)cssSupportedFileTypesProvider.getSupportedFileType());
                }
                for (FileType fileType : FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
                    if (!CssIndex.isHtmlLikeOrSupportedTemplateLanguage(fileType)) continue;
                    fileTypeSink.consume((Object)fileType);
                }
            }

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    3.$$$reportNull$$$0(1);
                }
                return file.isInLocalFileSystem();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileTypeSink";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/css/index/CssIndex$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerFileTypesUsedForIndexing";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptInput";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 37 + CssSupportedFileTypesProvider.EP_NAME.getExtensionList().stream().mapToInt(CssSupportedFileTypesProviderEP::getVersion).sum();
    }

    private static void indexValues(@NotNull Language language, @NotNull CharSequence input, @NotNull CssIndexCallback callback) {
        CssSupportedFileTypesProvider provider;
        Lexer lexer;
        if (language == null) {
            CssIndex.$$$reportNull$$$0(4);
        }
        if (input == null) {
            CssIndex.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            CssIndex.$$$reportNull$$$0(6);
        }
        if (language.isKindOf((Language)HTMLLanguage.INSTANCE) || language == XHTMLLanguage.INSTANCE) {
            HtmlLexer originalLexer = language != XHTMLLanguage.INSTANCE ? new HtmlLexer(true) : new XHtmlLexer(true);
            lexer = new FilterLexer((Lexer)originalLexer, type -> XmlTokenType.XML_WHITE_SPACE == type || XmlTokenType.XML_REAL_WHITE_SPACE == type || XmlTokenType.TAG_WHITE_SPACE == type);
            lexer.start(input);
            CssIndex.indexCss(input, callback, lexer, true);
        }
        if ((provider = CssSupportedFileTypesProvider.findProvider(language)) != null) {
            lexer = provider.getIndexingLexer();
            lexer.start(input);
            CssIndex.indexCss(input, callback, lexer, false);
        }
    }

    private static void indexCss(CharSequence input, CssIndexCallback callback, Lexer lexer, boolean blockInitial) {
        IElementType tokenType = lexer.getTokenType();
        boolean isCssLexer = lexer instanceof CssHighlighterLexer;
        CssHighlighterLexer cssLexer = null;
        if (isCssLexer) {
            cssLexer = (CssHighlighterLexer)lexer;
        }
        StringBuilder fontFamilyPack = new StringBuilder();
        int fontFamilyPackTokenStart = 0;
        boolean fontFamilyPackHasMoreThanOneFontName = false;
        boolean block = blockInitial;
        boolean afterAnimationNameProperty = false;
        boolean afterFontOrFontFamilyProperty = false;
        CharSequence lastAttrName = null;
        while (tokenType != null) {
            if (isCssLexer) {
                if (tokenType == CssElementTypes.CSS_COLOR) {
                    CssIndex.indexColorValue(lexer, input, callback);
                } else {
                    if (!CssIndex.indexKeyframes(lexer, input, callback)) {
                        tokenType = lexer.getTokenType();
                        continue;
                    }
                    if (tokenType == CssElementTypes.CSS_PROPERTY_NAME) {
                        CharSequence value = input.subSequence(lexer.getTokenStart(), lexer.getTokenEnd());
                        String propertyName = value.toString();
                        afterAnimationNameProperty = "animation-name".equalsIgnoreCase(propertyName);
                        afterFontOrFontFamilyProperty = CssIndex.isFontOrFontFamily(propertyName);
                        fontFamilyPackTokenStart = lexer.getTokenEnd();
                    } else if (afterAnimationNameProperty && tokenType == CssElementTypes.CSS_IDENT) {
                        CssIndex.indexAnimationName((Lexer)cssLexer, input, callback, false);
                        afterAnimationNameProperty = false;
                    } else if (afterFontOrFontFamilyProperty) {
                        if (cssLexer.isPropertyValueAllowed() && (tokenType == CssElementTypes.CSS_IDENT || tokenType == CssElementTypes.CSS_STRING_TOKEN || tokenType == CssElementTypes.CSS_PROPERTY_VALUE || tokenType == CssElementTypes.CSS_UNIT)) {
                            int tokenStart = cssLexer.getTokenStart();
                            int tokenEnd = cssLexer.getTokenEnd();
                            fontFamilyPack.append(input.subSequence(tokenStart, cssLexer.getTokenEnd()));
                            while (tokenType != null) {
                                cssLexer.advance();
                                tokenType = cssLexer.getTokenType();
                                if (tokenType == CssElementTypes.CSS_COMMA) {
                                    fontFamilyPack.append(", ");
                                    fontFamilyPackHasMoreThanOneFontName = true;
                                    break;
                                }
                                if (StringUtil.isEmptyOrSpaces((String)cssLexer.getTokenText())) {
                                    fontFamilyPack.append(' ');
                                } else {
                                    if (tokenType != CssElementTypes.CSS_IDENT) break;
                                    fontFamilyPack.append(cssLexer.getTokenText());
                                }
                                tokenEnd = cssLexer.getTokenEnd();
                            }
                            String fontFamily = input.subSequence(tokenStart, tokenEnd).toString().trim();
                            if ((fontFamily = StringUtil.unquoteString((String)fontFamily)).isEmpty()) continue;
                            callback.index(tokenStart, CssIndexValue.FONT_FAMILY, fontFamily);
                            continue;
                        }
                        if (tokenType != CssElementTypes.CSS_COMMA && tokenType != CssElementTypes.CSS_COLON && !StringUtil.isEmptyOrSpaces((String)lexer.getTokenText())) {
                            afterFontOrFontFamilyProperty = false;
                            if (fontFamilyPack.length() > 0 && fontFamilyPackHasMoreThanOneFontName) {
                                callback.index(fontFamilyPackTokenStart, CssIndexValue.FONT_FAMILY_PACK, fontFamilyPack.toString().trim());
                            }
                            fontFamilyPackTokenStart = 0;
                            fontFamilyPackHasMoreThanOneFontName = false;
                            fontFamilyPack.setLength(0);
                        }
                    }
                }
            } else {
                String name;
                if (XmlTokenType.XML_TAG_NAME == tokenType) {
                    lastAttrName = null;
                    String name2 = input.subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString();
                    if ("style".equalsIgnoreCase(name2)) {
                        int startCss;
                        block = false;
                        while (lexer.getTokenType() != null && lexer.getTokenType() != XmlTokenType.XML_TAG_END) {
                            lexer.advance();
                        }
                        int endCss = startCss = lexer.getTokenEnd();
                        while (lexer.getTokenType() != null) {
                            if (lexer.getTokenType() == XmlTokenType.XML_END_TAG_START) {
                                String endTagName;
                                endCss = lexer.getTokenStart();
                                lexer.advance();
                                if (lexer.getTokenType() == XmlTokenType.XML_TAG_NAME && "style".equalsIgnoreCase(endTagName = input.subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString())) break;
                            }
                            lexer.advance();
                        }
                        if (startCss < endCss) {
                            CssIndex.indexSubCss(input, callback, startCss, endCss, false);
                        }
                    } else if ("body".equalsIgnoreCase(name2)) {
                        block = true;
                    }
                } else if (XmlTokenType.XML_NAME == tokenType) {
                    lastAttrName = input.subSequence(lexer.getTokenStart(), lexer.getTokenEnd());
                }
                if (XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN == tokenType && lastAttrName != null && "style".equalsIgnoreCase(name = lastAttrName.toString())) {
                    CssIndex.indexSubCss(input, callback, lexer.getTokenStart(), lexer.getTokenEnd(), true);
                }
                CssIndex.index(lexer, block, input, callback);
            }
            lexer.advance();
            tokenType = lexer.getTokenType();
        }
    }

    private static void indexSubCss(CharSequence input, CssIndexCallback callback, int start, int end, boolean blockInitial) {
        CssHighlighterLexer styleBlockLexer = new CssHighlighterLexer(CssElementDescriptorFactory2.getInstance().getValueIdentifiers());
        styleBlockLexer.start(input, start, end);
        CssIndex.indexCss(input, callback, (Lexer)styleBlockLexer, blockInitial);
    }

    private static void index(Lexer lexer, boolean block, CharSequence input, CssIndexCallback callback) {
        if (block) {
            CssIndex.indexColorValue(lexer, input, callback);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean indexKeyframes(Lexer lexer, CharSequence input, CssIndexCallback callback) {
        if (lexer.getTokenType() != CssElementTypes.CSS_KEYFRAMES_SYM) return true;
        lexer.advance();
        if (!CssElementTypes.WHITESPACES.contains(lexer.getTokenType())) return false;
        lexer.advance();
        if (lexer.getTokenType() == CssElementTypes.CSS_IDENT) {
            CssIndex.indexAnimationName(lexer, input, callback, true);
            return true;
        } else {
            if (lexer.getTokenType() != CssElementTypes.CSS_COLON) return false;
            lexer.advance();
            if (lexer.getTokenType() != CssElementTypes.CSS_PSEUDO) {
                return false;
            }
            lexer.advance();
            if (lexer.getTokenType() != CssElementTypes.CSS_LPAREN) {
                return false;
            }
            lexer.advance();
            if (lexer.getTokenType() != CssElementTypes.CSS_IDENT) {
                return false;
            }
            CssIndex.indexAnimationName(lexer, input, callback, true);
        }
        return true;
    }

    private static void indexAnimationName(Lexer lexer, CharSequence input, CssIndexCallback callback, boolean afterKeyframes) {
        String value = input.subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString();
        if (!value.isEmpty()) {
            callback.index(lexer.getTokenStart(), CssIndexValue.ANIMATION, value);
            if (afterKeyframes) {
                callback.index(lexer.getTokenStart(), CssIndexValue.KEYFRAMES, value);
            }
        }
    }

    private static void indexColorValue(Lexer lexer, CharSequence input, CssIndexCallback callback) {
        IElementType tokenType = lexer.getTokenType();
        CharSequence value = input.subSequence(lexer.getTokenStart(), lexer.getTokenEnd());
        if (tokenType == CssElementTypes.CSS_COLOR && value.length() > 1) {
            String hex_value = value.subSequence(1, value.length()).toString();
            if (hex_value.length() == 3) {
                StringBuilder v = new StringBuilder();
                for (int i = 0; i < hex_value.length(); ++i) {
                    v.append(hex_value.charAt(i)).append(hex_value.charAt(i));
                }
                hex_value = v.toString();
            }
            if (hex_value.length() == 6) {
                callback.index(lexer.getTokenStart(), CssIndexValue.COLOR, hex_value);
            }
        }
        if (tokenType == CssElementTypes.CSS_FUNCTION_TOKEN) {
            int functionOffset = lexer.getTokenStart();
            if ("rgb".equalsIgnoreCase(value.toString())) {
                lexer.advance();
                tokenType = lexer.getTokenType();
                if (CssElementTypes.CSS_LPAREN == tokenType) {
                    lexer.advance();
                    String rgb_hex = CssIndex.extractColorComponent(lexer, input);
                    if (rgb_hex != null) {
                        callback.index(functionOffset, CssIndexValue.COLOR_RGB, rgb_hex);
                    }
                }
            }
        }
    }

    @Nullable
    private static String extractColorComponent(Lexer lexer, CharSequence input) {
        IElementType tokenType = lexer.getTokenType();
        if (CssElementTypes.CSS_COMMA == tokenType) {
            lexer.advance();
            tokenType = lexer.getTokenType();
        }
        if (CssElementTypes.CSS_NUMBER == tokenType) {
            int color_value;
            CharSequence number = input.subSequence(lexer.getTokenStart(), lexer.getTokenEnd());
            try {
                color_value = Integer.valueOf(number.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
            lexer.advance();
            tokenType = lexer.getTokenType();
            if (CssElementTypes.CSS_PERCENT == tokenType) {
                color_value = (int)((float)color_value / 100.0f * 255.0f);
                lexer.advance();
                tokenType = lexer.getTokenType();
            }
            String hex_number = Integer.toHexString(color_value);
            StringBuilder result = new StringBuilder();
            if (hex_number.length() < 2) {
                result.append('0');
            }
            result.append(hex_number);
            if (CssElementTypes.CSS_COMMA != tokenType) {
                return result.toString();
            }
            String next_components = CssIndex.extractColorComponent(lexer, input);
            if (next_components != null) {
                return result + next_components;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/index/CssIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/index/CssIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "indexValues";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    private static abstract class CssIndexCallback {
        private CssIndexCallback() {
        }

        abstract void index(int var1, @Nullable CssIndexValue var2, @NotNull String var3);
    }
}

