/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.lexer;

import com.intellij.lang.puppet.PuppetLanguage;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.util.PuppetConfigurationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetLexerKeywords
implements PuppetTokenTypes {
    private static final Map<String, IElementType> COMMON_KEYWORDS_MAP = new HashMap<String, IElementType>();
    private static final Map<PuppetLanguage.Version, Map<String, IElementType>> VERSIONED_KEYWORDS_MAP = new HashMap<PuppetLanguage.Version, Map<String, IElementType>>();

    public static TokenSet getAllKeywordsTokenset() {
        TokenSet result = TokenSet.EMPTY;
        for (Map<String, IElementType> map : VERSIONED_KEYWORDS_MAP.values()) {
            Collection<IElementType> values = map.values();
            result = TokenSet.orSet((TokenSet[])new TokenSet[]{result, TokenSet.create((IElementType[])values.toArray(IElementType.EMPTY_ARRAY))});
        }
        return result;
    }

    @NotNull
    public static Map<String, IElementType> getKeywordsMap(@Nullable Project project) {
        return project == null ? COMMON_KEYWORDS_MAP : PuppetLexerKeywords.getKeywordsMap(PuppetConfigurationUtil.getPuppetVersion(project));
    }

    @NotNull
    public static Map<String, IElementType> getKeywordsMap(@Nullable PuppetLanguage.Version version) {
        if (version == null) {
            Map<String, IElementType> map = COMMON_KEYWORDS_MAP;
            if (map == null) {
                PuppetLexerKeywords.$$$reportNull$$$0(0);
            }
            return map;
        }
        Map<String, IElementType> keywordsMap = VERSIONED_KEYWORDS_MAP.get((Object)version);
        assert (keywordsMap != null) : "Keywords map is not defined for puppet version: " + version;
        Map<String, IElementType> map = keywordsMap;
        if (map == null) {
            PuppetLexerKeywords.$$$reportNull$$$0(1);
        }
        return map;
    }

    static {
        COMMON_KEYWORDS_MAP.put("case", CASE);
        COMMON_KEYWORDS_MAP.put("class", CLASS);
        COMMON_KEYWORDS_MAP.put("default", DEFAULT);
        COMMON_KEYWORDS_MAP.put("define", DEFINE);
        COMMON_KEYWORDS_MAP.put("if", IF);
        COMMON_KEYWORDS_MAP.put("elsif", ELSIF);
        COMMON_KEYWORDS_MAP.put("else", ELSE);
        COMMON_KEYWORDS_MAP.put("inherits", INHERITS);
        COMMON_KEYWORDS_MAP.put("node", NODE);
        COMMON_KEYWORDS_MAP.put("and", AND);
        COMMON_KEYWORDS_MAP.put("or", OR);
        COMMON_KEYWORDS_MAP.put("undef", UNDEF);
        COMMON_KEYWORDS_MAP.put("false", FALSE);
        COMMON_KEYWORDS_MAP.put("true", TRUE);
        COMMON_KEYWORDS_MAP.put("in", IN);
        COMMON_KEYWORDS_MAP.put("unless", UNLESS);
        HashMap<String, IElementType> puppet3KeywordsMap = new HashMap<String, IElementType>();
        VERSIONED_KEYWORDS_MAP.put(PuppetLanguage.Version.PUPPET_3, puppet3KeywordsMap);
        puppet3KeywordsMap.putAll(COMMON_KEYWORDS_MAP);
        puppet3KeywordsMap.put("import", IMPORT);
        HashMap<String, IElementType> puppet4KeywordsMap = new HashMap<String, IElementType>();
        VERSIONED_KEYWORDS_MAP.put(PuppetLanguage.Version.PUPPET_4, puppet4KeywordsMap);
        puppet4KeywordsMap.putAll(COMMON_KEYWORDS_MAP);
        puppet4KeywordsMap.put("function", FUNCTION);
        puppet4KeywordsMap.put("attr", ATTR);
        puppet4KeywordsMap.put("private", PRIVATE);
        puppet4KeywordsMap.put("application", APPLICATION);
        puppet4KeywordsMap.put("consumes", CONSUMES);
        puppet4KeywordsMap.put("produces", PRODUCES);
        puppet4KeywordsMap.put("site", SITE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/puppet/lexer/PuppetLexerKeywords", "getKeywordsMap"));
    }
}

