/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.project;

import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.lang.puppet.project.PuppetProjectManager;
import com.intellij.lang.puppet.project.PuppetProjectModel;
import com.intellij.lang.puppet.project.PuppetScopeManager;
import com.intellij.lang.puppet.project.meta.PuppetHeadlessModuleMetadata;
import com.intellij.lang.puppet.project.meta.PuppetModuleMetadata;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetModule
extends PuppetEntity<PuppetModuleMetadata> {
    public static final String DEPENDENCIES_DIR = ".dependencies";
    public static final String FIXTURES_FILE = ".fixtures.yml";
    public static final String FIXTURES_DEPENDENCIES_DIR = "spec/fixtures/modules";
    private static final List<String> MEANINGFUL_SUB_DIRECTORIES = Arrays.asList("manifests", "functions", "lib", "facts.d");
    private final Comparator<PuppetModule> MODULE_DEPENDENCY_COMPARATOR;

    public PuppetModule(@NotNull Project project, @NotNull VirtualFile root, @NotNull PuppetModuleMetadata metadata) {
        if (project == null) {
            PuppetModule.$$$reportNull$$$0(0);
        }
        if (root == null) {
            PuppetModule.$$$reportNull$$$0(1);
        }
        if (metadata == null) {
            PuppetModule.$$$reportNull$$$0(2);
        }
        super(project, root, metadata);
        this.MODULE_DEPENDENCY_COMPARATOR = (o1, o2) -> Boolean.compare(o1.isInternalDependency(), o2.isInternalDependency());
    }

    @Override
    @NotNull
    protected List<String> getMeaningfulSubDirectoryNames() {
        List<String> list = MEANINGFUL_SUB_DIRECTORIES;
        if (list == null) {
            PuppetModule.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean isInternalDependency() {
        PuppetEntity parentEntity = this.getContainingEntity();
        if (parentEntity == null) {
            return false;
        }
        return parentEntity.isUnderDependenciesRoot(this.getRoot());
    }

    @NotNull
    public String getShortName() {
        String string = this.getRoot().getName();
        if (string == null) {
            PuppetModule.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private PuppetEntity getContainingEntity() {
        if (!this.isValid()) {
            return null;
        }
        VirtualFile parent = this.getRoot().getParent();
        if (parent == null) {
            return null;
        }
        return PuppetProjectModel.getInstance(this.getProject()).getPuppetModuleOrEnvironment(parent.getParent());
    }

    @Override
    public boolean isUnderDependenciesRoot(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PuppetModule.$$$reportNull$$$0(5);
        }
        return this.isValid() && PuppetModule.isUnderRoot(virtualFile, Arrays.asList(this.getLibrarianDependenciesRoot(), this.getFixturesDependenciesRoot()));
    }

    public boolean isHeadless() {
        return this.getMetadata() instanceof PuppetHeadlessModuleMetadata;
    }

    @Override
    @NotNull
    public List<VirtualFile> getAllDependenciesRoots() {
        VirtualFile effectiveRoot = this.hasFixturesFile() ? this.getFixturesDependenciesRoot() : this.getLibrarianDependenciesRoot();
        List list = ContainerUtil.createMaybeSingletonList((Object)effectiveRoot);
        if (list == null) {
            PuppetModule.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private VirtualFile getFixturesDependenciesRoot() {
        return this.isValid() ? this.getRoot().findFileByRelativePath(FIXTURES_DEPENDENCIES_DIR) : null;
    }

    @Override
    @NotNull
    public String getLibrarianDependenciesRootName() {
        return DEPENDENCIES_DIR;
    }

    @Override
    @NotNull
    public String getDescriptiveName() {
        String string = PuppetBundle.message("puppet.module", new Object[0]);
        if (string == null) {
            PuppetModule.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public List<PuppetModule> getDependencies() {
        if (this.hasFixturesFile()) {
            return this.getDependenciesFromFixtures();
        }
        if (this.getPuppetFile() != null) {
            return this.getDependenciesFromPuppetfile();
        }
        return this.getDependenciesFromMetadata();
    }

    @NotNull
    private List<PuppetModule> getDependenciesFromFixtures() {
        List<PuppetModule> list = PuppetProjectManager.getInstance(this.getProject()).getModulesInRoot(this.getFixturesDependenciesRoot());
        if (list == null) {
            PuppetModule.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private List<PuppetModule> getDependenciesFromPuppetfile() {
        List<PuppetModule> list = PuppetProjectManager.getInstance(this.getProject()).getModulesInRoot(this.getLibrarianDependenciesRoot());
        if (list == null) {
            PuppetModule.$$$reportNull$$$0(9);
        }
        return list;
    }

    public boolean hasFixturesFile() {
        return this.isValid() && this.getRoot().findChild(FIXTURES_FILE) != null;
    }

    @NotNull
    private List<PuppetModule> getDependenciesFromMetadata() {
        PuppetModuleMetadata metadata = (PuppetModuleMetadata)this.getMetadata();
        List<PuppetModuleMetadata.Dependency> dependencies = metadata.getDependencies();
        if (dependencies.isEmpty()) {
            List<PuppetModule> list = Collections.emptyList();
            if (list == null) {
                PuppetModule.$$$reportNull$$$0(10);
            }
            return list;
        }
        HashMap<String, PuppetModuleMetadata.Dependency> dependencyMap = new HashMap<String, PuppetModuleMetadata.Dependency>();
        for (PuppetModuleMetadata.Dependency dependency : dependencies) {
            String dependencyName = dependency.getName();
            if (!StringUtil.isNotEmpty((String)dependencyName)) continue;
            dependencyMap.putIfAbsent(dependencyName.replace('/', '-'), dependency);
        }
        List<PuppetModule> projectModules = PuppetProjectModel.getInstance(this.getProject()).getAllModules();
        ContainerUtil.sort(projectModules, this.MODULE_DEPENDENCY_COMPARATOR);
        ArrayList<PuppetModule> result = new ArrayList<PuppetModule>();
        for (PuppetModule module : projectModules) {
            if (this.equals(module) || dependencyMap.remove(module.getName()) == null) continue;
            result.add(module);
        }
        ArrayList<PuppetModule> arrayList = result;
        if (arrayList == null) {
            PuppetModule.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Override
    @RequiresReadLock
    @Nullable
    GlobalSearchScope calcResolveScope() {
        ThreadingAssertions.softAssertReadAccess();
        if (this.isInternalDependency()) {
            PuppetEntity containingEntity = this.getContainingEntity();
            assert (containingEntity != null);
            return PuppetScopeManager.getInstance(this.getProject()).getResolveScope(containingEntity);
        }
        return super.calcResolveScope();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/project/PuppetModule";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/project/PuppetModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMeaningfulSubDirectoryNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependenciesRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptiveName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependenciesFromFixtures";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependenciesFromPuppetfile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependenciesFromMetadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUnderDependenciesRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

