/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.ObjectUtils;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettings;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitTestType;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeunitSettingsSerializationUtils {
    private NodeunitSettingsSerializationUtils() {
    }

    @NotNull
    public static NodeunitSettings readFromJDomElement(@NotNull Element element) {
        if (element == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(0);
        }
        NodeunitSettings.Builder builder = new NodeunitSettings.Builder();
        String interpreterRefName = JDOMExternalizer.readString((Element)element, (String)Key.NODE_PATH.getKey());
        if (interpreterRefName != null) {
            builder.setInterpreterRef(NodeJsInterpreterRef.create((String)interpreterRefName));
        }
        EnvironmentVariablesData envData = EnvironmentVariablesData.readExternal((Element)element);
        builder.setEnvData(envData);
        String workingDirectoryPath = NodeunitSettingsSerializationUtils.readString(element, Key.WORKING_DIRECTORY);
        if (!workingDirectoryPath.isEmpty()) {
            builder.setWorkingDirectory(FileUtil.toSystemDependentName((String)workingDirectoryPath));
        }
        builder.setNodeunitPackage(new NodePackage(NodeunitSettingsSerializationUtils.readString(element, Key.NODEUNIT_MODULE_DIR)));
        NodeunitTestType testType = (NodeunitTestType)((Object)NodeunitSettingsSerializationUtils.readEnumByName(element));
        builder.setTestType(testType);
        if (testType == NodeunitTestType.DIRECTORY) {
            NodeunitSettingsSerializationUtils.readDirectory(builder, element);
        } else if (testType == NodeunitTestType.JS_FILE) {
            NodeunitSettingsSerializationUtils.readJsFile(builder, element);
        } else if (testType == NodeunitTestType.TEST) {
            NodeunitSettingsSerializationUtils.readTest(builder, element);
        } else {
            throw new RuntimeException("Unknown testType: " + testType);
        }
        NodeunitSettings nodeunitSettings = builder.build();
        if (nodeunitSettings == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(1);
        }
        return nodeunitSettings;
    }

    private static void readDirectory(@NotNull NodeunitSettings.Builder builder, @NotNull Element element) {
        if (builder == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(2);
        }
        if (element == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(3);
        }
        String directory = NodeunitSettingsSerializationUtils.readString(element, Key.DIRECTORY);
        builder.setDirectory(FileUtil.toSystemDependentName((String)directory));
    }

    private static void readJsFile(@NotNull NodeunitSettings.Builder builder, @NotNull Element element) {
        if (builder == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(4);
        }
        if (element == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(5);
        }
        String jsFile = NodeunitSettingsSerializationUtils.readString(element, Key.JS_FILE);
        builder.setJsFilePath(FileUtil.toSystemDependentName((String)jsFile));
    }

    private static void readTest(@NotNull NodeunitSettings.Builder builder, @NotNull Element element) {
        if (builder == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(6);
        }
        if (element == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(7);
        }
        NodeunitSettingsSerializationUtils.readJsFile(builder, element);
        String testName = NodeunitSettingsSerializationUtils.readString(element, Key.TEST_NAME);
        builder.setTest(testName);
    }

    public static void writeToJDomElement(@NotNull Element element, @NotNull NodeunitSettings settings) {
        if (element == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(9);
        }
        JdomKt.addOptionTag((Element)element, (String)Key.NODE_PATH.getKey(), (String)settings.getInterpreterRef().getReferenceName(), (String)"setting");
        settings.getEnvData().writeExternal(element);
        NodeunitSettingsSerializationUtils.writeString(element, Key.NODEUNIT_MODULE_DIR, settings.getNodeunitPackage().getSystemIndependentPath());
        NodeunitSettingsSerializationUtils.writeString(element, Key.WORKING_DIRECTORY, FileUtil.toSystemIndependentName((String)settings.getWorkingDirectory()));
        NodeunitTestType testType = settings.getTestType();
        NodeunitSettingsSerializationUtils.writeString(element, Key.TEST_TYPE, testType.name());
        if (testType == NodeunitTestType.DIRECTORY) {
            NodeunitSettingsSerializationUtils.writeDirectory(element, settings);
        } else if (testType == NodeunitTestType.JS_FILE) {
            NodeunitSettingsSerializationUtils.writeJsFile(element, settings);
        } else if (testType == NodeunitTestType.TEST) {
            NodeunitSettingsSerializationUtils.writeTest(element, settings);
        } else {
            throw new RuntimeException("Unknown testType: " + testType);
        }
    }

    private static void writeTest(@NotNull Element element, @NotNull NodeunitSettings settings) {
        if (element == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(11);
        }
        NodeunitSettingsSerializationUtils.writeJsFile(element, settings);
        String testName = settings.getTestName();
        NodeunitSettingsSerializationUtils.writeString(element, Key.TEST_NAME, testName);
    }

    private static void writeDirectory(@NotNull Element element, @NotNull NodeunitSettings settings) {
        if (element == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(12);
        }
        if (settings == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(13);
        }
        String directory = FileUtil.toSystemIndependentName((String)settings.getDirectory());
        NodeunitSettingsSerializationUtils.writeString(element, Key.DIRECTORY, directory);
    }

    private static void writeJsFile(@NotNull Element element, @NotNull NodeunitSettings settings) {
        if (element == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(14);
        }
        if (settings == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(15);
        }
        String jsFilePath = settings.getJsFile();
        NodeunitSettingsSerializationUtils.writeString(element, Key.JS_FILE, FileUtil.toSystemIndependentName((String)jsFilePath));
    }

    @NotNull
    private static <E extends Enum<E>> E readEnumByName(@NotNull Element element) {
        if (element == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(16);
        }
        String str = NodeunitSettingsSerializationUtils.readString(element, Key.TEST_TYPE);
        Object enumConstant = NodeunitSettingsSerializationUtils.findEnumByName(NodeunitTestType.JS_FILE.getDeclaringClass(), str);
        Enum enum_ = (Enum)ObjectUtils.notNull(enumConstant, (Object)((Object)NodeunitTestType.JS_FILE));
        if (enum_ == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(17);
        }
        return (E)enum_;
    }

    private static <E extends Enum> E findEnumByName(@NotNull Class<E> enumClass, @NotNull String value) {
        if (enumClass == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(18);
        }
        if (value == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(19);
        }
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            if (!value.equals(e.name())) continue;
            return (E)e;
        }
        return null;
    }

    private static void writeString(@NotNull Element element, @NotNull Key key, @Nullable String value) {
        if (element == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(20);
        }
        if (key == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(21);
        }
        if (value != null) {
            JdomKt.addOptionTag((Element)element, (String)key.getKey(), (String)value, (String)"setting");
        }
    }

    @NotNull
    private static String readString(@NotNull Element element, @NotNull Key key) {
        if (element == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(22);
        }
        if (key == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(23);
        }
        String value = JDOMExternalizer.readString((Element)element, (String)key.getKey());
        String string = StringUtil.notNullize((String)value);
        if (string == null) {
            NodeunitSettingsSerializationUtils.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 17, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readFromJDomElement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "readEnumByName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "readString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFromJDomElement";
                break;
            }
            case 1: 
            case 17: 
            case 24: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readDirectory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readJsFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readTest";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeToJDomElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeTest";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeDirectory";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writeJsFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readEnumByName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findEnumByName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "writeString";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "readString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 17, 24 -> new IllegalStateException(string);
        };
    }

    private static enum Key {
        NODE_PATH("nodePath"),
        PASS_PARENT_ENV_VARS("passParentEnvVars"),
        NODEUNIT_MODULE_DIR("nodeunitModuleDir"),
        WORKING_DIRECTORY("workingDirectory"),
        TEST_TYPE("testType"),
        DIRECTORY("directory"),
        JS_FILE("jsFile"),
        TEST_NAME("testName");

        private final String key;

        private Key(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

