/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8LogIndexesWriter;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.EventsStripeData;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.ChartPanel;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameColors;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.V8CpuFlameChart;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.Nls;

public class EventsStripe
extends ChartPanel {
    public static final int LINE_HEIGHT = 10;
    public static final int SPACE = 2;
    private final V8LogCachingReader myReader;
    private final java.util.function.Consumer<? super String> myNotificator;
    private final V8CpuFlameChart myFlameChart;
    private EventsStripeData myEventsStripeData;
    private boolean myIsLoading;
    private boolean myEmpty;
    private final Object myLock;
    private long mySelectionFrom;
    private long mySelectionTo;
    private java.util.function.Consumer<Boolean> myUIUpdate;
    @Nls
    static final String[] LEGEND = new String[]{NodeJSBundle.message("gc", new Object[0]), NodeJSBundle.message("engine", new Object[0]), NodeJSBundle.message("external", new Object[0]), NodeJSBundle.message("execution", new Object[0])};

    public EventsStripe(int left, int rightMargin, V8LogCachingReader reader, java.util.function.Consumer<? super String> notificator, V8CpuFlameChart view) {
        super(left, rightMargin, 0, 40, 0L, reader.getLastTick());
        this.myNotificator = notificator;
        this.myFlameChart = view;
        this.myLock = new Object();
        this.mySelectionFrom = 0L;
        this.mySelectionTo = reader.getLastTick();
        this.myEmpty = true;
        this.myIsLoading = false;
        this.myReader = reader;
        this.myTop = this.myGridTop = this.myGridFontHeight;
        this.myHeight = 40 + this.myTop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData() {
        long to;
        long from;
        Object object = this.myLock;
        synchronized (object) {
            from = this.mySelectionFrom;
            to = this.mySelectionTo;
        }
        try {
            EventsStripeData events = this.myReader.getTimerEvents(from, to);
            this.myUIUpdate = this.createUpdate(from, to, events);
        }
        catch (IOException e) {
            this.myNotificator.accept("Can not get data for flame chart events: " + e.getMessage());
            this.myUIUpdate = t -> {};
        }
    }

    public java.util.function.Consumer<Boolean> getUIUpdate() {
        return this.myUIUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selection(long from, long to) throws IOException {
        assert (from >= 0L && to >= 0L);
        this.myIsLoading = true;
        Object object = this.myLock;
        synchronized (object) {
            this.mySelectionFrom = from;
            this.mySelectionTo = to;
        }
    }

    private java.util.function.Consumer<Boolean> createUpdate(long from, long to, EventsStripeData events) {
        return reloadingIsEmpty -> {
            this.myRealLeft = from;
            this.myRealRight = to;
            this.myIsLoading = reloadingIsEmpty == false;
            this.myEventsStripeData = events != null ? events : null;
            this.myEmpty = this.myEventsStripeData == null || this.myFlameChart.isEmpty();
            this.revalidate();
            this.repaint();
        };
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.myLeft + this.myRightMargin + 10, this.myTop + 40);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(size.width, this.myTop + 40);
    }

    @Override
    protected void drawTsGrid(Graphics2D g) {
        if (!this.myEmpty) {
            super.drawTsGrid(g);
        }
    }

    @Override
    protected void drawChart(Graphics2D graphics2D, int left, int top, int width, int height, int gridGap) {
        if (this.myEmpty || this.myIsLoading) {
            return;
        }
        V8Utils.safeDraw(graphics2D, (Consumer<? super Graphics2D>)((Consumer)graphics -> {
            List<TreeMap<Long, V8LogIndexesWriter.TimerEvent>> ordered = this.myEventsStripeData.getOrdered();
            for (int i = 0; i < ordered.size(); ++i) {
                TreeMap<Long, V8LogIndexesWriter.TimerEvent> map = ordered.get(i);
                Color color = FlameColors.EVENTS_COLORS[i];
                for (V8LogIndexesWriter.TimerEvent event : map.values()) {
                    int startX = Math.max(this.myLeft, this.pixelsFromReal(event.getStartNanos()));
                    int endX = Math.max(this.myLeft, this.pixelsFromReal(event.getStartNanos() + event.getPause()));
                    if (startX > width + this.myLeft) continue;
                    if (endX > width + this.myLeft) {
                        endX = width + this.myLeft;
                    }
                    graphics.setColor(color);
                    graphics.fillRect(startX, this.myTop + i * 10, endX - startX, 8);
                }
            }
            Pair<Long, Integer> position = this.myFlameChart.getDetailsPosition();
            V8CpuFlameChart.drawDetailsLine(graphics, this.getVisibleRect(), height, this.pixelsFromReal((Long)position.getFirst()), top);
        }));
    }

    public static void drawLegend(Graphics2D graphics2D) {
        V8Utils.safeDraw(graphics2D, (Consumer<? super Graphics2D>)((Consumer)graphics -> {
            FontMetrics fm = graphics.getFontMetrics();
            Font font1 = graphics.getFont().deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            graphics.setFont(font1);
            int height1 = fm.getHeight();
            int x1 = 10;
            for (int i = 0; i < FlameColors.EVENTS_COLORS.length; ++i) {
                graphics.setColor(FlameColors.EVENTS_COLORS[i]);
                graphics.fillRect(x1, height1 + 2 - 10 + 2, 8, 8);
                graphics.setColor(Color.gray);
                graphics.drawString(LEGEND[i], x1 + 5 + 10, height1 + 2);
                x1 += fm.stringWidth(LEGEND[i]) + 20 + 2;
            }
        }));
    }

    public void setRight(int right) {
        this.myRightMargin = right;
    }

    public void detailsChanged() {
        this.revalidate();
        this.repaint();
    }
}

