/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.BeforeAfter;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ReadV8LogRawAction;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8CpuViewCallback;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8CpuViewCreatorPartner;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8StackTableModel;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.ChartPanel;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameChartParameters;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameChartView;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.V8CpuOverviewChart;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingMainComponent;
import icons.NodeJSIcons;
import java.io.IOException;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZoomFlameChartAnAction
extends DumbAwareAction {
    private final Project myProject;
    private final V8LogCachingReader myReader;
    @Nls
    private final String myDescription;
    private final Consumer<String> myNotificator;
    private final FlameChartView myFlameChartView;
    private final V8CpuViewCallback myViewCallback;

    public ZoomFlameChartAnAction(Project project, V8LogCachingReader reader, @Nls String description, Consumer<String> notificator, FlameChartView flameChartView, V8CpuViewCallback viewCallback) {
        super(NodeJSBundle.message("action.ZoomFlameChartAnAction.text", new Object[0]), NodeJSBundle.message("action.ZoomFlameChartAnAction.description", new Object[0]), AllIcons.Graph.ZoomIn);
        this.myProject = project;
        this.myReader = reader;
        this.myDescription = description;
        this.myNotificator = notificator;
        this.myFlameChartView = flameChartView;
        this.myViewCallback = viewCallback;
    }

    private BeforeAfter<Long> getInterval() {
        V8CpuOverviewChart overviewChart = this.myFlameChartView.getOverviewChart();
        if (overviewChart.isSelectionNarrow()) {
            return new BeforeAfter((Object)overviewChart.getLeftBound(), (Object)overviewChart.getRightBound());
        }
        return null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ZoomFlameChartAnAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ZoomFlameChartAnAction.$$$reportNull$$$0(1);
        }
        BeforeAfter<Long> interval = this.getInterval();
        e.getPresentation().setEnabled(interval != null && (Long)interval.getBefore() >= 0L && (Long)interval.getAfter() >= 0L);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        BeforeAfter<Long> interval;
        if (e == null) {
            ZoomFlameChartAnAction.$$$reportNull$$$0(2);
        }
        if ((interval = this.getInterval()) == null || (Long)interval.getBefore() < 0L || (Long)interval.getAfter() < 0L) {
            return;
        }
        Long detailsPosition = (Long)e.getData(V8Utils.DETAILS_POSITION);
        V8StackTableModel model = (V8StackTableModel)this.myFlameChartView.getStackTraceTable().getModel();
        int row = this.myFlameChartView.getStackTraceTable().getSelectedRow();
        V8CpuLogCall call = row == -1 ? null : model.getCall(row);
        ZoomTask zoomTask = new ZoomTask(this.myProject, this.myReader, this.myDescription, this.myNotificator, interval).withDetailsPosition(detailsPosition);
        if (call != null) {
            zoomTask = zoomTask.withStringId(call.getStringId());
        }
        ProgressManager.getInstance().run((Task)zoomTask);
        this.myViewCallback.updateActionsAvailability();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/cpu/v8log/ui/ZoomFlameChartAnAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/ui/ZoomFlameChartAnAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public static class ZoomTask
    extends Task.Backgroundable {
        private final Project myProject;
        private final V8LogCachingReader myReader;
        @Nls
        private final String myDescription;
        private final Consumer<String> myNotificator;
        private final BeforeAfter<Long> myInterval;
        private final FlameChartParameters myParameters;
        private V8LogCachingReader myCopyReader;

        public ZoomTask(@Nullable Project project, V8LogCachingReader reader, @Nls String description, Consumer<String> notificator, BeforeAfter<Long> interval) {
            super(project, NodeJSBundle.message("progress.title.zooming.v8.cpu.flamechart", new Object[0]), true);
            this.myProject = project;
            this.myReader = reader;
            this.myDescription = description;
            this.myNotificator = notificator;
            this.myInterval = interval;
            this.myParameters = new FlameChartParameters();
            this.myParameters.setNotInitial(true);
        }

        public ZoomTask withDetailsPosition(Long details) {
            this.myParameters.setDetailsPosition(details);
            return this;
        }

        public ZoomTask withStringId(long stringId) {
            this.myParameters.setStringId(stringId);
            return this;
        }

        public ZoomTask withSelection(long from, long to) {
            this.myParameters.setSelection((BeforeAfter<Long>)new BeforeAfter((Object)from, (Object)to));
            return this;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ZoomTask.$$$reportNull$$$0(0);
            }
            try {
                this.myCopyReader = this.myReader.cloneReader((Long)this.myInterval.getBefore(), (Long)this.myInterval.getAfter());
            }
            catch (IOException e1) {
                this.myNotificator.accept(e1.getMessage());
            }
        }

        public void onSuccess() {
            String zoomDescription = this.myDescription + ": " + ChartPanel.getIntervalDescription((Long)this.myInterval.getBefore(), (Long)this.myInterval.getAfter());
            V8CpuViewCreatorPartner partner = new V8CpuViewCreatorPartner(this.myProject, this.myCopyReader.getResources(), this.myCopyReader, this.myNotificator, this.myDescription, (Long)this.myInterval.getBefore(), (Long)this.myInterval.getAfter(), this.myParameters);
            V8ProfilingMainComponent.showMe(this.myProject, zoomDescription, ReadV8LogRawAction.TOOL_WINDOW_TITLE.get(), NodeJSIcons.OpenV8ProfilingLog_ToolWin, 1, partner, null, zoomDescription, AllIcons.Graph.ZoomIn);
            partner.getViewController().showTab(FlameChartView.FLAME_CHART.get());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nodejs/run/profile/cpu/v8log/ui/ZoomFlameChartAnAction$ZoomTask", "run"));
        }
    }
}

