/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.ref;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.django.ref.DjangoDirectoryReferenceSet;
import com.intellij.python.django.templateFSLoader.PyDjangoTemplateFSLoader;
import com.intellij.util.ProcessingContext;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.model.applications.DjangoAppConfigClassUtil;
import com.jetbrains.django.ref.DjangoItemReferenceSet;
import com.jetbrains.django.util.DjangoCoreUtil;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.PsiQuery;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralFileReferenceSet;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.WeakFileReference;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyPathEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoSettingsPyReferenceProvider
extends PsiReferenceProvider {
    private static final PsiElementPattern.Capture<PsiElement> LOG_CLASS_PATTERN = DjangoPsiUtil.valueInsideDictPattern((String)"class", (String)"LOGGING");

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(1);
        }
        assert (element instanceof PyStringLiteralExpression);
        PyStringLiteralExpression stringLiteral = (PyStringLiteralExpression)element;
        PsiReference[] references = DjangoSettingsPyReferenceProvider.findInOsPathJoin(stringLiteral);
        if (references != null) {
            if (references == null) {
                DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(2);
            }
            return references;
        }
        if (DjangoPsiUtil.isSettingsPy((PsiElement)element)) {
            if (DjangoSettingsPyReferenceProvider.isShouldBeAFilePath(element)) {
                PsiReference[] psiReferenceArray = DjangoSettingsPyReferenceProvider.getFileReferencesForStringLiteral(element, stringLiteral);
                if (psiReferenceArray == null) {
                    DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }
            if (DjangoSettingsPyReferenceProvider.inTemplateLoadersList(element) || DjangoSettingsPyReferenceProvider.inStaticFilesFindersList(element)) {
                PsiReference[] psiReferenceArray = DjangoItemReferenceSet.createClassesAndFunctionsReferenceSet((PsiElement)element).getAllReferences();
                if (psiReferenceArray == null) {
                    DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(4);
                }
                return psiReferenceArray;
            }
            if (DjangoSettingsPyReferenceProvider.inMiddlewareClassesList(element) || DjangoSettingsPyReferenceProvider.inFileUploadHandlersList(element) || DjangoSettingsPyReferenceProvider.inLogClasses(element) || DjangoSettingsPyReferenceProvider.inTestRunner(element) || DjangoPsiUtil.isElementOfListOrTupleAssignedTo((PsiElement)element, (String[])new String[]{"AUTHENTICATION_BACKENDS"})) {
                PsiReference[] psiReferenceArray = DjangoItemReferenceSet.createClassesAndFunctionsReferenceSet((PsiElement)element).getAllReferences();
                if (psiReferenceArray == null) {
                    DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(5);
                }
                return psiReferenceArray;
            }
            if (DjangoSettingsPyReferenceProvider.inInstalledAppsList(element)) {
                PsiReference[] psiReferenceArray = DjangoAppConfigClassUtil.getAppReferences((PsiElement)element);
                if (psiReferenceArray == null) {
                    DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(6);
                }
                return psiReferenceArray;
            }
            if (DjangoPsiUtil.isAssignedTo((ASTNode)element.getNode(), (String)"ROOT_URLCONF")) {
                PsiReference[] psiReferenceArray = DjangoItemReferenceSet.createFilesReferenceSet((PsiElement)element).getAllReferences();
                if (psiReferenceArray == null) {
                    DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(7);
                }
                return psiReferenceArray;
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(8);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            DjangoSettingsPyReferenceProvider.$$$reportNull$$$0(9);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static PsiReference @Nullable [] findInOsPathJoin(PyStringLiteralExpression stringLiteral) {
        PyExpression pyExpression;
        PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)stringLiteral, PyCallExpression.class);
        if (call != null && (pyExpression = call.getCallee()) instanceof PyQualifiedExpression) {
            VirtualFile rootPath;
            int literalIndex;
            PyQualifiedExpression qualExpr = (PyQualifiedExpression)pyExpression;
            PyExpression qualifier = qualExpr.getQualifier();
            if (call.isCalleeText(new String[]{"join"}) && qualifier != null && "path".equals(qualifier.getName()) && (literalIndex = PyPsiUtils.findArgumentIndex((PyCallExpression)call, (PsiElement)stringLiteral)) >= 0 && ((rootPath = DjangoSettingsPyReferenceProvider.evaluateRootPath(call, literalIndex)) != null || literalIndex == 0)) {
                return new PyStringLiteralFileReferenceSet(stringLiteral){

                    public FileReference createFileReference(TextRange range, int index, String text) {
                        return new WeakFileReference((FileReferenceSet)this, range, index, text){

                            @Nullable
                            public HighlightSeverity getUnresolvedHighlightSeverity(TypeEvalContext context) {
                                if (literalIndex == 0) {
                                    return null;
                                }
                                return HighlightSeverity.WEAK_WARNING;
                            }
                        };
                    }

                    @NotNull
                    public Collection<PsiFileSystemItem> computeDefaultContexts() {
                        PsiDirectory dir;
                        if (literalIndex == 0) {
                            Collection collection = super.computeDefaultContexts();
                            if (collection == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return collection;
                        }
                        PsiFile containingFile = this.getContainingFile();
                        if (containingFile != null && (dir = containingFile.getManager().findDirectory(rootPath)) != null) {
                            List<PsiDirectory> list = Collections.singletonList(dir);
                            if (list == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return list;
                        }
                        List<PsiFileSystemItem> list = Collections.emptyList();
                        if (list == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return list;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/python/django/ref/DjangoSettingsPyReferenceProvider$1", "computeDefaultContexts"));
                    }
                }.getAllReferences();
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile evaluateRootPath(PyCallExpression call, int literalIndex) {
        String pathBefore;
        VirtualFile file;
        PsiFile containingFile = call.getContainingFile();
        if (containingFile != null && (file = containingFile.getOriginalFile().getVirtualFile()) != null && !StringUtil.isEmpty((String)(pathBefore = new PyPathEvaluator(file.getPath()).evaluatePathInJoin(call.getArguments(), literalIndex)))) {
            VirtualFile evaluatedPath = VirtualFileUtil.findFile((String)pathBefore);
            if (evaluatedPath == null && file.getFileSystem() instanceof TempFileSystem) {
                evaluatedPath = file.getFileSystem().findFileByPath(pathBefore.replace("\\", "/"));
            }
            if (evaluatedPath == null && ApplicationManager.getApplication().isUnitTestMode()) {
                evaluatedPath = TempFileSystem.getInstance().findFileByPath(pathBefore);
            }
            return evaluatedPath;
        }
        return null;
    }

    private static boolean isShouldBeAFilePath(PsiElement element) {
        return DjangoSettingsPyReferenceProvider.inTemplatesDirsList(element) || DjangoSettingsPyReferenceProvider.inMediaRoot(element) || DjangoSettingsPyReferenceProvider.inStaticRoot(element) || DjangoSettingsPyReferenceProvider.inStaticDirsList(element) || DjangoSettingsPyReferenceProvider.inSqliteDatabaseNameValue(element);
    }

    private static PsiReference[] getFileReferencesForStringLiteral(PsiElement element, PyStringLiteralExpression stringLiteral) {
        PsiFile file = DjangoPsiUtil.getFile((PsiElement)element);
        if (file == null || file.getParent() == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        List textRanges = stringLiteral.getStringValueTextRanges();
        if (!textRanges.isEmpty()) {
            if (DjangoSettingsPyReferenceProvider.inSqliteDatabaseNameValue(element)) {
                return new SqlitePathFileReferenceSet(stringLiteral).getAllReferences();
            }
            return new DjangoDirectoryReferenceSet(PyStringLiteralCoreUtil.stripQuotesAroundValue((String)stringLiteral.getStringValue()), stringLiteral, ((TextRange)textRanges.get(0)).getStartOffset(), null, file.getViewProvider().getVirtualFile().isCaseSensitive()).getAllReferences();
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean inSqliteDatabaseNameValue(PsiElement element) {
        PyAssignmentStatement parent;
        ASTNode node = element.getNode().getTreeParent();
        return "NAME".equals(PyStringLiteralUtil.getStringValue((String)node.getFirstChildNode().getText())) && node.getFirstChildNode().getPsi() != element && DjangoSettingsPyReferenceProvider.isSqliteEngine(node) && (parent = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAssignmentStatement.class)) != null && parent.isAssignmentTo("DATABASES");
    }

    private static boolean isSqliteEngine(ASTNode node) {
        ASTNode parentNode = node.getTreeParent();
        if (parentNode.getElementType() == PyElementTypes.DICT_LITERAL_EXPRESSION) {
            for (ASTNode child = parentNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (child.getElementType() != PyElementTypes.KEY_VALUE_EXPRESSION || !"ENGINE".equals(PyStringLiteralUtil.getStringValue((String)child.getFirstChildNode().getText()))) continue;
                return PyStringLiteralUtil.getStringValue((String)child.getLastChildNode().getText()).endsWith("sqlite3");
            }
        }
        return false;
    }

    private static boolean inInstalledAppsList(PsiElement element) {
        return DjangoPsiUtil.isElementOfListOrTupleAssignedTo((PsiElement)element, (String[])new String[]{".+_APPS"}) || DjangoPsiUtil.isElementOfListArgumentToCall((PsiElement)element, (String)"INSTALLED_APPS", (String)"extends");
    }

    private static boolean inTemplatesDirsList(PsiElement element) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return false;
        }
        PyFile settingsFile = DjangoSettingsPy.getSettingsFile((Module)module);
        if (settingsFile == null) {
            return false;
        }
        PyDjangoTemplateFSLoader loader = PyDjangoTemplateFSLoader.Companion.getForSettings(settingsFile);
        return loader.isInTemplatesDirsList(element);
    }

    private static boolean inStaticDirsList(PsiElement element) {
        List ex;
        if (DjangoPsiUtil.isElementOfListOrTupleAssignedTo((PsiElement)element, (String[])new String[]{"STATICFILES_DIRS"})) {
            return true;
        }
        PyParenthesizedExpression par = (PyParenthesizedExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyParenthesizedExpression.class);
        return par != null && DjangoPsiUtil.isElementOfListOrTupleAssignedTo((PsiElement)par, (String[])new String[]{"STATICFILES_DIRS"}) && (ex = PyUtil.flattenedParensAndTuples((PyExpression[])new PyExpression[]{par})).size() == 2 && element == ex.get(1);
    }

    private static boolean inTemplateLoadersList(PsiElement element) {
        return new PsiQuery(element).ancestors(PySequenceExpression.class).ancestors(PyKeyValueExpression.class).filter(o -> "loaders".equals(PyEvaluator.evaluate((PyExpression)o.getKey(), String.class))).ancestors(PyKeyValueExpression.class).filter(o -> "OPTIONS".equals(PyEvaluator.evaluate((PyExpression)o.getKey(), String.class))).ancestors(PyAssignmentStatement.class).map(o -> o.getLeftHandSideExpression()).filter((PsiQuery.PsiFilter)new PsiQuery.PsiNameFilter(PyTargetExpression.class, "TEMPLATES")).exists();
    }

    private static boolean inStaticFilesFindersList(PsiElement element) {
        return DjangoPsiUtil.isElementOfListOrTupleAssignedTo((PsiElement)element, (String[])new String[]{"STATICFILES_FINDERS"});
    }

    private static boolean inMiddlewareClassesList(PsiElement element) {
        return DjangoPsiUtil.isElementOfListOrTupleAssignedTo((PsiElement)element, (String[])new String[]{"MIDDLEWARE"});
    }

    private static boolean inMediaRoot(PsiElement element) {
        return DjangoPsiUtil.isAssignedTo((ASTNode)element.getNode(), (String)"MEDIA_ROOT");
    }

    private static boolean inTestRunner(PsiElement element) {
        return DjangoPsiUtil.isAssignedTo((ASTNode)element.getNode(), (String)"TEST_RUNNER");
    }

    private static boolean inStaticRoot(PsiElement element) {
        return DjangoPsiUtil.isAssignedTo((ASTNode)element.getNode(), (String)"STATIC_ROOT");
    }

    private static boolean inFileUploadHandlersList(PsiElement element) {
        return DjangoPsiUtil.isElementOfListOrTupleAssignedTo((PsiElement)element, (String[])new String[]{"FILE_UPLOAD_HANDLERS"});
    }

    private static boolean inLogClasses(PsiElement element) {
        return LOG_CLASS_PATTERN.accepts((Object)element.getFirstChild(), new ProcessingContext());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/ref/DjangoSettingsPyReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/ref/DjangoSettingsPyReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class SqlitePathFileReferenceSet
    extends PyStringLiteralFileReferenceSet {
        SqlitePathFileReferenceSet(PyStringLiteralExpression stringLiteral) {
            super(stringLiteral);
        }

        public FileReference createFileReference(TextRange range, int index, String text) {
            return new WeakFileReference((FileReferenceSet)this, range, index, text){

                public Object @NotNull [] getVariants() {
                    ArrayList<Object> variants = new ArrayList<Object>(Arrays.asList(super.getVariants()));
                    if (this.getIndex() == 0) {
                        variants.add(":memory:");
                    }
                    Object[] objectArray = variants.toArray();
                    if (objectArray == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return objectArray;
                }

                @Nullable
                public HighlightSeverity getUnresolvedHighlightSeverity(TypeEvalContext context) {
                    if (this.getText().contains(":memory:")) {
                        return null;
                    }
                    return super.getUnresolvedHighlightSeverity(context);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/python/django/ref/DjangoSettingsPyReferenceProvider$SqlitePathFileReferenceSet$1", "getVariants"));
                }
            };
        }

        @NotNull
        public Collection<PsiFileSystemItem> computeDefaultContexts() {
            PsiFile file = this.getContainingFile();
            if (file == null) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    SqlitePathFileReferenceSet.$$$reportNull$$$0(0);
                }
                return list;
            }
            if (this.isAbsolutePathReference()) {
                Collection collection = super.computeDefaultContexts();
                if (collection == null) {
                    SqlitePathFileReferenceSet.$$$reportNull$$$0(1);
                }
                return collection;
            }
            PsiDirectory root = DjangoCoreUtil.getProjectRoot((PsiFileSystemItem)file);
            if (root != null) {
                List<PsiDirectory> list = Collections.singletonList(root);
                if (list == null) {
                    SqlitePathFileReferenceSet.$$$reportNull$$$0(2);
                }
                return list;
            }
            List<PsiFileSystemItem> list = DjangoDirectoryReferenceSet.getModuleRoots((PsiElement)file);
            if (list == null) {
                SqlitePathFileReferenceSet.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/python/django/ref/DjangoSettingsPyReferenceProvider$SqlitePathFileReferenceSet", "computeDefaultContexts"));
        }
    }
}

