/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridModelUtil;
import com.intellij.database.datagrid.GridModelWithNestedTables;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.HierarchicalReader;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.NestedTable;
import com.intellij.database.datagrid.NestedTablesDataGridModel;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.dbimport.CsvImportUtil;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HierarchicalColumnsDataGridModel
extends GridListModelBase<GridRow, GridColumn>
implements GridModelWithNestedTables {
    private final GridListModelBase<GridRow, GridColumn> myModel;
    private HierarchicalReader myHierarchicalReader;
    private List<HierarchicalGridColumn> myRoots = new ArrayList<HierarchicalGridColumn>();
    private ColumnNamesHierarchyNode myTopLevelHierarchy;

    public HierarchicalColumnsDataGridModel(GridListModelBase<GridRow, GridColumn> model) {
        this.myModel = model;
    }

    @Override
    @NotNull
    public HierarchicalReader getHierarchicalReader() {
        if (this.myHierarchicalReader == null) {
            this.myHierarchicalReader = new HierarchicalReader(this.myRoots);
        }
        HierarchicalReader hierarchicalReader = this.myHierarchicalReader;
        if (hierarchicalReader == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(0);
        }
        return hierarchicalReader;
    }

    @Override
    public boolean isValidRowIdx(@NotNull ModelIndex<GridRow> rowIdx) {
        if (rowIdx == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(1);
        }
        return this.myModel.isValidRowIdx(rowIdx);
    }

    @Override
    public boolean isValidColumnIdx(@NotNull ModelIndex<GridColumn> column) {
        if (column == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(2);
        }
        int[] path = this.getHierarchicalReader().getColumnPath(column.asInteger());
        return this.getHierarchicalReader().isValidPath(path);
    }

    @Override
    public boolean allValuesEqualTo(@NotNull ModelIndexSet<GridRow> rowIndices, @NotNull ModelIndexSet<GridColumn> columnIndices, @Nullable Object what) {
        if (rowIndices == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(3);
        }
        if (columnIndices == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(4);
        }
        return this.myModel.allValuesEqualTo(rowIndices, columnIndices, what);
    }

    @Override
    public GridRow getRow(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(5);
        }
        return this.myModel.getRow(row);
    }

    @Override
    @Nullable
    protected Object getValueAt(@NotNull GridRow row, @NotNull GridColumn column) {
        if (row == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(6);
        }
        if (column == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(7);
        }
        if (!(column instanceof HierarchicalGridColumn)) {
            throw new IllegalArgumentException("The hierarchical column type is expected");
        }
        HierarchicalGridColumn hierarchicalGridColumn = (HierarchicalGridColumn)column;
        return HierarchicalColumnsDataGridModel.getValue(row, hierarchicalGridColumn.getPathFromRoot());
    }

    @Override
    public boolean allValuesEqualTo(@NotNull List<CellMutation> mutations) {
        if (mutations == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(8);
        }
        return this.myModel.allValuesEqualTo(mutations);
    }

    @Override
    public void setUpdatingNow(boolean updatingNow) {
        this.myModel.setUpdatingNow(updatingNow);
    }

    @Override
    @Nullable
    public GridColumn getColumn(@NotNull ModelIndex<GridColumn> column) {
        if (column == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(9);
        }
        int[] hierarchicalIdx = this.getHierarchicalReader().getColumnPath(column.asInteger());
        return this.getColumn(hierarchicalIdx);
    }

    private GridColumn getColumn(int[] columnIdx) {
        List<HierarchicalGridColumn> columns = this.myRoots;
        HierarchicalGridColumn cur = null;
        for (int idx : columnIdx) {
            if (idx < 0 || idx >= columns.size()) {
                return null;
            }
            cur = columns.get(idx);
            columns = cur.getChildren();
        }
        return cur;
    }

    @Override
    @NotNull
    public List<GridRow> getRows(@NotNull ModelIndexSet<GridRow> rows) {
        if (rows == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(10);
        }
        List<GridRow> list = this.myModel.getRows(rows);
        if (list == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @NotNull
    public List<GridColumn> getColumns() {
        List list = ContainerUtil.map(this.getHierarchicalReader().getLeafs(), column -> column);
        if (list == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    public List<HierarchicalGridColumn> getTopLevelColumns() {
        return this.myRoots;
    }

    @Override
    public boolean isNestedTablesSupportEnabled() {
        return this.myModel instanceof NestedTablesDataGridModel;
    }

    @Override
    public boolean isTopLevelGrid() {
        GridListModelBase<GridRow, GridColumn> gridListModelBase = this.myModel;
        if (!(gridListModelBase instanceof NestedTablesDataGridModel)) {
            return true;
        }
        NestedTablesDataGridModel nestedTablesDataGridModel = (NestedTablesDataGridModel)gridListModelBase;
        return nestedTablesDataGridModel.isTopLevelGrid();
    }

    @Override
    public void navigateIntoNestedTable(@NotNull NestedTablesDataGridModel.NestedTableCellCoordinate cellCoordinate) {
        GridListModelBase<GridRow, GridColumn> gridListModelBase;
        if (cellCoordinate == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(13);
        }
        if (!((gridListModelBase = this.myModel) instanceof NestedTablesDataGridModel)) {
            return;
        }
        NestedTablesDataGridModel nestedTablesDataGridModel = (NestedTablesDataGridModel)gridListModelBase;
        nestedTablesDataGridModel.appendSelectedCellCoordinate(cellCoordinate);
        this.replaceColumnNameHierarchy(nestedTablesDataGridModel.getColumnsHierarchyOfSelectedNestedTable());
    }

    @Override
    @Nullable
    public NestedTablesDataGridModel.NestedTableCellCoordinate navigateBackFromNestedTable(int numSteps) {
        GridListModelBase<GridRow, GridColumn> gridListModelBase = this.myModel;
        if (!(gridListModelBase instanceof NestedTablesDataGridModel)) {
            return null;
        }
        NestedTablesDataGridModel nestedTablesDataGridModel = (NestedTablesDataGridModel)gridListModelBase;
        NestedTablesDataGridModel.NestedTableCellCoordinate cellCoordinateToRestoreScroll = nestedTablesDataGridModel.removeLastNCellCoordinates(numSteps);
        this.updateHierarchyFromNestedTable(nestedTablesDataGridModel);
        return cellCoordinateToRestoreScroll;
    }

    private void updateHierarchyFromNestedTable(NestedTablesDataGridModel nestedTablesDataGridModel) {
        if (nestedTablesDataGridModel.isTopLevelGrid()) {
            this.restoreOriginalColumnNamesHierarchy();
        } else {
            this.replaceColumnNameHierarchy(nestedTablesDataGridModel.getColumnsHierarchyOfSelectedNestedTable());
        }
    }

    @Override
    @NotNull
    public List<NestedTablesDataGridModel.NestedTableCellCoordinate> getPathToSelectedNestedTable() {
        GridListModelBase<GridRow, GridColumn> gridListModelBase = this.myModel;
        if (!(gridListModelBase instanceof NestedTablesDataGridModel)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                HierarchicalColumnsDataGridModel.$$$reportNull$$$0(14);
            }
            return list;
        }
        NestedTablesDataGridModel nestedTablesDataGridModel = (NestedTablesDataGridModel)gridListModelBase;
        List<NestedTablesDataGridModel.NestedTableCellCoordinate> list = nestedTablesDataGridModel.getPathToSelectedNestedTable();
        if (list == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Override
    public boolean isColumnContainsNestedTable(@NotNull GridColumn column) {
        if (column == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(16);
        }
        Object columnValue = GridModelUtil.tryToFindNonNullValueInColumn(this, column, 20);
        return columnValue instanceof NestedTable;
    }

    @Override
    public NestedTable getSelectedNestedTable() {
        GridListModelBase<GridRow, GridColumn> gridListModelBase = this.myModel;
        if (!(gridListModelBase instanceof NestedTablesDataGridModel)) {
            return null;
        }
        NestedTablesDataGridModel nestedTablesDataGridModel = (NestedTablesDataGridModel)gridListModelBase;
        return nestedTablesDataGridModel.getSelectedNestedTable();
    }

    @Override
    public void addRows(@NotNull List<? extends GridRow> rows) {
        if (rows == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(17);
        }
        this.myModel.addRows(rows);
    }

    @Override
    public void addRow(@NotNull GridRow objects) {
        if (objects == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(18);
        }
        this.myModel.addRow(objects);
    }

    @Override
    public void removeRows(int firstRowIndex, int rowCount) {
        GridListModelBase<GridRow, GridColumn> gridListModelBase = this.myModel;
        if (!(gridListModelBase instanceof NestedTablesDataGridModel)) {
            this.myModel.removeRows(firstRowIndex, rowCount);
            return;
        }
        NestedTablesDataGridModel nestedTablesDataGridModel = (NestedTablesDataGridModel)gridListModelBase;
        ArrayList<NestedTablesDataGridModel.NestedTableCellCoordinate> prevPath = new ArrayList<NestedTablesDataGridModel.NestedTableCellCoordinate>(nestedTablesDataGridModel.getPathToSelectedNestedTable());
        this.myModel.removeRows(firstRowIndex, rowCount);
        if (!nestedTablesDataGridModel.getPathToSelectedNestedTable().equals(prevPath)) {
            this.updateHierarchyFromNestedTable(nestedTablesDataGridModel);
        }
    }

    @Override
    @NotNull
    public JBIterable<GridColumn> getColumnsAsIterable() {
        JBIterable jBIterable = JBIterable.from(Collections.unmodifiableList(this.getColumns()));
        if (jBIterable == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(19);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public JBIterable<GridColumn> getColumnsAsIterable(@NotNull ModelIndexSet<GridColumn> columns) {
        if (columns == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(20);
        }
        JBIterable jBIterable = columns.asIterable().transform(modelIndex -> this.getColumn((ModelIndex)modelIndex));
        if (jBIterable == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(21);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public List<GridRow> getRows() {
        List<GridRow> list = this.myModel.getRows();
        if (list == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(22);
        }
        return list;
    }

    @Override
    @NotNull
    public ModelIndexSet<GridRow> getRowIndices() {
        ModelIndexSet<GridRow> modelIndexSet = this.myModel.getRowIndices();
        if (modelIndexSet == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(23);
        }
        return modelIndexSet;
    }

    @Override
    public void setColumns(@NotNull List<? extends GridColumn> columns) {
        if (columns == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(24);
        }
        this.myModel.setColumns(columns);
        this.myHierarchicalReader = null;
    }

    @Override
    public void clearColumns() {
        this.myModel.clearColumns();
        this.myHierarchicalReader = null;
    }

    @Override
    public void set(int i, GridRow objects) {
        GridListModelBase<GridRow, GridColumn> gridListModelBase = this.myModel;
        if (!(gridListModelBase instanceof NestedTablesDataGridModel)) {
            this.myModel.set(i, objects);
            return;
        }
        NestedTablesDataGridModel nestedTablesDataGridModel = (NestedTablesDataGridModel)gridListModelBase;
        ArrayList<NestedTablesDataGridModel.NestedTableCellCoordinate> prevPath = new ArrayList<NestedTablesDataGridModel.NestedTableCellCoordinate>(nestedTablesDataGridModel.getPathToSelectedNestedTable());
        this.myModel.set(i, objects);
        if (!nestedTablesDataGridModel.getPathToSelectedNestedTable().equals(prevPath)) {
            this.updateHierarchyFromNestedTable(nestedTablesDataGridModel);
        }
    }

    @Override
    public int getColumnCount() {
        return this.getHierarchicalReader().getLeafColumnsCount();
    }

    @Override
    public int getRowCount() {
        return this.myModel.getRowCount();
    }

    @Override
    public boolean isUpdatingNow() {
        return this.myModel.isUpdatingNow();
    }

    @Override
    public void addListener(@NotNull GridModel.Listener<GridRow, GridColumn> l, @NotNull Disposable disposable) {
        if (l == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(25);
        }
        if (disposable == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(26);
        }
        this.myModel.addListener(l, disposable);
    }

    @Override
    public boolean hasListeners() {
        return this.myModel.hasListeners();
    }

    @Override
    @NotNull
    public List<GridColumn> getAllColumnsForExtraction(int ... selection) {
        Set<Integer> selectedIndices = GridExtractorsUtilCore.intArrayToSet(selection);
        return selectedIndices.size() == 1 ? this.getColumns() : this.getRootColumnsForExtraction(selectedIndices);
    }

    @NotNull
    private List<GridColumn> getRootColumnsForExtraction(@NotNull Set<Integer> selectedIndices) {
        if (selectedIndices == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(27);
        }
        ArrayList<GridColumn> result = new ArrayList<GridColumn>();
        for (int i = 0; i < this.myRoots.size(); ++i) {
            result.add(new ExtractorHierarchicalGridColumnImpl(this.myRoots.get(i), i, selectedIndices));
        }
        ArrayList<GridColumn> arrayList = result;
        if (arrayList == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    public void setOriginalColumnNamesHierarchy(@NotNull ColumnNamesHierarchyNode root) {
        if (root == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(29);
        }
        this.myTopLevelHierarchy = root;
        this.constructHierarchicalColumnsFromHierarchy(this.myTopLevelHierarchy);
    }

    private void constructHierarchicalColumnsFromHierarchy(ColumnNamesHierarchyNode root) {
        List<ColumnNamesHierarchyNode> children = root.getChildren();
        int[] globalIdx = new int[]{0};
        this.myRoots = IntStream.range(0, children.size()).mapToObj(idx -> this.constructHierarchicalColumn((ColumnNamesHierarchyNode)children.get(idx), globalIdx, new int[]{idx}, null)).toList();
        this.myHierarchicalReader = null;
    }

    public void restoreOriginalColumnNamesHierarchy() {
        if (this.myTopLevelHierarchy == null) {
            throw new IllegalStateException();
        }
        this.constructHierarchicalColumnsFromHierarchy(this.myTopLevelHierarchy);
    }

    private void replaceColumnNameHierarchy(@NotNull ColumnNamesHierarchyNode root) {
        if (root == null) {
            HierarchicalColumnsDataGridModel.$$$reportNull$$$0(30);
        }
        this.constructHierarchicalColumnsFromHierarchy(root);
        this.updateColumnTypes();
    }

    private HierarchicalGridColumn constructHierarchicalColumn(ColumnNamesHierarchyNode node, int[] globalIdx, int[] path, HierarchicalGridColumn parent) {
        HierarchicalGridColumn column;
        if (node.getChildren().isEmpty()) {
            int n = globalIdx[0];
            globalIdx[0] = n + 1;
            column = new HierarchicalGridColumn(node.getName(), n, path, parent);
        } else {
            column = new HierarchicalGridColumn(node.getName(), path, parent);
        }
        ArrayList<HierarchicalGridColumn> children = new ArrayList<HierarchicalGridColumn>();
        for (int i = 0; i < node.getChildren().size(); ++i) {
            ColumnNamesHierarchyNode n = node.getChildren().get(i);
            HierarchicalGridColumn child = this.constructHierarchicalColumn(n, globalIdx, HierarchicalColumnsDataGridModel.addIntToArray(path, i), column);
            children.add(child);
        }
        column.setChildren(children);
        return column;
    }

    public boolean updateColumnTypes() {
        boolean typesUpdated = false;
        for (HierarchicalGridColumn root : this.myRoots) {
            typesUpdated |= this.updateColumnTypesRecursively(root);
        }
        return typesUpdated;
    }

    private boolean updateColumnTypesRecursively(HierarchicalGridColumn column) {
        boolean typeChanged = false;
        TypeMerger merger = HierarchicalColumnsDataGridModel.determineColumnType(this.getRows(), column.getPathFromRoot());
        typeChanged |= column.getType() != DocumentDataHookUp.DataMarkup.getType(merger);
        column.setType(DocumentDataHookUp.DataMarkup.getType(merger));
        column.setTypeName(merger.getName());
        for (HierarchicalGridColumn c : column.getChildren()) {
            typeChanged |= this.updateColumnTypesRecursively(c);
        }
        return typeChanged;
    }

    private static TypeMerger determineColumnType(List<GridRow> rows, int[] columnPath) {
        return HierarchicalColumnsDataGridModel.determineColumnType((Object[][])ContainerUtil.map(rows, GridRow::getValues).toArray(x$0 -> new Object[x$0][]), columnPath);
    }

    public static TypeMerger determineColumnType(Object[][] rowsValues, int[] columnPath) {
        List<String> values = IntStream.range(0, rowsValues.length).mapToObj(rowIdx -> {
            Object[] rowValues = rowsValues[rowIdx];
            HierarchicalColumnsDataGridModel.validateHierarchicalIndex(columnPath, rowIdx + 1);
            Object value = HierarchicalColumnsDataGridModel.tryExtractValueByHierarchicalIndex(rowValues, columnPath, rowIdx + 1);
            return value == null ? null : value.toString();
        }).limit(200L).collect(Collectors.toList());
        return CsvImportUtil.getPreferredTypeMergerBasedOnContent(values, DocumentDataHookUp.DataMarkup.STRING_MERGER, DocumentDataHookUp.DataMarkup.INTEGER_MERGER, DocumentDataHookUp.DataMarkup.BIG_INTEGER_MERGER, DocumentDataHookUp.DataMarkup.DOUBLE_MERGER, DocumentDataHookUp.DataMarkup.BOOLEAN_MERGER);
    }

    private static Object getValue(GridRow row, int[] hierarchicalIdx) {
        HierarchicalColumnsDataGridModel.validateHierarchicalIndex(hierarchicalIdx, row.getRowNum());
        return HierarchicalColumnsDataGridModel.tryExtractValueByHierarchicalIndex(GridRow.getValues(row), hierarchicalIdx, row.getRowNum());
    }

    private static void validateHierarchicalIndex(int[] hierarchicalIdx, int rowNum) {
        if (hierarchicalIdx == null) {
            throw new IllegalArgumentException(String.format("Row %d failed: hierarchicalIdx cannot be null", rowNum));
        }
        if (hierarchicalIdx.length == 0) {
            throw new IllegalArgumentException(String.format("Row %d access failed: hierarchicalIdx cannot be empty", rowNum));
        }
    }

    @Nullable
    private static Object tryExtractValueByHierarchicalIndex(Object[] topLevelValues, int[] hierarchicalIdx, int rowNum) {
        try {
            return HierarchicalColumnsDataGridModel.extractValueByHierarchicalIndex(topLevelValues, hierarchicalIdx);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException e) {
            throw new RuntimeException(String.format("Row %d access failed: %s", rowNum, e.getMessage()), e);
        }
    }

    public static Object extractValueByHierarchicalIndex(Object[] topLevelValues, int[] hierarchicalIdx) {
        Object result = null;
        Object[] data = topLevelValues;
        for (int i = 0; i < hierarchicalIdx.length; ++i) {
            Object vals;
            int idx = hierarchicalIdx[i];
            if (idx < 0 || idx >= data.length) {
                throw new IndexOutOfBoundsException(String.format("Access by hierarchical idx %s failed: Index out of bounds at element by path %s", Arrays.toString(hierarchicalIdx), Arrays.toString(Arrays.copyOfRange(hierarchicalIdx, 0, i))));
            }
            result = data[idx];
            if (result == null && i == hierarchicalIdx.length - 1) {
                return null;
            }
            if (result == null) {
                throw new NullPointerException(String.format("Access by hierarchical idx %s failed: Encountered a null element by path %s.", Arrays.toString(hierarchicalIdx), Arrays.toString(Arrays.copyOfRange(hierarchicalIdx, 0, i))));
            }
            if (result instanceof Object[]) {
                vals = (Object[])result;
                data = vals;
                continue;
            }
            if (result instanceof List) {
                vals = (List)result;
                data = vals.toArray();
                continue;
            }
            if (!(result instanceof Collection)) break;
            throw new NullPointerException(String.format("Access by hierarchical idx %s failed: Encountered an unexpected nested collection by path %s. Only arrays or lists are allowed as nested collections", Arrays.toString(hierarchicalIdx), Arrays.toString(Arrays.copyOfRange(hierarchicalIdx, 0, i))));
        }
        return result;
    }

    private static int[] addIntToArray(int[] array, int value) {
        int[] newArray = new int[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = value;
        return newArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13, 16, 17, 18, 20, 24, 25, 26, 27, 29, 30 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/HierarchicalColumnsDataGridModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIndices";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIndices";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellCoordinate";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedIndices";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchicalReader";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/HierarchicalColumnsDataGridModel";
                break;
            }
            case 11: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRows";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToSelectedNestedTable";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnsAsIterable";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowIndices";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootColumnsForExtraction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidRowIdx";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidColumnIdx";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "allValuesEqualTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRow";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getValueAt";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getColumn";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRows";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "navigateIntoNestedTable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isColumnContainsNestedTable";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addRows";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addRow";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getColumnsAsIterable";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setColumns";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getRootColumnsForExtraction";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setOriginalColumnNamesHierarchy";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "replaceColumnNameHierarchy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13, 16, 17, 18, 20, 24, 25, 26, 27, 29, 30 -> new IllegalArgumentException(string);
        };
    }

    public class HierarchicalGridColumn
    implements GridColumn {
        private final String myName;
        private List<HierarchicalGridColumn> myChildren;
        private final int[] myPathFromRoot;
        private final int myColumnIdx;
        private int myType;
        private String myTypeName;
        private final HierarchicalGridColumn myParent;

        HierarchicalGridColumn(@NotNull String name, @Nullable int[] pathFromRoot, HierarchicalGridColumn parent) {
            if (name == null) {
                HierarchicalGridColumn.$$$reportNull$$$0(0);
            }
            if (pathFromRoot == null) {
                HierarchicalGridColumn.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myPathFromRoot = pathFromRoot;
            this.myColumnIdx = -1;
            this.myType = DocumentDataHookUp.DataMarkup.getType(DocumentDataHookUp.DataMarkup.STRING_MERGER);
            this.myTypeName = DocumentDataHookUp.DataMarkup.STRING_MERGER.getName();
            this.myParent = parent;
        }

        HierarchicalGridColumn(String name, @NotNull int leafIdx, @Nullable int[] pathFromRoot, HierarchicalGridColumn parent) {
            if (name == null) {
                HierarchicalGridColumn.$$$reportNull$$$0(2);
            }
            if (pathFromRoot == null) {
                HierarchicalGridColumn.$$$reportNull$$$0(3);
            }
            this.myName = name;
            this.myPathFromRoot = pathFromRoot;
            this.myColumnIdx = leafIdx;
            this.myType = DocumentDataHookUp.DataMarkup.getType(DocumentDataHookUp.DataMarkup.STRING_MERGER);
            this.myTypeName = DocumentDataHookUp.DataMarkup.STRING_MERGER.getName();
            this.myParent = parent;
        }

        @Override
        public Object getValue(@NotNull GridRow row) {
            if (row == null) {
                HierarchicalGridColumn.$$$reportNull$$$0(4);
            }
            return HierarchicalColumnsDataGridModel.this.getValueAt(row, this);
        }

        @NotNull
        public List<HierarchicalGridColumn> getLeaves() {
            List<HierarchicalGridColumn> list = HierarchicalColumnsDataGridModel.this.getHierarchicalReader().getAllLeafNodesInSubtree(this);
            if (list == null) {
                HierarchicalGridColumn.$$$reportNull$$$0(5);
            }
            return list;
        }

        public List<HierarchicalGridColumn> getSiblings() {
            return HierarchicalColumnsDataGridModel.this.getHierarchicalReader().getSiblings(this);
        }

        public void setChildren(@NotNull List<HierarchicalGridColumn> children) {
            if (children == null) {
                HierarchicalGridColumn.$$$reportNull$$$0(6);
            }
            this.myChildren = children;
        }

        public int @NotNull [] getPathFromRoot() {
            if (this.myPathFromRoot == null) {
                HierarchicalGridColumn.$$$reportNull$$$0(7);
            }
            return this.myPathFromRoot;
        }

        @NotNull
        public List<HierarchicalGridColumn> getChildren() {
            List<HierarchicalGridColumn> list = this.myChildren == null ? ContainerUtil.emptyList() : this.myChildren;
            if (list == null) {
                HierarchicalGridColumn.$$$reportNull$$$0(8);
            }
            return list;
        }

        @Override
        public int getColumnNumber() {
            return this.myColumnIdx;
        }

        @Override
        public int getType() {
            return this.myType;
        }

        @Override
        @NotNull
        @NlsSafe
        public String getName() {
            String string = this.myName;
            if (string == null) {
                HierarchicalGridColumn.$$$reportNull$$$0(9);
            }
            return string;
        }

        @NlsSafe
        @Nullable
        public String getNameOfAncestor(int depth) {
            int currentDepth = this.myPathFromRoot.length - 1;
            HierarchicalGridColumn ancestor = depth == currentDepth - 1 ? this.getParent() : HierarchicalColumnsDataGridModel.this.getHierarchicalReader().getAncestorAtDepth(this, depth);
            return ancestor == null ? null : ancestor.getName();
        }

        @Nullable
        public HierarchicalGridColumn getAncestorAtDepth(int depth) {
            int currentDepth = this.myPathFromRoot.length - 1;
            return depth == currentDepth - 1 ? this.getParent() : HierarchicalColumnsDataGridModel.this.getHierarchicalReader().getAncestorAtDepth(this, depth);
        }

        @Override
        @NlsSafe
        @Nullable
        public String getTypeName() {
            return this.myTypeName;
        }

        public void setType(int type) {
            if (type != this.myType) {
                this.myType = type;
            }
        }

        public void setTypeName(String name) {
            if (!name.equals(this.myTypeName)) {
                this.myTypeName = name;
            }
        }

        public boolean isTopLevelColumn() {
            return this.myPathFromRoot.length == 1;
        }

        public boolean isLeftMostChildOfDirectAncestor() {
            return this.isChildAtPositionOfDirectAncestor(0);
        }

        public boolean isRightMostChildOfAncestor(HierarchicalGridColumn ancestor, @NotNull Predicate<HierarchicalGridColumn> shouldSkip) {
            if (shouldSkip == null) {
                HierarchicalGridColumn.$$$reportNull$$$0(10);
            }
            if (ancestor == null) {
                return false;
            }
            HierarchicalGridColumn rightMost = ancestor;
            while (rightMost != null && !rightMost.isLeaf()) {
                rightMost = this.getRightMostChild(rightMost, shouldSkip);
            }
            return rightMost == this;
        }

        @Nullable
        private HierarchicalGridColumn getRightMostChild(@NotNull HierarchicalGridColumn ancestor, @NotNull Predicate<HierarchicalGridColumn> shouldSkip) {
            if (shouldSkip == null) {
                HierarchicalGridColumn.$$$reportNull$$$0(11);
            }
            if (ancestor == null) {
                HierarchicalGridColumn.$$$reportNull$$$0(12);
            }
            List<HierarchicalGridColumn> children = ancestor.getChildren();
            for (int i = children.size() - 1; i >= 0; --i) {
                HierarchicalGridColumn child = children.get(i);
                if (shouldSkip.test(child)) continue;
                return child;
            }
            return null;
        }

        private boolean isChildAtPositionOfDirectAncestor(int position) {
            HierarchicalGridColumn ancestor = this.getParent();
            if (ancestor == null) {
                return true;
            }
            List<HierarchicalGridColumn> children = ancestor.getChildren();
            if (children.isEmpty()) {
                return false;
            }
            int index = position < 0 ? children.size() + position : position;
            return children.get(index).equals(this);
        }

        @Nullable
        public HierarchicalGridColumn getParent() {
            return this.myParent;
        }

        @NotNull
        public List<String> getFullyQualifiedName() {
            ArrayList<String> columnsNames = new ArrayList<String>();
            for (HierarchicalGridColumn current = this; current != null; current = current.getParent()) {
                columnsNames.add(current.getName());
            }
            List list = ContainerUtil.reverse(columnsNames);
            if (list == null) {
                HierarchicalGridColumn.$$$reportNull$$$0(13);
            }
            return list;
        }

        public boolean isLeaf() {
            return this.myChildren == null || this.myChildren.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HierarchicalGridColumn column = (HierarchicalGridColumn)o;
            return this.myColumnIdx == column.myColumnIdx && Objects.equals(this.myName, column.myName) && Arrays.equals(this.myPathFromRoot, column.myPathFromRoot);
        }

        public int hashCode() {
            int result = Objects.hash(this.myName, this.myColumnIdx);
            result = 31 * result + Arrays.hashCode(this.myPathFromRoot);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 7, 8, 9, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathFromRoot";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/HierarchicalColumnsDataGridModel$HierarchicalGridColumn";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shouldSkip";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ancestor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/HierarchicalColumnsDataGridModel$HierarchicalGridColumn";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLeaves";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathFromRoot";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullyQualifiedName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 13: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setChildren";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isRightMostChildOfAncestor";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getRightMostChild";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 7, 8, 9, 13 -> new IllegalStateException(string);
            };
        }
    }

    public static interface ColumnNamesHierarchyNode {
        @NotNull
        public String getName();

        @NotNull
        public List<ColumnNamesHierarchyNode> getChildren();
    }

    public class ExtractorHierarchicalGridColumnImpl
    implements ExtractorHierarchicalGridColumn {
        private final HierarchicalGridColumn myColumn;
        private final Set<Integer> mySelectedColumns;
        private final int myColNumber;

        ExtractorHierarchicalGridColumnImpl(HierarchicalGridColumn column, @NotNull int columnNumber, Set<Integer> selectedColumns) {
            if (selectedColumns == null) {
                ExtractorHierarchicalGridColumnImpl.$$$reportNull$$$0(0);
            }
            if (column == null) {
                ExtractorHierarchicalGridColumnImpl.$$$reportNull$$$0(1);
            }
            this.myColumn = column;
            this.myColNumber = columnNumber;
            this.mySelectedColumns = selectedColumns;
        }

        @Override
        @Nullable
        public Object getValue(@NotNull GridRow row) {
            HierarchicalGridColumn root;
            if (row == null) {
                ExtractorHierarchicalGridColumnImpl.$$$reportNull$$$0(2);
            }
            if ((root = this.myColumn).getChildren().isEmpty()) {
                return root.getValue(row);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (HierarchicalGridColumn c : root.getChildren()) {
                this.dfs(row, c, result);
            }
            return result;
        }

        private void dfs(GridRow row, HierarchicalGridColumn node, Map<String, Object> result) {
            if (node.getChildren().isEmpty()) {
                if (!this.mySelectedColumns.isEmpty() && !this.mySelectedColumns.contains(node.getColumnNumber())) {
                    return;
                }
                Object value = node.getValue(row);
                result.put(node.getName(), value);
                return;
            }
            HashMap<String, Object> nested = new HashMap<String, Object>();
            for (HierarchicalGridColumn c : node.getChildren()) {
                this.dfs(row, c, nested);
            }
            result.put(node.getName(), nested);
        }

        @Override
        public boolean isMatchesSelection() {
            if (this.mySelectedColumns.isEmpty()) {
                return true;
            }
            if (this.myColumn.getChildren().isEmpty()) {
                return this.mySelectedColumns.contains(this.myColumn.getColumnNumber());
            }
            List<HierarchicalGridColumn> leaves = this.myColumn.getLeaves();
            for (HierarchicalGridColumn leaf : leaves) {
                if (!this.mySelectedColumns.contains(leaf.getColumnNumber())) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getColumnNumber() {
            return this.myColNumber;
        }

        @Override
        public int getType() {
            return this.myColumn.getType();
        }

        @Override
        public String getName() {
            return this.myColumn.getName();
        }

        @Override
        @Nullable
        public String getTypeName() {
            return this.myColumn.getTypeName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedColumns";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/HierarchicalColumnsDataGridModel$ExtractorHierarchicalGridColumnImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ExtractorHierarchicalGridColumn
    extends GridColumn {
        public boolean isMatchesSelection();
    }
}

