/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.environment.json;

import com.intellij.httpClient.executor.util.PartialResult;
import com.intellij.httpClient.executor.util.ResultsKt;
import com.intellij.httpClient.http.request.environment.json.ConfigurationProperty;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001!B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\u0016\u001a\u00028\u0000H'\u00a2\u0006\u0002\u0010\u0017J=\u0010\u0018\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u0001H\u0001\u0012\u000e\u0012\f0\u001aR\b\u0012\u0004\u0012\u00028\u00000\u00000\u0019\"\b\b\u0001\u0010\u0001*\u00020\u001b*\u00020\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00010\u001dH\u0084\u0002J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0005R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/intellij/httpClient/http/request/environment/json/EnvironmentJsonObjectDataExtractor;", "T", "", "envJson", "Lcom/intellij/json/psi/JsonObject;", "isScratch", "", "<init>", "(Lcom/intellij/json/psi/JsonObject;Z)V", "getEnvJson", "()Lcom/intellij/json/psi/JsonObject;", "()Z", "document", "Lcom/intellij/openapi/editor/Document;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "filePath", "", "getFilePath", "()Ljava/lang/String;", "envName", "getEnvName", "extractConfiguration", "()Ljava/lang/Object;", "get", "Lcom/intellij/httpClient/executor/util/PartialResult$ConcreteResult;", "Lcom/intellij/httpClient/http/request/environment/json/EnvironmentJsonObjectDataExtractor$ErrorMessage;", "Lcom/intellij/json/psi/JsonValue;", "property", "Lcom/intellij/httpClient/http/request/environment/json/ConfigurationProperty;", "getPositionPrefix", "element", "Lcom/intellij/psi/PsiElement;", "ErrorMessage", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nEnvironmentJsonObjectDataExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvironmentJsonObjectDataExtractor.kt\ncom/intellij/httpClient/http/request/environment/json/EnvironmentJsonObjectDataExtractor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 Results.kt\ncom/intellij/httpClient/executor/util/ResultsKt\n*L\n1#1,52:1\n19#2:53\n152#3,4:54\n*S KotlinDebug\n*F\n+ 1 EnvironmentJsonObjectDataExtractor.kt\ncom/intellij/httpClient/http/request/environment/json/EnvironmentJsonObjectDataExtractor\n*L\n24#1:53\n34#1:54,4\n*E\n"})
public abstract class EnvironmentJsonObjectDataExtractor<T> {
    @NotNull
    private final JsonObject envJson;
    private final boolean isScratch;
    @Nullable
    private final Document document;
    @Nullable
    private final String filePath;
    @NotNull
    private final String envName;

    public EnvironmentJsonObjectDataExtractor(@NotNull JsonObject envJson, boolean isScratch) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)envJson, (String)"envJson");
        this.envJson = envJson;
        this.isScratch = isScratch;
        this.document = this.envJson.getContainingFile().getViewProvider().getDocument();
        VirtualFile virtualFile = this.envJson.getContainingFile().getVirtualFile();
        this.filePath = virtualFile != null ? virtualFile.getPresentableUrl() : null;
        PsiElement $this$asSafely$iv = this.envJson.getParent();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof JsonProperty)) {
            psiElement = null;
        }
        if ((object = (JsonProperty)psiElement) == null || (object = object.getName()) == null) {
            object = "Unknown environment";
        }
        this.envName = object;
    }

    @NotNull
    protected final JsonObject getEnvJson() {
        return this.envJson;
    }

    protected final boolean isScratch() {
        return this.isScratch;
    }

    @Nullable
    protected final Document getDocument() {
        return this.document;
    }

    @Nullable
    protected final String getFilePath() {
        return this.filePath;
    }

    @NotNull
    protected final String getEnvName() {
        return this.envName;
    }

    @RequiresReadLock
    public abstract T extractConfiguration();

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final <T extends JsonValue> PartialResult.ConcreteResult<T, ErrorMessage> get(@NotNull JsonObject $this$get, @NotNull ConfigurationProperty<T> property) {
        PartialResult.ConcreteResult concreteResult;
        void $this$toSuccessOr$iv;
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        JsonProperty jsonProperty = $this$get.findProperty(property.getPropertyName());
        if (jsonProperty == null || (jsonProperty = jsonProperty.getValue()) == null) {
            return ResultsKt.nullSuccess();
        }
        JsonProperty value2 = jsonProperty;
        Object object = SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)property.getValueTypes()), arg_0 -> EnvironmentJsonObjectDataExtractor.get$lambda$0((JsonValue)value2, arg_0)));
        boolean $i$f$toSuccessOr = false;
        if ($this$toSuccessOr$iv == null) {
            boolean bl = false;
            String string = property.getErrorDescription();
            PsiElement psiElement = value2.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
            ErrorMessage errorMessage = new ErrorMessage(string, psiElement);
            concreteResult = new PartialResult.Error<ErrorMessage>(errorMessage);
        } else {
            concreteResult = new PartialResult.Success<void>($this$toSuccessOr$iv);
        }
        return concreteResult;
    }

    @NlsSafe
    @NotNull
    protected final String getPositionPrefix(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.filePath == null || this.document == null) {
            return "";
        }
        int line = this.document.getLineNumber(PsiTreeUtilKt.getStartOffset((PsiElement)element));
        int column = PsiTreeUtilKt.getStartOffset((PsiElement)element) - this.document.getLineStartOffset(line);
        return this.filePath + ":" + (line + 1) + ":" + column + "\n";
    }

    private static final JsonValue get$lambda$0(JsonValue $value, KClass it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (JsonValue)KClasses.safeCast((KClass)it, (Object)$value);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/httpClient/http/request/environment/json/EnvironmentJsonObjectDataExtractor$ErrorMessage;", "", "description", "", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/httpClient/http/request/environment/json/EnvironmentJsonObjectDataExtractor;Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "message", "getMessage", "()Ljava/lang/String;", "intellij.restClient"})
    protected final class ErrorMessage {
        @NotNull
        private final String description;
        @NotNull
        private final PsiElement element;

        public ErrorMessage(@NotNull String description, PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.description = description;
            this.element = element;
        }

        @NotNull
        public final PsiElement getElement() {
            return this.element;
        }

        @Nls
        @NotNull
        public final String getMessage() {
            return EnvironmentJsonObjectDataExtractor.this.getPositionPrefix(this.element) + this.description;
        }
    }
}

