/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.microservices.actions;

import com.intellij.httpClient.actions.generation.HttpRequestGenerationManager;
import com.intellij.httpClient.actions.generation.HttpRequestPresentableError;
import com.intellij.httpClient.actions.generation.HttpRequestUrlsGenerationRequest;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.executor.util.PartialResult;
import com.intellij.httpClient.executor.util.ResultsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010\u001c\n\u0000\u001a2\u0010\u0000\u001a\u00020\u00012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a*\u0010\u000b\u001a\u00020\u00012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a2\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00032\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0012\u0010\r\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0003\u00a8\u0006\u0010"}, d2={"generateRequestsFromEditor", "", "requestsInfo", "", "Lcom/intellij/httpClient/executor/util/PartialResult;", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlsGenerationRequest;", "Lcom/intellij/httpClient/actions/generation/HttpRequestPresentableError;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "generateRequests", "generateRequest", "concatErrors", "", "", "intellij.restClient"})
public final class GenerationUtilsKt {
    public static final void generateRequestsFromEditor(@NotNull List<? extends PartialResult<HttpRequestUrlsGenerationRequest, ? extends HttpRequestPresentableError>> requestsInfo, @NotNull Project project, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter(requestsInfo, (String)"requestsInfo");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        List<HttpRequestPresentableError> list2 = GenerationUtilsKt.generateRequest(requestsInfo, project);
        if (list2 == null) {
            return;
        }
        List<HttpRequestPresentableError> errors = list2;
        String messageContent = GenerationUtilsKt.concatErrors((Iterable<? extends HttpRequestPresentableError>)errors);
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)messageContent, (String)RestClientBundle.message("http.request.open.in.http.client.intention.error.title", new Object[0]), null);
    }

    public static final void generateRequests(@NotNull List<? extends PartialResult<HttpRequestUrlsGenerationRequest, ? extends HttpRequestPresentableError>> requestsInfo, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(requestsInfo, (String)"requestsInfo");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<HttpRequestPresentableError> list2 = GenerationUtilsKt.generateRequest(requestsInfo, project);
        if (list2 == null) {
            return;
        }
        List<HttpRequestPresentableError> errors = list2;
        Messages.showErrorDialog((Project)project, (String)GenerationUtilsKt.concatErrors((Iterable<? extends HttpRequestPresentableError>)errors), (String)RestClientBundle.message("http.request.open.in.http.client.intention.error.title", new Object[0]));
    }

    private static final List<HttpRequestPresentableError> generateRequest(List<? extends PartialResult<HttpRequestUrlsGenerationRequest, ? extends HttpRequestPresentableError>> requestsInfo, Project project) {
        List<HttpRequestUrlsGenerationRequest> requests2 = ResultsKt.unwrapSuccess((Iterable)requestsInfo);
        if (requests2.isEmpty()) {
            return ResultsKt.unwrapErrors((Iterable)requestsInfo);
        }
        new HttpRequestGenerationManager(project).generateRequestsInHttpEditor(requests2);
        return null;
    }

    @NlsSafe
    private static final String concatErrors(Iterable<? extends HttpRequestPresentableError> $this$concatErrors) {
        return CollectionsKt.joinToString$default($this$concatErrors, (CharSequence)"\n", null, null, (int)0, null, GenerationUtilsKt::concatErrors$lambda$0, (int)30, null);
    }

    private static final CharSequence concatErrors$lambda$0(HttpRequestPresentableError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMessage();
    }
}

