/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.qml.QmlLanguageDialect;
import com.intellij.lang.qml.parsing.QmlExpressionParser;
import com.intellij.lang.qml.parsing.QmlFunctionParser;
import com.intellij.lang.qml.parsing.QmlStatementParser;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QmlParser<E extends QmlExpressionParser<QmlParser<?, ?, ?, ?>>, S extends QmlStatementParser<QmlParser<?, ?, ?, ?>>, F extends QmlFunctionParser<QmlParser<?, ?, ?, ?>>, T extends JSPsiTypeParser<QmlParser<?, ?, ?, ?>>>
extends ES6Parser<E, S, F, T> {
    protected S myJSStatementParser;
    protected E myJSExpressionParser;
    private int myInsideJsFunctionCount = 0;
    private static final RecursionGuard<PsiFile> ourGuard = RecursionManager.createGuard((String)"functionContextGuard");

    public S getStatementParser() {
        if (this.isInsideJsFunction()) {
            return this.myJSStatementParser;
        }
        return (S)((Object)((QmlStatementParser)this.myStatementParser));
    }

    public boolean isInsideJsFunction() {
        return this.myInsideJsFunctionCount > 0;
    }

    public void increaseInsideJSFunctionCount() {
        ++this.myInsideJsFunctionCount;
    }

    public void decreaseInsideJSFunctionCount() {
        --this.myInsideJsFunctionCount;
    }

    public E getExpressionParser() {
        if (this.isInsideJsFunction()) {
            return this.myJSExpressionParser;
        }
        return (E)((Object)((QmlExpressionParser)this.myExpressionParser));
    }

    public QmlParser(PsiBuilder builder) {
        super((JSLanguageDialect)QmlLanguageDialect.getInstance(), builder);
        this.myStatementParser = new QmlStatementParser<QmlParser>(this, true);
        this.myFunctionParser = new QmlFunctionParser<QmlParser>(this);
        this.myExpressionParser = new QmlExpressionParser<QmlParser>(this, true);
        this.myJSStatementParser = new QmlStatementParser<QmlParser>(this, false);
        this.myJSExpressionParser = new QmlExpressionParser<QmlParser>(this, false);
    }

    public void fillBuilderDataFromContext(@NotNull PsiElement context) {
        JSFileImpl jsFile;
        if (context == null) {
            QmlParser.$$$reportNull$$$0(0);
        }
        super.fillBuilderDataFromContext(context);
        @Nullable PsiFile origPsi = context.getContainingFile();
        if (origPsi != null && (origPsi = origPsi.getOriginalFile()) instanceof JSFileImpl && (jsFile = (JSFileImpl)origPsi).getTreeElement() != null) {
            PsiElement elem;
            PsiFile finalOrigPsi = origPsi;
            for (elem = (PsiElement)ourGuard.doPreventingRecursion((Object)origPsi, false, () -> finalOrigPsi.findElementAt(context.getTextOffset())); elem != null && !(elem instanceof JSFunction) && !(elem instanceof PsiFile); elem = elem.getParent()) {
            }
            if (elem instanceof JSFunction) {
                ++this.myInsideJsFunctionCount;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/qml/parsing/QmlParser", "fillBuilderDataFromContext"));
    }
}

