/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.thinClientLink;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.jetbrains.gateway.thinClientLink.ClientLifetimeTracker;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Signal;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\f\u0012\u0004\u0012\u00020\u00130\u0015j\u0002`\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lcom/jetbrains/gateway/thinClientLink/ClientVersionContext;", "Lcom/jetbrains/gateway/thinClientLink/ClientLifetimeTracker;", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "<init>", "(Lcom/intellij/openapi/util/BuildNumber;)V", "getBuildNumber", "()Lcom/intellij/openapi/util/BuildNumber;", "aliveProcessCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "openHandleCount", "clientHandlesLifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "clientsTerminatedSignal", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "clientsTerminated", "Lcom/jetbrains/rd/util/reactive/ISource;", "Lcom/jetbrains/rd/util/reactive/IVoidSource;", "getClientsTerminated", "()Lcom/jetbrains/rd/util/reactive/ISource;", "registerClientHandleLifetime", "clientHandleLifetime", "uid", "", "registerClientProcessLifetime", "processLifetime", "handleClosed", "processTerminated", "Companion", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nClientVersionContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientVersionContext.kt\ncom/jetbrains/gateway/thinClientLink/ClientVersionContext\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,70:1\n61#2,5:71\n61#2,5:76\n61#2,5:81\n61#2,5:86\n14#2:91\n*S KotlinDebug\n*F\n+ 1 ClientVersionContext.kt\ncom/jetbrains/gateway/thinClientLink/ClientVersionContext\n*L\n33#1:71,5\n39#1:76,5\n48#1:81,5\n56#1:86,5\n68#1:91\n*E\n"})
public final class ClientVersionContext
implements ClientLifetimeTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BuildNumber buildNumber;
    @NotNull
    private final AtomicInteger aliveProcessCount;
    @NotNull
    private final AtomicInteger openHandleCount;
    @NotNull
    private final LifetimeDefinition clientHandlesLifetimeDef;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Signal<Unit> clientsTerminatedSignal;
    @NotNull
    private final ISource<Unit> clientsTerminated;
    @NotNull
    private static final Logger logger;

    public ClientVersionContext(@NotNull BuildNumber buildNumber) {
        Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
        this.buildNumber = buildNumber;
        this.aliveProcessCount = new AtomicInteger();
        this.openHandleCount = new AtomicInteger();
        this.clientHandlesLifetimeDef = new LifetimeDefinition();
        this.lifetime = (Lifetime)this.clientHandlesLifetimeDef;
        this.clientsTerminatedSignal = new Signal();
        this.clientsTerminated = (ISource)this.clientsTerminatedSignal;
    }

    @Override
    @NotNull
    public BuildNumber getBuildNumber() {
        return this.buildNumber;
    }

    @Override
    @NotNull
    public Lifetime getLifetime() {
        return this.lifetime;
    }

    @Override
    @NotNull
    public ISource<Unit> getClientsTerminated() {
        return this.clientsTerminated;
    }

    @Override
    public void registerClientHandleLifetime(@NotNull Lifetime clientHandleLifetime, @NotNull String uid) {
        Intrinsics.checkNotNullParameter((Object)clientHandleLifetime, (String)"clientHandleLifetime");
        Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
        int newHandlesCount = this.openHandleCount.incrementAndGet();
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Registered new client handle for " + this.getBuildNumber() + " with uid " + uid + ", current count is " + newHandlesCount, e$iv);
        }
        clientHandleLifetime.onTermination(() -> ClientVersionContext.registerClientHandleLifetime$lambda$1(this, uid));
    }

    @Override
    public void registerClientProcessLifetime(@NotNull Lifetime processLifetime, @NotNull String uid) {
        Intrinsics.checkNotNullParameter((Object)processLifetime, (String)"processLifetime");
        Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
        int newProcessCount = this.aliveProcessCount.incrementAndGet();
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Registered new process for " + this.getBuildNumber() + " uid " + uid + ", current count is " + newProcessCount, e$iv);
        }
        if (!processLifetime.onTerminationIfAlive(() -> ClientVersionContext.registerClientProcessLifetime$lambda$3(this, uid))) {
            this.processTerminated(uid);
        }
    }

    private final void handleClosed(String uid) {
        int newHandlesCount = this.openHandleCount.decrementAndGet();
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Client handle with uid " + uid + " is closed, current count is " + newHandlesCount, e$iv);
        }
        if (newHandlesCount == 0) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)this.clientHandlesLifetimeDef, (boolean)false, (int)1, null);
        }
    }

    private final void processTerminated(String uid) {
        int newProcessCount = this.aliveProcessCount.decrementAndGet();
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Process for version " + this.getBuildNumber() + " uid " + uid + " terminated, current count is " + newProcessCount, e$iv);
        }
        if (newProcessCount < 0) {
            logger.error("Process count for version " + this.getBuildNumber() + " uid " + uid + " is negative: " + newProcessCount);
            this.aliveProcessCount.incrementAndGet();
            return;
        }
        if (newProcessCount == 0) {
            this.clientsTerminatedSignal.fire((Object)Unit.INSTANCE);
        }
    }

    private static final Unit registerClientHandleLifetime$lambda$1(ClientVersionContext this$0, String $uid) {
        this$0.handleClosed($uid);
        return Unit.INSTANCE;
    }

    private static final Unit registerClientProcessLifetime$lambda$3(ClientVersionContext this$0, String $uid) {
        this$0.processTerminated($uid);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ClientVersionContext.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ClientVersionContext.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/thinClientLink/ClientVersionContext$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

