/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.file.singleFile;

import com.intellij.jupyter.core.jupyter.helper.JupyterFileExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCellBuilder;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.transformer.TextPresentationTransformer;
import java.io.StringWriter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterFileRegistry;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/singleFile/JupyterTextPresentationTransformer;", "Lcom/intellij/openapi/vfs/transformer/TextPresentationTransformer;", "<init>", "()V", "fromPersistent", "", "text", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "toPersistent", "intellij.jupyter.core"})
public final class JupyterTextPresentationTransformer
implements TextPresentationTransformer {
    @NotNull
    public CharSequence fromPersistent(@NotNull CharSequence text, @NotNull VirtualFile virtualFile) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!JupyterFileRegistry.INSTANCE.getUseSingleFile()) {
            charSequence = text;
        } else if (text.length() == 0) {
            JupyterNotebookBase emptyNotebook = JupyterFileUtils.createEmptyNotebook$default(JupyterFileUtils.INSTANCE, null, 1, null);
            emptyNotebook.addCell((Function1<? super JupyterCellBuilder, Unit>)((Function1)JupyterTextPresentationTransformer::fromPersistent$lambda$0));
            charSequence = emptyNotebook.asSource();
        } else if (!StringsKt.startsWith$default((CharSequence)text, (CharSequence)"{", (boolean)false, (int)2, null)) {
            charSequence = text;
        } else {
            JupyterNotebookBase notebook = JupyterFileUtils.INSTANCE.readNotebook(text);
            charSequence = notebook.asSource();
        }
        return charSequence;
    }

    @NotNull
    public CharSequence toPersistent(@NotNull CharSequence text, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!JupyterFileRegistry.INSTANCE.getUseSingleFile()) {
            return text;
        }
        JupyterNotebook jupyterNotebook = JupyterFileExtensionsKt.getJupyterNotebookOrNull(virtualFile);
        if (jupyterNotebook == null) {
            jupyterNotebook = JupyterFileUtils.INSTANCE.restoreJupyterNotebookFromSource(virtualFile);
        }
        StringWriter stringWriter = new StringWriter();
        String separator = LoadTextUtil.detectLineSeparator((VirtualFile)virtualFile, (boolean)true);
        jupyterNotebook.writeJson(stringWriter, separator);
        String string = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String result2 = string;
        return result2;
    }

    private static final Unit fromPersistent$lambda$0(JupyterCellBuilder $this$addCell) {
        Intrinsics.checkNotNullParameter((Object)$this$addCell, (String)"$this$addCell");
        $this$addCell.setSource("");
        $this$addCell.setCellType(JupyterCellType.CODE);
        return Unit.INSTANCE;
    }
}

