/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.auth.notebook;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.intellij.jupyter.core.jupyter.connections.auth.JupyterAuthHandlerFinder;
import com.intellij.jupyter.core.jupyter.connections.auth.notebook.JupyterNoteAuthUtils;
import com.intellij.jupyter.core.jupyter.connections.auth.notebook.JupyterNotebookAuthHandler;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterRest;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterScriptUtilsKt;
import com.intellij.util.UriUtilKt;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/auth/notebook/JupyterNotebookAuthHandlerFinder;", "Lcom/intellij/jupyter/core/jupyter/connections/auth/JupyterAuthHandlerFinder;", "<init>", "()V", "find", "Lkotlin/Pair;", "Lcom/intellij/jupyter/core/jupyter/connections/auth/notebook/JupyterNotebookAuthHandler;", "Ljava/net/URI;", "uri", "detectVersion", "", "parseVersion", "versionText", "Utils", "intellij.jupyter.core"})
public final class JupyterNotebookAuthHandlerFinder
implements JupyterAuthHandlerFinder {
    @Nullable
    public Pair<JupyterNotebookAuthHandler, URI> find(@NotNull URI uri) {
        Pair pair;
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = uri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (StringsKt.endsWith$default((String)string, (String)"tree", (boolean)false, (int)2, null)) {
            String string2 = uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            uRI = UriUtilKt.withPath((URI)uri, (String)StringsKt.removeSuffix((String)string2, (CharSequence)"tree"));
        } else {
            String string3 = uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            if (StringsKt.endsWith$default((String)string3, (String)"lab", (boolean)false, (int)2, null)) {
                String string4 = uri.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                uRI = UriUtilKt.withPath((URI)uri, (String)StringsKt.removeSuffix((String)string4, (CharSequence)"lab"));
            } else {
                uRI = uri;
            }
        }
        URI preparedUri = uRI;
        String version = this.detectVersion(preparedUri);
        if (version != null) {
            URI fixedUri = JupyterNoteAuthUtils.INSTANCE.removeTokenFromQuery$intellij_jupyter_core(preparedUri);
            String tokenFromUrl = Utils.getToken$intellij_jupyter_core(preparedUri);
            pair = TuplesKt.to((Object)new JupyterNotebookAuthHandler(tokenFromUrl), (Object)new URIBuilder(fixedUri).build());
        } else {
            pair = null;
        }
        return pair;
    }

    private final String detectVersion(URI uri) {
        String string = uri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        URI apiUri = UriUtilKt.withPath((URI)uri, (String)(JupyterScriptUtilsKt.withSlash(string) + "api"));
        String stringResponse = JupyterRest.INSTANCE.getStringResponse(apiUri);
        return this.parseVersion(stringResponse);
    }

    private final String parseVersion(String versionText) {
        String string;
        try {
            String versionString;
            JsonNode versionObj = ((JsonMapper)JsonMapper.builder().build()).readTree(versionText);
            string = versionString = versionObj.get("version").asText();
        }
        catch (Throwable throwable) {
            string = null;
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/auth/notebook/JupyterNotebookAuthHandlerFinder$Utils;", "", "<init>", "()V", "getToken", "", "uri", "Ljava/net/URI;", "getToken$intellij_jupyter_core", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterNotebookAuthHandlerFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterNotebookAuthHandlerFinder.kt\ncom/intellij/jupyter/core/jupyter/connections/auth/notebook/JupyterNotebookAuthHandlerFinder$Utils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1#2:64\n295#3,2:65\n*S KotlinDebug\n*F\n+ 1 JupyterNotebookAuthHandlerFinder.kt\ncom/intellij/jupyter/core/jupyter/connections/auth/notebook/JupyterNotebookAuthHandlerFinder$Utils\n*L\n60#1:65,2\n*E\n"})
    public static final class Utils {
        @NotNull
        public static final Utils INSTANCE = new Utils();

        private Utils() {
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @Nullable
        public static final String getToken$intellij_jupyter_core(@NotNull URI uri) {
            Object v2;
            block1: {
                void $this$firstOrNull$iv;
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                String string = uri.getQuery();
                if (string == null) return null;
                char[] cArray = new char[]{'?'};
                String string2 = StringsKt.trimStart((String)string, (char[])cArray);
                if (string2 == null) return null;
                Object it = string2;
                boolean bl = false;
                List list = URLEncodedUtils.parse((String)it, (Charset)StandardCharsets.UTF_8);
                if (list == null) return null;
                it = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    NameValuePair it2 = (NameValuePair)element$iv;
                    boolean bl2 = false;
                    String string3 = it2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                    String string4 = string3.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                    if (!Intrinsics.areEqual((Object)string4, (Object)"token")) continue;
                    v2 = element$iv;
                    break block1;
                }
                v2 = null;
            }
            NameValuePair nameValuePair = v2;
            if (nameValuePair == null) return null;
            String string = nameValuePair.getValue();
            return string;
        }
    }
}

