/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.DatabasePluginId;
import com.intellij.database.actions.DumpToDdlDataSourceFileManager;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DdlMapping;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.extensions.SchemaLayoutScripts;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptedScriptConsumer;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTaskBuilder;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DetailsSyncHelper;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.ide.script.IdeScriptException;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u009a\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aP\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u000526\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0007\u001aP\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u000526\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0007\u001a,\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a6\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a$\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u001c\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u001c\u0010!\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#\u001aD\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0#2\u0006\u0010\u0015\u001a\u00020\u0016\u001a:\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020+0#2\u0006\u0010\u0015\u001a\u00020\u0016\u001a6\u0010-\u001a\u0010\u0012\f\u0012\n /*\u0004\u0018\u00010+0+0.*\b\u0012\u0004\u0012\u00020+0.2\b\u0010(\u001a\u0004\u0018\u00010)2\n\u00100\u001a\u0006\u0012\u0002\b\u000301H\u0002\u001a\u001c\u00102\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a8\u00064"}, d2={"createScriptConsumerSafe", "Lcom/intellij/database/script/generator/ScriptedScriptConsumer;", "project", "Lcom/intellij/openapi/project/Project;", "sqlDs", "Lcom/intellij/sql/database/SqlDataSource;", "writer", "Lkotlin/Function2;", "Ljava/nio/file/Path;", "Lkotlin/ParameterName;", "name", "s", "Lcom/intellij/database/script/generator/ScriptingResult;", "t", "", "createScriptConsumer", "generate", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "task", "Lcom/intellij/database/script/generator/ScriptingTaskBuilder;", "dropExtra", "", "generateUnderCommand", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getElementsByDs", "", "Lcom/intellij/database/model/DasDataSource;", "", "Lcom/intellij/database/psi/DbElement;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "dump", "mappings", "", "Lcom/intellij/database/dataSource/DdlMapping;", "expandAndDump", "model", "Lcom/intellij/database/model/basic/BasicModel;", "scope", "Lcom/intellij/database/util/TreePattern;", "be", "Lcom/intellij/database/model/basic/BasicElement;", "elements", "filterByScope", "Lcom/intellij/util/containers/JBTreeTraverser;", "kotlin.jvm.PlatformType", "meta", "Lcom/intellij/database/model/meta/BasicMetaModel;", "selectFile", "files", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDumpToDdlDataSourceAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpToDdlDataSourceAction.kt\ncom/intellij/database/actions/DumpToDdlDataSourceActionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,375:1\n1#2:376\n31#3,2:377\n1510#4,3:379\n1513#4,3:389\n1863#4,2:392\n381#5,7:382\n*S KotlinDebug\n*F\n+ 1 DumpToDdlDataSourceAction.kt\ncom/intellij/database/actions/DumpToDdlDataSourceActionKt\n*L\n259#1:377,2\n294#1:379,3\n294#1:389,3\n298#1:392,2\n294#1:382,7\n*E\n"})
public final class DumpToDdlDataSourceActionKt {
    @Nullable
    public static final ScriptedScriptConsumer createScriptConsumerSafe(@NotNull Project project, @NotNull SqlDataSource sqlDs, @NotNull Function2<? super Path, ? super ScriptingResult, Unit> writer) {
        ScriptedScriptConsumer scriptedScriptConsumer;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sqlDs, (String)"sqlDs");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        try {
            scriptedScriptConsumer = DumpToDdlDataSourceActionKt.createScriptConsumer(project, sqlDs, writer);
        }
        catch (Throwable th) {
            scriptedScriptConsumer = null;
        }
        return scriptedScriptConsumer;
    }

    @Nullable
    public static final ScriptedScriptConsumer createScriptConsumer(@NotNull Project project, @NotNull SqlDataSource sqlDs, @NotNull Function2<? super Path, ? super ScriptingResult, Unit> writer) throws IOException, IdeScriptException {
        Path outPath;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sqlDs, (String)"sqlDs");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        Path script2 = SchemaLayoutScripts.findScript(sqlDs.getOutputLayout());
        if (script2 == null || !Files.exists(script2, new LinkOption[0])) {
            if (SchemaLayoutScripts.getScriptFiles().isEmpty()) {
                ExtensionsRootType.getInstance().extractBundledResources(DatabasePluginId.get(), "");
            }
            throw new IOException("Script " + sqlDs.getOutputLayout() + " not found");
        }
        String string = sqlDs.getOutputPath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            v1 = Paths.get(it, new String[0]);
        } else {
            v1 = outPath = null;
        }
        if (outPath == null) {
            throw new IOException("No output path specified");
        }
        return ScriptedScriptConsumer.createScriptedConsumer(project, script2, outPath, (PairConsumer<Path, ScriptingResult>)((PairConsumer)(arg_0, arg_1) -> DumpToDdlDataSourceActionKt.createScriptConsumer$lambda$1(writer, arg_0, arg_1)));
    }

    @NotNull
    public static final Set<VirtualFile> generate(@NotNull Project project, @NotNull SqlDataSource sqlDs, @NotNull ScriptingTaskBuilder task, boolean dropExtra) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sqlDs, (String)"sqlDs");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        LinkedHashSet result2 = new LinkedHashSet();
        CommandProcessor.getInstance().executeCommand(project, () -> DumpToDdlDataSourceActionKt.generate$lambda$3(project, result2, sqlDs, task, dropExtra), DatabaseBundle.message("dialog.title.generating.migration.script", new Object[0]), null);
        return result2;
    }

    private static final Set<VirtualFile> generateUnderCommand(Project project, SqlDataSource sqlDs, ScriptingTaskBuilder task, boolean dropExtra, ProgressIndicator indicator) {
        WriteAction.runAndWait(DumpToDdlDataSourceActionKt::generateUnderCommand$lambda$4);
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<DumpToDdlDataSourceFileManager> serviceClass$iv = DumpToDdlDataSourceFileManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DumpToDdlDataSourceFileManager.Session session = ((DumpToDdlDataSourceFileManager)object).createSession(sqlDs);
        Map map2 = sqlDs.getScriptOptions();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getScriptOptions(...)");
        task.setOptions(ScriptingOptionStatic.importScriptingOptions(map2));
        task.setCodeStyle(ScriptingTaskBuilderKt.getCodeStyle((DasDataSource)sqlDs));
        try {
            task.setConsumer(DumpToDdlDataSourceActionKt.createScriptConsumer(project, sqlDs, (Function2<? super Path, ? super ScriptingResult, Unit>)((Function2)(arg_0, arg_1) -> DumpToDdlDataSourceActionKt.generateUnderCommand$lambda$5(indicator, session, arg_0, arg_1))));
            if (task.getConsumer() == null) {
                String string = DatabaseBundle.message("notification.content.failed.to.instantiate.layout", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                MessageType messageType = MessageType.ERROR;
                Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
                DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(string, messageType).setDisplayId("DumpToDdlDataSourceAction.failed.to.create.layout").notify(project);
                return SetsKt.emptySet();
            }
            ScriptGenerators.INSTANCE.makeScript(project, task.build());
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable th) {
            String string = th.getMessage();
            if (string == null) {
                string = th.toString();
            }
            MessageType messageType = MessageType.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(string, messageType).setDisplayId("DumpToDdlDataSourceAction.dump.error").notify(project);
            return SetsKt.emptySet();
        }
        return session.complete(dropExtra);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<DasDataSource, ? extends List<DbElement>> getElementsByDs(AnActionEvent e) {
        void var2_2;
        void $this$groupByTo$iv;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Iterable iterable = (Iterable)DatabaseContextFun.getSelectedDbElements(dataContext);
        Map destination$iv = new HashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv : $this$groupByTo$iv) {
            Object object;
            DbElement it = (DbElement)element$iv;
            boolean bl = false;
            RawDataSource key$iv = it.getDataSource().getDelegate();
            Map $this$getOrPut$iv$iv = destination$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
            if (value$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                object = answer$iv$iv;
            } else {
                object = value$iv$iv;
            }
            List list$iv = (List)object;
            list$iv.add(element$iv);
        }
        return var2_2;
    }

    public static final void dump(@NotNull Project project, @NotNull Iterable<? extends DdlMapping> mappings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)dbPsiFacade), (String)"getInstance(...)");
        DbPsiFacade dbFacade = dbPsiFacade;
        Iterable<? extends DdlMapping> $this$forEach$iv = mappings;
        boolean $i$f$forEach = false;
        Iterator<? extends DdlMapping> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            JBTreeTraverser<BasicElement> elements;
            TreePattern pattern;
            TreePattern treePattern;
            DasModel model;
            SqlDataSource sqlDs;
            LocalDataSource lds;
            block10: {
                block9: {
                    DdlMapping element$iv;
                    DdlMapping m = element$iv = iterator.next();
                    boolean bl = false;
                    lds = DbImplUtil.getMaybeLocalDataSource(dbFacade.findDataSource(m.getDataSourceId()));
                    if (lds == null) {
                        String key2 = m.getDataSourceId() == null ? "notification.content.no.data.source.specified" : "notification.content.non.existing.data.source.specified";
                        String string = DatabaseBundle.message(key2, new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        MessageType messageType = MessageType.ERROR;
                        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
                        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(string, messageType).setDisplayId("DumpToDdlDataSourceAction.no.db.data.source").notify(project);
                        continue;
                    }
                    sqlDs = DbImplUtil.getMaybeSqlDataSource(dbFacade.findDataSource(m.getDdlDataSourceId()));
                    if (sqlDs == null) {
                        String key3 = m.getDdlDataSourceId() == null ? "notification.content.no.ddl.data.source.specified" : "notification.content.non.existing.ddl.data.source.specified";
                        String string = DatabaseBundle.message(key3, new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        MessageType messageType = MessageType.ERROR;
                        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
                        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(string, messageType).setDisplayId("DumpToDdlDataSourceAction.no.ddl.data.source").notify(project);
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)lds.getModel(), (String)"getModel(...)");
                    if (!(model instanceof BasicModel)) {
                        String string = DatabaseBundle.message("notification.content.nothing.to.dump", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        MessageType messageType = MessageType.ERROR;
                        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
                        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(string, messageType).setDisplayId("DumpToDdlDataSourceAction.no.objects").notify(project);
                        continue;
                    }
                    treePattern = m.getScope();
                    if (treePattern == null) break block9;
                    TreePattern mScope = treePattern;
                    boolean bl2 = false;
                    TreePattern treePattern2 = TreePatternUtils.UNION_PROCESSOR.merge((Iterable)((JBTreeTraverser)((BasicModel)model).basicTraverser().expandAndFilter(arg_0 -> DumpToDdlDataSourceActionKt.dump$lambda$12$lambda$11$lambda$8(arg_0 -> DumpToDdlDataSourceActionKt.dump$lambda$12$lambda$11$lambda$7(lds, mScope, arg_0), arg_0))).map(arg_0 -> DumpToDdlDataSourceActionKt.dump$lambda$12$lambda$11$lambda$10(DumpToDdlDataSourceActionKt::dump$lambda$12$lambda$11$lambda$9, arg_0)));
                    treePattern = treePattern2;
                    if (treePattern2 != null) break block10;
                }
                TreePattern treePattern3 = lds.getIntrospectionScope();
                treePattern = treePattern3;
                Intrinsics.checkNotNullExpressionValue((Object)treePattern3, (String)"getIntrospectionScope(...)");
            }
            if ((pattern = treePattern).isEmpty()) {
                String string = DatabaseBundle.message("notification.content.no.introspected.schemas.in.mapping.scope", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                MessageType messageType = MessageType.ERROR;
                Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
                DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(string, messageType).setDisplayId("DumpToDdlDataSourceAction.no.introspected.schemas").notify(project);
                continue;
            }
            DetailsSyncHelper syncHelper = DetailsSyncHelper.of(sqlDs.getProject(), lds, null);
            if (syncHelper.check((Iterable)(elements = DbImplUtil.traverseVisibleObjects(((BasicModel)model).basicTraverser(), pattern))).askAbortIfSyncRequired(DatabaseBundle.message("button.dump", new Object[0]))) {
                return;
            }
            Project project2 = sqlDs.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            DumpToDdlDataSourceActionKt.expandAndDump(project2, sqlDs, (BasicModel)model, pattern, CollectionsKt.listOf((Object)((BasicModel)model).getRoot()), true);
        }
    }

    @NotNull
    public static final Set<VirtualFile> expandAndDump(@NotNull Project project, @NotNull SqlDataSource sqlDs, @NotNull BasicModel model, @Nullable TreePattern scope2, @NotNull Iterable<? extends BasicElement> be, boolean dropExtra) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sqlDs, (String)"sqlDs");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(be, (String)"be");
        FilteredTraverserBase filteredTraverserBase = model.basicTraverser().withRoots(be);
        Intrinsics.checkNotNullExpressionValue((Object)filteredTraverserBase, (String)"withRoots(...)");
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)filteredTraverserBase;
        MetaModel metaModel = model.getMetaModel();
        Intrinsics.checkNotNullExpressionValue((Object)metaModel, (String)"getMetaModel(...)");
        JBIterable jBIterable = ((JBTreeTraverser)DumpToDdlDataSourceActionKt.filterByScope((JBTreeTraverser<BasicElement>)jBTreeTraverser, scope2, metaModel).expandAndFilter(arg_0 -> DumpToDdlDataSourceActionKt.expandAndDump$lambda$14(DumpToDdlDataSourceActionKt::expandAndDump$lambda$13, arg_0))).bfsTraversal();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"bfsTraversal(...)");
        JBIterable elements = jBIterable;
        return DumpToDdlDataSourceActionKt.dump(project, sqlDs, model, (Iterable)elements, dropExtra);
    }

    @NotNull
    public static final Set<VirtualFile> dump(@NotNull Project project, @NotNull SqlDataSource sqlDs, @NotNull BasicModel model, @NotNull Iterable<? extends BasicElement> elements, boolean dropExtra) {
        ScriptingSingleModelTaskBuilder scriptingSingleModelTaskBuilder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sqlDs, (String)"sqlDs");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        ScriptingSingleModelTaskBuilder $this$dump_u24lambda_u2415 = scriptingSingleModelTaskBuilder = new ScriptingSingleModelTaskBuilder(model, ScriptCategory.CREATE_COMPLETE);
        boolean bl = false;
        CollectionsKt.addAll($this$dump_u24lambda_u2415.getElements(), elements);
        ScriptingSingleModelTaskBuilder task = scriptingSingleModelTaskBuilder;
        if (task.getElements().isEmpty()) {
            String string = DatabaseBundle.message("notification.content.nothing.to.dump", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            MessageType messageType = MessageType.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(string, messageType).setDisplayId("DumpToDdlDataSourceAction.no.objects").notify(project);
            return SetsKt.emptySet();
        }
        return DumpToDdlDataSourceActionKt.generate(project, sqlDs, task, dropExtra);
    }

    private static final JBTreeTraverser<BasicElement> filterByScope(JBTreeTraverser<BasicElement> $this$filterByScope, TreePattern scope2, BasicMetaModel<?> meta) {
        JBTreeTraverser jBTreeTraverser;
        block3: {
            block2: {
                jBTreeTraverser = scope2;
                if (jBTreeTraverser == null) break block2;
                JBTreeTraverser it = jBTreeTraverser;
                boolean bl = false;
                BasicMetaObject metaSc = (BasicMetaObject)meta.findMetaObjects(ObjectKind.SCHEMA).first();
                JBTreeTraverser jBTreeTraverser2 = (JBTreeTraverser)DbImplUtil.traverseVisibleObjects($this$filterByScope, scope2).filter(arg_0 -> DumpToDdlDataSourceActionKt.filterByScope$lambda$18$lambda$17(arg_0 -> DumpToDdlDataSourceActionKt.filterByScope$lambda$18$lambda$16(metaSc, arg_0), arg_0));
                jBTreeTraverser = jBTreeTraverser2;
                if (jBTreeTraverser2 != null) break block3;
            }
            jBTreeTraverser = $this$filterByScope;
        }
        return jBTreeTraverser;
    }

    public static final void selectFile(@NotNull Project project, @NotNull Set<? extends VirtualFile> files2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            VirtualFile virtualFile = (VirtualFile)CollectionsKt.firstOrNull((Iterable)files2);
            if (virtualFile == null) break block0;
            VirtualFile it = virtualFile;
            boolean bl = false;
            new OpenFileDescriptor(project, it).navigate(true);
        }
    }

    private static final void createScriptConsumer$lambda$1(Function2 $tmp0, Path p0, ScriptingResult p1) {
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void generate$lambda$3$lambda$2(LinkedHashSet $result, Project $project, SqlDataSource $sqlDs, ScriptingTaskBuilder $task, boolean $dropExtra, ProgressManager $progressManager) {
        ProgressIndicator progressIndicator = $progressManager.getProgressIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
        $result.addAll((Collection)DumpToDdlDataSourceActionKt.generateUnderCommand($project, $sqlDs, $task, $dropExtra, progressIndicator));
    }

    private static final void generate$lambda$3(Project $project, LinkedHashSet $result, SqlDataSource $sqlDs, ScriptingTaskBuilder $task, boolean $dropExtra) {
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"getInstance(...)");
        ProgressManager progressManager2 = progressManager;
        progressManager2.runProcessWithProgressSynchronously(() -> DumpToDdlDataSourceActionKt.generate$lambda$3$lambda$2($result, $project, $sqlDs, $task, $dropExtra, progressManager2), DatabaseBundle.message("dialog.title.generating", new Object[0]), false, $project);
    }

    private static final void generateUnderCommand$lambda$4() {
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    private static final Unit generateUnderCommand$lambda$5(ProgressIndicator $indicator, DumpToDdlDataSourceFileManager.Session $session, Path file, ScriptingResult txt) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        $indicator.setText(((Object)file.getFileName()).toString());
        String text2 = txt.getScriptText();
        if (((CharSequence)text2).length() > 0) {
            $session.add(file, text2);
        }
        return Unit.INSTANCE;
    }

    private static final boolean dump$lambda$12$lambda$11$lambda$7(LocalDataSource $lds, TreePattern $mScope, BasicElement it) {
        return DataSourceSchemaMapping.matches($lds.getIntrospectionScope(), it) && DataSourceSchemaMapping.matches($mScope, it);
    }

    private static final boolean dump$lambda$12$lambda$11$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final TreePattern dump$lambda$12$lambda$11$lambda$9(BasicElement it) {
        return DataSourceSchemaMapping.asPattern(ObjectPaths.of(it));
    }

    private static final TreePattern dump$lambda$12$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        return (TreePattern)$tmp0.invoke(p0);
    }

    private static final boolean expandAndDump$lambda$13(BasicElement it) {
        return (!(it instanceof BasicTable) || !((BasicTable)it).isSystem()) && !it.isAutoCreated();
    }

    private static final boolean expandAndDump$lambda$14(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean filterByScope$lambda$18$lambda$16(BasicMetaObject $metaSc, BasicElement it) {
        return BasicMetaUtils.isAncestor($metaSc, it.getMetaObject(), true);
    }

    private static final boolean filterByScope$lambda$18$lambda$17(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Map access$getElementsByDs(AnActionEvent e) {
        return DumpToDdlDataSourceActionKt.getElementsByDs(e);
    }
}

