/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis.generator.dml.stream;

import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.dialects.redis.generator.dml.UtilKt;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.SelectGenerationResult;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.util.DdlBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/redis/generator/dml/stream/RedisStreamSelectGenerator;", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "Lcom/intellij/database/script/generator/dml/SelectGenerationResult;", "Lcom/intellij/database/script/generator/dml/SelectTask;", "task", "kind", "Lcom/intellij/database/model/ObjectKind;", "<init>", "(Lcom/intellij/database/script/generator/dml/SelectTask;Lcom/intellij/database/model/ObjectKind;)V", "generate", "intellij.database.dialects.redis"})
public final class RedisStreamSelectGenerator
extends DmlGenerator<SelectGenerationResult, SelectTask> {
    @NotNull
    private final ObjectKind kind;

    public RedisStreamSelectGenerator(@NotNull SelectTask task, @NotNull ObjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        super((DmlTask)task);
        this.kind = kind;
    }

    @Override
    @NotNull
    public SelectGenerationResult generate() {
        DdlBuilder builder = ((SelectTask)this.getTask()).getOutput();
        DasObject table = ((SelectTask)this.getTask()).getTable();
        DdlBuilder ddlBuilder = builder.plain("XRANGE").space();
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
        UtilKt.key(ddlBuilder, table, this.kind).space();
        if (UtilKt.isNotBlank(((SelectTask)this.getTask()).getWhereClause())) {
            UtilKt.generateWhere(builder, ((SelectTask)this.getTask()).getWhereClause());
        } else {
            DdlBuilder ddlBuilder2 = builder.plain("-").space().plain("+");
            Intrinsics.checkNotNull((Object)ddlBuilder2);
        }
        if (((SelectTask)this.getTask()).getLimit() > 0) {
            builder.space().plain("count").space().number(((SelectTask)this.getTask()).getLimit());
        }
        return new SelectGenerationResult(builder, null, null, 6, null);
    }
}

