/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.snowflake.plan;

import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.snowflake.plan.SFlakeRawPlanData;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.util.ObjectUtils;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SFlakePlanModelBuilder
extends AbstractPlanModelBuilder<SFlakeRawPlanData, SFlakeRawPlanData.MetaNode> {
    public static final Map<String, PlanModel.NodeType> TYPE_MAPPING = new HashMap<String, PlanModel.NodeType>();

    protected SFlakePlanModelBuilder() {
        super(EnumSet.noneOf(PlanModel.Feature.class));
    }

    @Override
    @NotNull
    public SFlakeRawPlanData createData() {
        return new SFlakeRawPlanData();
    }

    @Override
    protected void parseData() {
        this.parseRoot();
    }

    private void parseRoot() throws PlanRetrievalException {
        this.openNode(((SFlakeRawPlanData)this.myData).root);
        this.parseStatement(((SFlakeRawPlanData)this.myData).root.children.get(0));
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull SFlakeRawPlanData.MetaNode node) {
        if (node == null) {
            SFlakePlanModelBuilder.$$$reportNull$$$0(0);
        }
        String string = "objects = " + node.objects + ";\nalias = " + node.alias + ";\nexpressions = " + node.expressions + ";\npartitionsTotal = " + node.partitionsTotal + ";\npartitionsAssigned = " + node.partitionsAssigned + ";\nbytesAssigned = " + node.bytesAssigned + ";\n";
        if (string == null) {
            SFlakePlanModelBuilder.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull SFlakeRawPlanData.MetaNode node) {
        if (node == null) {
            SFlakePlanModelBuilder.$$$reportNull$$$0(2);
        }
        return (String)ObjectUtils.chooseNotNull((Object)node.objects, (Object)((String)ObjectUtils.chooseNotNull((Object)node.alias, (Object)node.expressions)));
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull SFlakeRawPlanData.MetaNode node) {
        if (node == null) {
            SFlakePlanModelBuilder.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull SFlakeRawPlanData.MetaNode node) {
        if (node == null) {
            SFlakePlanModelBuilder.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    protected void parsePlan(@NotNull SFlakeRawPlanData.MetaNode node) {
        if (node == null) {
            SFlakePlanModelBuilder.$$$reportNull$$$0(5);
        }
        if (!this.openNode(node)) {
            return;
        }
        this.parseSubPlans(node);
        this.closeNode(this.createNode(node, TYPE_MAPPING.getOrDefault(node.tp, PlanModel.NodeType.UNKNOWN), node.tp));
    }

    @Override
    protected void parseSubPlans(@NotNull SFlakeRawPlanData.MetaNode node) {
        if (node == null) {
            SFlakePlanModelBuilder.$$$reportNull$$$0(6);
        }
        if (node.children != null) {
            node.children.forEach(this::parsePlan);
        }
    }

    @Override
    protected void parseStatement(@NotNull SFlakeRawPlanData.MetaNode node) {
        PlanModel.NodeType type;
        if (node == null) {
            SFlakePlanModelBuilder.$$$reportNull$$$0(7);
        }
        if ((type = TYPE_MAPPING.get(node.tp)) == null) {
            this.openNode(null);
            this.parsePlan(node);
            this.closeNode(this.createNode(node, PlanModel.NodeType.SELECT, null));
        } else {
            if (!this.openNode(node)) {
                return;
            }
            this.parseSubPlans(node);
            this.closeNode(this.createNode(node, type, node.tp));
        }
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull SFlakeRawPlanData.MetaNode node) {
        if (node == null) {
            SFlakePlanModelBuilder.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull SFlakeRawPlanData.MetaNode node) {
        if (node == null) {
            SFlakePlanModelBuilder.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull SFlakeRawPlanData.MetaNode node) {
        if (node == null) {
            SFlakePlanModelBuilder.$$$reportNull$$$0(10);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull SFlakeRawPlanData.MetaNode node) {
        if (node == null) {
            SFlakePlanModelBuilder.$$$reportNull$$$0(11);
        }
        return false;
    }

    static {
        TYPE_MAPPING.put("CartesianJoin", PlanModel.NodeType.JOIN);
        TYPE_MAPPING.put("WithReference", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("WithClause", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("UnionAll", PlanModel.NodeType.UNION_ALL);
        TYPE_MAPPING.put("Generator", PlanModel.NodeType.VALUE);
        TYPE_MAPPING.put("Insert", PlanModel.NodeType.INSERT);
        TYPE_MAPPING.put("Update", PlanModel.NodeType.UPDATE);
        TYPE_MAPPING.put("TableScan", PlanModel.NodeType.SEQ_SCAN);
        TYPE_MAPPING.put("Aggregate", PlanModel.NodeType.AGGREGATE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/snowflake/plan/SFlakePlanModelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/snowflake/plan/SFlakePlanModelBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

