/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.migration;

import com.intellij.codeWithMe.ClientId;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbScopeProvider;
import com.intellij.database.actions.DumpToDdlDataSourceActionKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.diff.SchemaDiffCustomization;
import com.intellij.database.model.migration.DbDdlDiffPanel;
import com.intellij.database.model.migration.DbMigrationDialog;
import com.intellij.database.model.migration.DbMigrationDiffPanel;
import com.intellij.database.model.migration.DbMigrationDiffPanelBase;
import com.intellij.database.model.migration.DbMigrationElement;
import com.intellij.database.model.migration.DbMigrationOptionsPanelKt;
import com.intellij.database.model.migration.DbMigrationRequest;
import com.intellij.database.model.migration.DbMigrationTableDiffPanel;
import com.intellij.database.model.migration.DbMigrationTreeModel;
import com.intellij.database.model.migration.DbPropsDiffTableModel;
import com.intellij.database.model.migration.DiffStatus;
import com.intellij.database.model.migration.EmptyMigrationModel;
import com.intellij.database.model.migration.SdColorsKt;
import com.intellij.database.model.migration.SdUtilsKt;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.generator.DelegateScriptingOptions;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.AbstractDatabaseModifier;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.database.view.ui.SqlPreviewComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00f3\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001K\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u00102\u001a\u00020\u001fH\u0002J\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020406H\u0007J\b\u00107\u001a\u000204H\u0003J\b\u00108\u001a\u000204H\u0007J\b\u00109\u001a\u00020:H\u0003J\b\u0010;\u001a\u00020<H\u0002J\b\u0010=\u001a\u000204H\u0002J\b\u0010>\u001a\u00020?H\u0014J\b\u0010@\u001a\u00020#H\u0002J\b\u0010A\u001a\u00020BH\u0002J\b\u0010C\u001a\u00020BH\u0002J\b\u0010D\u001a\u00020BH\u0002J\b\u0010E\u001a\u00020#H\u0002J\u0010\u0010F\u001a\u0002042\u0006\u0010G\u001a\u00020#H\u0002J\b\u0010H\u001a\u00020IH\u0002J\r\u0010J\u001a\u00020KH\u0002\u00a2\u0006\u0002\u0010LJ\u0010\u0010M\u001a\u0002042\u0006\u0010N\u001a\u00020OH\u0002J\b\u0010P\u001a\u000204H\u0002J\u0010\u0010Q\u001a\u00020O2\u0006\u0010N\u001a\u00020OH\u0002J\b\u0010R\u001a\u00020(H\u0002J\u0014\u0010S\u001a\u0002042\f\u0010T\u001a\b\u0018\u00010UR\u00020\rJ\u0016\u0010V\u001a\u0002042\f\u0010T\u001a\b\u0018\u00010UR\u00020\rH\u0002J\u0016\u0010W\u001a\u0002042\f\u0010T\u001a\b\u0018\u00010UR\u00020\rH\u0002J\b\u0010X\u001a\u00020YH\u0003J\b\u0010Z\u001a\u000204H\u0002J\b\u0010[\u001a\u00020?H\u0014J\u0013\u0010\\\u001a\b\u0012\u0004\u0012\u00020^0]H\u0014\u00a2\u0006\u0002\u0010_J\b\u0010`\u001a\u000204H\u0014J\b\u0010a\u001a\u000204H\u0002J\u0016\u0010b\u001a\u0002042\u0006\u0010c\u001a\u00020dH\u0082@\u00a2\u0006\u0002\u0010eJ\u0010\u0010f\u001a\u0002042\u0006\u0010g\u001a\u00020hH\u0002J\u0010\u0010i\u001a\u0002042\u0006\u0010j\u001a\u00020kH\u0002J\b\u0010l\u001a\u00020YH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020%X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006m"}, d2={"Lcom/intellij/database/model/migration/DbMigrationDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "request", "Lcom/intellij/database/model/migration/DbMigrationRequest;", "<init>", "(Lcom/intellij/database/model/migration/DbMigrationRequest;)V", "getRequest", "()Lcom/intellij/database/model/migration/DbMigrationRequest;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "migrationTree", "Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "getMigrationTree", "()Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "setMigrationTree", "(Lcom/intellij/database/model/migration/DbMigrationTreeModel;)V", "dividerMapping", "", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$MappingItem;", "getDividerMapping", "()Ljava/util/List;", "mainLoadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "showIdenticalCheckBox", "Ljavax/swing/JCheckBox;", "diffPanel", "Lcom/intellij/database/model/migration/DbMigrationDiffPanelBase;", "scriptLoadingPanel", "scriptPreview", "Lcom/intellij/database/view/ui/SqlPreviewComponent;", "ddlDiffPanel", "Lcom/intellij/database/model/migration/DbDdlDiffPanel;", "southPanelWrapper", "Ljavax/swing/JPanel;", "PREVIEW_PROP_DIFF_INDEX", "", "PREVIEW_DDL_DIFF_INDEX", "previewPane", "Lcom/intellij/ui/components/JBTabbedPane;", "propsDiffTableModel", "Lcom/intellij/database/model/migration/DbPropsDiffTableModel;", "propsDiffTable", "Ljavax/swing/JTable;", "scriptGenerationProgress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "treesInitializationProgress", "generatedWithErrors", "", "createScriptPreview", "refresh", "", "refreshTrees", "Lorg/jetbrains/concurrency/Promise;", "initializeTreeModel", "refreshScript", "generate", "Lcom/intellij/database/script/generator/ScriptingResult;", "createTask", "Lcom/intellij/database/script/generator/ScriptingTask;", "initializeMetaPropertiesDiffTable", "createCenterPanel", "Ljavax/swing/JComponent;", "createMainPanel", "createDiffPanel", "Ljava/awt/Component;", "createDiffPanelTwoTrees", "createDiffPanelTreeTable", "createToolbarPanel", "addShowIdenticalCheckBox", "panel", "createToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "createOptionsPopup", "com/intellij/database/model/migration/DbMigrationDialog$createOptionsPopup$1", "()Lcom/intellij/database/model/migration/DbMigrationDialog$createOptionsPopup$1;", "onScriptingOptionsChange", "options", "Lcom/intellij/database/script/generator/ScriptingOptions;", "onIgnoreImplicitChange", "appendCodeStyle", "createPreviewPane", "updateCurrentPreviewPage", "node", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "updatePropsDiffTable", "updateDdlDiff", "getOKButtonText", "", "reinitializeButtons", "createSouthPanel", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "doOKAction", "perform", "runScript", "localDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "(Lcom/intellij/database/dataSource/LocalDataSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fillLoaderContext", "modifier", "Lcom/intellij/database/view/AbstractDatabaseModifier;", "updateSqlDataSource", "ds", "Lcom/intellij/sql/database/SqlDataSource;", "getHelpId", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbMigrationDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMigrationDialog.kt\ncom/intellij/database/model/migration/DbMigrationDialog\n+ 2 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,500:1\n212#2,12:501\n212#2,12:514\n1#3:513\n40#4,3:526\n1317#5,2:529\n1797#6,3:531\n*S KotlinDebug\n*F\n+ 1 DbMigrationDialog.kt\ncom/intellij/database/model/migration/DbMigrationDialog\n*L\n132#1:501,12\n363#1:514,12\n462#1:526,3\n484#1:529,2\n492#1:531,3\n*E\n"})
public final class DbMigrationDialog
extends DialogWrapper {
    @NotNull
    private final DbMigrationRequest request;
    @NotNull
    private DbMigrationTreeModel migrationTree;
    @NotNull
    private final JBLoadingPanel mainLoadingPanel;
    @NotNull
    private final JCheckBox showIdenticalCheckBox;
    private DbMigrationDiffPanelBase diffPanel;
    @NotNull
    private final JBLoadingPanel scriptLoadingPanel;
    @NotNull
    private SqlPreviewComponent scriptPreview;
    @NotNull
    private final DbDdlDiffPanel ddlDiffPanel;
    @NotNull
    private JPanel southPanelWrapper;
    private final int PREVIEW_PROP_DIFF_INDEX;
    private final int PREVIEW_DDL_DIFF_INDEX;
    private JBTabbedPane previewPane;
    private DbPropsDiffTableModel propsDiffTableModel;
    private JTable propsDiffTable;
    @Nullable
    private ProgressIndicator scriptGenerationProgress;
    @Nullable
    private ProgressIndicator treesInitializationProgress;
    private volatile boolean generatedWithErrors;

    public DbMigrationDialog(@NotNull DbMigrationRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        super(request2.getProject());
        this.request = request2;
        this.migrationTree = new EmptyMigrationModel(this.request);
        LayoutManager layoutManager = new BorderLayout();
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        this.mainLoadingPanel = new JBLoadingPanel(layoutManager, disposable, 100);
        this.showIdenticalCheckBox = new JCheckBox(DatabaseBundle.message("checkbox.show.identical", new Object[0]), false);
        LayoutManager layoutManager2 = new BorderLayout();
        Disposable disposable2 = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"getDisposable(...)");
        this.scriptLoadingPanel = new JBLoadingPanel(layoutManager2, disposable2, 100);
        this.scriptPreview = this.createScriptPreview();
        this.ddlDiffPanel = new DbDdlDiffPanel(this.getProject(), this);
        this.southPanelWrapper = new JPanel(new BorderLayout(0, 0), false);
        this.PREVIEW_PROP_DIFF_INDEX = 1;
        this.PREVIEW_DDL_DIFF_INDEX = 2;
        this.initializeMetaPropertiesDiffTable();
        this.setTitle(DatabaseBundle.message("dialog.title.migration", new Object[0]));
        this.setOKButtonText(this.getOKButtonText());
        this.init();
        this.refresh();
    }

    @NotNull
    public final DbMigrationRequest getRequest() {
        return this.request;
    }

    private final Project getProject() {
        return this.request.getProject();
    }

    @NotNull
    public final DbMigrationTreeModel getMigrationTree() {
        return this.migrationTree;
    }

    public final void setMigrationTree(@NotNull DbMigrationTreeModel dbMigrationTreeModel) {
        Intrinsics.checkNotNullParameter((Object)dbMigrationTreeModel, (String)"<set-?>");
        this.migrationTree = dbMigrationTreeModel;
    }

    @NotNull
    public final List<DbMigrationTreeModel.MappingItem> getDividerMapping() {
        return this.migrationTree.getDividerMapping();
    }

    private final SqlPreviewComponent createScriptPreview() {
        return new SqlPreviewComponent(this.getProject(), this.request.getDataSource(DbMigrationTreeModel.Side.TARGET), this.request.getTargetSearchPath(), "", false, () -> DbMigrationDialog.createScriptPreview$lambda$0(this));
    }

    public final void refresh() {
        this.request.reinitializeAltModels();
        this.refreshTrees().onSuccess(arg_0 -> DbMigrationDialog.refresh$lambda$3(arg_0 -> DbMigrationDialog.refresh$lambda$2(this, arg_0), arg_0));
    }

    @RequiresEdt
    @NotNull
    public final Promise<Unit> refreshTrees() {
        this.mainLoadingPanel.startLoading();
        if (this.treesInitializationProgress != null) {
            ProgressIndicator progressIndicator = this.treesInitializationProgress;
            Intrinsics.checkNotNull((Object)progressIndicator);
            progressIndicator.cancel();
        }
        this.treesInitializationProgress = (ProgressIndicator)new EmptyProgressIndicator();
        boolean $i$f$runAsync = false;
        AsyncPromise promise$iv = new AsyncPromise();
        AppExecutorUtil.getAppExecutorService().execute(new Runnable(promise$iv, this){
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.$promise = $promise;
                this.this$0 = dbMigrationDialog;
            }

            public final void run() {
                Unit unit;
                try {
                    boolean bl = false;
                    ProgressManager.getInstance().runProcess(() -> DbMigrationDialog.access$initializeTreeModel(this.this$0), DbMigrationDialog.access$getTreesInitializationProgress$p(this.this$0));
                    unit = Unit.INSTANCE;
                }
                catch (Throwable e) {
                    this.$promise.setError(e);
                    return;
                }
                Unit result2 = unit;
                this.$promise.setResult((Object)result2);
            }
        });
        Promise promise = ((Promise)promise$iv).onProcessed(arg_0 -> DbMigrationDialog.refreshTrees$lambda$7(arg_0 -> DbMigrationDialog.refreshTrees$lambda$6(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"onProcessed(...)");
        Promise p2 = promise;
        return p2;
    }

    @RequiresBackgroundThread
    private final void initializeTreeModel() {
        this.migrationTree = new DbMigrationTreeModel(this.request, this.showIdenticalCheckBox.isSelected());
    }

    @RequiresEdt
    public final void refreshScript() {
        this.scriptLoadingPanel.startLoading();
        if (this.scriptGenerationProgress != null) {
            ProgressIndicator progressIndicator = this.scriptGenerationProgress;
            Intrinsics.checkNotNull((Object)progressIndicator);
            progressIndicator.cancel();
        }
        this.scriptGenerationProgress = (ProgressIndicator)new EmptyProgressIndicator();
        ApplicationManager.getApplication().executeOnPooledThread(() -> DbMigrationDialog.refreshScript$lambda$12(this));
    }

    @RequiresBackgroundThread
    private final ScriptingResult generate() {
        return ScriptGenerators.INSTANCE.makeScript(this.request.getProject(), this.createTask());
    }

    private final ScriptingTask createTask() {
        ScriptingAlterTaskBuilder builder;
        ScriptingAlterTaskBuilder scriptingAlterTaskBuilder;
        BasicModel basicModel = this.request.getElement(DbMigrationTreeModel.Side.TARGET).getModel();
        Intrinsics.checkNotNull((Object)basicModel);
        BasicModElement basicModElement = this.request.getAltElement(DbMigrationTreeModel.Side.ORIGIN);
        Intrinsics.checkNotNull((Object)basicModElement);
        BasicModel basicModel2 = basicModElement.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)basicModel2, (String)"getModel(...)");
        ScriptingAlterTaskBuilder $this$createTask_u24lambda_u2413 = scriptingAlterTaskBuilder = (builder = new ScriptingAlterTaskBuilder(basicModel, basicModel2));
        boolean bl = false;
        $this$createTask_u24lambda_u2413.setCorrespondence((Collection)this.migrationTree.computeCorrespondence());
        $this$createTask_u24lambda_u2413.setOptions(this.appendCodeStyle(this.request.getOptions().getScriptingOptions()));
        $this$createTask_u24lambda_u2413.setCurrentNamespace(this.request.getTargetNamespace());
        return scriptingAlterTaskBuilder.build();
    }

    private final void initializeMetaPropertiesDiffTable() {
        JTable jTable;
        this.propsDiffTableModel = new DbPropsDiffTableModel();
        DbPropsDiffTableModel dbPropsDiffTableModel = this.propsDiffTableModel;
        if (dbPropsDiffTableModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTableModel");
            dbPropsDiffTableModel = null;
        }
        if ((jTable = (this.propsDiffTable = (JTable)new JBTable((TableModel)dbPropsDiffTableModel))) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTable");
            jTable = null;
        }
        SdUtilsKt.setTableColors(jTable);
        JTable jTable2 = this.propsDiffTable;
        if (jTable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTable");
            jTable2 = null;
        }
        jTable2.getTableHeader().setReorderingAllowed(false);
        DefaultTableCellRenderer renderer2 = new DefaultTableCellRenderer(this){
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column2) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column2);
                JTable jTable = DbMigrationDialog.access$getPropsDiffTable$p(this.this$0);
                if (jTable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTable");
                    jTable = null;
                }
                if (!jTable.isRowSelected(row)) {
                    DiffStatus status;
                    DbPropsDiffTableModel dbPropsDiffTableModel = DbMigrationDialog.access$getPropsDiffTableModel$p(this.this$0);
                    if (dbPropsDiffTableModel == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTableModel");
                        dbPropsDiffTableModel = null;
                    }
                    component.setBackground((status = dbPropsDiffTableModel.getRowStatus(row)) == DiffStatus.MODIFIED ? SdColorsKt.getBackground(status) : null);
                }
                Intrinsics.checkNotNull((Object)component);
                return component;
            }
        };
        JTable jTable3 = this.propsDiffTable;
        if (jTable3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTable");
            jTable3 = null;
        }
        jTable3.setDefaultRenderer(Object.class, renderer2);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JBSplitter jBSplitter;
        JBSplitter $this$createCenterPanel_u24lambda_u2414 = jBSplitter = new JBSplitter(true);
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u2414.setFirstComponent((JComponent)this.createMainPanel());
        this.previewPane = this.createPreviewPane();
        JBTabbedPane jBTabbedPane = this.previewPane;
        if (jBTabbedPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewPane");
            jBTabbedPane = null;
        }
        $this$createCenterPanel_u24lambda_u2414.setSecondComponent((JComponent)jBTabbedPane);
        JBSplitter splitter = jBSplitter;
        this.mainLoadingPanel.add((Component)splitter);
        return (JComponent)this.mainLoadingPanel;
    }

    private final JPanel createMainPanel() {
        JPanel jPanel;
        JPanel $this$createMainPanel_u24lambda_u2415 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$createMainPanel_u24lambda_u2415.add((Component)this.createToolbarPanel(), "North");
        $this$createMainPanel_u24lambda_u2415.add(this.createDiffPanel(), "Center");
        return jPanel;
    }

    private final Component createDiffPanel() {
        boolean useTreeTable = Registry.Companion.is("database.schema.diff.table.view");
        return useTreeTable ? this.createDiffPanelTreeTable() : this.createDiffPanelTwoTrees();
    }

    private final Component createDiffPanelTwoTrees() {
        DbMigrationDiffPanel panel2 = new DbMigrationDiffPanel(this);
        this.diffPanel = panel2;
        return panel2;
    }

    private final Component createDiffPanelTreeTable() {
        JBScrollPane jBScrollPane;
        DbMigrationTableDiffPanel panel2 = new DbMigrationTableDiffPanel(this);
        this.diffPanel = panel2;
        JBScrollPane $this$createDiffPanelTreeTable_u24lambda_u2416 = jBScrollPane = new JBScrollPane((Component)((Object)panel2));
        boolean bl = false;
        $this$createDiffPanelTreeTable_u24lambda_u2416.setPreferredSize((Dimension)new JBDimension(1000, 480));
        return (Component)jBScrollPane;
    }

    private final JPanel createToolbarPanel() {
        JPanel jPanel;
        JPanel $this$createToolbarPanel_u24lambda_u2417 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        ActionToolbar toolbar2 = this.createToolbar();
        toolbar2.setTargetComponent((JComponent)$this$createToolbarPanel_u24lambda_u2417);
        $this$createToolbarPanel_u24lambda_u2417.add((Component)toolbar2.getComponent(), "West");
        this.addShowIdenticalCheckBox($this$createToolbarPanel_u24lambda_u2417);
        return jPanel;
    }

    private final void addShowIdenticalCheckBox(JPanel panel2) {
        this.showIdenticalCheckBox.addActionListener(arg_0 -> DbMigrationDialog.addShowIdenticalCheckBox$lambda$18(this, arg_0));
        panel2.add((Component)this.showIdenticalCheckBox, "East");
    }

    private final ActionToolbar createToolbar() {
        String string = DatabaseBundle.message("migration.toolbar.action.expand.all.text", new Object[0]);
        Object object = AllIcons.Actions.Expandall;
        DumbAwareAction expandAll2 = new DumbAwareAction(this, string, (Icon)object){
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DbMigrationDiffPanelBase dbMigrationDiffPanelBase = DbMigrationDialog.access$getDiffPanel$p(this.this$0);
                if (dbMigrationDiffPanelBase == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
                    dbMigrationDiffPanelBase = null;
                }
                dbMigrationDiffPanelBase.expandAll();
            }
        };
        object = DatabaseBundle.message("migration.toolbar.action.collapse.all.text", new Object[0]);
        Object object2 = AllIcons.Actions.Collapseall;
        DumbAwareAction collapseAll2 = new DumbAwareAction(this, (String)object, (Icon)object2){
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DbMigrationDiffPanelBase dbMigrationDiffPanelBase = DbMigrationDialog.access$getDiffPanel$p(this.this$0);
                if (dbMigrationDiffPanelBase == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
                    dbMigrationDiffPanelBase = null;
                }
                dbMigrationDiffPanelBase.collapseAll();
            }
        };
        object2 = DatabaseBundle.message("migration.toolbar.action.swap", new Object[0]);
        Object[] objectArray = AllIcons.Actions.SwapPanels;
        DumbAwareAction swap2 = new DumbAwareAction(this, (String)object2, (Icon)objectArray){
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getRequest().swap();
                DbMigrationDiffPanelBase dbMigrationDiffPanelBase = DbMigrationDialog.access$getDiffPanel$p(this.this$0);
                if (dbMigrationDiffPanelBase == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
                    dbMigrationDiffPanelBase = null;
                }
                dbMigrationDiffPanelBase.swapSourceLabels();
                DbMigrationDialog.access$reinitializeButtons(this.this$0);
                this.this$0.refreshTrees().onSuccess(arg_0 -> createToolbar.swap.1.actionPerformed$lambda$2(arg_0 -> createToolbar.swap.1.actionPerformed$lambda$1(this, this.this$0, arg_0), arg_0));
            }

            private final void reinitializeScriptPreview() {
                DbMigrationDialog.access$getScriptLoadingPanel$p(this.this$0).getContentPanel().remove((Component)DbMigrationDialog.access$getScriptPreview$p(this.this$0).getEditor());
                DbMigrationDialog.access$setScriptPreview$p(this.this$0, DbMigrationDialog.access$createScriptPreview(this.this$0));
                JBLoadingPanel jBLoadingPanel = DbMigrationDialog.access$getScriptLoadingPanel$p(this.this$0);
                EditorTextField editorTextField2 = DbMigrationDialog.access$getScriptPreview$p(this.this$0).getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editorTextField2, (String)"getEditor(...)");
                jBLoadingPanel.add((Component)editorTextField2);
                DbMigrationDialog.access$getScriptLoadingPanel$p(this.this$0).revalidate();
            }

            private static final void actionPerformed$lambda$1$lambda$0(createToolbar.swap.1 this$0, DbMigrationDialog this$1) {
                this$0.reinitializeScriptPreview();
                this$1.refreshScript();
                DbMigrationDiffPanelBase dbMigrationDiffPanelBase = DbMigrationDialog.access$getDiffPanel$p(this$1);
                if (dbMigrationDiffPanelBase == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
                    dbMigrationDiffPanelBase = null;
                }
                dbMigrationDiffPanelBase.refreshTreesUI();
            }

            private static final Unit actionPerformed$lambda$1(createToolbar.swap.1 this$0, DbMigrationDialog this$1, Unit it) {
                UIUtil.invokeLaterIfNeeded(() -> createToolbar.swap.1.actionPerformed$lambda$1$lambda$0(this$0, this$1));
                return Unit.INSTANCE;
            }

            private static final void actionPerformed$lambda$2(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        };
        objectArray = new Object[]{expandAll2, collapseAll2, Separator.getInstance(), swap2, Separator.getInstance(), this.createOptionsPopup()};
        List actions = CollectionsKt.listOf((Object[])objectArray);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("database.migration.window", (ActionGroup)new DefaultActionGroup(actions), true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        return actionToolbar;
    }

    private final createOptionsPopup.1 createOptionsPopup() {
        Supplier<String> supplier = DatabaseBundle.messagePointer("action.options.text", new Object[0]);
        Supplier supplier2 = Presentation.NULL_STRING;
        Icon icon = AllIcons.General.GearPlain;
        return new DumbAware(this, supplier, supplier2, icon){
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                this.setPopup(true);
                this.getTemplatePresentation().setPerformGroup(true);
                this.getTemplatePresentation().setDisableGroupIfEmpty(false);
            }

            public AnAction[] getChildren(AnActionEvent e) {
                return ActionGroup.EMPTY_ARRAY;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                JBPopup popup2 = DbMigrationOptionsPanelKt.createOptionsPopup(this.this$0.getRequest(), DbMigrationDialog.access$createTask(this.this$0), (Function1<? super ScriptingOptions, Unit>)((Function1)new Function1<ScriptingOptions, Unit>((Object)((Object)this.this$0)){

                    public final void invoke(ScriptingOptions p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        DbMigrationDialog.access$onScriptingOptionsChange((DbMigrationDialog)((Object)this.receiver), p0);
                    }
                }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)((Object)this.this$0)){

                    public final void invoke() {
                        DbMigrationDialog.access$onIgnoreImplicitChange((DbMigrationDialog)((Object)this.receiver));
                    }
                }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)((Object)this.this$0)){

                    public final void invoke() {
                        ((DbMigrationDialog)((Object)this.receiver)).refresh();
                    }
                }));
                DbUIUtil.showPopup(popup2, null, e);
            }
        };
    }

    private final void onScriptingOptionsChange(ScriptingOptions options) {
        this.request.saveScriptingOptions(options);
        this.refresh();
    }

    private final void onIgnoreImplicitChange() {
        boolean $i$f$runAsync = false;
        AsyncPromise promise$iv = new AsyncPromise();
        AppExecutorUtil.getAppExecutorService().execute(new Runnable(promise$iv, this){
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.$promise = $promise;
                this.this$0 = dbMigrationDialog;
            }

            public final void run() {
                Unit unit;
                try {
                    boolean bl = false;
                    this.this$0.getMigrationTree().recomputeDividerMappingAndCounters();
                    unit = Unit.INSTANCE;
                }
                catch (Throwable e) {
                    this.$promise.setError(e);
                    return;
                }
                Unit result2 = unit;
                this.$promise.setResult((Object)result2);
            }
        });
        ((Promise)promise$iv).onProcessed(arg_0 -> DbMigrationDialog.onIgnoreImplicitChange$lambda$22(arg_0 -> DbMigrationDialog.onIgnoreImplicitChange$lambda$21(this, arg_0), arg_0));
    }

    private final ScriptingOptions appendCodeStyle(ScriptingOptions options) {
        DelegateScriptingOptions result2 = new DelegateScriptingOptions(options);
        result2.set(ScriptingOptionStatic.CODE_STYLE, ScriptingTaskBuilderKt.getCodeStyle(this.request.getDataSource(DbMigrationTreeModel.Side.TARGET)));
        return result2;
    }

    private final JBTabbedPane createPreviewPane() {
        JBTabbedPane tabbedPane = new JBTabbedPane(1);
        tabbedPane.setTabComponentInsets(null);
        EditorTextField editorTextField2 = this.scriptPreview.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField2, (String)"getEditor(...)");
        this.scriptLoadingPanel.add((Component)editorTextField2);
        tabbedPane.add(DatabaseBundle.message("tab.title.migration.script.preview", new Object[0]), (Component)this.scriptLoadingPanel);
        String string = DatabaseBundle.message("tab.title.migration.object.properties.diff", new Object[0]);
        JTable jTable = this.propsDiffTable;
        if (jTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTable");
            jTable = null;
        }
        tabbedPane.add(string, (Component)new JBScrollPane((Component)jTable));
        tabbedPane.add(DatabaseBundle.message("tab.title.migration.ddl.diff", new Object[0]), (Component)this.ddlDiffPanel.getComponent());
        tabbedPane.addChangeListener(arg_0 -> DbMigrationDialog.createPreviewPane$lambda$23(this, arg_0));
        return tabbedPane;
    }

    public final void updateCurrentPreviewPage(@Nullable DbMigrationTreeModel.Node node) {
        int n;
        JBTabbedPane jBTabbedPane = this.previewPane;
        if (jBTabbedPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewPane");
            jBTabbedPane = null;
        }
        if ((n = jBTabbedPane.getSelectedIndex()) == this.PREVIEW_PROP_DIFF_INDEX) {
            this.updatePropsDiffTable(node);
        } else if (n == this.PREVIEW_DDL_DIFF_INDEX) {
            this.updateDdlDiff(node);
        }
    }

    private final void updatePropsDiffTable(DbMigrationTreeModel.Node node) {
        if (node == null) {
            DbPropsDiffTableModel dbPropsDiffTableModel = this.propsDiffTableModel;
            if (dbPropsDiffTableModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTableModel");
                dbPropsDiffTableModel = null;
            }
            dbPropsDiffTableModel.clear();
            return;
        }
        DbMigrationElement dbMigrationElement = node.getOrigin();
        BasicNode basicNode = dbMigrationElement != null ? dbMigrationElement.getBase() : null;
        BasicElement originElement = basicNode instanceof BasicElement ? (BasicElement)basicNode : null;
        DbMigrationElement dbMigrationElement2 = node.getTarget();
        BasicNode basicNode2 = dbMigrationElement2 != null ? dbMigrationElement2.getBase() : null;
        BasicElement targetElement = basicNode2 instanceof BasicElement ? (BasicElement)basicNode2 : null;
        DbPropsDiffTableModel dbPropsDiffTableModel = this.propsDiffTableModel;
        if (dbPropsDiffTableModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"propsDiffTableModel");
            dbPropsDiffTableModel = null;
        }
        dbPropsDiffTableModel.setElements(originElement, targetElement, node.getStatus());
    }

    private final void updateDdlDiff(DbMigrationTreeModel.Node node) {
        this.ddlDiffPanel.updateRequest(node);
    }

    @NlsContexts.Button
    private final String getOKButtonText() {
        String string;
        if (this.request.isToDdl()) {
            String string2 = DatabaseBundle.message("dialog.button.migration.script.dump", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = DatabaseBundle.message("dialog.button.migration.script.execute", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    private final void reinitializeButtons() {
        this.setOKButtonText(this.getOKButtonText());
        this.southPanelWrapper.remove(0);
        this.createSouthPanel();
        this.southPanelWrapper.revalidate();
    }

    @NotNull
    protected JComponent createSouthPanel() {
        this.southPanelWrapper.add((Component)super.createSouthPanel(), "Center");
        return this.southPanelWrapper;
    }

    @NotNull
    protected Action[] createActions() {
        Object[] objectArray = super.createActions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"createActions(...)");
        Object[] actions = objectArray;
        if (this.request.isToDdl()) {
            return actions;
        }
        String string = DatabaseBundle.message("dialog.button.migration.open.in.console", new Object[0]);
        DialogWrapper.DialogWrapperAction openInConsole2 = new DialogWrapper.DialogWrapperAction(this, string){
            final /* synthetic */ DbMigrationDialog this$0;
            {
                this.this$0 = $receiver;
                super((DialogWrapper)$receiver, $super_call_param$1);
            }

            protected void doAction(ActionEvent e) {
                RawDataSource rawDataSource = this.this$0.getRequest().getDataSource(DbMigrationTreeModel.Side.TARGET).getDelegate();
                LocalDataSource localDataSource = rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
                if (localDataSource == null) {
                    return;
                }
                LocalDataSource dataSource = localDataSource;
                DbUIUtil.openInConsole(DbMigrationDialog.access$getProject(this.this$0), dataSource, this.this$0.getRequest().getTargetNamespace(), DbMigrationDialog.access$getScriptPreview$p(this.this$0).getQuery(), false);
                this.this$0.close(0);
            }
        };
        openInConsole2.putValue("DefaultAction", (Object)true);
        return (Action[])ArraysKt.plus((Object[])actions, (Object)openInConsole2);
    }

    protected void doOKAction() {
        if (this.generatedWithErrors) {
            String string = DatabaseBundle.message("dialog.title.run.script.anyway", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = DatabaseBundle.message("dialog.message.generated.script.contains.errors", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            boolean runAnyway = ((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).asWarning()).ask(this.getProject());
            if (!runAnyway) {
                return;
            }
        }
        this.perform();
        super.doOKAction();
    }

    private final void perform() {
        block2: {
            SqlDataSource sqlDs;
            DbDataSource dataSource = this.request.getDataSource(DbMigrationTreeModel.Side.TARGET);
            LocalDataSource lds = DbImplUtil.getMaybeLocalDataSource(dataSource);
            if (lds != null) {
                boolean $i$f$service = false;
                Class<DbScopeProvider> serviceClass$iv = DbScopeProvider.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                DbScopeProvider.launchWithModality$default((DbScopeProvider)object, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, lds, null){
                    int label;
                    final /* synthetic */ DbMigrationDialog this$0;
                    final /* synthetic */ LocalDataSource $lds;
                    {
                        this.this$0 = $receiver;
                        this.$lds = $lds;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = DbMigrationDialog.access$runScript(this.this$0, this.$lds, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 1, null);
                return;
            }
            RawDataSource rawDataSource = dataSource.getDelegate();
            SqlDataSource sqlDataSource = sqlDs = rawDataSource instanceof SqlDataSource ? (SqlDataSource)rawDataSource : null;
            if (sqlDataSource == null) break block2;
            SqlDataSource it = sqlDataSource;
            boolean bl = false;
            this.updateSqlDataSource(it);
        }
    }

    private final Object runScript(LocalDataSource localDataSource, Continuation<? super Unit> $completion) {
        DatabaseRefactoringHandler handler2 = new DatabaseRefactoringHandler(this.getProject(), localDataSource, this.request.getTargetSearchPath());
        this.fillLoaderContext(handler2);
        String string = this.scriptPreview.getQuery();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQuery(...)");
        Object object = handler2.setStatement(string).runStatements(false, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void fillLoaderContext(AbstractDatabaseModifier modifier) {
        Sequence $this$forEach$iv = SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.migrationTree.computeCorrespondence()), (Function1)((Function1)fillLoaderContext.1.INSTANCE)));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicElement p0 = (BasicElement)element$iv;
            boolean $i$f$fillLoaderContext$stub_for_inlining = false;
            boolean bl = false;
            modifier.include(p0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSqlDataSource(SqlDataSource ds) {
        void $this$fold$iv;
        ScriptingSingleModelTaskBuilder builder = DatabaseScriptDialog.Companion.prepareCreationTask(this.createTask());
        List customizations = SchemaDiffCustomization.Companion.getEP().getExtensionList();
        FilteredTraverserBase filteredTraverserBase = ((JBTreeTraverser)builder.getModel().basicTraverser().withRoots((Iterable)builder.getElements())).filter(arg_0 -> DbMigrationDialog.updateSqlDataSource$lambda$26(DbMigrationDialog::updateSqlDataSource$lambda$25, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)filteredTraverserBase, (String)"filter(...)");
        JBTreeTraverser<BasicElement> originalElements = (JBTreeTraverser<BasicElement>)filteredTraverserBase;
        Iterable iterable = customizations;
        boolean $i$f$fold = false;
        JBTreeTraverser<BasicElement> accumulator$iv = originalElements;
        for (Object element$iv : $this$fold$iv) {
            void customization;
            SchemaDiffCustomization schemaDiffCustomization = (SchemaDiffCustomization)element$iv;
            JBTreeTraverser<BasicElement> e = accumulator$iv;
            boolean bl = false;
            accumulator$iv = customization.filterElementsBeforeGeneration(this.getProject(), ds, e);
        }
        JBIterable jBIterable = accumulator$iv.bfsTraversal();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"bfsTraversal(...)");
        JBIterable elements = jBIterable;
        Set<VirtualFile> files2 = DumpToDdlDataSourceActionKt.dump(this.getProject(), ds, builder.getModel(), (Iterable)elements, false);
        DumpToDdlDataSourceActionKt.selectFile(this.getProject(), files2);
    }

    @NotNull
    protected String getHelpId() {
        return "Differences_viewer_for_database_objects";
    }

    private static final void createScriptPreview$lambda$0(DbMigrationDialog this$0) {
        this$0.close(1);
    }

    private static final void refresh$lambda$2$lambda$1(DbMigrationDialog this$0) {
        this$0.refreshScript();
        DbMigrationDiffPanelBase dbMigrationDiffPanelBase = this$0.diffPanel;
        if (dbMigrationDiffPanelBase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
            dbMigrationDiffPanelBase = null;
        }
        dbMigrationDiffPanelBase.refreshTreesUI();
    }

    private static final Unit refresh$lambda$2(DbMigrationDialog this$0, Unit it) {
        UIUtil.invokeLaterIfNeeded(() -> DbMigrationDialog.refresh$lambda$2$lambda$1(this$0));
        return Unit.INSTANCE;
    }

    private static final void refresh$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void refreshTrees$lambda$6$lambda$5(DbMigrationDialog this$0) {
        this$0.mainLoadingPanel.stopLoading();
    }

    private static final Unit refreshTrees$lambda$6(DbMigrationDialog this$0, Unit it) {
        UIUtil.invokeLaterIfNeeded(() -> DbMigrationDialog.refreshTrees$lambda$6$lambda$5(this$0));
        return Unit.INSTANCE;
    }

    private static final void refreshTrees$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean refreshScript$lambda$12$lambda$10$lambda$8(CompositeText.Fragment it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getError() != null;
    }

    private static final void refreshScript$lambda$12$lambda$10$lambda$9(DbMigrationDialog this$0, String $text) {
        this$0.scriptPreview.setQuery($text);
        this$0.scriptLoadingPanel.stopLoading();
    }

    private static final Unit refreshScript$lambda$12$lambda$10(DbMigrationDialog this$0) {
        ScriptingResult script2 = this$0.generate();
        this$0.generatedWithErrors = SequencesKt.count((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)script2.getScript().getFragments()), DbMigrationDialog::refreshScript$lambda$12$lambda$10$lambda$8)) > 0;
        String text2 = script2.getScriptText();
        if (!this$0.isDisposed()) {
            UIUtil.invokeLaterIfNeeded(() -> DbMigrationDialog.refreshScript$lambda$12$lambda$10$lambda$9(this$0, text2));
        }
        return Unit.INSTANCE;
    }

    private static final void refreshScript$lambda$12$lambda$11(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void refreshScript$lambda$12(DbMigrationDialog this$0) {
        Function0 process2 = () -> DbMigrationDialog.refreshScript$lambda$12$lambda$10(this$0);
        ProgressManager.getInstance().runProcess(() -> DbMigrationDialog.refreshScript$lambda$12$lambda$11(process2), this$0.scriptGenerationProgress);
    }

    private static final void addShowIdenticalCheckBox$lambda$18(DbMigrationDialog this$0, ActionEvent it) {
        DbMigrationDiffPanelBase p2;
        this$0.migrationTree.setShowIdentical(this$0.showIdenticalCheckBox.isSelected());
        DbMigrationDiffPanelBase dbMigrationDiffPanelBase = this$0.diffPanel;
        if (dbMigrationDiffPanelBase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
            dbMigrationDiffPanelBase = null;
        }
        if ((p2 = dbMigrationDiffPanelBase) instanceof DbMigrationTableDiffPanel) {
            ((DbMigrationTableDiffPanel)p2).treeStructureChanged();
        }
        p2.expandMappingNodes();
        p2.repaintDivider();
    }

    private static final void onIgnoreImplicitChange$lambda$21$lambda$20(DbMigrationDialog this$0) {
        this$0.migrationTree.getOriginTreeModel().treeStructureChanged();
        this$0.migrationTree.getTargetTreeModel().treeStructureChanged();
        DbMigrationDiffPanelBase dbMigrationDiffPanelBase = this$0.diffPanel;
        if (dbMigrationDiffPanelBase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
            dbMigrationDiffPanelBase = null;
        }
        dbMigrationDiffPanelBase.expandMappingNodes();
        DbMigrationDiffPanelBase dbMigrationDiffPanelBase2 = this$0.diffPanel;
        if (dbMigrationDiffPanelBase2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
            dbMigrationDiffPanelBase2 = null;
        }
        dbMigrationDiffPanelBase2.doRepaint();
    }

    private static final Unit onIgnoreImplicitChange$lambda$21(DbMigrationDialog this$0, Unit it) {
        UIUtil.invokeLaterIfNeeded(() -> DbMigrationDialog.onIgnoreImplicitChange$lambda$21$lambda$20(this$0));
        this$0.refreshScript();
        return Unit.INSTANCE;
    }

    private static final void onIgnoreImplicitChange$lambda$22(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void createPreviewPane$lambda$23(DbMigrationDialog this$0, ChangeEvent it) {
        DbMigrationDiffPanelBase dbMigrationDiffPanelBase = this$0.diffPanel;
        if (dbMigrationDiffPanelBase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"diffPanel");
            dbMigrationDiffPanelBase = null;
        }
        this$0.updateCurrentPreviewPage(dbMigrationDiffPanelBase.getSelectedNode());
    }

    private static final boolean updateSqlDataSource$lambda$25(BasicElement it) {
        return (!(it instanceof BasicTable) || !((BasicTable)it).isSystem()) && !it.isAutoCreated();
    }

    private static final boolean updateSqlDataSource$lambda$26(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ JTable access$getPropsDiffTable$p(DbMigrationDialog $this) {
        return $this.propsDiffTable;
    }

    public static final /* synthetic */ DbPropsDiffTableModel access$getPropsDiffTableModel$p(DbMigrationDialog $this) {
        return $this.propsDiffTableModel;
    }

    public static final /* synthetic */ DbMigrationDiffPanelBase access$getDiffPanel$p(DbMigrationDialog $this) {
        return $this.diffPanel;
    }

    public static final /* synthetic */ void access$reinitializeButtons(DbMigrationDialog $this) {
        $this.reinitializeButtons();
    }

    public static final /* synthetic */ JBLoadingPanel access$getScriptLoadingPanel$p(DbMigrationDialog $this) {
        return $this.scriptLoadingPanel;
    }

    public static final /* synthetic */ SqlPreviewComponent access$getScriptPreview$p(DbMigrationDialog $this) {
        return $this.scriptPreview;
    }

    public static final /* synthetic */ void access$setScriptPreview$p(DbMigrationDialog $this, SqlPreviewComponent sqlPreviewComponent) {
        $this.scriptPreview = sqlPreviewComponent;
    }

    public static final /* synthetic */ SqlPreviewComponent access$createScriptPreview(DbMigrationDialog $this) {
        return $this.createScriptPreview();
    }

    public static final /* synthetic */ ScriptingTask access$createTask(DbMigrationDialog $this) {
        return $this.createTask();
    }

    public static final /* synthetic */ void access$onScriptingOptionsChange(DbMigrationDialog $this, ScriptingOptions options) {
        $this.onScriptingOptionsChange(options);
    }

    public static final /* synthetic */ void access$onIgnoreImplicitChange(DbMigrationDialog $this) {
        $this.onIgnoreImplicitChange();
    }

    public static final /* synthetic */ Project access$getProject(DbMigrationDialog $this) {
        return $this.getProject();
    }

    public static final /* synthetic */ Object access$runScript(DbMigrationDialog $this, LocalDataSource localDataSource, Continuation $completion) {
        return $this.runScript(localDataSource, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$initializeTreeModel(DbMigrationDialog $this) {
        $this.initializeTreeModel();
    }

    public static final /* synthetic */ ProgressIndicator access$getTreesInitializationProgress$p(DbMigrationDialog $this) {
        return $this.treesInitializationProgress;
    }
}

