/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbGoToSymbolContributor
implements GotoClassContributor,
ChooseByNameContributorEx,
DumbAware {
    public void processNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope2, @Nullable IdFilter filter) {
        Project project;
        if (processor2 == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(0);
        }
        if (scope2 == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(1);
        }
        if ((project = scope2.getProject()) == null) {
            return;
        }
        DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE.ignoreDumbMode(() -> {
            for (DbDataSource ds : this.getRoots(project, scope2)) {
                if (this.processNamesInDataSource(ds, processor2)) continue;
                return;
            }
        });
    }

    protected boolean processNamesInDataSource(@NotNull DbDataSource ds, @NotNull Processor<? super String> processor2) {
        if (ds == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(3);
        }
        return processor2.process((Object)ds.getName()) && ContainerUtil.process(ds.getNameIndex().getAllNames(), processor2);
    }

    public void processElementsWithName(@NotNull String name2, @NotNull Processor<? super NavigationItem> processor2, @NotNull FindSymbolParameters parameters) {
        if (name2 == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(4);
        }
        if (processor2 == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(5);
        }
        if (parameters == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(6);
        }
        Predicate<DasObject> filter = this.extractFilter(parameters);
        GlobalSearchScope scope2 = parameters.getSearchScope();
        Project project = scope2.getProject();
        if (project == null) {
            return;
        }
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
            for (DbDataSource dataSource : this.getRoots(project, scope2)) {
                this.processElementsWithNameInDataSource(dataSource, name2, processor2, filter);
            }
        });
    }

    @Nullable
    protected Predicate<DasObject> extractFilter(@NotNull FindSymbolParameters parameters) {
        if (parameters == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(7);
        }
        return null;
    }

    protected void processElementsWithNameInDataSource(@NotNull DbDataSource dataSource, @NotNull String name2, @NotNull Processor<? super NavigationItem> processor2, @Nullable Predicate<DasObject> filter) {
        Condition<DasObject> objectFilter;
        if (dataSource == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(8);
        }
        if (name2 == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(9);
        }
        if (processor2 == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(10);
        }
        Iterable<DasObject> byName2 = this.getObjectsByNameInDataSource(dataSource, name2);
        JBIterable objects = this.filterObjects(byName2);
        if (filter != null) {
            objects = objects.filter(filter::test);
        }
        if ((objectFilter = DbImplUtilCore.buildFilter(dataSource)) != null) {
            objects = objects.filter(objectFilter);
        }
        TreePattern introspectionScope = DbImplUtilCore.getIntrospectionScope(dataSource);
        DbImplUtil.processCandidates((JBIterable<DasObject>)objects, (Condition<? super DasObject>)((Condition)o -> DbImplUtilCore.isExpandable(o, introspectionScope)), (Processor<? super DasObject>)((Processor)o -> this.processItem(dataSource, (DasObject)o, processor2)));
    }

    @NotNull
    protected Iterable<DasObject> getObjectsByNameInDataSource(@NotNull DbDataSource dataSource, @NotNull String name2) {
        if (dataSource == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(11);
        }
        if (name2 == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(12);
        }
        JBIterable byName2 = dataSource.getNameIndex().getObjectsByName(name2);
        if (dataSource.getName().equals(name2)) {
            byName2 = JBIterable.of((Object)dataSource).append(byName2);
        }
        JBIterable jBIterable = byName2;
        if (jBIterable == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    protected boolean processItem(@NotNull DbDataSource dataSource, @NotNull DasObject o, @NotNull Processor<? super NavigationItem> processor2) {
        NavigationItem item;
        if (dataSource == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(14);
        }
        if (o == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(15);
        }
        if (processor2 == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(16);
        }
        return (item = this.getNavigationItem(dataSource, o)) == null || processor2.process((Object)item);
    }

    @Nullable
    protected NavigationItem getNavigationItem(DbDataSource dataSource, DasObject o) {
        DbElement element = DbImplUtilCore.findElement(dataSource, o);
        return element == null ? null : DbNavigationUtils.createToSourceNavigatable(element);
    }

    @NotNull
    public JBIterable<DasObject> filterObjects(@NotNull Iterable<DasObject> objects) {
        if (objects == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(17);
        }
        JBIterable jBIterable = JBIterable.from(objects).filter(o -> DbGoToSymbolContributor.isVisible(o));
        if (jBIterable == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(18);
        }
        return jBIterable;
    }

    private static boolean isVisible(DasObject o) {
        BasicElement e = (BasicElement)ObjectUtils.tryCast((Object)o, BasicElement.class);
        if (e == null || e instanceof BasicNamespace) {
            return true;
        }
        BasicSchema sc = e.getSchema();
        BasicDatabase db = (sc == null ? e : sc).getDatabase();
        return !(sc != null && sc.isSubstituted() || db != null && db.isSubstituted());
    }

    @Nullable
    public String getQualifiedName(@NotNull NavigationItem item) {
        DbElement element;
        if (item == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(19);
        }
        if ((element = DbNavigationUtils.extractDbElement((Navigatable)item)) == null) {
            return null;
        }
        DbDataSource dataSource = element.getDataSource();
        String groupName = dataSource.getDelegate().getGroupName();
        return (String)(groupName == null ? "" : groupName + "/") + dataSource.getName() + "/" + QNameUtil.getQualifiedName(element);
    }

    @Nullable
    public String getQualifiedNameSeparator() {
        return "/";
    }

    protected JBIterable<DbDataSource> getRoots(@NotNull Project project, @NotNull GlobalSearchScope scope2) {
        if (project == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(20);
        }
        if (scope2 == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(21);
        }
        JBIterable result2 = JBIterable.from(DbPsiFacade.getInstance(project).getDataSources());
        return result2.filter(o -> {
            VirtualFile file = o.getVirtualFile();
            return file != null && scope2.contains(file);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 4: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbGoToSymbolContributor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbGoToSymbolContributor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsByNameInDataSource";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "filterObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processNames";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processNamesInDataSource";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractFilter";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithNameInDataSource";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsByNameInDataSource";
                break;
            }
            case 13: 
            case 18: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processItem";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "filterObjects";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 18 -> new IllegalStateException(string);
        };
    }
}

