/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.DbObjectFormatter;
import com.intellij.database.extractors.DisplayHtmlValuesExtractor;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractionConfigKt;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.actions.CountRowsAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridDocumentationCommand;
import com.intellij.database.run.ui.DbDocumentationHelper;
import com.intellij.database.run.ui.grid.documentation.DataGridDocumentationTarget;
import com.intellij.database.run.ui.grid.documentation.DataGridDocumentationUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.Out;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.awt.Color;
import java.awt.Image;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataGridDocumentationProvider
extends AbstractDocumentationProvider
implements ExternalDocumentationHandler {
    private static final String VIEW_MODE_PROPERTY = "DataGrid.QuickDoc.View";
    private static final Key<State> GRID_HINT_STATE_KEY = Key.create((String)"GRID_HINT_STATE_KEY");

    public static String buildAndRunQueries(@NotNull DataGrid dataGrid, @Nls CharSequence initialValue) {
        boolean noRelationships;
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(0);
        }
        DasObject databaseTable = DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)dataGrid);
        DbDataSource dataSource = DataGridUtilCore.getDatabaseSystem((CoreGrid<GridRow, GridColumn>)dataGrid);
        if (dataSource == null || databaseTable == null) {
            return null;
        }
        ModelIndexSet selectedRows = dataGrid.getSelectionModel().getSelectedRows();
        boolean badSelection = dataGrid.getSelectionModel().getSelectedRowCount() <= 0;
        for (ModelIndex selectedRow : selectedRows.asIterable()) {
            badSelection |= !selectedRow.isValid((CoreGrid)dataGrid);
        }
        boolean bl = noRelationships = !(databaseTable instanceof DasTable) || !DataGridDocumentationTarget.hasNavigatableKeys(dataSource, (DasTable)databaseTable);
        if (badSelection || noRelationships) {
            DataGridDocumentationProvider.setHint(dataGrid, null);
            return null;
        }
        State state = (State)dataGrid.getUserData(GRID_HINT_STATE_KEY);
        List<DataGridDocumentationUtil.QueryInfo> newQueries = DataGridDocumentationUtil.buildQueries(dataSource, dataGrid, (ModelIndexSet<GridRow>)selectedRows, EnumSet.of(DataGridDocumentationUtil.KeyType.FOREIGN, DataGridDocumentationUtil.KeyType.EXPORTED));
        if (state != null && state.queries.equals(newQueries) && selectedRows.equals(state.rows) && System.currentTimeMillis() - state.timestamp <= 5000L) {
            return state.current;
        }
        state = new State(newQueries, (ModelIndexSet<GridRow>)selectedRows, null);
        DataGridDocumentationProvider.setHint(dataGrid, state);
        DataGridDocumentationProvider.runQueries(dataGrid, state, initialValue.toString());
        return null;
    }

    private static void runQueries(final DataGrid dataGrid, final State state, final @Nls String initialValue) {
        if (state.queries.isEmpty()) {
            return;
        }
        final PsiElement element = DataGridUtil.getPsiElementForSelection((DataGrid)dataGrid);
        if (DataGridPomTarget.unwrapCell((PsiElement)element) == null) {
            return;
        }
        final Project project = element.getProject();
        DatabaseGridDataHookUp ownerEx = DataGridUtil.getDatabaseHookUp((CoreGrid<GridRow, GridColumn>)dataGrid);
        if (ownerEx == null) {
            return;
        }
        ownerEx.getMessageBus().getDataProducer().processRequest((GridDataRequest)new DataRequest.RawRequest(ownerEx){

            @Override
            public void processRaw(DataRequest.Context context, DatabaseConnectionCore connection2) {
                String doc = DataGridDocumentationProvider.getQuickDocFooter(state, dataGrid, (DatabaseConnection)connection2);
                if (doc != null) {
                    QuickDocUtil.updateQuickDoc((Project)project, (PsiElement)element, (String)(initialValue + doc));
                }
            }
        });
    }

    @Nullable
    @Nls
    public static String getQuickDocFooter(@NotNull State state, @NotNull DataGrid dataGrid, @NotNull DatabaseConnection connection2) {
        if (state == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (connection2 == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(3);
        }
        @Nls StringBuilder sb = new StringBuilder();
        for (DataGridDocumentationUtil.QueryInfo info2 : state.queries) {
            DataGridDocumentationProvider.checkCancelled(state, dataGrid);
            int length = sb.length();
            DataSourceUtil.tryLoadFirstNRows(connection2, info2.query, sb, info2.values.size());
            DataGridDocumentationProvider.checkCancelled(state, dataGrid);
            if (sb.length() == length) continue;
            @Nls String title = DatabaseBundle.message("documentation.referenced.1.first.referencing.1", !info2.exported ? 0 : 1, info2.table.getName());
            sb.insert(length, "<br><b>" + title + ":</b><br>" + info2.keysAndColumns);
        }
        if (sb.length() == 0) {
            return null;
        }
        sb.insert(0, "<br>");
        DataGridDocumentationProvider.setHint(dataGrid, new State(state.queries, state.rows, sb.toString()));
        return sb.toString();
    }

    private static void checkCancelled(State state, DataGrid dataGrid) {
        if (dataGrid.getUserData(GRID_HINT_STATE_KEY) != state) {
            throw new ProcessCanceledException();
        }
    }

    public static void setHint(@NotNull DataGrid dataGrid, @Nullable State state) {
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(4);
        }
        dataGrid.putUserData(GRID_HINT_STATE_KEY, (Object)state);
    }

    @NlsSafe
    @NotNull
    public static String getCellDocumentation(@NotNull DataGrid dataGrid, final DataGridDocumentationCommand mode) {
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(5);
        }
        StringBuilder sb = new StringBuilder(DisplayHtmlValuesExtractor.getHeader());
        SelectionModel selectionModel = dataGrid.getSelectionModel();
        boolean singleValue = selectionModel.getSelectedColumnCount() + selectionModel.getSelectedRowCount() == 2;
        final boolean plainMode = singleValue && mode != DataGridDocumentationCommand.TRANSPOSED;
        Out.Wrapper out = new Out.Wrapper((Out)new Out.Readable()){
            static final int max = 10240;

            @NotNull
            public Out appendText(@NotNull CharSequence seq) {
                CharSequence trimmedSeq;
                if (seq == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (seq.length() == 0) {
                    2 v0 = this;
                    if (v0 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return v0;
                }
                boolean truncate = mode != DataGridDocumentationCommand.FULL_VALUE && (double)seq.length() > 11264.0;
                CharSequence charSequence = trimmedSeq = truncate ? seq.subSequence(0, 10240) : seq;
                if (plainMode) {
                    DataGridDocumentationProvider.appendHyperLinkCommand(this.getDelegate(), DataGridDocumentationCommand.TRANSPOSED, DatabaseBundle.message("cells.view.mode.transposed", new Object[0]));
                    if (truncate) {
                        DataGridDocumentationProvider.appendHyperLinkCommand(this.getDelegate().appendText((CharSequence)"&nbsp;&nbsp;&nbsp;"), DataGridDocumentationCommand.FULL_VALUE, DatabaseBundle.message("cells.show.all.N.byte", ExtractorsUtil.getPresentableSize(seq.length())));
                    }
                    super.appendText((CharSequence)"<br><br><pre><code>");
                    this.appendInner(trimmedSeq);
                    super.appendText((CharSequence)"</code>");
                    if (truncate) {
                        DataGridDocumentationProvider.appendHyperLinkCommand(this.getDelegate().appendText((CharSequence)"&nbsp;"), DataGridDocumentationCommand.FULL_VALUE, DatabaseBundle.message("cells.show.N.byte.more", ExtractorsUtil.getPresentableSize(seq.length() - 10240)));
                    }
                    super.appendText((CharSequence)"</pre>");
                } else if (truncate) {
                    this.appendInner(trimmedSeq);
                    super.appendText((CharSequence)(" " + ExtractorsUtil.getPresentableSize(seq.length() - 10240) + " more..."));
                } else {
                    this.appendInner(seq);
                }
                2 v2 = this;
                if (v2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return v2;
            }

            void appendInner(CharSequence trimmedSeq) {
                int cur = 0;
                int len = trimmedSeq.length();
                while (cur < len) {
                    int next = StringUtil.indexOf((CharSequence)trimmedSeq, (char)'\n', (int)cur);
                    next = next < 0 ? len : next;
                    super.appendText(trimmedSeq.subSequence(cur, next));
                    if (next != len) {
                        super.appendText((CharSequence)" \n");
                    }
                    cur = next + 1;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "seq";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/DataGridDocumentationProvider$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/DataGridDocumentationProvider$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "appendText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "appendText";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
        final ObjectFormatter delegateFormatter = dataGrid.getObjectFormatter();
        DbObjectFormatter converter = new DbObjectFormatter(DataGridUtil.getDbms(dataGrid)){

            @Nullable
            public String objectToString(@Nullable Object o, GridColumn column2, @NotNull ObjectFormatterConfig config) {
                if (config == null) {
                    3.$$$reportNull$$$0(0);
                }
                ObjectFormatterConfig newConfig = DatabaseObjectFormatterConfig.toDisplayConfig((ObjectFormatterConfig)config);
                if (o instanceof ImageInfo) {
                    ImageInfo oo = (ImageInfo)o;
                    String s = delegateFormatter.objectToString((Object)oo.stripBytes(), column2, newConfig);
                    return DbDocumentationHelper.createImageRefTag(oo, s);
                }
                String s = delegateFormatter.objectToString(o, column2, newConfig);
                return HtmlValuesExtractor.escapeChars((String)s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/database/run/ui/DataGridDocumentationProvider$3", "objectToString"));
            }
        };
        if (singleValue) {
            GridUtil.extractSelectedValues((DataGrid)dataGrid, (DataExtractor)GridExtractorsUtilCore.getSingleValueExtractor((ObjectFormatter)converter, (Function)DataGridUtil.getConfigProvider((DataGrid)dataGrid)), (Out)out);
        } else {
            int[] columns = (mode == DataGridDocumentationCommand.TRANSPOSED ? dataGrid.getVisibleColumns() : selectionModel.getSelectedColumns()).asArray();
            Color color = Objects.requireNonNull(EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)DocumentationComponent.COLOR_KEY));
            DisplayHtmlValuesExtractor extractor = new DisplayHtmlValuesExtractor(color, (ObjectFormatter)converter);
            DataGridDocumentationCommand command = mode == DataGridDocumentationCommand.TRANSPOSED ? DataGridDocumentationCommand.REGULAR : DataGridDocumentationCommand.TRANSPOSED;
            String text2 = mode == DataGridDocumentationCommand.TRANSPOSED ? DatabaseBundle.message("cells.view.mode.regular", new Object[0]) : DatabaseBundle.message("cells.view.mode.transposed", new Object[0]);
            DataGridDocumentationProvider.appendHyperLinkCommand(out.getDelegate(), command, text2).appendText((CharSequence)"<br><br>");
            Dbms dbms = DataGridUtil.getDbms(dataGrid);
            List allColumns = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getAllColumnsForExtraction(columns);
            List selectedRows = GridUtil.getSelectedGridRows((DataGrid)dataGrid);
            GridExtractorsUtilCore.extract((Out)out, (ExtractionConfig)ExtractionConfigKt.builder().setTransposed(mode == DataGridDocumentationCommand.TRANSPOSED).build(), (List)allColumns, (DataExtractor)extractor, (List)selectedRows, (int[])columns);
        }
        String result2 = DataGridDocumentationProvider.buildAndRunQueries(dataGrid, sb);
        String string = (result2 == null ? sb : sb.append(result2)).append("<br><br><br>").toString();
        if (string == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public Image getLocalImageForElement(@NotNull PsiElement element, @NotNull String imageSpec) {
        if (element == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(7);
        }
        if (imageSpec == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(8);
        }
        return DbDocumentationHelper.resolveImageRef(imageSpec);
    }

    @Nullable
    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        DataGridPomTarget.Cell cell = DataGridPomTarget.unwrapCell((PsiElement)element);
        if (cell != null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)element.getProject());
            DataGridDocumentationCommand command = DataGridDocumentationCommand.getCommand(propertiesComponent.getValue(VIEW_MODE_PROPERTY), DataGridDocumentationCommand.REGULAR);
            return DataGridDocumentationProvider.getCellDocumentation(cell.dataGrid, command);
        }
        DataGrid dataGrid = DataGridPomTarget.unwrapDataGrid((PsiElement)element);
        if (DataGridUtil.getQueryText(dataGrid) != null) {
            return DataGridDocumentationTarget.getGridDocumentation(element.getProject(), dataGrid);
        }
        return null;
    }

    public boolean canFetchDocumentationLink(String link) {
        return link != null && DbDocumentationHelper.extractDbSubstituteSection(link) != null;
    }

    @Nullable
    public String extractRefFromLink(@NotNull String link) {
        if (link == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(9);
        }
        return link.endsWith(DataGridDocumentationCommand.COUNT.code()) ? "$keepScrollingPosition$" : null;
    }

    @NotNull
    @Nls
    public String fetchExternalDocumentation(@NotNull String link, @Nullable PsiElement element) {
        if (link == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (element == null) {
            return "";
        }
        String section = DbDocumentationHelper.extractDbSubstituteSection(link);
        if (section == null) {
            return "";
        }
        int paramStart = section.indexOf(63);
        String substring = section.substring(0, paramStart == -1 ? section.length() : paramStart);
        DataGridDocumentationCommand command = DataGridDocumentationCommand.getCommand(substring, null);
        Project project = element.getProject();
        if (command == DataGridDocumentationCommand.COUNT) {
            int queryIdx;
            Long rowCount = DataGridDocumentationProvider.getUpdatedRowCount(element);
            if (rowCount == null || !project.isOpen()) {
                return "";
            }
            DocumentationComponent component = QuickDocUtil.getActiveDocComponent((Project)project);
            String text2 = component == null ? null : component.getText();
            int n = queryIdx = text2 == null ? -1 : text2.indexOf(link);
            if (queryIdx < 0) {
                return "";
            }
            int idx0 = text2.lastIndexOf("</b>", queryIdx) + "</b>".length() + 1;
            int idx1 = text2.indexOf("</a>", queryIdx + link.length()) + "</a>".length();
            if (idx0 < 0 || idx1 < 0) {
                return "";
            }
            String string = text2.substring(0, idx0) + rowCount + DbDocumentationHelper.getCountCommand(true) + text2.substring(idx1);
            if (string == null) {
                DataGridDocumentationProvider.$$$reportNull$$$0(11);
            }
            return string;
        }
        if (command == DataGridDocumentationCommand.TRANSPOSED || command == DataGridDocumentationCommand.REGULAR) {
            PropertiesComponent.getInstance((Project)project).setValue(VIEW_MODE_PROPERTY, command.name());
        }
        return DataGridDocumentationProvider.getCellDocumentation(Objects.requireNonNull(DataGridPomTarget.unwrapDataGrid((PsiElement)element)), command);
    }

    public boolean canHandleExternal(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        return false;
    }

    @Nullable
    private static Long getUpdatedRowCount(@Nullable PsiElement element) {
        DataGrid grid = DataGridPomTarget.unwrapDataGrid((PsiElement)element);
        if (grid == null) {
            return null;
        }
        AsyncFutureResult rowCountResult = CountRowsAction.countRows((DataGrid)grid);
        try {
            return (Long)rowCountResult.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @NotNull
    private static Out appendHyperLinkCommand(@NotNull Out sb, @NotNull DataGridDocumentationCommand command, @NotNull String text2) {
        if (sb == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(12);
        }
        if (command == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(13);
        }
        if (text2 == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(14);
        }
        Out out = sb.appendText((CharSequence)("<a href=\"" + DbDocumentationHelper.dbSubstituteUrl(command.code()) + "\">" + text2 + "</a>"));
        if (out == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(15);
        }
        return out;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 6: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/DataGridDocumentationProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageSpec";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/DataGridDocumentationProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellDocumentation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchExternalDocumentation";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "appendHyperLinkCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildAndRunQueries";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQuickDocFooter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setHint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCellDocumentation";
                break;
            }
            case 6: 
            case 11: 
            case 15: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLocalImageForElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractRefFromLink";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fetchExternalDocumentation";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendHyperLinkCommand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 11, 15 -> new IllegalStateException(string);
        };
    }

    public static class State {
        final List<DataGridDocumentationUtil.QueryInfo> queries;
        final ModelIndexSet<GridRow> rows;
        final String current;
        final long timestamp = System.currentTimeMillis();

        public State(List<DataGridDocumentationUtil.QueryInfo> queries, ModelIndexSet<GridRow> rows, String current) {
            this.queries = queries;
            this.rows = rows;
            this.current = current;
        }
    }
}

