/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.Dbms;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelListener;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbModelApplier;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbEditorListener;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbEditorBase<E extends BasicElement, S extends DbModelState>
implements DbEditor<E, S> {
    private final DbEditorController myController;
    private final DbModelRef<E, S> myModelRef;
    private final DbEditorListener myEditorListener;
    private final DbEditorModelListener myModelListener;
    private boolean myApplying;

    protected DbEditorBase(@NotNull DbEditorController controller, @NotNull DbModelRef<E, S> modelRef) {
        if (controller == null) {
            DbEditorBase.$$$reportNull$$$0(0);
        }
        if (modelRef == null) {
            DbEditorBase.$$$reportNull$$$0(1);
        }
        this.myController = controller;
        this.myModelRef = modelRef;
        this.myModelListener = this.createModelListener();
        this.myEditorListener = this.createEditorListener();
    }

    @Nullable
    protected DbEditorListener createEditorListener() {
        return null;
    }

    @Nullable
    protected DbEditorModelListener createModelListener() {
        return null;
    }

    @Override
    public boolean register() {
        if (!this.myController.registerEditor(this)) {
            return false;
        }
        if (this.myEditorListener != null) {
            this.myController.getEventDispatcher().addListener((EventListener)this.myEditorListener);
        }
        if (this.myModelListener != null) {
            this.myController.getModelController().getEventDispatcher().addListener((EventListener)this.myModelListener);
        }
        this.myModelRef.register(this.myController.getModelController());
        return true;
    }

    @Override
    public boolean unregister(boolean keepModel) {
        if (!this.myController.unregisterEditor(this)) {
            return false;
        }
        if (this.myEditorListener != null) {
            this.myController.getEventDispatcher().removeListener((EventListener)this.myEditorListener);
        }
        if (this.myModelListener != null) {
            this.myController.getModelController().getEventDispatcher().removeListener((EventListener)this.myModelListener);
        }
        if (!keepModel) {
            this.myModelRef.unregister(this.myController.getModelController());
        }
        return true;
    }

    @Override
    @NotNull
    public DbEditorController getController() {
        DbEditorController dbEditorController = this.myController;
        if (dbEditorController == null) {
            DbEditorBase.$$$reportNull$$$0(2);
        }
        return dbEditorController;
    }

    @NotNull
    private DbEditorModel<E, S> getModel() {
        DbEditorModel<E, S> dbEditorModel = this.myModelRef.resolve(this.myController.getModelController());
        if (dbEditorModel == null) {
            DbEditorBase.$$$reportNull$$$0(3);
        }
        return dbEditorModel;
    }

    @Override
    @NotNull
    public DbModelRef<E, S> getModelRef() {
        DbModelRef<E, S> dbModelRef = this.myModelRef;
        if (dbModelRef == null) {
            DbEditorBase.$$$reportNull$$$0(4);
        }
        return dbModelRef;
    }

    @Override
    @NotNull
    public DbModelApplier<E, S> getApplier() {
        DbModelApplier<E, S> dbModelApplier = this.myModelRef.getApplier();
        if (dbModelApplier == null) {
            DbEditorBase.$$$reportNull$$$0(5);
        }
        return dbModelApplier;
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.getModelTitle();
    }

    @Override
    @Nullable
    public final String getModelTitle() {
        return this.getModel().getTitle();
    }

    @Override
    @NotNull
    public final ElementIdentity<E> getIdentity() {
        ElementIdentity elementIdentity = this.myModelRef.getIdentity();
        if (elementIdentity == null) {
            DbEditorBase.$$$reportNull$$$0(6);
        }
        return elementIdentity;
    }

    @Override
    @NotNull
    public final BasicMetaId getModelInternalKey() {
        BasicMetaId basicMetaId = this.myModelRef.getModelInternalKey();
        if (basicMetaId == null) {
            DbEditorBase.$$$reportNull$$$0(7);
        }
        return basicMetaId;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.getModel().getDbms();
        if (dbms == null) {
            DbEditorBase.$$$reportNull$$$0(8);
        }
        return dbms;
    }

    @Override
    @NotNull
    public S getState() {
        S s = this.myModelRef.getState();
        if (s == null) {
            DbEditorBase.$$$reportNull$$$0(9);
        }
        return s;
    }

    protected boolean isApplying() {
        return this.myApplying;
    }

    @Override
    public final void apply() {
        this.myApplying = true;
        try {
            this.applyImpl();
            this.updateState();
        }
        finally {
            this.myApplying = false;
        }
    }

    @Override
    public final void reset() {
        this.resetImpl();
        this.updateState();
    }

    protected abstract void applyImpl();

    protected abstract void resetImpl();

    public void modified() {
        if (!this.getController().isEditorRegistered(this)) {
            return;
        }
        ((DbEditorListener)this.getController().getEventDispatcher().getMulticaster()).modified(this);
    }

    protected String getDebugString() {
        String title = this.getTitle();
        return title == null ? this.getClass().getSimpleName() : title;
    }

    public String toString() {
        return this.getModel() + " " + this.getDebugString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelRef";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbEditorBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbEditorBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getController";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelRef";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplier";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentity";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelInternalKey";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

