/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DatabaseToggleNotebookModeAction;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.MutableProperty;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/settings/DatabaseSettingsOutputResults;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "<init>", "()V", "textAsTitleAfterTextField", "Lcom/intellij/ui/components/JBTextField;", "apply", "", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "Companion", "intellij.database.impl"})
public final class DatabaseSettingsOutputResults
extends BoundSearchableConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private JBTextField textAsTitleAfterTextField;
    @NotNull
    private static final Predicate<JTextComponent> STATUS_VISIBILITY_PREDICATE = DatabaseSettingsOutputResults::STATUS_VISIBILITY_PREDICATE$lambda$19;

    public DatabaseSettingsOutputResults() {
        String string = IdeBundle.message((String)"configurable.DatabaseSettingsConfigurable.OutputResults.display.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "preferences.database.outputResults", "database.output.results");
    }

    public void apply() {
        DatabaseSettings settings = DatabaseSettings.getSettings();
        boolean oldNotebookMode = settings.notebookMode;
        super.apply();
        DatabaseSettings.fireSettingsChanged();
        if (oldNotebookMode != settings.notebookMode) {
            DatabaseToggleNotebookModeAction.forgetSavedState();
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            for (Project project : projectArray) {
                List<JdbcConsole> consoles;
                Intrinsics.checkNotNull((Object)project);
                Project project2 = project;
                Intrinsics.checkNotNullExpressionValue(JdbcConsole.getActiveConsoles(project2), (String)"getActiveConsoles(...)");
                for (JdbcConsole console : consoles) {
                    console.setNotebookMode(settings.notebookMode, false);
                }
                DaemonCodeAnalyzer.getInstance((Project)project2).restart();
            }
        }
    }

    @NotNull
    public DialogPanel createPanel() {
        DatabaseSettings settings = DatabaseSettings.getSettings();
        DialogPanel panel2 = com.intellij.ui.dsl.builder.BuilderKt.panel(arg_0 -> DatabaseSettingsOutputResults.createPanel$lambda$18(settings, this, arg_0));
        return panel2;
    }

    private static final Unit createPanel$lambda$18$lambda$1$lambda$0(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message("settings.show.timestamp.for.query.output", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).showQueryOutputTimestamp;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).showQueryOutputTimestamp = (Boolean)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$18$lambda$1(DatabaseSettings $settings, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsOutputResults.createPanel$lambda$18$lambda$1$lambda$0($settings, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$18$lambda$10$lambda$2(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message("settings.database.notebook.mode", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).notebookMode;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).notebookMode = (Boolean)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$18$lambda$10$lambda$3(Ref.ObjectRef $resultsTitlePrefixCheckBox, DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message("settings.create.title.for.results.from.comment.before.query", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $resultsTitlePrefixCheckBox.element = ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).resultsTitlePrefixEnabled;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).resultsTitlePrefixEnabled = (Boolean)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$18$lambda$10$lambda$9$lambda$8$lambda$4(DatabaseSettings $settings, DatabaseSettingsOutputResults this$0) {
        JBTextField jBTextField = this$0.textAsTitleAfterTextField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textAsTitleAfterTextField");
            jBTextField = null;
        }
        $settings.resultsTitlePrefix = StringUtil.nullize((String)jBTextField.getText(), (boolean)true);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$18$lambda$10$lambda$9$lambda$8$lambda$5(DatabaseSettingsOutputResults this$0, DatabaseSettings $settings) {
        JBTextField jBTextField = this$0.textAsTitleAfterTextField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textAsTitleAfterTextField");
            jBTextField = null;
        }
        jBTextField.setText($settings.resultsTitlePrefix);
        return Unit.INSTANCE;
    }

    private static final boolean createPanel$lambda$18$lambda$10$lambda$9$lambda$8$lambda$6(DatabaseSettings $settings, DatabaseSettingsOutputResults this$0) {
        String string = $settings.resultsTitlePrefix;
        JBTextField jBTextField = this$0.textAsTitleAfterTextField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textAsTitleAfterTextField");
            jBTextField = null;
        }
        return !Intrinsics.areEqual((Object)string, (Object)StringUtil.nullize((String)jBTextField.getText(), (boolean)true));
    }

    private static final Unit createPanel$lambda$18$lambda$10$lambda$9$lambda$8$lambda$7(JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.getEmptyText().setText(DatabaseBundle.message("settings.comment.beginning", new Object[0]));
        $this$applyToComponent.putClientProperty((Object)"StatusVisibleFunction", STATUS_VISIBILITY_PREDICATE);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$18$lambda$10$lambda$9$lambda$8(DatabaseSettingsOutputResults this$0, DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.textAsTitleAfterTextField = (JBTextField)$this$row.textField().onApply(() -> DatabaseSettingsOutputResults.createPanel$lambda$18$lambda$10$lambda$9$lambda$8$lambda$4($settings, this$0)).onReset(() -> DatabaseSettingsOutputResults.createPanel$lambda$18$lambda$10$lambda$9$lambda$8$lambda$5(this$0, $settings)).onIsModified(() -> DatabaseSettingsOutputResults.createPanel$lambda$18$lambda$10$lambda$9$lambda$8$lambda$6($settings, this$0)).applyToComponent(DatabaseSettingsOutputResults::createPanel$lambda$18$lambda$10$lambda$9$lambda$8$lambda$7).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$18$lambda$10$lambda$9(Ref.ObjectRef $resultsTitlePrefixCheckBox, DatabaseSettingsOutputResults this$0, DatabaseSettings $settings, Panel $this$indent) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        String string = DatabaseBundle.message("settings.treat.text.as.title.after", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row row = $this$indent.row(string, arg_0 -> DatabaseSettingsOutputResults.createPanel$lambda$18$lambda$10$lambda$9$lambda$8(this$0, $settings, arg_0));
        if ($resultsTitlePrefixCheckBox.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resultsTitlePrefixCheckBox");
            cell = null;
        } else {
            cell = (Cell)$resultsTitlePrefixCheckBox.element;
        }
        row.enabledIf(ButtonKt.getSelected((Cell)cell));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$18$lambda$10(DatabaseSettings $settings, DatabaseSettingsOutputResults this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsOutputResults.createPanel$lambda$18$lambda$10$lambda$2($settings, arg_0), (int)1, null);
        Ref.ObjectRef resultsTitlePrefixCheckBox = new Ref.ObjectRef();
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsOutputResults.createPanel$lambda$18$lambda$10$lambda$3(resultsTitlePrefixCheckBox, $settings, arg_0), (int)1, null);
        $this$group.indent(arg_0 -> DatabaseSettingsOutputResults.createPanel$lambda$18$lambda$10$lambda$9(resultsTitlePrefixCheckBox, this$0, $settings, arg_0));
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$18$lambda$17$lambda$13$lambda$11(DatabaseSettings.ShowServicesMode it) {
        DatabaseSettings.ShowServicesMode showServicesMode = it;
        return switch (showServicesMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[showServicesMode.ordinal()]) {
            case 1 -> DatabaseBundle.message("settings.show.services.for.all.output", new Object[0]);
            case 2 -> DatabaseBundle.message("settings.show.services.for.query.output.errors.and.result.sets", new Object[0]);
            case 3 -> DatabaseBundle.message("settings.show.services.for.errors.and.result.sets", new Object[0]);
            case 4 -> DatabaseBundle.message("settings.show.services.for.result.sets", new Object[0]);
            case 5 -> DatabaseBundle.message("settings.show.services.never", new Object[0]);
            case -1 -> "";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Unit createPanel$lambda$18$lambda$17$lambda$13$lambda$12(ComboBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setMinLength(30);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$18$lambda$17$lambda$13(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell = $this$row.comboBox((Collection)ArraysKt.toList((Object[])DatabaseSettings.ShowServicesMode.values()), BuilderKt.textListCellRenderer(DatabaseSettingsOutputResults::createPanel$lambda$18$lambda$17$lambda$13$lambda$11));
        String string = DatabaseBundle.message("settings.show.services.tool.window.for.query.console.output", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ComboBoxKt.bindItem((Cell)cell.label(string, LabelPosition.TOP).applyToComponent(DatabaseSettingsOutputResults::createPanel$lambda$18$lambda$17$lambda$13$lambda$12), (MutableProperty)MutablePropertyKt.toNullableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).showServicesMode;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).showServicesMode = (DatabaseSettings.ShowServicesMode)((Object)value);
            }
        })));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$18$lambda$17$lambda$14(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message("settings.focus.on.services.tool.window.in.window.mode", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).focusOnServicesInWindowMode;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).focusOnServicesInWindowMode = (Boolean)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$18$lambda$17$lambda$15(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message("settings.open.output.in.services.tab", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).showOutputInTab;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).showOutputInTab = (Boolean)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$18$lambda$17$lambda$16(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message("settings.activate.services.output.pane.for.selected.query.console.only", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).showOnlySelectedClientOutput;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).showOnlySelectedClientOutput = (Boolean)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$18$lambda$17(DatabaseSettings $settings, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsOutputResults.createPanel$lambda$18$lambda$17$lambda$13($settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsOutputResults.createPanel$lambda$18$lambda$17$lambda$14($settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsOutputResults.createPanel$lambda$18$lambda$17$lambda$15($settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsOutputResults.createPanel$lambda$18$lambda$17$lambda$16($settings, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$18(DatabaseSettings $settings, DatabaseSettingsOutputResults this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.group$default((Panel)$this$panel, (String)DatabaseBundle.message("settings.output", new Object[0]), (boolean)false, arg_0 -> DatabaseSettingsOutputResults.createPanel$lambda$18$lambda$1($settings, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)DatabaseBundle.message("settings.results", new Object[0]), (boolean)false, arg_0 -> DatabaseSettingsOutputResults.createPanel$lambda$18$lambda$10($settings, this$0, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)DatabaseBundle.message("settings.services.tool.window", new Object[0]), (boolean)false, arg_0 -> DatabaseSettingsOutputResults.createPanel$lambda$18$lambda$17($settings, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean STATUS_VISIBILITY_PREDICATE$lambda$19(JTextComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (!component.isEnabled()) return false;
        if (component.isFocusOwner()) return false;
        String string = component.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() != 0) return false;
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/settings/DatabaseSettingsOutputResults$Companion;", "", "<init>", "()V", "STATUS_VISIBILITY_PREDICATE", "Ljava/util/function/Predicate;", "Ljavax/swing/text/JTextComponent;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseSettings.ShowServicesMode.values().length];
            try {
                nArray[DatabaseSettings.ShowServicesMode.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseSettings.ShowServicesMode.QUERYOUTPUT_ERRORS_RESULTSETS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseSettings.ShowServicesMode.ERRORS_RESULTSETS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseSettings.ShowServicesMode.RESULTSETS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseSettings.ShowServicesMode.NEVER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

