/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class BatchIndicesEditorModel
extends EditorModelBase {
    public static final Function<DeIndex, Boolean> PREV_UNIQUE_GENERATOR = index -> {
        BasicIndex basic = index.getEditedBasic();
        if (basic != null) {
            return basic.isUnique();
        }
        return Objects.requireNonNull(index.getEditedDeObject()).unique;
    };
    public static final Function<DeIndex, Boolean> TRUE_UNIQUE_GENERATOR = index -> true;
    public static final Function<DeIndex, Boolean> FALSE_UNIQUE_GENERATOR = index -> false;
    public static final Consumer<List<DeIndex>> PREV_NAME_GENERATOR = new Consumer<List<DeIndex>>(){

        public void consume(List<DeIndex> indices) {
            for (DeIndex index : indices) {
                index.name = index.getPrevName();
            }
        }

        public String toString() {
            return "Using present names";
        }
    };
    public static final Consumer<List<DeIndex>> DEFAULT_NAME_GENERATOR = new PatternNameGenerator("{table}_{columns}_index");
    private final List<DeIndex> myIndices;
    private Consumer<List<DeIndex>> myNameGenerator;
    private Function<DeIndex, Boolean> myUniqueGenerator;

    @NotNull
    public Iterable<DeIndex> getIndices() {
        List<DeIndex> list = this.myIndices;
        if (list == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(0);
        }
        return list;
    }

    public BatchIndicesEditorModel(@NotNull List<DeIndex> indices, @NotNull DeModel model, @NotNull EditorModelsCache models2) {
        if (indices == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(1);
        }
        if (model == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(2);
        }
        if (models2 == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(3);
        }
        super(model, models2);
        this.myIndices = indices;
    }

    public void setNameGenerator(@NotNull Consumer<List<DeIndex>> generator) {
        if (generator == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(4);
        }
        if (Comparing.equal(generator, this.myNameGenerator)) {
            return;
        }
        this.myNameGenerator = generator;
        generator.consume(this.myIndices);
        this.modify();
    }

    @NotNull
    public Consumer<List<DeIndex>> getNameGenerator() {
        Consumer<List<DeIndex>> consumer = this.myNameGenerator;
        if (consumer == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(5);
        }
        return consumer;
    }

    public void setUniqueGenerator(@NotNull Function<DeIndex, Boolean> generator) {
        if (generator == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(6);
        }
        if (Comparing.equal(generator, this.myUniqueGenerator)) {
            return;
        }
        this.myUniqueGenerator = generator;
        for (DeIndex index : this.myIndices) {
            index.unique = (Boolean)generator.fun((Object)index);
        }
        this.modify();
    }

    @NotNull
    public Function<DeIndex, Boolean> getUniqueGenerator() {
        Function<DeIndex, Boolean> function = this.myUniqueGenerator;
        if (function == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(7);
        }
        return function;
    }

    @NotNull
    public ThreeState isUnique() {
        ThreeState res2 = ThreeState.UNSURE;
        for (DeIndex index : this.myIndices) {
            if (res2 == ThreeState.UNSURE) {
                res2 = ThreeState.fromBoolean((boolean)index.unique);
                continue;
            }
            if (index.unique == res2.toBoolean()) continue;
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                BatchIndicesEditorModel.$$$reportNull$$$0(8);
            }
            return threeState;
        }
        ThreeState threeState = res2;
        if (threeState == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(9);
        }
        return threeState;
    }

    @NotNull
    public JBIterable<DeIndex> getEditedObjects() {
        JBIterable jBIterable = JBIterable.from(this.myIndices);
        if (jBIterable == null) {
            BatchIndicesEditorModel.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/models/BatchIndicesEditorModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndices";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/models/BatchIndicesEditorModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameGenerator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueGenerator";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "isUnique";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditedObjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setNameGenerator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setUniqueGenerator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6 -> new IllegalArgumentException(string);
        };
    }

    public static class PatternNameGenerator
    implements Consumer<List<DeIndex>> {
        private final String myPattern;

        public PatternNameGenerator(@NotNull String pattern) {
            if (pattern == null) {
                PatternNameGenerator.$$$reportNull$$$0(0);
            }
            this.myPattern = pattern;
        }

        @NotNull
        public String generate(@NotNull DeIndex index) {
            if (index == null) {
                PatternNameGenerator.$$$reportNull$$$0(1);
            }
            String string = this.myPattern.replace("{table}", index.table.name).replace("{columns}", StringUtil.join(index.getColumnNames(), (String)"_"));
            if (string == null) {
                PatternNameGenerator.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatternNameGenerator generator = (PatternNameGenerator)o;
            return this.myPattern.equals(generator.myPattern);
        }

        public int hashCode() {
            return this.myPattern.hashCode();
        }

        public String toString() {
            return this.myPattern;
        }

        @NotNull
        public String getPattern() {
            String string = this.myPattern;
            if (string == null) {
                PatternNameGenerator.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void consume(List<DeIndex> indices) {
            Map<String, Integer> names = DasUtil.newCaseAwareMap(DasUtil.isCaseSensitive(indices.get((int)0).model.getCasing(ObjectKind.INDEX, null)));
            for (DeIndex index : indices) {
                index.name = this.generate(index);
                Integer integer = (Integer)names.get(index.name);
                if (integer != null) {
                    integer = integer + 1;
                    names.put(index.name, integer);
                    index.name = index.name + "_" + integer;
                    continue;
                }
                names.put(index.name, 0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "index";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/models/BatchIndicesEditorModel$PatternNameGenerator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/models/BatchIndicesEditorModel$PatternNameGenerator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

