/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow.sql.inst;

import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.sql.inspections.dataflow.sql.anchor.SqlClauseAnchor;
import com.intellij.sql.inspections.dataflow.types.SqlDfTableType;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlWhereClause;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/inspections/dataflow/sql/inst/SqlFilteringInstruction;", "Lcom/intellij/codeInspection/dataFlow/lang/ir/ExpressionPushingInstruction;", "clause", "Lcom/intellij/sql/psi/SqlClause;", "<init>", "(Lcom/intellij/sql/psi/SqlClause;)V", "getClause", "()Lcom/intellij/sql/psi/SqlClause;", "accept", "", "Lcom/intellij/codeInspection/dataFlow/lang/ir/DfaInstructionState;", "interpreter", "Lcom/intellij/codeInspection/dataFlow/interpreter/DataFlowInterpreter;", "stateBefore", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "(Lcom/intellij/codeInspection/dataFlow/interpreter/DataFlowInterpreter;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;)[Lcom/intellij/codeInspection/dataFlow/lang/ir/DfaInstructionState;", "toString", "", "intellij.database.sql.core.impl"})
public final class SqlFilteringInstruction
extends ExpressionPushingInstruction {
    @NotNull
    private final SqlClause clause;

    public SqlFilteringInstruction(@NotNull SqlClause clause) {
        Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
        super((DfaAnchor)SqlClauseAnchor.Companion.getAnchor(clause));
        this.clause = clause;
    }

    @NotNull
    public final SqlClause getClause() {
        return this.clause;
    }

    @NotNull
    public DfaInstructionState[] accept(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)stateBefore, (String)"stateBefore");
        DfType dfType = stateBefore.getDfType(stateBefore.pop());
        Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"getDfType(...)");
        DfType condition = dfType;
        DfaValue dfaValue = stateBefore.peek();
        Intrinsics.checkNotNullExpressionValue((Object)dfaValue, (String)"peek(...)");
        DfaValue tableValue = dfaValue;
        DfType dfType2 = stateBefore.getDfType(tableValue);
        SqlDfTableType sqlDfTableType = dfType2 instanceof SqlDfTableType ? (SqlDfTableType)dfType2 : null;
        if (sqlDfTableType == null) {
            DfaInstructionState[] dfaInstructionStateArray = this.nextStates(interpreter, stateBefore);
            Intrinsics.checkNotNullExpressionValue((Object)dfaInstructionStateArray, (String)"nextStates(...)");
            return dfaInstructionStateArray;
        }
        SqlDfTableType tableType2 = sqlDfTableType;
        DfType dfType3 = condition;
        if (Intrinsics.areEqual((Object)dfType3, (Object)SqlDfTypesKt.getNULL()) || Intrinsics.areEqual((Object)dfType3, (Object)SqlDfTypesKt.getFALSE())) {
            stateBefore.setDfType(tableValue, (DfType)tableType2.empty());
        } else {
            if (Intrinsics.areEqual((Object)dfType3, (Object)SqlDfTypesKt.getTRUE())) {
                DfaInstructionState[] dfaInstructionStateArray = this.nextStates(interpreter, stateBefore);
                Intrinsics.checkNotNullExpressionValue((Object)dfaInstructionStateArray, (String)"nextStates(...)");
                return dfaInstructionStateArray;
            }
            stateBefore.setDfType(tableValue, (DfType)tableType2.dropCardinality());
        }
        DfaInstructionState[] dfaInstructionStateArray = this.nextStates(interpreter, stateBefore);
        Intrinsics.checkNotNullExpressionValue((Object)dfaInstructionStateArray, (String)"nextStates(...)");
        return dfaInstructionStateArray;
    }

    @NotNull
    public String toString() {
        SqlClause sqlClause = this.clause;
        return sqlClause instanceof SqlWhereClause ? "FILTERING_OP WHERE" : (sqlClause instanceof SqlHavingClause ? "FILTERING_OP HAVING" : "UNKNOWN_FILTERING_OP");
    }
}

