/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.slicer;

import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.PsiTable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.slicer.SliceUsage;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlLocalDefinition;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.slicer.SqlPsiUtilKt;
import com.intellij.sql.slicer.SqlSliceUsage;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0003H\u0004J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0003H\u0014J\b\u0010\u0019\u001a\u00020\u0014H&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0004\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0010j\b\u0012\u0004\u0012\u00020\u0003`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/sql/slicer/SqlSlicerBase;", "", "element", "Lcom/intellij/psi/PsiElement;", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/slicer/SliceUsage;", "parentUsage", "Lcom/intellij/sql/slicer/SqlSliceUsage;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/Processor;Lcom/intellij/sql/slicer/SqlSliceUsage;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getProcessor", "()Lcom/intellij/util/Processor;", "processed", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "uniquenessKey", "passToProcessor", "", "findUsages", "Lkotlin/sequences/Sequence;", "Lcom/intellij/sql/psi/SqlExpression;", "definition", "processChildren", "intellij.database.sql.impl"})
public abstract class SqlSlicerBase {
    @NotNull
    private final PsiElement element;
    @NotNull
    private final Processor<? super SliceUsage> processor;
    @NotNull
    private final SqlSliceUsage parentUsage;
    @NotNull
    private final HashSet<PsiElement> processed;

    public SqlSlicerBase(@NotNull PsiElement element, @NotNull Processor<? super SliceUsage> processor2, @NotNull SqlSliceUsage parentUsage) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)((Object)parentUsage), (String)"parentUsage");
        this.element = element;
        this.processor = processor2;
        this.parentUsage = parentUsage;
        this.processed = new HashSet();
    }

    @NotNull
    protected final PsiElement getElement() {
        return this.element;
    }

    @NotNull
    protected final Processor<? super SliceUsage> getProcessor() {
        return this.processor;
    }

    @NotNull
    protected PsiElement uniquenessKey(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element;
    }

    protected final void passToProcessor(@NotNull PsiElement $this$passToProcessor) {
        Intrinsics.checkNotNullParameter((Object)$this$passToProcessor, (String)"<this>");
        if (!this.processed.add(this.uniquenessKey($this$passToProcessor))) {
            return;
        }
        this.processor.process((Object)new SqlSliceUsage($this$passToProcessor, this.parentUsage));
    }

    @NotNull
    protected Sequence<SqlExpression> findUsages(@NotNull PsiElement definition) {
        PsiObject psiObject;
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        SqlLocalDefinition sqlLocalDefinition = definition instanceof SqlLocalDefinition ? (SqlLocalDefinition)definition : null;
        PsiElement elementToSearch = sqlLocalDefinition != null ? (PsiElement)sqlLocalDefinition : ((psiObject = definition instanceof PsiObject ? (PsiObject)definition : null) != null && (psiObject = SqlPsiUtilKt.toDbElement(psiObject)) != null ? (PsiElement)psiObject : definition);
        Query query = ReferencesSearch.search((PsiElement)elementToSearch);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)query)), arg_0 -> SqlSlicerBase.findUsages$lambda$0(this, definition, arg_0));
    }

    public abstract void processChildren();

    private static final SqlExpression findUsages$lambda$0(SqlSlicerBase this$0, PsiElement $definition, PsiReference ref2) {
        SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)SqlImplUtil.sqlParents(ref2.getElement()).filter(SqlReferenceExpression.class).first();
        if (sqlReferenceExpression == null) {
            return null;
        }
        SqlReferenceExpression refExpression = sqlReferenceExpression;
        VirtualFile virtualFile = refExpression.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (DbSrcFileSystem.isOriginalFilePath(virtualFile2.getPath())) {
            return null;
        }
        if (!this$0.parentUsage.params.scope.toSearchScope().contains(virtualFile2)) {
            return null;
        }
        PsiElement psiElement = $definition;
        return psiElement instanceof SqlVariableDefinition || psiElement instanceof PsiColumn || psiElement instanceof PsiTable ? (SqlExpression)refExpression : (psiElement instanceof SqlProcedureDefinitionImpl ? (SqlExpression)SqlImplUtil.sqlParents((PsiElement)refExpression).filter(SqlFunctionCallExpression.class).first() : null);
    }
}

