/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j;

import java.io.Serializable;
import java.util.Objects;
import org.locationtech.proj4j.datum.Datum;
import org.locationtech.proj4j.proj.LongLatProjection;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.units.Units;

public class CoordinateReferenceSystem
implements Serializable {
    public static final CoordinateReferenceSystem CS_GEO = new CoordinateReferenceSystem("CS_GEO", null, null, null);
    private String name;
    private String[] params;
    private Datum datum;
    private Projection proj;

    public CoordinateReferenceSystem(String name2, String[] params, Datum datum, Projection proj) {
        this.name = name2;
        this.params = params;
        this.datum = datum;
        this.proj = proj;
        if (name2 == null) {
            String projName = "null-proj";
            if (proj != null) {
                projName = proj.getName();
            }
            this.name = projName + "-CS";
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameters() {
        return this.params;
    }

    public Datum getDatum() {
        return this.datum;
    }

    public Projection getProjection() {
        return this.proj;
    }

    public String getParameterString() {
        if (this.params == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < this.params.length; ++i2) {
            buf.append(this.params[i2]);
            buf.append(" ");
        }
        return buf.toString();
    }

    public Boolean isGeographic() {
        return this.proj.isGeographic();
    }

    public CoordinateReferenceSystem createGeographic() {
        Datum datum = this.getDatum();
        LongLatProjection geoProj = new LongLatProjection();
        geoProj.setEllipsoid(this.getProjection().getEllipsoid());
        geoProj.setUnits(Units.DEGREES);
        ((Projection)geoProj).initialize();
        return new CoordinateReferenceSystem("GEO-" + datum.getCode(), null, datum, geoProj);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof CoordinateReferenceSystem) {
            CoordinateReferenceSystem cr = (CoordinateReferenceSystem)that;
            return this.datum.isEqual(cr.getDatum()) && this.proj.equals(cr.proj);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.datum, this.proj);
    }
}

