/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.HtmlEditorPaneUtilKt;
import com.intellij.collaboration.ui.codereview.details.CodeReviewDetailsBranchComponentFactory;
import com.intellij.collaboration.ui.codereview.details.CodeReviewDetailsCommitInfoComponentFactory;
import com.intellij.collaboration.ui.codereview.details.CodeReviewDetailsCommitsComponentFactory;
import com.intellij.collaboration.ui.codereview.details.CodeReviewDetailsTitleComponentFactory;
import com.intellij.collaboration.ui.codereview.details.CommitPresentation;
import com.intellij.collaboration.ui.codereview.details.ReviewDetailsUIUtil;
import com.intellij.collaboration.ui.codereview.details.data.ReviewRequestState;
import com.intellij.collaboration.ui.codereview.details.model.CodeReviewBranchesViewModel;
import com.intellij.collaboration.ui.codereview.details.model.CodeReviewChangesViewModel;
import com.intellij.collaboration.ui.codereview.details.model.CodeReviewDetailsViewModel;
import com.intellij.collaboration.ui.util.MigLayoutUtilKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.ActionLink;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHCommit;
import org.jetbrains.plugins.github.api.data.GHGitActor;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.comment.GHMarkdownToHtmlConverterKt;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRDetailsActionsComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRStatusChecksComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.details.model.impl.GHPRDetailsViewModel;
import org.jetbrains.plugins.github.ui.util.GHHtmlPaneUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRDetailsComponentFactory;", "", "<init>", "()V", "create", "Ljavax/swing/JComponent;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "detailsVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/model/impl/GHPRDetailsViewModel;", "commitFilesBrowserComponent", "showTimelineAction", "", "parentComponent", "createCommitsPopupPresenter", "Lcom/intellij/collaboration/ui/codereview/details/CommitPresentation;", "commit", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "ghostUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "intellij.vcs.github"})
public final class GHPRDetailsComponentFactory {
    @NotNull
    public static final GHPRDetailsComponentFactory INSTANCE = new GHPRDetailsComponentFactory();

    private GHPRDetailsComponentFactory() {
    }

    @NotNull
    public final JComponent create(@NotNull CoroutineScope scope, @NotNull Project project, @NotNull GHPRDetailsViewModel detailsVm2, @NotNull JComponent commitFilesBrowserComponent) {
        JPanel jPanel;
        JPanel jPanel2;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)detailsVm2, (String)"detailsVm");
        Intrinsics.checkNotNullParameter((Object)commitFilesBrowserComponent, (String)"commitFilesBrowserComponent");
        AnAction anAction = ActionManager.getInstance().getAction("Github.PullRequest.Details.Popup");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup actionGroup = (ActionGroup)anAction;
        CodeReviewDetailsViewModel codeReviewDetailsViewModel = detailsVm2;
        String string = GithubBundle.message("open.on.github.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        JComponent title = CodeReviewDetailsTitleComponentFactory.INSTANCE.create(scope, codeReviewDetailsViewModel, string, actionGroup, GHPRDetailsComponentFactory::create$lambda$0);
        String string2 = CollaborationToolsBundle.message((String)"review.details.view.timeline.action", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        ActionLink timelineLink = new ActionLink(string2, GHPRDetailsComponentFactory::create$lambda$1);
        JPanel $this$create_u24lambda_u243 = jPanel2 = new JPanel((LayoutManager)new MigLayout(MigLayoutUtilKt.emptyBorders((LC)new LC()).fill(), new AC().gap("push")));
        boolean bl = false;
        $this$create_u24lambda_u243.setOpaque(false);
        $this$create_u24lambda_u243.add(CodeReviewDetailsCommitsComponentFactory.INSTANCE.create(scope, (CodeReviewChangesViewModel)detailsVm2.getChangesVm(), arg_0 -> GHPRDetailsComponentFactory.create$lambda$3$lambda$2(project, detailsVm2, arg_0)));
        $this$create_u24lambda_u243.add(CodeReviewDetailsBranchComponentFactory.INSTANCE.create(scope, (CodeReviewBranchesViewModel)detailsVm2.getBranchesVm()));
        JPanel commitsAndBranches = jPanel2;
        JComponent statusChecks = GHPRStatusChecksComponentFactory.INSTANCE.create(scope, project, detailsVm2);
        JComponent actionsComponent = GHPRDetailsActionsComponentFactory.INSTANCE.create(scope, project, (Flow<? extends ReviewRequestState>)detailsVm2.getReviewRequestState(), detailsVm2.getReviewFlowVm());
        JPanel $this$create_u24lambda_u247 = jPanel = new JPanel((LayoutManager)new MigLayout(MigLayoutUtilKt.emptyBorders((LC)new LC()).fill().flowY().noGrid().hideMode(3)));
        boolean bl2 = false;
        $this$create_u24lambda_u247.setOpaque(false);
        Component component = ReviewDetailsUIUtil.INSTANCE.createTitlePanel(title, (JComponent)timelineLink);
        CC cC = new CC().growX();
        Intrinsics.checkNotNullExpressionValue((Object)cC, (String)"growX(...)");
        $this$create_u24lambda_u247.add(component, MigLayoutUtilKt.gap((CC)cC, (Insets)ReviewDetailsUIUtil.INSTANCE.getTITLE_GAPS()));
        Component component2 = commitsAndBranches;
        CC cC2 = new CC().growX();
        Intrinsics.checkNotNullExpressionValue((Object)cC2, (String)"growX(...)");
        $this$create_u24lambda_u247.add(component2, MigLayoutUtilKt.gap((CC)cC2, (Insets)ReviewDetailsUIUtil.INSTANCE.getCOMMIT_POPUP_BRANCHES_GAPS()));
        Component component3 = CodeReviewDetailsCommitInfoComponentFactory.INSTANCE.create(scope, (Flow)detailsVm2.getChangesVm().getSelectedCommit(), arg_0 -> GHPRDetailsComponentFactory.create$lambda$7$lambda$4(project, detailsVm2, arg_0), () -> GHPRDetailsComponentFactory.create$lambda$7$lambda$6(detailsVm2));
        CC cC3 = new CC().growX();
        Intrinsics.checkNotNullExpressionValue((Object)cC3, (String)"growX(...)");
        $this$create_u24lambda_u247.add(component3, MigLayoutUtilKt.gap((CC)cC3, (Insets)ReviewDetailsUIUtil.INSTANCE.getCOMMIT_INFO_GAPS()));
        $this$create_u24lambda_u247.add((Component)commitFilesBrowserComponent, new CC().grow().shrinkPrioY(200));
        Component component4 = statusChecks;
        CC cC4 = new CC().growX();
        Intrinsics.checkNotNullExpressionValue((Object)cC4, (String)"growX(...)");
        $this$create_u24lambda_u247.add(component4, MigLayoutUtilKt.gap((CC)cC4, (Insets)ReviewDetailsUIUtil.INSTANCE.getSTATUSES_GAPS()).maxHeight(String.valueOf(ReviewDetailsUIUtil.INSTANCE.getSTATUSES_MAX_HEIGHT())));
        Component component5 = actionsComponent;
        CC cC5 = new CC().growX().pushX();
        Intrinsics.checkNotNullExpressionValue((Object)cC5, (String)"pushX(...)");
        $this$create_u24lambda_u247.add(component5, MigLayoutUtilKt.gap((CC)cC5, (Insets)ReviewDetailsUIUtil.INSTANCE.getACTIONS_GAPS()).minHeight("pref"));
        PopupHandler.installPopupMenu((JComponent)$this$create_u24lambda_u247, (ActionGroup)actionGroup, (String)"popup");
        return jPanel;
    }

    private final void showTimelineAction(JComponent parentComponent) {
        AnAction anAction = ActionManager.getInstance().getAction("Github.PullRequest.Timeline.Show");
        if (anAction == null) {
            return;
        }
        AnAction action = anAction;
        ActionUtil.invokeAction((AnAction)action, (Component)parentComponent, (String)"unknown", null, null);
    }

    private final CommitPresentation createCommitsPopupPresenter(Project project, GHCommit commit, GHUser ghostUser) {
        String string = GHMarkdownToHtmlConverterKt.convertToHtml(commit.getMessageHeadline(), project);
        String string2 = GHMarkdownToHtmlConverterKt.convertToHtml(commit.getMessageBody(), project);
        Object object = commit.getAuthor();
        if (object == null || (object = ((GHGitActor)object).getUser()) == null) {
            object = ghostUser;
        }
        return new CommitPresentation(string, string2, ((GHUser)object).getPresentableName(), commit.getCommittedDate());
    }

    private static final JEditorPane create$lambda$0() {
        return HtmlEditorPaneUtilKt.SimpleHtmlPane$default(null, (boolean)false, null, null, null, (int)31, null);
    }

    private static final Unit create$lambda$1(ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        INSTANCE.showTimelineAction((JComponent)object);
        return Unit.INSTANCE;
    }

    private static final CommitPresentation create$lambda$3$lambda$2(Project $project, GHPRDetailsViewModel $detailsVm, GHCommit commit) {
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        return INSTANCE.createCommitsPopupPresenter($project, commit, $detailsVm.getSecurityService().getGhostUser());
    }

    private static final CommitPresentation create$lambda$7$lambda$4(Project $project, GHPRDetailsViewModel $detailsVm, GHCommit commit) {
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        return INSTANCE.createCommitsPopupPresenter($project, commit, $detailsVm.getSecurityService().getGhostUser());
    }

    private static final JEditorPane create$lambda$7$lambda$6(GHPRDetailsViewModel $detailsVm) {
        JEditorPane jEditorPane;
        JEditorPane $this$create_u24lambda_u247_u24lambda_u246_u24lambda_u245 = jEditorPane = HtmlEditorPaneUtilKt.SimpleHtmlPane$default(null, (boolean)false, null, null, null, (int)29, null);
        boolean bl = false;
        GHHtmlPaneUtilKt.addGithubHyperlinkListener($this$create_u24lambda_u247_u24lambda_u246_u24lambda_u245, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>((Object)$detailsVm){

            public final void invoke(long p0) {
                ((GHPRDetailsViewModel)this.receiver).openPullRequestInfoAndTimeline(p0);
            }
        }));
        return jEditorPane;
    }
}

