/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.services;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0002\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\u0004\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/completion/full/line/local/services/SignManager;", "", "<init>", "()V", "suppressChecks", "", "verify", "", "serverPath", "Ljava/io/File;", "serverSignPath", "block", "Lkotlin/Function0;", "VerifyException", "Companion", "intellij.fullLine.local"})
public final class SignManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean suppressChecks;
    @NotNull
    private static final String SIGNATURE_ALGORITHM = "SHA512withRSA";
    @NotNull
    private static final Lazy<PublicKey> defaultKey$delegate = LazyKt.lazy(SignManager::defaultKey_delegate$lambda$2);

    public final void verify(@NotNull File serverPath, @NotNull File serverSignPath) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter((Object)serverSignPath, (String)"serverSignPath");
        if (this.suppressChecks) {
            return;
        }
        Signature $this$verify_u24lambda_u240 = Signature.getInstance(SIGNATURE_ALGORITHM);
        boolean bl2 = false;
        try {
            $this$verify_u24lambda_u240.initVerify(SignManager.Companion.getDefaultKey());
            $this$verify_u24lambda_u240.update(FilesKt.readBytes((File)serverPath));
            bl = $this$verify_u24lambda_u240.verify(FilesKt.readBytes((File)serverSignPath));
        }
        catch (Throwable e) {
            Throwable throwable = e;
            if (throwable instanceof InvalidKeyException || throwable instanceof SignatureException) {
                throw new VerifyException(e);
            }
            throw e;
        }
        boolean verified = bl;
        if (!verified) {
            throw new VerifyException(new IllegalStateException("Wrong sign"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void suppressChecks(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.suppressChecks = true;
        try {
            block.invoke();
        }
        finally {
            this.suppressChecks = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PublicKey defaultKey_delegate$lambda$2() {
        PublicKey publicKey;
        URL uRL = Companion.class.getClassLoader().getResource("publicKeys/key.pub");
        Intrinsics.checkNotNull((Object)uRL);
        Closeable closeable = uRL.openStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            publicKey = SignManager.Companion.readPublicKey(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return publicKey;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/completion/full/line/local/services/SignManager$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/completion/full/line/local/services/SignManager;", "SIGNATURE_ALGORITHM", "", "defaultKey", "Ljava/security/PublicKey;", "getDefaultKey", "()Ljava/security/PublicKey;", "defaultKey$delegate", "Lkotlin/Lazy;", "readPublicKey", "input", "Ljava/io/InputStream;", "intellij.fullLine.local"})
    @SourceDebugExtension(value={"SMAP\nSignManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignManager.kt\norg/jetbrains/completion/full/line/local/services/SignManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,72:1\n40#2,3:73\n*S KotlinDebug\n*F\n+ 1 SignManager.kt\norg/jetbrains/completion/full/line/local/services/SignManager$Companion\n*L\n54#1:73,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SignManager getInstance() {
            boolean $i$f$service = false;
            Class<SignManager> serviceClass$iv = SignManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (SignManager)object;
        }

        private final PublicKey getDefaultKey() {
            Lazy lazy = defaultKey$delegate;
            return (PublicKey)lazy.getValue();
        }

        private final PublicKey readPublicKey(InputStream input) {
            InputStream inputStream2 = input;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            String text = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)StringsKt.lines((CharSequence)TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)))), (int)1), (int)1), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            byte[] keyBytes = Base64.getDecoder().decode(text);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PublicKey publicKey = kf.generatePublic(spec);
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"generatePublic(...)");
            return publicKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/completion/full/line/local/services/SignManager$VerifyException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "cause", "", "<init>", "(Ljava/lang/Throwable;)V", "intellij.fullLine.local"})
    public static final class VerifyException
    extends RuntimeException {
        public VerifyException(@NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super(cause);
        }
    }
}

