/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerServerRuntimesManager;
import com.intellij.docker.action.AddDockerConnectionActionKt;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerServerRuntime;
import com.intellij.docker.settings.DockerNamedConnectionConfigurable;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/action/AddDockerConnectionAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "intellij.clouds.docker"})
public final class AddDockerConnectionAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (Intrinsics.areEqual((Object)e.getPlace(), (Object)"GoToAction")) {
            Object[] objectArray = new Object[]{DockerCloudType.getInstance().getPresentableName()};
            e.getPresentation().setText(CloudBundle.messagePointer((String)"new.cloud.connection.configurable.title", (Object[])objectArray));
        } else {
            e.getPresentation().setText(DockerBundle.message("AddDockerConnectionAction.title", new Object[0]));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        String name2 = AddDockerConnectionActionKt.access$generateUniqueDockerServerName();
        RemoteServersManager remoteServersManager = RemoteServersManager.getInstance();
        DockerCloudType type = DockerCloudType.getInstance();
        RemoteServer remoteServer = remoteServersManager.createServer((ServerType)type, name2);
        Intrinsics.checkNotNullExpressionValue((Object)remoteServer, (String)"createServer(...)");
        RemoteServer server = remoteServer;
        DockerNamedConnectionConfigurable configurable = new DockerNamedConnectionConfigurable((RemoteServer<DockerCloudConfiguration>)server);
        Runnable advancedInitialization = () -> AddDockerConnectionAction.actionPerformed$lambda$0(configurable, name2);
        if (ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)configurable, advancedInitialization)) {
            remoteServersManager.addServer(server);
            DockerServerRuntimesManager.Companion.getInstance(project2).getOrCreateConnection((RemoteServer<DockerCloudConfiguration>)server).thenAccept(arg_0 -> AddDockerConnectionAction.actionPerformed$lambda$2(AddDockerConnectionAction::actionPerformed$lambda$1, arg_0));
        }
    }

    private static final void actionPerformed$lambda$0(DockerNamedConnectionConfigurable $configurable, String $name) {
        $configurable.setDisplayName($name);
    }

    private static final Unit actionPerformed$lambda$1(DockerServerRuntime it) {
        Intrinsics.checkNotNull((Object)it);
        DockerUiUtilsKt.select(it);
        DockerUiUtilsKt.expand(it);
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

