/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui.rest;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.HttpRequests;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J.\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J$\u0010%\u001a\u00020&2\u001a\u0010'\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100)0(H\u0002R\u000e\u0010*\u001a\u00020+X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020+X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020+X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/swagger/core/ui/rest/SwPreviewCorsBypassingProxy;", "Lorg/jetbrains/ide/HttpRequestHandler;", "<init>", "()V", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "executeOriginalRequest", "", "originalUrl", "", "originalRequest", "executeOriginalRequestUnsafe", "copyRequestData", "connection", "Ljava/net/URLConnection;", "sendOriginalRequestAndRedirectResponse", "substitutedRequest", "Lcom/intellij/util/io/HttpRequests$Request;", "wrappingExceptionsToResponse", "url", "unsafeAction", "Lkotlin/Function0;", "writeOriginalRequestBodyUnsafe", "originalBrowserRequest", "redirectResponseUnsafe", "transferResponseBytesToChannelUnsafe", "input", "Ljava/io/InputStream;", "channel", "Lio/netty/channel/Channel;", "wrapOriginalHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "originalHeaders", "", "", "MIN_ERROR_STATUS_CODE", "", "UNHANDLED_EXCEPTION_CODE", "CONNECTION_REFUSED_CODE", "IGNORED_HEADERS", "", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwPreviewCorsBypassingProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwPreviewCorsBypassingProxy.kt\ncom/intellij/swagger/core/ui/rest/SwPreviewCorsBypassingProxy\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 7 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,165:1\n992#2:166\n1021#2,3:167\n1024#2,3:177\n1317#2,2:196\n381#3,7:170\n462#3:180\n412#3:181\n1246#4,4:182\n216#5,2:186\n24#6:188\n24#6:189\n24#6:190\n24#6:193\n24#6:194\n24#6:195\n19#7:191\n19#7:192\n*S KotlinDebug\n*F\n+ 1 SwPreviewCorsBypassingProxy.kt\ncom/intellij/swagger/core/ui/rest/SwPreviewCorsBypassingProxy\n*L\n61#1:166\n61#1:167,3\n61#1:177,3\n154#1:196,2\n61#1:170,7\n62#1:180\n62#1:181\n62#1:182,4\n63#1:186,2\n88#1:188\n93#1:189\n98#1:190\n132#1:193\n138#1:194\n147#1:195\n107#1:191\n119#1:192\n*E\n"})
public final class SwPreviewCorsBypassingProxy
extends HttpRequestHandler {
    private final int MIN_ERROR_STATUS_CODE;
    private final int UNHANDLED_EXCEPTION_CODE;
    private final int CONNECTION_REFUSED_CODE;
    @NotNull
    private final Set<String> IGNORED_HEADERS;

    public SwPreviewCorsBypassingProxy() {
        this.MIN_ERROR_STATUS_CODE = 400;
        this.UNHANDLED_EXCEPTION_CODE = 418;
        this.CONNECTION_REFUSED_CODE = 502;
        Object[] objectArray = new String[]{"__ij-openapi-plugin-original-url", "Accept-Encoding"};
        this.IGNORED_HEADERS = SetsKt.setOf((Object[])objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!Registry.Companion.is("openapi.preview.proxy.enable")) return false;
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"/__ij-openapi-plugin-preview-cors", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = request.headers().get("__ij-openapi-plugin-original-url");
        if (string == null) {
            return false;
        }
        String originalUrl = string;
        this.executeOriginalRequest(originalUrl, request, context);
        return true;
    }

    private final void executeOriginalRequest(String originalUrl, FullHttpRequest originalRequest, ChannelHandlerContext context) {
        this.wrappingExceptionsToResponse(originalUrl, originalRequest, context, (Function0<Unit>)((Function0)() -> SwPreviewCorsBypassingProxy.executeOriginalRequest$lambda$0(this, originalUrl, originalRequest, context)));
    }

    private final void executeOriginalRequestUnsafe(String originalUrl, FullHttpRequest originalRequest, ChannelHandlerContext context) {
        int timeout = Registry.Companion.intValue("openapi.preview.proxy.connect.timeout");
        HttpRequests.request((String)originalUrl).connectTimeout(timeout).readTimeout(timeout).throwStatusCodeException(false).tuner(arg_0 -> SwPreviewCorsBypassingProxy.executeOriginalRequestUnsafe$lambda$1(this, originalRequest, arg_0)).connect(arg_0 -> SwPreviewCorsBypassingProxy.executeOriginalRequestUnsafe$lambda$2(this, originalRequest, context, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void copyRequestData(URLConnection connection, FullHttpRequest request) {
        void $this$mapValuesTo$iv$iv;
        Object key;
        Map $this$groupByTo$iv$iv;
        if (!(connection instanceof HttpURLConnection)) {
            return;
        }
        ((HttpURLConnection)connection).setDoOutput(true);
        ((HttpURLConnection)connection).setDoInput(true);
        ((HttpURLConnection)connection).setRequestMethod(request.method().name());
        HttpHeaders httpHeaders = request.headers();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"headers(...)");
        Sequence $this$groupBy$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)httpHeaders)), arg_0 -> SwPreviewCorsBypassingProxy.copyRequestData$lambda$3(this, arg_0)), SwPreviewCorsBypassingProxy::copyRequestData$lambda$4);
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object2;
            Object element$iv$iv = iterator.next();
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            key = (String)pair.component1();
            String key$iv$iv = key;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void entry;
            void it$iv$iv;
            key = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry $i$f$getOrPut = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl3 = false;
            String string = CollectionsKt.joinToString$default((Iterable)((Iterable)entry.getValue()), (CharSequence)",", null, null, (int)0, null, SwPreviewCorsBypassingProxy::copyRequestData$lambda$7$lambda$6, (int)30, null);
            map3.put(k, string);
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String key2 = (String)entry.getKey();
            String value = (String)entry.getValue();
            connection.setRequestProperty(key2, value);
        }
    }

    private final void sendOriginalRequestAndRedirectResponse(HttpRequests.Request substitutedRequest, FullHttpRequest originalRequest, ChannelHandlerContext context) {
        String string = substitutedRequest.getURL();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getURL(...)");
        this.wrappingExceptionsToResponse(string, originalRequest, context, (Function0<Unit>)((Function0)() -> SwPreviewCorsBypassingProxy.sendOriginalRequestAndRedirectResponse$lambda$9(this, originalRequest, substitutedRequest, context)));
    }

    private final void wrappingExceptionsToResponse(String url2, FullHttpRequest originalRequest, ChannelHandlerContext context, Function0<Unit> unsafeAction) {
        try {
            unsafeAction.invoke();
        }
        catch (HttpRequests.HttpStatusException exception) {
            SwPreviewCorsBypassingProxy $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SwPreviewCorsBypassingProxy.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to process request to '" + url2 + "', received status code '" + exception.getStatusCode() + "'", (Throwable)exception);
            HttpResponse httpResponse = (HttpResponse)new DefaultHttpResponse(originalRequest.protocolVersion(), HttpResponseStatus.valueOf((int)exception.getStatusCode()));
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            Responses.send$default((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)originalRequest), null, (int)4, null);
        }
        catch (ConnectException exception) {
            SwPreviewCorsBypassingProxy $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SwPreviewCorsBypassingProxy.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to execute request to '" + url2 + "', connection refused", (Throwable)exception);
            HttpResponse httpResponse = (HttpResponse)new DefaultHttpResponse(originalRequest.protocolVersion(), HttpResponseStatus.valueOf((int)this.CONNECTION_REFUSED_CODE));
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            Responses.send$default((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)originalRequest), null, (int)4, null);
        }
        catch (IOException exception) {
            SwPreviewCorsBypassingProxy $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SwPreviewCorsBypassingProxy.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to execute request to '" + url2 + "'", (Throwable)exception);
            HttpResponse httpResponse = (HttpResponse)new DefaultHttpResponse(originalRequest.protocolVersion(), HttpResponseStatus.valueOf((int)this.UNHANDLED_EXCEPTION_CODE));
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            Responses.send$default((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)originalRequest), null, (int)4, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void writeOriginalRequestBodyUnsafe(FullHttpRequest originalBrowserRequest, HttpRequests.Request substitutedRequest) {
        if (originalBrowserRequest.content().readableBytes() > 0) {
            Object object;
            void $this$asSafely$iv;
            Object object2 = substitutedRequest.getConnection();
            boolean $i$f$asSafely = false;
            Object v0 = $this$asSafely$iv;
            if (!(v0 instanceof HttpURLConnection)) {
                v0 = null;
            }
            object = (object = (HttpURLConnection)v0) != null ? ((URLConnection)object).getOutputStream() : null;
            object2 = null;
            try {
                long l;
                OutputStream output = (OutputStream)object;
                boolean bl = false;
                Closeable closeable = (Closeable)new ByteBufInputStream(originalBrowserRequest.content());
                Throwable throwable = null;
                try {
                    ByteBufInputStream it = (ByteBufInputStream)closeable;
                    boolean bl2 = false;
                    l = it.transferTo(output);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                long l2 = l;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
    }

    private final void redirectResponseUnsafe(FullHttpRequest originalRequest, HttpRequests.Request substitutedRequest, ChannelHandlerContext context) {
        URLConnection $this$asSafely$iv = substitutedRequest.getConnection();
        boolean $i$f$asSafely = false;
        URLConnection uRLConnection = $this$asSafely$iv;
        if (!(uRLConnection instanceof HttpURLConnection)) {
            uRLConnection = null;
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        if (httpURLConnection == null) {
            return;
        }
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        int responseCode = httpURLConnection2.getResponseCode();
        if (responseCode >= this.MIN_ERROR_STATUS_CODE) {
            throw new HttpRequests.HttpStatusException("", responseCode, substitutedRequest.getURL());
        }
        HttpVersion httpVersion = originalRequest.protocolVersion();
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.valueOf((int)responseCode);
        Map<String, List<String>> map2 = httpURLConnection2.getHeaderFields();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getHeaderFields(...)");
        DefaultHttpResponse response = new DefaultHttpResponse(httpVersion, httpResponseStatus, this.wrapOriginalHeaders(map2));
        ChannelFuture channelFuture = context.channel().write((Object)response);
        InputStream inputStream = substitutedRequest.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        Channel channel = channelFuture.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
        this.transferResponseBytesToChannelUnsafe(inputStream, channel);
        channelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private final void transferResponseBytesToChannelUnsafe(InputStream input, Channel channel) {
        boolean $i$f$thisLogger;
        SwPreviewCorsBypassingProxy $this$thisLogger$iv;
        SwPreviewCorsBypassingProxy $this$thisLogger$iv2 = this;
        boolean $i$f$thisLogger2 = false;
        Logger logger = Logger.getInstance(SwPreviewCorsBypassingProxy.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Started transferring proxied response to the jcef browser");
        byte[] buffer = new byte[1024];
        int bytesRead = input.read(buffer);
        long bytesTransferred = 0L;
        int chunkNumber = 1;
        while (bytesRead != -1) {
            ByteBuf buf;
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(SwPreviewCorsBypassingProxy.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.debug("Chunk " + ++chunkNumber + " transferring in progress");
            Intrinsics.checkNotNullExpressionValue((Object)channel.alloc().buffer(bytesRead), (String)"buffer(...)");
            buf.writeBytes(buffer, 0, bytesRead);
            channel.write((Object)buf);
            bytesTransferred += (long)bytesRead;
            bytesRead = input.read(buffer);
        }
        channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        Logger logger3 = Logger.getInstance(SwPreviewCorsBypassingProxy.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
        logger3.debug("Transferred response with length " + bytesTransferred + " bytes in " + chunkNumber + " chunks");
    }

    private final HttpHeaders wrapOriginalHeaders(Map<String, ? extends List<String>> originalHeaders) {
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)MapsKt.asSequence(originalHeaders), SwPreviewCorsBypassingProxy::wrapOriginalHeaders$lambda$12);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            httpHeaders.set(key, (Iterable)values);
        }
        return (HttpHeaders)httpHeaders;
    }

    private static final Unit executeOriginalRequest$lambda$0(SwPreviewCorsBypassingProxy this$0, String $originalUrl, FullHttpRequest $originalRequest, ChannelHandlerContext $context) {
        this$0.executeOriginalRequestUnsafe($originalUrl, $originalRequest, $context);
        return Unit.INSTANCE;
    }

    private static final void executeOriginalRequestUnsafe$lambda$1(SwPreviewCorsBypassingProxy this$0, FullHttpRequest $originalRequest, URLConnection newUrlConnection) {
        Intrinsics.checkNotNullParameter((Object)newUrlConnection, (String)"newUrlConnection");
        this$0.copyRequestData(newUrlConnection, $originalRequest);
    }

    private static final Unit executeOriginalRequestUnsafe$lambda$2(SwPreviewCorsBypassingProxy this$0, FullHttpRequest $originalRequest, ChannelHandlerContext $context, HttpRequests.Request substitutedRequest) {
        Intrinsics.checkNotNullParameter((Object)substitutedRequest, (String)"substitutedRequest");
        this$0.sendOriginalRequestAndRedirectResponse(substitutedRequest, $originalRequest, $context);
        return Unit.INSTANCE;
    }

    private static final boolean copyRequestData$lambda$3(SwPreviewCorsBypassingProxy this$0, Map.Entry entry) {
        Intrinsics.checkNotNull((Object)entry);
        String key = (String)entry.getKey();
        return !this$0.IGNORED_HEADERS.contains(key);
    }

    private static final Pair copyRequestData$lambda$4(Map.Entry entry) {
        Intrinsics.checkNotNull((Object)entry);
        String key = (String)entry.getKey();
        String value = (String)entry.getValue();
        Intrinsics.checkNotNull((Object)key);
        String string = key.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return TuplesKt.to((Object)string, (Object)value);
    }

    private static final CharSequence copyRequestData$lambda$7$lambda$6(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getSecond();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-second>(...)");
        return (CharSequence)object;
    }

    private static final Unit sendOriginalRequestAndRedirectResponse$lambda$9(SwPreviewCorsBypassingProxy this$0, FullHttpRequest $originalRequest, HttpRequests.Request $substitutedRequest, ChannelHandlerContext $context) {
        this$0.writeOriginalRequestBodyUnsafe($originalRequest, $substitutedRequest);
        this$0.redirectResponseUnsafe($originalRequest, $substitutedRequest, $context);
        return Unit.INSTANCE;
    }

    private static final boolean wrapOriginalHeaders$lambda$12(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String key = (String)entry.getKey();
        return key != null;
    }
}

