/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.http;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.intellij.microservices.http.HttpHeaderDocumentation;
import com.intellij.microservices.mime.MimeTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpHeadersDictionary {
    private static final List<String> ENCODINGS = List.of("compress", "deflate", "exi", "gzip", "identity", "pack200-gzip", "br", "bzip2", "lzma", "peerdist", "sdch", "xpress", "xz");
    private static final List<String> knownExtraHeaders = List.of("X-Correlation-ID", "X-Csrf-Token", "X-Forwarded-For", "X-Forwarded-Host", "X-Forwarded-Proto", "X-Http-Method-Override", "X-Request-ID", "X-Requested-With", "X-Total-Count", "X-User-Agent");
    private static Map<String, HttpHeaderDocumentation> ourHeaders = null;
    private static Map<String, List<String>> ourHeaderValues;
    private static final Map<String, List<String>> ourHeaderOptionNames;
    public static final Pattern HEADER_NAME_PATTERN;

    @NotNull
    public static synchronized Map<String, HttpHeaderDocumentation> getHeaders() {
        if (ourHeaders == null) {
            Map<String, HttpHeaderDocumentation> map = HttpHeadersDictionary.Y();
            for (String string : knownExtraHeaders) {
                map.put(string, new HttpHeaderDocumentation(string));
            }
            ourHeaders = map;
        }
        Map<String, HttpHeaderDocumentation> map = ourHeaders;
        if (map == null) {
            HttpHeadersDictionary.Y(0);
        }
        return map;
    }

    @Nullable
    public static HttpHeaderDocumentation getDocumentation(@NotNull String fieldName) {
        if (fieldName == null) {
            HttpHeadersDictionary.Y(1);
        }
        Map<String, HttpHeaderDocumentation> map = HttpHeadersDictionary.getHeaders();
        return map.get(fieldName);
    }

    @NotNull
    private static Map<String, HttpHeaderDocumentation> Y() {
        HashMap<String, HttpHeaderDocumentation> hashMap = new HashMap<String, HttpHeaderDocumentation>();
        InputStream inputStream = HttpHeadersDictionary.class.getResourceAsStream("/com/intellij/microservices/http/headers-doc.json");
        try {
            JsonElement jsonElement;
            String string;
            String string2 = string = inputStream != null ? FileUtil.loadTextAndClose((InputStream)inputStream) : "";
            if (StringUtil.isNotEmpty((String)string) && (jsonElement = JsonParser.parseString((String)string)).isJsonArray()) {
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                for (JsonElement jsonElement2 : jsonArray) {
                    HttpHeaderDocumentation httpHeaderDocumentation;
                    if (!jsonElement2.isJsonObject() || (httpHeaderDocumentation = HttpHeaderDocumentation.read(jsonElement2.getAsJsonObject())) == null) continue;
                    hashMap.put(httpHeaderDocumentation.getName(), httpHeaderDocumentation);
                }
            }
        }
        catch (IOException iOException) {
            Logger.getInstance(HttpHeadersDictionary.class).error((Throwable)iOException);
        }
        HashMap<String, HttpHeaderDocumentation> hashMap2 = hashMap;
        if (hashMap2 == null) {
            HttpHeadersDictionary.Y(2);
        }
        return hashMap2;
    }

    @NotNull
    public static Collection<String> getHeaderValues(@NotNull Project project, @NotNull String headerName) {
        if (project == null) {
            HttpHeadersDictionary.Y(3);
        }
        if (headerName == null) {
            HttpHeadersDictionary.Y(4);
        }
        if (ourHeaderValues == null) {
            ourHeaderValues = HttpHeadersDictionary.B();
        }
        Collection collection = ourHeaderValues.containsKey(headerName) ? (Collection)ourHeaderValues.get(headerName) : ContainerUtil.emptyList();
        if (collection == null) {
            HttpHeadersDictionary.Y(5);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getHeaderOptionNames(@NotNull String headerName) {
        if (headerName == null) {
            HttpHeadersDictionary.Y(6);
        }
        Collection collection = ourHeaderOptionNames.containsKey(headerName) ? (Collection)ourHeaderOptionNames.get(headerName) : ContainerUtil.emptyList();
        if (collection == null) {
            HttpHeadersDictionary.Y(7);
        }
        return collection;
    }

    @NotNull
    private static Map<String, List<String>> B() {
        List<String> list = Arrays.asList(MimeTypes.PREDEFINED_MIME_VARIANTS);
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("Accept", list);
        hashMap.put("Content-Type", list);
        hashMap.put("Accept-Encoding", ENCODINGS);
        HashMap<String, List<String>> hashMap2 = hashMap;
        if (hashMap2 == null) {
            HttpHeadersDictionary.Y(8);
        }
        return hashMap2;
    }

    static {
        ourHeaderOptionNames = new HashMap<String, List<String>>();
        HEADER_NAME_PATTERN = Pattern.compile("[^:\\r\\n]+");
        ourHeaderOptionNames.put("Content-Type", List.of("charset", "boundary"));
    }

    private static /* synthetic */ void Y(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 1, 3, 4, 6 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/http/HttpHeadersDictionary";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaders";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/http/HttpHeadersDictionary";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readHeaders";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderValues";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderOptionNames";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readHeaderValues";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderValues";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderOptionNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 6 -> new IllegalArgumentException(string);
        };
    }
}

