/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.management;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.FullPathOnTargetKt;
import com.intellij.execution.target.PersistentTargetEnvironmentConfigurationKt;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.jupyter.core.core.api.NotebookDisposable;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.auth.notebook.JupyterNotebookAuthHandler;
import com.intellij.jupyter.core.jupyter.connections.http.HttpSession;
import com.intellij.jupyter.core.jupyter.connections.management.DiscoveredServer;
import com.intellij.jupyter.core.jupyter.connections.management.JupyterServerListener;
import com.intellij.jupyter.py.connections.management.JupyterServerCommandsKt;
import com.intellij.jupyter.py.connections.management.JupyterServerDiscoverer;
import com.intellij.jupyter.py.connections.management.JupyterServerDiscovererKt;
import com.intellij.notebooks.core.ResettingPeriodicalRunner;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.containers.SmartHashSet;
import com.jetbrains.python.sdk.PySdkExtKt;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0086@\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0082@\u00a2\u0006\u0002\u0010\u000eJ0\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/jupyter/py/connections/management/JupyterServerDiscoverer;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "oldDiscoveredServers", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lcom/intellij/jupyter/core/jupyter/connections/management/DiscoveredServer;", "scheduler", "Lcom/intellij/notebooks/core/ResettingPeriodicalRunner;", "", "discover", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setUpdateTimeout", "", "duration", "Ljava/time/Duration;", "discoverImpl", "getConnectionsData", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "jupyterModuleArgument", "", "charset", "Ljava/nio/charset/Charset;", "isServerReallyAvailable", "", "server", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterServerDiscoverer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterServerDiscoverer.kt\ncom/intellij/jupyter/py/connections/management/JupyterServerDiscoverer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,182:1\n774#2:183\n865#2,2:184\n24#3:186\n*S KotlinDebug\n*F\n+ 1 JupyterServerDiscoverer.kt\ncom/intellij/jupyter/py/connections/management/JupyterServerDiscoverer\n*L\n119#1:183\n119#1:184,2\n124#1:186\n*E\n"})
public final class JupyterServerDiscoverer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicReference<Set<DiscoveredServer>> oldDiscoveredServers;
    @NotNull
    private final ResettingPeriodicalRunner<Collection<DiscoveredServer>> scheduler;

    public JupyterServerDiscoverer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.oldDiscoveredServers = new AtomicReference();
        this.scheduler = ResettingPeriodicalRunner.Companion.create$default((ResettingPeriodicalRunner.Companion)ResettingPeriodicalRunner.Companion, (CoroutineScope)((CoroutineScope)NotebookDisposable.Companion.forProject(this.project)), (long)0L, (Function1)((Function1)new Function1<Continuation<? super Collection<? extends DiscoveredServer>>, Object>((Object)this){

            public final Object invoke(Continuation<? super Collection<DiscoveredServer>> $completion) {
                return JupyterServerDiscoverer.access$discoverImpl((JupyterServerDiscoverer)this.receiver, $completion);
            }
        }), (int)2, null);
    }

    @Nullable
    public final Object discover(@NotNull Continuation<? super Collection<DiscoveredServer>> $completion) {
        return BuildersKt.withContext((CoroutineContext)this.scheduler.getScope().getCoroutineContext(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Collection<? extends DiscoveredServer>>, Object>(this, null){
            int label;
            final /* synthetic */ JupyterServerDiscoverer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JupyterServerDiscoverer.access$getScheduler$p(this.this$0).invoke((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Collection<DiscoveredServer>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @TestOnly
    public final void setUpdateTimeout(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        this.scheduler.setTickerPeriodMs(duration.toMillis());
    }

    private final Object discoverImpl(Continuation<? super Collection<DiscoveredServer>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Set<? extends DiscoveredServer>>, Object>(this, null){
            int label;
            final /* synthetic */ JupyterServerDiscoverer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Set goneServers;
                        Set previous;
                        Set addedServers;
                        void destination$iv;
                        void $this$flatMapTo$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Object[] objectArray = new Sdk[]{PySdkExtKt.getPythonSdk((Project)JupyterServerDiscoverer.access$getProject$p(this.this$0))};
                        Collection sdksWithDifferentTargets2 = SequencesKt.toList((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])ModuleManager.Companion.getInstance(JupyterServerDiscoverer.access$getProject$p(this.this$0)).getModules()), (Function1)((Function1)discoverImpl.sdksWithDifferentTargets.1.INSTANCE)))), discoverImpl.2::invokeSuspend$lambda$0), discoverImpl.2::invokeSuspend$lambda$1));
                        Iterable iterable = sdksWithDifferentTargets2;
                        Collection collection = (Collection)new SmartHashSet();
                        JupyterServerDiscoverer jupyterServerDiscoverer = this.this$0;
                        boolean $i$f$flatMapTo = false;
                        for (T element$iv : $this$flatMapTo$iv) {
                            void $this$flatMapTo$iv$iv;
                            Sdk sdk = (Sdk)element$iv;
                            boolean bl = false;
                            Charset charset = Charset.defaultCharset();
                            EmptyProgressIndicator progressIndicator = new EmptyProgressIndicator();
                            Object[] objectArray2 = new String[]{"notebook", "server"};
                            Iterable $this$flatMap$iv = CollectionsKt.listOf((Object[])objectArray2);
                            boolean $i$f$flatMap = false;
                            Iterable iterable2 = $this$flatMap$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$flatMapTo2 = false;
                            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                                String jupyterModuleArgument = (String)element$iv$iv;
                                boolean bl2 = false;
                                Iterable list$iv$iv = JupyterServerDiscoverer.access$getConnectionsData(jupyterServerDiscoverer, (ProgressIndicator)progressIndicator, sdk, jupyterModuleArgument, charset);
                                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                            }
                            Iterable list$iv = (List)destination$iv$iv;
                            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                        }
                        Set actualServers = (Set)destination$iv;
                        Set set = JupyterServerDiscoverer.access$getOldDiscoveredServers$p(this.this$0).getAndSet(actualServers);
                        if (set == null) {
                            set = SetsKt.emptySet();
                        }
                        if (!((Collection)(addedServers = SetsKt.minus((Set)actualServers, (Iterable)(previous = set)))).isEmpty()) {
                            ((JupyterServerListener)JupyterServerDiscoverer.access$getProject$p(this.this$0).getMessageBus().syncPublisher(JupyterServerDiscovererKt.getJUPYTER_SERVER_DISCOVERY_TOPIC())).discovered(addedServers);
                        }
                        if (!((Collection)(goneServers = SetsKt.minus((Set)previous, (Iterable)actualServers))).isEmpty()) {
                            ((JupyterServerListener)JupyterServerDiscoverer.access$getProject$p(this.this$0).getMessageBus().syncPublisher(JupyterServerDiscovererKt.getJUPYTER_SERVER_DISCOVERY_TOPIC())).shutdown(goneServers);
                        }
                        return actualServers;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Set<DiscoveredServer>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final boolean invokeSuspend$lambda$0(Sdk sdk) {
                return PySdkExtKt.getSdkSeemsValid((Sdk)sdk) && PersistentTargetEnvironmentConfigurationKt.isPersistent((TargetEnvironmentConfiguration)PySdkExtKt.getTargetEnvConfiguration((Sdk)sdk));
            }

            private static final TargetEnvironmentConfiguration invokeSuspend$lambda$1(Sdk sdk) {
                return PySdkExtKt.getTargetEnvConfiguration((Sdk)sdk);
            }
        }), $completion);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<DiscoveredServer> getConnectionsData(ProgressIndicator progressIndicator, Sdk sdk, String jupyterModuleArgument, Charset charset) {
        Collection collection;
        TargetEnvironmentConfiguration targetEnvConfiguration = PySdkExtKt.getTargetEnvConfiguration((Sdk)sdk);
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = targetEnvConfiguration;
        if (targetEnvironmentConfiguration == null || (targetEnvironmentConfiguration = targetEnvironmentConfiguration.createEnvironmentRequest(this.project)) == null) {
            targetEnvironmentConfiguration = (TargetEnvironmentRequest)new LocalTargetEnvironmentRequest();
        }
        Pair<TargetEnvironment, TargetedCommandLine> pair = JupyterServerCommandsKt.jupyterListTargetedCommandLine((TargetEnvironmentRequest)targetEnvironmentConfiguration, progressIndicator, sdk, jupyterModuleArgument, this.project);
        TargetEnvironment targetEnvironment = (TargetEnvironment)pair.component1();
        TargetedCommandLine targetCommandLine = (TargetedCommandLine)pair.component2();
        try {
            void $this$filterTo$iv$iv;
            Process process = targetEnvironment.createProcess(targetCommandLine, progressIndicator);
            ProcessOutput processOutput = new CapturingProcessHandler(process, charset, targetCommandLine.getCommandPresentation(targetEnvironment)).runProcess(5000, true);
            Intrinsics.checkNotNull((Object)processOutput);
            Collection<DiscoveredServer> servers = Companion.getConnections(targetEnvConfiguration, processOutput);
            Iterable $this$filter$iv = servers;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DiscoveredServer it = (DiscoveredServer)element$iv$iv;
                boolean bl = false;
                if (!this.isServerReallyAvailable(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        }
        catch (Exception err) {
            Exception exception = err;
            if (!(exception instanceof IOException) && !(exception instanceof ExecutionException)) {
                throw err;
            }
            JupyterServerDiscoverer $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterServerDiscoverer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to get running Jupyter servers using SDK " + sdk, (Throwable)err);
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    private final boolean isServerReallyAvailable(DiscoveredServer server) {
        HttpClients.createDefault();
        new HttpSession.Request(HttpSession.Method.GET, server.getTargetUri(), null, null, null, null, 60, null);
        return true;
    }

    @JvmStatic
    @NotNull
    public static final JupyterServerDiscoverer getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ ResettingPeriodicalRunner access$getScheduler$p(JupyterServerDiscoverer $this) {
        return $this.scheduler;
    }

    public static final /* synthetic */ Object access$discoverImpl(JupyterServerDiscoverer $this, Continuation $completion) {
        return $this.discoverImpl((Continuation<? super Collection<DiscoveredServer>>)$completion);
    }

    public static final /* synthetic */ Project access$getProject$p(JupyterServerDiscoverer $this) {
        return $this.project;
    }

    public static final /* synthetic */ AtomicReference access$getOldDiscoveredServers$p(JupyterServerDiscoverer $this) {
        return $this.oldDiscoveredServers;
    }

    public static final /* synthetic */ Collection access$getConnectionsData(JupyterServerDiscoverer $this, ProgressIndicator progressIndicator, Sdk sdk, String jupyterModuleArgument, Charset charset) {
        return $this.getConnectionsData(progressIndicator, sdk, jupyterModuleArgument, charset);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/py/connections/management/JupyterServerDiscoverer$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/py/connections/management/JupyterServerDiscoverer;", "project", "Lcom/intellij/openapi/project/Project;", "getConnections", "", "Lcom/intellij/jupyter/core/jupyter/connections/management/DiscoveredServer;", "targetEnvConfiguration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "processOutput", "Lcom/intellij/execution/process/ProcessOutput;", "getConnectionParameters", "line", "", "intellij.jupyter.py"})
    @SourceDebugExtension(value={"SMAP\nJupyterServerDiscoverer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterServerDiscoverer.kt\ncom/intellij/jupyter/py/connections/management/JupyterServerDiscoverer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1611#2,9:183\n1863#2:192\n1864#2:194\n1620#2:195\n1#3:193\n1#3:196\n*S KotlinDebug\n*F\n+ 1 JupyterServerDiscoverer.kt\ncom/intellij/jupyter/py/connections/management/JupyterServerDiscoverer$Companion\n*L\n152#1:183,9\n152#1:192\n152#1:194\n152#1:195\n152#1:193\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JupyterServerDiscoverer getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(JupyterServerDiscoverer.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (JupyterServerDiscoverer)object;
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        @NotNull
        public final Collection<DiscoveredServer> getConnections(@Nullable TargetEnvironmentConfiguration targetEnvConfiguration, @NotNull ProcessOutput processOutput) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
            List list = processOutput.getStdoutLines();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStdoutLines(...)");
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                DiscoveredServer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (Companion.getConnectionParameters(targetEnvConfiguration, it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final DiscoveredServer getConnectionParameters(TargetEnvironmentConfiguration targetEnvConfiguration, String line) {
            JupyterConnectionParameters.ServerPath serverPath;
            String token;
            Object v2;
            Object object;
            URI uri;
            String serverPathStr;
            block7: {
                URI uRI2;
                Object object2 = new String[]{" :: "};
                Object it = object2 = StringsKt.split$default((CharSequence)line, (String[])object2, (boolean)false, (int)0, (int)6, null);
                boolean uRI2 = false;
                Object object3 = it.size() == 2 ? object2 : null;
                if (object3 == null) {
                    return null;
                }
                Object object4 = object3;
                String rawUrl = (String)object4.get(0);
                serverPathStr = (String)object4.get(1);
                try {
                    uRI2 = new URI(rawUrl);
                }
                catch (URISyntaxException ignored) {
                    return null;
                }
                uri = uRI2;
                if (!Intrinsics.areEqual((Object)uri.getScheme(), (Object)"http") && !Intrinsics.areEqual((Object)uri.getScheme(), (Object)"https")) {
                    return null;
                }
                List list = URLEncodedUtils.parse((String)uri.getQuery(), (Charset)Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
                object = list;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    NameValuePair it2 = (NameValuePair)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getName(), (Object)"token")) continue;
                    v2 = t;
                    break block7;
                }
                v2 = null;
            }
            NameValuePair nameValuePair = v2;
            String string = token = nameValuePair != null ? nameValuePair.getValue() : null;
            if (targetEnvConfiguration == null) {
                Path path = Path.of(serverPathStr, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                serverPath = (JupyterConnectionParameters.ServerPath)new JupyterConnectionParameters.ServerPath.Local(path);
            } else {
                serverPath = (JupyterConnectionParameters.ServerPath)new JupyterConnectionParameters.ServerPath.Targeted(targetEnvConfiguration, FullPathOnTargetKt.FullPathOnTarget((String)serverPathStr));
            }
            JupyterConnectionParameters.ServerPath serverPath2 = serverPath;
            URIBuilder uRIBuilder = new URIBuilder(uri);
            String string2 = uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            object = new char[1];
            object[0] = 47;
            URI uRI = uRIBuilder.setPath(StringsKt.trimEnd((String)string2, (char[])object)).setCustomQuery(null).build();
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"build(...)");
            return new DiscoveredServer(uRI, new JupyterNotebookAuthHandler(token), serverPath2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

