/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.variables;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterCellExecutionListener;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionTask;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookOfflineSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookRuntimeSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookSessionSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.ManagedJupyterServerNotebookSessionSettings;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.jupyter.core.jupyter.editor.completion.JupyterRuntimeProcessListener;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerFinished;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerState;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerStateListener;
import com.intellij.jupyter.core.jupyter.variables.common.JupyterVarsToolWindowPanel;
import com.intellij.jupyter.core.jupyter.variables.common.NotebookVarsToolWindowPanelProvider;
import com.intellij.jupyter.py.variables.JupyterVariableViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.frame.XValueChildrenList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0002J\b\u0010\u0011\u001a\u00020\rH\u0002J\u0012\u0010\u0012\u001a\u00020\r2\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\rH\u0002J\b\u0010\u0016\u001a\u00020\rH\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\rH\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u0010\u001c\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u00192\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/intellij/jupyter/py/variables/JupyterVariableViewPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterCellExecutionListener;", "Lcom/intellij/jupyter/core/jupyter/editor/completion/JupyterRuntimeProcessListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "initVariableView", "clearVariables", "showMessage", "message", "", "showMessageRunNotebookToSeeVariables", "showMessageForNonNotebookFiles", "addServerStateListener", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "refreshVariablesView", "getCurrentFile", "dispose", "executionStarted", "task", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionTask;", "notebookSessionEnvironmentUpdated", "virtualFile", "values", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterVariableViewPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterVariableViewPanel.kt\ncom/intellij/jupyter/py/variables/JupyterVariableViewPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public final class JupyterVariableViewPanel
extends SimpleToolWindowPanel
implements FileEditorManagerListener,
JupyterCellExecutionListener,
JupyterRuntimeProcessListener,
Disposable {
    @NotNull
    private final Project project;

    public JupyterVariableViewPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(false, true);
        this.project = project;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)this);
        this.project.getMessageBus().connect((Disposable)this).subscribe(JupyterCellExecutionListener.Companion.getTOPIC(), (Object)this);
        this.project.getMessageBus().connect((Disposable)this).subscribe(JupyterRuntimeProcessListener.Companion.getTOPIC(), (Object)this);
        this.initVariableView();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        JComponent jComponent = this.getContent();
        JupyterVarsToolWindowPanel jupyterVarsToolWindowPanel = jComponent instanceof JupyterVarsToolWindowPanel ? (JupyterVarsToolWindowPanel)jComponent : null;
        if (jupyterVarsToolWindowPanel != null) {
            JupyterVarsToolWindowPanel it = jupyterVarsToolWindowPanel;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        this.initVariableView();
    }

    private final void initVariableView() {
        BackedNotebookVirtualFile file;
        VirtualFile virtualFile = this.getCurrentFile();
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            BackedNotebookVirtualFile.Companion companion = BackedNotebookVirtualFile.Companion;
            VirtualFile p0 = virtualFile2;
            boolean $i$f$initVariableView$stub_for_inlining = false;
            boolean bl = false;
            v1 = companion.takeIfBacked(p0);
        } else {
            v1 = file = null;
        }
        if (file != null) {
            if (JupyterRuntimeService.Companion.getInstance(this.project).getRuntime(file.getFile()) != null) {
                this.addServerStateListener(file.getFile());
                JupyterVarsToolWindowPanel toolWindowPanel = NotebookVarsToolWindowPanelProvider.Companion.getAvailableToolWindowPanel(this.project, file);
                toolWindowPanel.rebuildView();
                this.removeAll();
                this.setContent((JComponent)toolWindowPanel);
            } else {
                this.showMessageRunNotebookToSeeVariables();
            }
        } else {
            this.showMessageForNonNotebookFiles();
        }
    }

    private final void clearVariables() {
        this.showMessageRunNotebookToSeeVariables();
    }

    private final void showMessage(@Nls String message2) {
        this.removeAll();
        JLabel label = new JLabel(message2);
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        this.setContent(label);
    }

    private final void showMessageRunNotebookToSeeVariables() {
        this.showMessage(JupyterBundle.message((String)"jupyter.variables.no.jupyter.session.for.file", (Object[])new Object[0]));
    }

    private final void showMessageForNonNotebookFiles() {
        this.showMessage(JupyterBundle.message((String)"jupyter.variables.view.not.a.notebook.file", (Object[])new Object[0]));
    }

    private final void addServerStateListener(VirtualFile file) {
        JupyterNotebookRuntimeSettings settings = JupyterRuntimeService.Companion.getInstance(this.project).getRuntime(file);
        if (settings != null && !(settings instanceof JupyterNotebookOfflineSettings) && !(settings instanceof JupyterNotebookSessionSettings)) {
            if (settings instanceof ManagedJupyterServerNotebookSessionSettings) {
                ((ManagedJupyterServerNotebookSessionSettings)settings).getJupyterServerExecution().addStateListener(new JupyterServerStateListener(file, this){
                    final /* synthetic */ VirtualFile $file;
                    final /* synthetic */ JupyterVariableViewPanel this$0;
                    {
                        this.$file = $file;
                        this.this$0 = $receiver;
                    }

                    public void stateChanged(JupyterServerState newState) {
                        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                        if (!Intrinsics.areEqual((Object)this.$file, (Object)JupyterVariableViewPanel.access$getCurrentFile(this.this$0))) {
                            return;
                        }
                        if (newState instanceof JupyterServerFinished) {
                            ActionsKt.invokeLater((ModalityState)ModalityState.defaultModalityState(), () -> addServerStateListener.1.stateChanged$lambda$0(this.this$0));
                        }
                    }

                    private static final Unit stateChanged$lambda$0(JupyterVariableViewPanel this$0) {
                        JupyterVariableViewPanel.access$clearVariables(this$0);
                        return Unit.INSTANCE;
                    }
                });
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void refreshVariablesView() {
        block1: {
            JComponent jComponent = this.getContent();
            JupyterVarsToolWindowPanel jupyterVarsToolWindowPanel = jComponent instanceof JupyterVarsToolWindowPanel ? (JupyterVarsToolWindowPanel)jComponent : null;
            if (jupyterVarsToolWindowPanel == null) break block1;
            JupyterVarsToolWindowPanel it = jupyterVarsToolWindowPanel;
            boolean bl = false;
            it.rebuildView();
            if (it.getToolbar() != null) {
                it.setToolbar(null);
            }
        }
    }

    private final VirtualFile getCurrentFile() {
        if (this.project.isDisposed()) {
            return null;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        FileEditor fileEditor = fileEditorManager != null ? fileEditorManager.getSelectedEditor() : null;
        JupyterFileEditor jupyterFileEditor = fileEditor instanceof JupyterFileEditor ? (JupyterFileEditor)fileEditor : null;
        if (jupyterFileEditor == null) {
            return null;
        }
        JupyterFileEditor fileEditor2 = jupyterFileEditor;
        return fileEditor2.getNotebookFile();
    }

    public void dispose() {
    }

    public void executionStarted(@NotNull JupyterExecutionTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ActionsKt.invokeAndWaitIfNeeded$default(null, () -> JupyterVariableViewPanel.executionStarted$lambda$2(this), (int)1, null);
    }

    public void notebookSessionEnvironmentUpdated(@NotNull VirtualFile virtualFile, @Nullable XValueChildrenList values) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        ActionsKt.invokeAndWaitIfNeeded$default(null, () -> JupyterVariableViewPanel.notebookSessionEnvironmentUpdated$lambda$3(this), (int)1, null);
    }

    public void executionFinished(@NotNull BackedNotebookVirtualFile notebookVirtualFile) {
        JupyterCellExecutionListener.DefaultImpls.executionFinished((JupyterCellExecutionListener)this, (BackedNotebookVirtualFile)notebookVirtualFile);
    }

    private static final Unit executionStarted$lambda$2(JupyterVariableViewPanel this$0) {
        Unit unit;
        JComponent jComponent;
        JComponent jComponent2 = this$0.getContent();
        if ((jComponent2 instanceof JupyterVarsToolWindowPanel ? (JupyterVarsToolWindowPanel)jComponent2 : null) == null) {
            this$0.initVariableView();
        }
        JupyterVarsToolWindowPanel jupyterVarsToolWindowPanel = (jComponent = this$0.getContent()) instanceof JupyterVarsToolWindowPanel ? (JupyterVarsToolWindowPanel)jComponent : null;
        if (jupyterVarsToolWindowPanel != null) {
            jupyterVarsToolWindowPanel.showInitMessage();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final Unit notebookSessionEnvironmentUpdated$lambda$3(JupyterVariableViewPanel this$0) {
        this$0.refreshVariablesView();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ VirtualFile access$getCurrentFile(JupyterVariableViewPanel $this) {
        return $this.getCurrentFile();
    }

    public static final /* synthetic */ void access$clearVariables(JupyterVariableViewPanel $this) {
        $this.clearVariables();
    }
}

