/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.util.xml.dom.StaxFactory;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.stream.XMLStreamException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.codehaus.stax2.XMLStreamReader2;
import org.jdom.Attribute;
import org.jdom.AttributeList;
import org.jdom.CDATA;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007\u001a\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"buildJdomDocument", "Lorg/jdom/Document;", "stream", "Lorg/codehaus/stax2/XMLStreamReader2;", "buildNsUnawareJdom", "Lorg/jdom/Element;", "reader", "Ljava/io/Reader;", "data", "", "file", "Ljava/nio/file/Path;", "buildNsUnawareJdomAndClose", "buildJdom", "isNsSupported", "", "processElementFragment", "processElement", "intellij.platform.util"})
@ApiStatus.Internal
public final class SafeStAXStreamBuilderKt {
    @ApiStatus.Internal
    @NotNull
    public static final Document buildJdomDocument(@NotNull XMLStreamReader2 stream) throws XMLStreamException {
        Intrinsics.checkNotNullParameter(stream, "stream");
        int state = stream.getEventType();
        if (7 != state) {
            throw new XMLStreamException("JDOM requires that XMLStreamReaders are at their beginning when being processed.");
        }
        Document document = new Document();
        while (state != 8) {
            switch (state) {
                case 7: {
                    document.setBaseURI(stream.getLocation().getSystemId());
                    document.setProperty("ENCODING_SCHEME", stream.getCharacterEncodingScheme());
                    document.setProperty("STANDALONE", String.valueOf(stream.isStandalone()));
                    document.setProperty("ENCODING", stream.getEncoding());
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 11: {
                    break;
                }
                case 1: {
                    document.setRootElement(SafeStAXStreamBuilderKt.processElementFragment(stream, true));
                    break;
                }
                case 4: {
                    String badTxt = stream.getText();
                    if (Verifier.isAllXMLWhitespace(badTxt)) break;
                    throw new XMLStreamException("Unexpected XMLStream event at Document level: CHARACTERS (" + badTxt + ')');
                }
                default: {
                    throw new XMLStreamException("Unexpected XMLStream event at Document level: " + state);
                }
            }
            if (stream.hasNext()) {
                state = stream.next();
                continue;
            }
            throw new XMLStreamException("Unexpected end-of-XMLStreamReader");
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static final Element buildNsUnawareJdom(@NotNull Reader reader) throws XMLStreamException {
        Intrinsics.checkNotNullParameter(reader, "reader");
        try (XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader(reader);){
            Element element = SafeStAXStreamBuilderKt.buildNsUnawareJdomAndClose(xmlStreamReader);
            return element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static final Element buildNsUnawareJdom(@NotNull byte[] data) throws XMLStreamException {
        Intrinsics.checkNotNullParameter(data, "data");
        try (XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader(data);){
            Element element = SafeStAXStreamBuilderKt.buildNsUnawareJdomAndClose(xmlStreamReader);
            return element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static final Element buildNsUnawareJdom(@NotNull Path file) throws XMLStreamException {
        Intrinsics.checkNotNullParameter(file, "file");
        InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(...)");
        try (XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader$default(inputStream, null, 2, null);){
            Element element = SafeStAXStreamBuilderKt.buildNsUnawareJdomAndClose(xmlStreamReader);
            return element;
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static final Element buildNsUnawareJdomAndClose(@NotNull XMLStreamReader2 stream) throws XMLStreamException {
        Intrinsics.checkNotNullParameter(stream, "stream");
        return SafeStAXStreamBuilderKt.buildJdom(stream, false);
    }

    @ApiStatus.Internal
    @NotNull
    public static final Element buildJdom(@NotNull XMLStreamReader2 stream, boolean isNsSupported) throws XMLStreamException {
        Intrinsics.checkNotNullParameter(stream, "stream");
        int state = stream.getEventType();
        if (state != 7) {
            throw new XMLStreamException("JDOM requires that XMLStreamReaders are at their beginning when being processed");
        }
        Element rootElement = null;
        while (state != 8) {
            switch (state) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 11: {
                    break;
                }
                case 1: {
                    rootElement = SafeStAXStreamBuilderKt.processElementFragment(stream, isNsSupported);
                    break;
                }
                default: {
                    throw new XMLStreamException("Unexpected XMLStream event " + state);
                }
            }
            if (stream.hasNext()) {
                state = stream.next();
                continue;
            }
            throw new XMLStreamException("Unexpected end-of-XMLStreamReader");
        }
        if (rootElement == null) {
            return new Element("empty");
        }
        return rootElement;
    }

    private static final Element processElementFragment(XMLStreamReader2 reader, boolean isNsSupported) throws XMLStreamException {
        Element fragment;
        Element current = fragment = SafeStAXStreamBuilderKt.processElement(reader, isNsSupported);
        int depth = 1;
        block8: while (depth > 0 && reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    Element tmp = SafeStAXStreamBuilderKt.processElement(reader, isNsSupported);
                    current.addContent(tmp);
                    current = tmp;
                    ++depth;
                    continue block8;
                }
                case 2: {
                    if (current.getParentElement() == null) {
                        return fragment;
                    }
                    --depth;
                    continue block8;
                }
                case 12: {
                    current.addContent(new CDATA(reader.getText()));
                    continue block8;
                }
                case 6: {
                    continue block8;
                }
                case 4: {
                    if (reader.isWhiteSpace()) continue block8;
                    current.addContent(new Text(reader.getText()));
                    continue block8;
                }
                case 3: 
                case 5: 
                case 9: {
                    continue block8;
                }
            }
            throw new XMLStreamException("Unexpected XMLStream event " + reader.getEventType(), reader.getLocation());
        }
        return fragment;
    }

    private static final Element processElement(XMLStreamReader2 reader, boolean isNsSupported) {
        Element element = new Element(reader.getLocalName(), isNsSupported ? Namespace.getNamespace(reader.getPrefix(), reader.getNamespaceURI()) : Namespace.NO_NAMESPACE);
        int attributeCount = reader.getAttributeCount();
        if (attributeCount != 0) {
            AttributeList list = element.initAttributeList(attributeCount);
            for (int i = 0; i < attributeCount; ++i) {
                list.doAdd(new Attribute(true, reader.getAttributeLocalName(i), reader.getAttributeValue(i), isNsSupported ? Namespace.getNamespace(reader.getAttributePrefix(i), reader.getAttributeNamespace(i)) : Namespace.NO_NAMESPACE));
            }
        }
        if (isNsSupported) {
            int len = reader.getNamespaceCount();
            for (int i = 0; i < len; ++i) {
                element.addNamespaceDeclaration(Namespace.getNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i)));
            }
        }
        return element;
    }
}

