/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.r.inlays;

import com.intellij.notebooks.visualization.r.inlays.InlayDimensions;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.EditorPainter;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0003/01BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00126\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010,\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010.\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u0015\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c0\u001b\u00a2\u0006\u0002\b\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00062"}, d2={"Lcom/intellij/notebooks/visualization/r/inlays/ResizeController;", "Ljava/awt/event/MouseListener;", "Ljava/awt/event/MouseMotionListener;", "component", "Ljavax/swing/JComponent;", "editor", "Lcom/intellij/openapi/editor/Editor;", "deltaSize", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "dx", "dy", "", "<init>", "(Ljavax/swing/JComponent;Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function2;)V", "prevPoint", "Ljava/awt/Point;", "scaleMode", "Lcom/intellij/notebooks/visualization/r/inlays/ResizeController$ScaleMode;", "value", "Lcom/intellij/notebooks/visualization/r/inlays/ResizeController$ResizeState;", "resizeState", "setResizeState", "(Lcom/intellij/notebooks/visualization/r/inlays/ResizeController$ResizeState;)V", "resizeStateDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/notebooks/visualization/r/inlays/ResizeController$ResizeStateListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getResizeStateDispatcher", "()Lcom/intellij/util/EventDispatcher;", "setCursor", "cursor", "Ljava/awt/Cursor;", "mouseReleased", "e", "Ljava/awt/event/MouseEvent;", "mousePressed", "mouseDragged", "mouseInResizeArea", "", "mouseMoved", "mouseExited", "mouseClicked", "mouseEntered", "ResizeStateListener", "ScaleMode", "ResizeState", "intellij.notebooks.visualization"})
public final class ResizeController
implements MouseListener,
MouseMotionListener {
    @NotNull
    private final JComponent component;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Function2<Integer, Integer, Unit> deltaSize;
    @Nullable
    private Point prevPoint;
    @NotNull
    private ScaleMode scaleMode;
    @NotNull
    private ResizeState resizeState;
    @NotNull
    private final EventDispatcher<ResizeStateListener> resizeStateDispatcher;

    public ResizeController(@NotNull JComponent component, @NotNull Editor editor, @NotNull Function2<? super Integer, ? super Integer, Unit> deltaSize) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(deltaSize, (String)"deltaSize");
        this.component = component;
        this.editor = editor;
        this.deltaSize = deltaSize;
        this.scaleMode = ScaleMode.NONE;
        this.resizeState = ResizeState.NONE;
        EventDispatcher eventDispatcher = EventDispatcher.create(ResizeStateListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.resizeStateDispatcher = eventDispatcher;
    }

    private final void setResizeState(ResizeState value) {
        if (this.resizeState != value) {
            this.resizeState = value;
            ((ResizeStateListener)this.resizeStateDispatcher.getMulticaster()).onModeChanged(value);
        }
    }

    @NotNull
    public final EventDispatcher<ResizeStateListener> getResizeStateDispatcher() {
        return this.resizeStateDispatcher;
    }

    private final void setCursor(Cursor cursor) {
        if (!Intrinsics.areEqual((Object)this.component.getCursor(), (Object)cursor)) {
            this.component.setCursor(cursor);
        }
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (EditorPainter.isMarginShown((Editor)this.editor) && this.prevPoint != null) {
            Font font = this.editor.getColorsScheme().getFont(EditorFontType.PLAIN);
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
            Font font2 = font;
            FontRenderContext context = FontInfo.getFontRenderContext((Component)this.editor.getContentComponent());
            FontMetrics fontMetrics = FontInfo.getFontMetrics((Font)font2, (FontRenderContext)context);
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
            FontMetrics fm = fontMetrics;
            float width = FontLayoutService.Companion.getInstance().charWidth2D(fm, 32);
            float rightMargin = (float)this.editor.getSettings().getRightMargin(this.editor.getProject()) * width;
            Point point = this.prevPoint;
            Intrinsics.checkNotNull((Object)point);
            SwingUtilities.convertPointFromScreen(point, this.editor.getContentComponent());
            Point point2 = this.prevPoint;
            Intrinsics.checkNotNull((Object)point2);
            if (Math.abs((float)point2.x - rightMargin) < (float)JBUI.scale((int)40)) {
                int n = (int)rightMargin;
                Point point3 = this.prevPoint;
                Intrinsics.checkNotNull((Object)point3);
                this.deltaSize.invoke((Object)(n - point3.x), (Object)0);
                SwingUtilities.invokeLater(() -> ResizeController.mouseReleased$lambda$0(this));
            }
        }
        this.prevPoint = null;
        this.scaleMode = ScaleMode.NONE;
        this.setResizeState(this.mouseInResizeArea(e) ? ResizeState.HOVER : ResizeState.NONE);
    }

    @Override
    public void mousePressed(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        int correctedHeight = this.component.getHeight() - InlayDimensions.INSTANCE.getBottomBorder();
        if (e.getPoint().y <= correctedHeight) {
            return;
        }
        this.scaleMode = ScaleMode.N;
        this.prevPoint = e.getLocationOnScreen();
        this.setResizeState(ResizeState.RESIZING);
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Point point = this.prevPoint;
        if (point == null) {
            return;
        }
        Point prevPoint = point;
        Point locationOnScreen = e.getLocationOnScreen();
        int dy = this.scaleMode == ScaleMode.N ? locationOnScreen.y - prevPoint.y : 0;
        this.deltaSize.invoke((Object)0, (Object)dy);
        this.prevPoint = locationOnScreen;
    }

    private final boolean mouseInResizeArea(MouseEvent e) {
        return e.getPoint().y > this.component.getHeight() - this.component.getInsets().bottom;
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.scaleMode != ScaleMode.NONE) {
            return;
        }
        boolean canResize = this.mouseInResizeArea(e);
        Cursor cursor = canResize ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(0);
        Intrinsics.checkNotNull((Object)cursor);
        this.setCursor(cursor);
        this.setResizeState(canResize ? ResizeState.HOVER : ResizeState.NONE);
    }

    @Override
    public void mouseExited(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.scaleMode == ScaleMode.NONE) {
            Cursor cursor = Cursor.getPredefinedCursor(0);
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"getPredefinedCursor(...)");
            this.setCursor(cursor);
            this.setResizeState(ResizeState.NONE);
        }
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void mouseEntered(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    private static final void mouseReleased$lambda$0(ResizeController this$0) {
        this$0.component.revalidate();
        this$0.component.repaint();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/notebooks/visualization/r/inlays/ResizeController$ResizeState;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "HOVER", "RESIZING", "intellij.notebooks.visualization"})
    public static final class ResizeState
    extends Enum<ResizeState> {
        public static final /* enum */ ResizeState NONE = new ResizeState();
        public static final /* enum */ ResizeState HOVER = new ResizeState();
        public static final /* enum */ ResizeState RESIZING = new ResizeState();
        private static final /* synthetic */ ResizeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ResizeState[] values() {
            return (ResizeState[])$VALUES.clone();
        }

        public static ResizeState valueOf(String value) {
            return Enum.valueOf(ResizeState.class, value);
        }

        @NotNull
        public static EnumEntries<ResizeState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = resizeStateArray = new ResizeState[]{ResizeState.NONE, ResizeState.HOVER, ResizeState.RESIZING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/intellij/notebooks/visualization/r/inlays/ResizeController$ResizeStateListener;", "Ljava/util/EventListener;", "onModeChanged", "", "newState", "Lcom/intellij/notebooks/visualization/r/inlays/ResizeController$ResizeState;", "intellij.notebooks.visualization"})
    public static interface ResizeStateListener
    extends EventListener {
        public void onModeChanged(@NotNull ResizeState var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/notebooks/visualization/r/inlays/ResizeController$ScaleMode;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "N", "intellij.notebooks.visualization"})
    private static final class ScaleMode
    extends Enum<ScaleMode> {
        public static final /* enum */ ScaleMode NONE = new ScaleMode();
        public static final /* enum */ ScaleMode N = new ScaleMode();
        private static final /* synthetic */ ScaleMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ScaleMode[] values() {
            return (ScaleMode[])$VALUES.clone();
        }

        public static ScaleMode valueOf(String value) {
            return Enum.valueOf(ScaleMode.class, value);
        }

        @NotNull
        public static EnumEntries<ScaleMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = scaleModeArray = new ScaleMode[]{ScaleMode.NONE, ScaleMode.N};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

