/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.visualization.outputs.NotebookOutputComponentFactory;
import com.intellij.notebooks.visualization.outputs.NotebookOutputInlayShowable;
import com.intellij.notebooks.visualization.outputs.impl.CollapsingComponent;
import com.intellij.notebooks.visualization.ui.EditorCellFoldingBar;
import com.intellij.notebooks.visualization.ui.EditorCellOutputsView;
import com.intellij.notebooks.visualization.ui.EditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.NotebookEditorUiUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0007J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J&\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorCellOutputView;", "Lcom/intellij/notebooks/visualization/ui/EditorCellViewComponent;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "component", "Lcom/intellij/notebooks/visualization/outputs/impl/CollapsingComponent;", "toDispose", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/notebooks/visualization/outputs/impl/CollapsingComponent;Lcom/intellij/openapi/Disposable;)V", "value", "", "collapsed", "getCollapsed", "()Z", "setCollapsed", "(Z)V", "folding", "Lcom/intellij/notebooks/visualization/ui/EditorCellFoldingBar;", "getFolding", "()Lcom/intellij/notebooks/visualization/ui/EditorCellFoldingBar;", "getOutputComponent", "Ljavax/swing/JComponent;", "getFoldingBounds", "Lkotlin/Pair;", "", "dispose", "", "doViewportChange", "paintGutter", "yOffset", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "calculateBounds", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nEditorCellOutputView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellOutputView.kt\ncom/intellij/notebooks/visualization/ui/EditorCellOutputView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class EditorCellOutputView
extends EditorCellViewComponent {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final CollapsingComponent component;
    @Nullable
    private final Disposable toDispose;
    @NotNull
    private final EditorCellFoldingBar folding;

    public EditorCellOutputView(@NotNull EditorImpl editor, @NotNull CollapsingComponent component, @Nullable Disposable toDispose) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.editor = editor;
        this.component = component;
        this.toDispose = toDispose;
        this.folding = new EditorCellFoldingBar(this.editor, (Function0<Pair<Integer, Integer>>)((Function0)new Function0<Pair<? extends Integer, ? extends Integer>>((Object)this){

            public final Pair<Integer, Integer> invoke() {
                return EditorCellOutputView.access$getFoldingBounds((EditorCellOutputView)this.receiver);
            }
        }), (Function0<Unit>)((Function0)() -> EditorCellOutputView.folding$lambda$0(this)));
    }

    public final boolean getCollapsed() {
        return !this.component.isSeen();
    }

    public final void setCollapsed(boolean value) {
        this.component.setSeen(!value);
    }

    @NotNull
    public final EditorCellFoldingBar getFolding() {
        return this.folding;
    }

    @TestOnly
    @NotNull
    public final JComponent getOutputComponent() {
        return this.component.getMainComponent();
    }

    private final Pair<Integer, Integer> getFoldingBounds() {
        Rectangle bounds = this.calculateBounds();
        return TuplesKt.to((Object)bounds.y, (Object)bounds.height);
    }

    @Override
    public void dispose() {
        block0: {
            super.dispose();
            this.folding.dispose();
            Disposable disposable = this.toDispose;
            if (disposable == null) break block0;
            Disposable it = disposable;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
    }

    @Override
    public void doViewportChange() {
        JComponent jComponent = this.component.getMainComponent();
        NotebookOutputInlayShowable notebookOutputInlayShowable = jComponent instanceof NotebookOutputInlayShowable ? (NotebookOutputInlayShowable)((Object)jComponent) : null;
        if (notebookOutputInlayShowable == null) {
            return;
        }
        NotebookOutputInlayShowable component = notebookOutputInlayShowable;
        if (!(component instanceof JComponent)) {
            return;
        }
        Rectangle componentRect = SwingUtilities.convertRectangle((Component)((Object)component), ((Component)((Object)component)).getBounds(), this.editor.getScrollPane().getViewport().getView());
        component.setShown(this.editor.getScrollPane().getViewport().getViewRect().intersects(componentRect));
    }

    public final void paintGutter(@NotNull EditorImpl editor, int yOffset, @NotNull Graphics g, @NotNull Rectangle r) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            if (!Intrinsics.areEqual((Object)editor.getUserData(com.intellij.notebooks.ui.NotebookEditorUiUtilKt.isFoldingEnabledKey()), (Object)true)) {
                this.component.paintGutter((EditorEx)editor, yOffset, g);
            }
            JComponent mainComponent = this.component.getMainComponent();
            NotebookOutputComponentFactory.GutterPainter gutterPainter = NotebookOutputComponentFactory.Companion.getGutterPainter(mainComponent);
            if (gutterPainter == null) break block2;
            NotebookOutputComponentFactory.GutterPainter painter = gutterPainter;
            boolean bl = false;
            Integer n = NotebookEditorUiUtilKt.yOffsetFromEditor(mainComponent, (Editor)editor);
            if (n != null) {
                int yOffset2 = ((Number)n).intValue();
                boolean bl2 = false;
                Rectangle bounds = new Rectangle(r.x, yOffset2, r.width, mainComponent.getHeight());
                painter.paintGutter(editor, g, bounds);
            }
        }
    }

    @Override
    @NotNull
    public Rectangle calculateBounds() {
        EditorCellViewComponent editorCellViewComponent = this.getParent();
        EditorCellOutputsView editorCellOutputsView = editorCellViewComponent instanceof EditorCellOutputsView ? (EditorCellOutputsView)editorCellViewComponent : null;
        if (editorCellOutputsView == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        EditorCellOutputsView allCellOutputs = editorCellOutputsView;
        allCellOutputs.getInnerComponent$intellij_notebooks_visualization().validate();
        Object object = allCellOutputs.getInlay$intellij_notebooks_visualization();
        if (object == null || (object = object.getBounds()) == null) {
            object = new Rectangle(0, 0, 0, 0);
        }
        Object inlayBounds = object;
        Point diffBetweenInternalAndExternal = allCellOutputs.getInnerComponent$intellij_notebooks_visualization().getLocation();
        Point location = this.component.getLocation();
        location.translate(inlayBounds.x + diffBetweenInternalAndExternal.x, inlayBounds.y + diffBetweenInternalAndExternal.y);
        return new Rectangle(location, this.component.getSize());
    }

    private static final Unit folding$lambda$0(EditorCellOutputView this$0) {
        this$0.component.setSeen(!this$0.component.isSeen());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Pair access$getFoldingBounds(EditorCellOutputView $this) {
        return $this.getFoldingBounds();
    }
}

