/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables.panel.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridUtilKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.scientific.tables.DSTableDataManager;
import com.intellij.scientific.tables.DSTableDataRetrieverFromDataSourceImpl;
import com.intellij.scientific.tables.NestedTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.api.DSTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.DSTableOutputData;
import com.intellij.scientific.tables.editor.DSTableFileEditor;
import com.intellij.scientific.tables.editor.DSTableVirtualFile;
import com.intellij.scientific.tables.panel.DSTable;
import com.intellij.scientific.tables.panel.DSTableKt;
import com.intellij.scientific.tables.panel.actions.DSOpenInNewTabActionKt;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/scientific/tables/panel/actions/DSOpenInNewTabAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.scientific.tables"})
public final class DSOpenInNewTabAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DSTable table = (DSTable)e.getData(DSTableKt.getDS_TABLE_DATA_KEY());
        FileEditor fileEditor = GridUtilKt.getOuterFileEditor((DataGrid)((DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)));
        boolean isDataSpell = PlatformUtils.isDataSpell();
        DSTableDataType[] dSTableDataTypeArray = new DSTableDataType[]{DSTableDataType.KOTLIN_DATAFRAME, DSTableDataType.EXTERNAL};
        boolean isKotlinTables = CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])dSTableDataTypeArray), (object = table) != null && (object = object.getTableDataRetrieverFromDataSource()) != null ? object.getTableType() : null);
        boolean isShouldBeEnabled = table != null && !(fileEditor instanceof DSTableFileEditor);
        e.getPresentation().setEnabledAndVisible(isShouldBeEnabled && (isDataSpell || isKotlinTables) && !DSOpenInNewTabActionKt.willUsePowerfulTable(table));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DSTableDataRetrieverFromDataSourceImpl dSTableDataRetrieverFromDataSourceImpl;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DSTable dSTable = (DSTable)e.getData(DSTableKt.getDS_TABLE_DATA_KEY());
        if (dSTable == null) {
            return;
        }
        DSTable table = dSTable;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DSTableDataRetrieverFromDataSource v = table.getTableDataRetrieverFromDataSource();
        if (v instanceof NestedTableDataRetrieverFromDataSource) {
            dSTableDataRetrieverFromDataSourceImpl = ((NestedTableDataRetrieverFromDataSource)v).asSimpleTableDataExtractor();
        } else if (v instanceof DSTableDataRetrieverFromDataSourceImpl) {
            dSTableDataRetrieverFromDataSourceImpl = (DSTableDataRetrieverFromDataSourceImpl)v;
        } else {
            return;
        }
        DSTableDataRetrieverFromDataSourceImpl tableDataRetriever = dSTableDataRetrieverFromDataSourceImpl;
        Object object = DSTableDataManager.Companion.getInstance(project2).getStaticTableData(tableDataRetriever.getDataId());
        if (object == null || (object = ((DSTableOutputData)object).getEditorTabName()) == null) {
            object = "Out";
        }
        Object editorTabName = object;
        DSTableVirtualFile file = new DSTableVirtualFile((String)editorTabName, project2, tableDataRetriever);
        FileEditorManager.getInstance((Project)project2).openEditor(new OpenFileDescriptor(project2, (VirtualFile)file), true);
    }
}

