/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.diff;

import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.diff.BatchDiffElement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;

public class BatchDirDiffTableModel
extends DirDiffTableModel {
    private final Project myProject;
    private final PublishConfig myConfig;
    private final Deployable myServer;

    public BatchDirDiffTableModel(@NotNull Project project, DiffElement<?> source, DiffElement<?> target, DirDiffSettings settings, PublishConfig config, Deployable server) {
        if (project == null) {
            BatchDirDiffTableModel.$$$reportNull$$$0(0);
        }
        super(project, source, target, settings);
        this.myProject = project;
        this.myConfig = config;
        this.myServer = server;
    }

    protected void sync(List<DirDiffElementImpl> elements) {
        ArrayList<DirDiffElementImpl> filesToUpload = new ArrayList<DirDiffElementImpl>();
        ArrayList<DirDiffElementImpl> filesToDownload = new ArrayList<DirDiffElementImpl>();
        for (DirDiffElementImpl element : elements) {
            DirDiffOperation operation = element.getOperation();
            if (operation == null) continue;
            if (operation.equals((Object)DirDiffOperation.COPY_FROM)) {
                filesToDownload.add(element);
                continue;
            }
            if (operation.equals((Object)DirDiffOperation.COPY_TO)) {
                filesToUpload.add(element);
                continue;
            }
            this.syncElement(element);
        }
        this.performSync(filesToUpload, filesToDownload, elements);
    }

    private void performSync(final List<DirDiffElementImpl> upload, final List<DirDiffElementImpl> download, List<DirDiffElementImpl> elements) {
        TransferTask.ListBased transferTask = new TransferTask.ListBased(this.myProject, ConnectionOwnerFactory.createConnectionOwner(this.myProject), true, this.myConfig, this.myServer, WDBundle.message("progress.title.uploading", new Object[0]), true, true, true, ProjectDeploymentRevisionTracker.getInstance(this.myProject)){

            public void onSuccess() {
                if (BatchDirDiffTableModel.this.myServer.isUseRsync()) {
                    BatchDirDiffTableModel.this.reloadModel(true);
                }
                LocalFileSystem.getInstance().refresh(true);
            }

            @Override
            @NotNull
            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                String path;
                ArrayList<TransferOperation> transferOperations = new ArrayList<TransferOperation>();
                for (DirDiffElementImpl element : upload) {
                    DiffElement source = element.getSource();
                    if (source == null) continue;
                    path = element.getParentNode().getPath();
                    if (source instanceof BatchDiffElement) {
                        AsyncPromise promise = new AsyncPromise();
                        transferOperations.add(((BatchDiffElement)source).getTransferOperation(BatchDirDiffTableModel.this.myTarget, element.getTarget(), path, (AsyncPromise<DiffElement>)promise));
                        promise.onError(error -> BatchDirDiffTableModel.this.reportException(error.getMessage())).onSuccess(newElement -> BatchDirDiffTableModel.this.refreshAfterCopyTo(element, newElement));
                        continue;
                    }
                    WriteAction.run(() -> {
                        DiffElement diffElement = source.copyTo(BatchDirDiffTableModel.this.myTarget, path);
                        BatchDirDiffTableModel.this.refreshElementAfterCopyTo(diffElement, element);
                    });
                }
                for (DirDiffElementImpl element : download) {
                    DiffElement target = element.getTarget();
                    if (target == null) continue;
                    path = element.getParentNode().getPath();
                    if (target instanceof BatchDiffElement) {
                        BatchDiffElement batchDiffElement = (BatchDiffElement)target;
                        AsyncPromise promise = new AsyncPromise();
                        transferOperations.add(batchDiffElement.getTransferOperation(BatchDirDiffTableModel.this.mySource, element.getSource(), path, (AsyncPromise<DiffElement>)promise));
                        promise.onError(error -> BatchDirDiffTableModel.this.reportException(error.getMessage())).onSuccess(newElement -> BatchDirDiffTableModel.this.refreshAfterCopyFrom(element, newElement));
                        continue;
                    }
                    WriteAction.run(() -> {
                        DiffElement diffElement = BatchDirDiffTableModel.this.myTarget.copyTo(BatchDirDiffTableModel.this.mySource, path);
                        BatchDirDiffTableModel.this.refreshElementAfterCopyTo(diffElement, element);
                    });
                }
                return new TransferTask.ListBased.ResultWithErrors(DeploymentPathUtils.mergeIfNeeded(context, transferOperations), new DeploymentPathUtils.ErrorsAndExclusions());
            }
        };
        ProgressManager.getInstance().run((Task)transferTask);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/diff/BatchDirDiffTableModel", "<init>"));
    }
}

