/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pycharm.pro.customization.pyramid.project;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.pycharm.pro.customization.pyramid.project.PyramidNewProjectSettings;
import com.intellij.python.pyramid.project.PyramidUtils;
import com.intellij.template.lang.core.templateLanguages.TemplatesService;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.sdk.PySdkUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PyramidProjectGenerator {
    private static final Logger LOG = Logger.getInstance(PyramidProjectGenerator.class);
    @NonNls
    private static final String COOKIECUTTER_PACKAGE = "cookiecutter";
    @NonNls
    static final String PYRAMID_PACKAGE = "pyramid";
    @NonNls
    private static final String M_KEY = "-m";
    @NonNls
    private static final String NO_INPUT_KEY = "--no-input";
    @NonNls
    private static final String GH_PYLONS_KEY = "gh:Pylons/pyramid-cookiecutter-starter";
    @NonNls
    private static final String PROJECT_NAME_KEY = "project_name=";
    @NonNls
    private static final String REPO_NAME_KEY = "repo_name=";
    @NonNls
    private static final String TEMPLATE_LANGUAGE_KEY = "template_language=";
    @NonNls
    private static final String BACKEND_KEY = "backend=";

    static void configureProjectImpl(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull PyramidNewProjectSettings settings, @NotNull Module module, @NotNull Sdk sdk2) {
        if (project == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(2);
        }
        if (module == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(3);
        }
        if (sdk2 == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(4);
        }
        PythonProjectGenerator.installFrameworkIfNeeded((Project)project, (String)COOKIECUTTER_PACKAGE, (String)COOKIECUTTER_PACKAGE, (Sdk)sdk2, (boolean)true, () -> {
            if (sdk2.getHomePath() == null) {
                PyramidProjectGenerator.showError(PythonProBundle.message((String)"pyramid.create.project.invalid.interpreter"), project);
                return;
            }
            File tempDir = null;
            try {
                tempDir = FileUtil.generateRandomTemporaryPath();
                boolean created = tempDir.mkdir();
                if (!created) {
                    PyramidProjectGenerator.showError(PythonProBundle.message((String)"pyramid.create.project.failed.to.create.temp.dir"), project);
                    return;
                }
                LOG.info("Created temp directory " + tempDir);
                List<String> command = PyramidProjectGenerator.createCookiecutterCommand(baseDir, settings);
                GeneralCommandLine cmd = new GeneralCommandLine().withExePath(sdk2.getHomePath()).withParameters(command);
                ProcessOutput output = PySdkUtil.getProcessOutput((GeneralCommandLine)cmd, (String)tempDir.getPath(), (Map)PySdkUtil.activateVirtualEnv((Sdk)sdk2), (int)10000);
                if (output.getStderr().isEmpty()) {
                    File rootRepoFile = tempDir.listFiles()[0];
                    for (File file : rootRepoFile.listFiles()) {
                        file.renameTo(Paths.get(baseDir.getPath(), file.getName()).toFile());
                    }
                } else {
                    PyramidProjectGenerator.showError(output.getStderr(), project);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                PyramidProjectGenerator.showError(PythonProBundle.message((String)"pyramid.create.project.failed.to.initialize"), project);
            }
            finally {
                if (tempDir != null) {
                    boolean deleted = FileUtil.delete((File)tempDir);
                    if (deleted) {
                        LOG.info("Temp dir removed: " + tempDir);
                    } else {
                        LOG.warn("Failed to remove temp directory: " + tempDir);
                    }
                }
            }
        });
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            VirtualFile templatesFolderVfs;
            baseDir.refresh(false, true);
            TemplatesService service = TemplatesService.getInstance((Module)module);
            service.setTemplateLanguage(settings.getTemplateLanguage());
            String templatesFolder = settings.getTemplatesFolder();
            if (templatesFolder != null && (templatesFolderVfs = baseDir.findChild(templatesFolder)) != null) {
                service.setTemplateFolders(new VirtualFile[]{templatesFolderVfs});
            }
            PyramidUtils.createRunConfigurations((Module)module, (VirtualFile)baseDir);
            ApplicationManager.getApplication().invokeLater(() -> {
                PsiFile readme;
                PsiDirectory baseDirPsi = PsiManager.getInstance((Project)project).findDirectory(baseDir);
                if (baseDirPsi != null && (readme = baseDirPsi.findFile("README.txt")) != null) {
                    readme.navigate(true);
                }
            });
        });
    }

    @NotNull
    private static List<String> createCookiecutterCommand(@NotNull VirtualFile baseDir, @NotNull PyramidNewProjectSettings settings) {
        if (baseDir == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(6);
        }
        List<String> list = Arrays.asList(M_KEY, COOKIECUTTER_PACKAGE, NO_INPUT_KEY, GH_PYLONS_KEY, PROJECT_NAME_KEY + settings.getProjectName(), REPO_NAME_KEY + baseDir.getName(), TEMPLATE_LANGUAGE_KEY + settings.getTemplateLanguage().getTemplateLanguageName().toLowerCase(), BACKEND_KEY + settings.getBackend().toLowerCase());
        if (list == null) {
            PyramidProjectGenerator.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static void showError(String errorMessage, Project project) {
        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)PythonProBundle.message((String)"pyramid.create.project.error", (Object[])new Object[]{errorMessage}), (String)PythonProBundle.message((String)"pyramid.create.project")));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/pycharm/pro/customization/pyramid/project/PyramidProjectGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/pycharm/pro/customization/pyramid/project/PyramidProjectGenerator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCookiecutterCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureProjectImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCookiecutterCommand";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

