/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.cython.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.python.pro.cython.CythonResolveUtil;
import com.intellij.python.pro.cython.psi.CythonFile;
import com.intellij.python.pro.cython.psi.CythonNameDecl;
import com.intellij.python.pro.cython.psi.CythonNamedElement;
import com.intellij.python.pro.cython.psi.CythonProperty;
import com.intellij.python.pro.cython.psi.CythonPsiUtil;
import com.intellij.python.pro.cython.psi.CythonScopeOwner;
import com.intellij.python.pro.cython.psi.CythonVariableList;
import com.intellij.python.pro.cython.psi.elementTypes.CythonElementTypes;
import com.intellij.python.pro.cython.types.CythonClassType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.stubs.PyClassStub;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CythonClass
extends PyClassImpl
implements CythonNamedElement,
CythonScopeOwner {
    public CythonClass(ASTNode astNode) {
        super(astNode);
    }

    public CythonClass(PyClassStub stub) {
        super(stub, (IStubElementType)CythonElementTypes.CLASS_DECLARATION);
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            CythonClass.$$$reportNull$$$0(0);
        }
        return CythonPsiUtil.setName(this, name);
    }

    public ASTNode getNameNode() {
        return CythonPsiUtil.getNameNode(this);
    }

    @Override
    @Nullable
    public CythonNameDecl getNameDecl() {
        return (CythonNameDecl)((Object)this.findChildByClass(CythonNameDecl.class));
    }

    @Override
    public boolean isForwardDeclaration() {
        return this.getStatementList().getStatements().length == 0;
    }

    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            CythonClass.$$$reportNull$$$0(1);
        }
        if (key == null) {
            CythonClass.$$$reportNull$$$0(2);
        }
        return new CythonClassType(this, true);
    }

    public String toString() {
        return "CythonClass: " + this.getName();
    }

    @Override
    public List<? extends CythonNamedElement> getCythonNamedElements() {
        return this.getCythonAttributes();
    }

    public List<CythonNamedElement> getCythonAttributes() {
        PsiElement defition;
        CythonFile implicit;
        ArrayList<CythonNamedElement> results = new ArrayList<CythonNamedElement>();
        for (PyStatement stmt : this.getStatementList().getStatements()) {
            if (stmt instanceof CythonVariableList) {
                results.addAll(((CythonVariableList)stmt).getVariables());
                continue;
            }
            if (!(stmt instanceof CythonProperty)) continue;
            results.add((CythonProperty)stmt);
        }
        if (results.isEmpty() && (implicit = CythonResolveUtil.findImplicitDefinitionFile((PsiElement)this)) != null && (defition = implicit.getElementNamed(this.getName())) instanceof CythonClass) {
            return ((CythonClass)defition).getCythonAttributes();
        }
        return results;
    }

    public boolean isCppClass() {
        for (PsiElement t : this.findChildrenByType((IElementType)PyTokenTypes.IDENTIFIER)) {
            if (!"cppclass".equals(t.getText())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/pro/cython/psi/CythonClass";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

