/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter;

import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.remoteInterpreter.PyVagrantTargetEnvironmentFactoryKt;
import com.intellij.python.remoteInterpreter.target.HelpersAwareSshTargetEnvironmentRequest;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsType;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshRemoteEnvironmentRequest;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetEnvironmentConfigurationBase;
import com.jetbrains.plugins.remotesdk.target.vagrant.VagrantEnvironmentConfiguration;
import com.jetbrains.plugins.remotesdk.target.vagrant.VagrantEnvironmentRequest;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.sdk.add.v1.TargetPanelExtension;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0014H\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\f\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J&\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001bH\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0014H\u0016\u00a8\u0006!"}, d2={"Lcom/intellij/python/remoteInterpreter/PyVagrantTargetEnvironmentFactory;", "Lcom/jetbrains/python/run/PythonInterpreterTargetEnvironmentFactory;", "<init>", "()V", "getPythonTargetInterpreter", "Lcom/intellij/python/remoteInterpreter/target/HelpersAwareSshTargetEnvironmentRequest;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "buildRemoteSdkCredentials", "Lcom/intellij/remote/RemoteCredentials;", "configuration", "Lcom/jetbrains/plugins/remotesdk/target/vagrant/VagrantEnvironmentConfiguration;", "produceRemoteCredentials", "sdkAdditionalData", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalData;", "packageManagementSupported", "", "evConfiguration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "(Lcom/intellij/execution/target/TargetEnvironmentConfiguration;)Ljava/lang/Boolean;", "isFor", "isMutable", "getTargetType", "Lcom/intellij/execution/target/TargetEnvironmentType;", "getDefaultSdkName", "", "data", "Lcom/jetbrains/python/target/PyTargetAwareAdditionalData;", "version", "getPanelExtension", "Lcom/jetbrains/python/sdk/add/v1/TargetPanelExtension;", "intellij.python.remoteInterpreter"})
public final class PyVagrantTargetEnvironmentFactory
implements PythonInterpreterTargetEnvironmentFactory {
    @Nullable
    public HelpersAwareSshTargetEnvironmentRequest getPythonTargetInterpreter(@NotNull Sdk sdk, @NotNull Project project) {
        HelpersAwareSshTargetEnvironmentRequest helpersAwareSshTargetEnvironmentRequest;
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
        if (sdkAdditionalData instanceof PyTargetAwareAdditionalData) {
            TargetEnvironmentConfiguration targetEnvironmentConfiguration = ((PyTargetAwareAdditionalData)sdkAdditionalData).getTargetEnvironmentConfiguration();
            TargetEnvironmentRequest targetEnvironmentRequest = targetEnvironmentConfiguration != null ? targetEnvironmentConfiguration.createEnvironmentRequest(project) : null;
            VagrantEnvironmentRequest vagrantEnvironmentRequest = targetEnvironmentRequest instanceof VagrantEnvironmentRequest ? (VagrantEnvironmentRequest)targetEnvironmentRequest : null;
            if (vagrantEnvironmentRequest != null) {
                VagrantEnvironmentRequest it = vagrantEnvironmentRequest;
                boolean bl = false;
                RemoteCredentials credentials = this.buildRemoteSdkCredentials(it.getConfiguration());
                helpersAwareSshTargetEnvironmentRequest = new HelpersAwareSshTargetEnvironmentRequest((TargetEnvironmentRequest)it, credentials, (RemoteSdkProperties)sdkAdditionalData);
            } else {
                helpersAwareSshTargetEnvironmentRequest = null;
            }
        } else if (sdkAdditionalData instanceof PyRemoteSdkAdditionalData) {
            Ref.ObjectRef request2 = new Ref.ObjectRef();
            CredentialsCase[] credentialsCaseArray = new CredentialsCase[]{CredentialsCase.create((CredentialsType)((CredentialsType)VagrantCredentialsType.Companion.getInstance()), arg_0 -> PyVagrantTargetEnvironmentFactory.getPythonTargetInterpreter$lambda$2(request2, project, arg_0))};
            ((PyRemoteSdkAdditionalData)sdkAdditionalData).connectionCredentials().switchType(credentialsCaseArray);
            VagrantEnvironmentRequest vagrantEnvironmentRequest = (VagrantEnvironmentRequest)request2.element;
            if (vagrantEnvironmentRequest != null) {
                VagrantEnvironmentRequest targetEnvironmentFactory = vagrantEnvironmentRequest;
                boolean bl = false;
                helpersAwareSshTargetEnvironmentRequest = new HelpersAwareSshTargetEnvironmentRequest((TargetEnvironmentRequest)targetEnvironmentFactory, this.produceRemoteCredentials((PyRemoteSdkAdditionalData)sdkAdditionalData), (RemoteSdkProperties)sdkAdditionalData);
            } else {
                helpersAwareSshTargetEnvironmentRequest = null;
            }
        } else {
            helpersAwareSshTargetEnvironmentRequest = null;
        }
        return helpersAwareSshTargetEnvironmentRequest;
    }

    private final RemoteCredentials buildRemoteSdkCredentials(VagrantEnvironmentConfiguration configuration) {
        String string = configuration.getVagrantFolder();
        if (string == null) {
            throw new IllegalStateException("Vagrant folder must be specified");
        }
        String vagrantFolder = string;
        VagrantBasedCredentialsHolder vagrantCredentials = new VagrantBasedCredentialsHolder(vagrantFolder, configuration.getMachineName());
        PyRemoteSdkAdditionalData sdkAdditionalData = new PyRemoteSdkAdditionalData("");
        sdkAdditionalData.setCredentials(VagrantCredentialsType.Companion.getInstance().getCredentialsKey(), (Object)vagrantCredentials);
        return this.produceRemoteCredentials(sdkAdditionalData);
    }

    private final RemoteCredentials produceRemoteCredentials(PyRemoteSdkAdditionalData sdkAdditionalData) {
        Ref.ObjectRef remoteCredentials = new Ref.ObjectRef();
        sdkAdditionalData.produceRemoteCredentials(null, true, arg_0 -> PyVagrantTargetEnvironmentFactory.produceRemoteCredentials$lambda$4(remoteCredentials, arg_0));
        RemoteCredentials remoteCredentials2 = (RemoteCredentials)remoteCredentials.element;
        if (remoteCredentials2 == null) {
            throw new IllegalStateException("SSH credentials cannot be obtained");
        }
        return remoteCredentials2;
    }

    @Nullable
    public Boolean packageManagementSupported(@NotNull TargetEnvironmentConfiguration evConfiguration) {
        Intrinsics.checkNotNullParameter((Object)evConfiguration, (String)"evConfiguration");
        return evConfiguration instanceof VagrantEnvironmentConfiguration ? Boolean.valueOf(false) : null;
    }

    public boolean isFor(@NotNull TargetEnvironmentConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return configuration instanceof VagrantEnvironmentConfiguration;
    }

    @Nullable
    public Boolean isMutable(@NotNull TargetEnvironmentConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return Intrinsics.areEqual((Object)configuration.getTypeId(), (Object)"vagrant") ? Boolean.valueOf(true) : null;
    }

    @NotNull
    public TargetEnvironmentType<?> getTargetType() {
        return (TargetEnvironmentType)PyVagrantTargetEnvironmentFactoryKt.access$getVagrantTargetType();
    }

    @Nullable
    public String getDefaultSdkName(@Nullable Project project, @NotNull PyTargetAwareAdditionalData data, @Nullable String version) {
        String string;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = data.getTargetEnvironmentConfiguration();
        VagrantEnvironmentConfiguration vagrantEnvironmentConfiguration = targetEnvironmentConfiguration instanceof VagrantEnvironmentConfiguration ? (VagrantEnvironmentConfiguration)targetEnvironmentConfiguration : null;
        if (vagrantEnvironmentConfiguration != null) {
            VagrantEnvironmentConfiguration conf = vagrantEnvironmentConfiguration;
            boolean bl = false;
            String pathRelativeToHome = FileUtil.getLocationRelativeToUserHome((String)conf.getVagrantFolder());
            Object[] objectArray = new Object[4];
            objectArray[0] = conf.getMachineName();
            objectArray[1] = StringUtil.isNotEmpty((String)conf.getMachineName()) ? 0 : 1;
            String string2 = conf.getVagrantFolder();
            objectArray[2] = pathRelativeToHome.length() < (string2 != null ? string2.length() : 0) ? pathRelativeToHome : conf.getVagrantFolder();
            objectArray[3] = data.getInterpreterPath();
            String string3 = IdeBundle.message((String)"vagrant.vm.1.choice.0.0.1.at.2.3", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            String vagrantDetails = string3;
            String string4 = version;
            if (string4 == null) {
                string4 = "unknown interpreter";
            }
            string = "Remote " + string4 + " " + vagrantDetails;
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public TargetPanelExtension getPanelExtension(@NotNull Project project, @NotNull TargetEnvironmentConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return null;
    }

    private static final void getPythonTargetInterpreter$lambda$2(Ref.ObjectRef $request, Project $project, VagrantBasedCredentialsHolder it) {
        VagrantEnvironmentConfiguration vagrantEnvironmentConfiguration;
        VagrantEnvironmentConfiguration $this$getPythonTargetInterpreter_u24lambda_u242_u24lambda_u241 = vagrantEnvironmentConfiguration = new VagrantEnvironmentConfiguration();
        boolean bl = false;
        $this$getPythonTargetInterpreter_u24lambda_u242_u24lambda_u241.setVagrantFolder(it.getVagrantFolder());
        $this$getPythonTargetInterpreter_u24lambda_u242_u24lambda_u241.setMachineName(it.getMachineName());
        VagrantEnvironmentConfiguration config2 = vagrantEnvironmentConfiguration;
        $request.element = new VagrantEnvironmentRequest(config2, new SshRemoteEnvironmentRequest($project, (SshTargetEnvironmentConfigurationBase)config2, config2.getGuestMachinePlatform()));
    }

    private static final void produceRemoteCredentials$lambda$4(Ref.ObjectRef $remoteCredentials, RemoteCredentials it) {
        $remoteCredentials.element = it;
    }
}

