/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter.packaging;

import com.google.common.collect.Collections2;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.remoteInterpreter.PyHelpersUpload;
import com.intellij.python.remoteInterpreter.PyRemoteProcessUtil;
import com.intellij.python.remoteInterpreter.PythonRemoteInterpreterBundle;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.VagrantNotStartedException;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.plugins.remotesdk.RemoteSdkSessionUtil;
import com.jetbrains.plugins.remotesdk.SshCredentialsUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyExecutionFix;
import com.jetbrains.python.packaging.PyPackageManagerImpl;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemotePackageManagerImpl
extends PyPackageManagerImpl {
    private static final Logger LOG = Logger.getInstance(PyRemotePackageManagerImpl.class);

    PyRemotePackageManagerImpl(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(0);
        }
        super(sdk);
    }

    protected boolean shouldSubscribeToLocalChanges() {
        return false;
    }

    @Nullable
    protected String getHelperPath(@NotNull String helper2) throws ExecutionException {
        Sdk sdk;
        SdkAdditionalData sdkData;
        if (helper2 == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(1);
        }
        if ((sdkData = (sdk = this.getSdk()).getSdkAdditionalData()) instanceof PyRemoteSdkAdditionalDataBase) {
            PyRemoteSdkAdditionalDataBase remoteSdkData = (PyRemoteSdkAdditionalDataBase)sdkData;
            try {
                String helpersPath;
                if (SshCredentialsUtil.producesSshSdkCredentials((RemoteSdkAdditionalData)remoteSdkData)) {
                    remoteSdkData.getRemoteCredentials(null, false);
                }
                if (!StringUtil.isEmpty((String)(helpersPath = remoteSdkData.getHelpersPath()))) {
                    return RemoteFile.createRemoteFile((String)helpersPath, (String)helper2).getPath();
                }
                return null;
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            catch (ExecutionException e) {
                throw PyRemotePackageManagerImpl.analyzeException(e, helper2, Collections.emptyList());
            }
        }
        return null;
    }

    @NotNull
    protected ProcessOutput getPythonProcessOutput(@NotNull String helperPath, @NotNull List<String> args, boolean askForSudo, boolean showProgress, @Nullable String workingDir, @Nullable List<String> pyArgs) throws ExecutionException {
        Sdk sdk;
        String homePath;
        if (helperPath == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(2);
        }
        if (args == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(3);
        }
        if ((homePath = (sdk = this.getSdk()).getHomePath()) == null) {
            throw new ExecutionException(PythonRemoteInterpreterBundle.message("remote.interpreter.cannot.find.python.interpreter.for.sdk", sdk.getName()));
        }
        SdkAdditionalData sdkData = sdk.getSdkAdditionalData();
        if (sdkData instanceof PyRemoteSdkAdditionalDataBase) {
            ProcessOutput processOutput;
            RemoteCredentials remoteCredentials;
            PyRemoteSdkAdditionalDataBase pySdkData = (PyRemoteSdkAdditionalDataBase)sdkData;
            try {
                remoteCredentials = pySdkData.getRemoteCredentials(null, false);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
                remoteCredentials = null;
            }
            catch (ExecutionException e) {
                throw PyRemotePackageManagerImpl.analyzeException(e, helperPath, args);
            }
            if (remoteCredentials != null) {
                if (askForSudo) {
                    askForSudo = !PyRemotePackageManagerImpl.ensureCanWrite(remoteCredentials, (RemoteSdkProperties)pySdkData);
                }
            } else {
                throw new PyExecutionException(PyBundle.message((String)"remote.interpreter.failed.to.obtain.credentials", (Object[])new Object[]{sdk.getName()}), helperPath, args);
            }
            ArrayList<String> cmdline = new ArrayList<String>();
            cmdline.add(homePath);
            cmdline.add(RemoteFile.createRemoteFile((String)helperPath, (boolean)RemoteFile.isWindowsPath((String)homePath)).getPath());
            cmdline.addAll(Collections2.transform(args, input -> PyRemotePackageManagerImpl.quoteIfNeeded(input)));
            do {
                PyRemotePathMapper pathMapper = PyRemotePackageManagerImpl.setupPathMappings(pySdkData, null);
                try {
                    processOutput = PyRemotePackageManagerImpl.getSshProcessOutput(cmdline, workingDir, pySdkData, pathMapper, askForSudo, helperPath);
                }
                catch (InterruptedException e) {
                    throw new ExecutionException((Throwable)e);
                }
            } while (askForSudo && processOutput.getStderr().contains("sudo: 3 incorrect password attempts"));
            ProcessOutput processOutput2 = processOutput;
            if (processOutput2 == null) {
                PyRemotePackageManagerImpl.$$$reportNull$$$0(4);
            }
            return processOutput2;
        }
        throw new PyExecutionException(PythonRemoteInterpreterBundle.message("python.remote.package.manager.invalid.remote.sdk", new Object[0]), helperPath, args);
    }

    private static boolean ensureCanWrite(RemoteCredentials credentials, RemoteSdkProperties sdkProperties) {
        boolean bl;
        block11: {
            ConnectionOwnerFactory.createConnectionOwnerWithDialogMessages(null);
            ConnectionBuilder builder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)credentials).withConnectionTimeout(60L);
            SftpChannel sftp = builder.openSftpChannel(60);
            try {
                RemoteFileObject fileObject = sftp.file(sdkProperties.getInterpreterPath());
                boolean bl2 = bl = (fileObject.getPermissions() & 0x80) != 0 && fileObject.getUId() != 0;
                if (sftp == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (sftp != null) {
                            try {
                                sftp.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                catch (Exception e) {
                    return true;
                }
            }
            sftp.close();
        }
        return bl;
    }

    private static ProcessOutput getSshProcessOutput(List<String> cmdline, @Nullable String workingDir, PyRemoteSdkAdditionalDataBase sdkAdditionalData, PyRemotePathMapper pathMapper, boolean askForSudo, String helperPath) throws ExecutionException, InterruptedException {
        String[] command = ArrayUtilRt.toStringArray(cmdline);
        PyRemotePathMapper mapper = PyRemotePackageManagerImpl.setupPathMappings(sdkAdditionalData, pathMapper);
        RemoteCredentials credentials = sdkAdditionalData.getRemoteCredentials(null, true);
        Set<String> helpersPaths = Set.of(mapper.convertToLocal(helperPath));
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)credentials, null);
        RemoteSdkSessionUtil.checkConnection((ConnectionBuilder)connectionBuilder, null);
        PyHelpersUpload.uploadHelpersSync(null, credentials, (RemoteSdkProperties)sdkAdditionalData, helpersPaths);
        return PyRemoteProcessUtil.getProcessOutput(connectionBuilder, credentials, (RemoteSdkProperties)sdkAdditionalData, pathMapper, command, workingDir, askForSudo);
    }

    private static PyRemotePathMapper setupPathMappings(PyRemoteSdkAdditionalDataBase sdkAdditionalData, PyRemotePathMapper pathMapper) {
        return PythonRemoteInterpreterManager.appendBasicMappings(null, (PyRemotePathMapper)pathMapper, (RemoteSdkAdditionalData)sdkAdditionalData);
    }

    private static ExecutionException analyzeException(ExecutionException exception, String command, List<String> args) {
        Throwable cause = exception.getCause();
        if (cause instanceof VagrantNotStartedException) {
            VagrantNotStartedException vse = (VagrantNotStartedException)cause;
            List<LaunchVagrantFix> fixes = List.of(new LaunchVagrantFix(vse.getVagrantFolder(), vse.getMachineName()));
            return new PyExecutionException(PythonRemoteInterpreterBundle.message("python.remote.package.manger.vagrant.instance.down", new Object[0]), command, args, "", "", 0, fixes);
        }
        return exception;
    }

    protected void installManagement(@NotNull String name) throws ExecutionException {
        if (name == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(5);
        }
        super.installManagement(name);
    }

    private static String quoteIfNeeded(String arg) {
        return arg.replace("<", "\\<").replace(">", "\\>");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helperPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/remoteInterpreter/packaging/PyRemotePackageManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/remoteInterpreter/packaging/PyRemotePackageManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonProcessOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHelperPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPythonProcessOutput";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installManagement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static class LaunchVagrantFix
    implements PyExecutionFix {
        private final String myVagrantFolder;
        @Nullable
        private final String myMachineName;

        LaunchVagrantFix(String vagrantFolder, @Nullable String machineName) {
            this.myVagrantFolder = vagrantFolder;
            this.myMachineName = machineName;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = PythonRemoteInterpreterBundle.message("launch.vagrant.fix.name", new Object[0]);
            if (string == null) {
                LaunchVagrantFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void run(@NotNull Sdk sdk) {
            PythonRemoteInterpreterManager manager;
            if (sdk == null) {
                LaunchVagrantFix.$$$reportNull$$$0(1);
            }
            if ((manager = PythonRemoteInterpreterManager.getInstance()) != null) {
                try {
                    manager.runVagrant(this.myVagrantFolder, this.myMachineName);
                    PythonSdkType.getInstance().setupSdkPaths(sdk);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/python/remoteInterpreter/packaging/PyRemotePackageManagerImpl$LaunchVagrantFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/python/remoteInterpreter/packaging/PyRemotePackageManagerImpl$LaunchVagrantFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

