/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.panel.datawrangler.actions;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridPanel;
import com.intellij.database.datagrid.GridUtilKt;
import com.intellij.database.datagrid.RemovableView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.scientific.py.tables.panel.datawrangler.DataWranglerMainPanel;
import com.intellij.scientific.py.tables.panel.datawrangler.DataWranglerMainPanelKt;
import com.intellij.scientific.tables.editor.DSTableFileEditor;
import com.intellij.scientific.tables.panel.DSTable;
import com.intellij.scientific.tables.panel.DSTableKt;
import com.intellij.scientific.tables.panel.DSTableWithStatistics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/scientific/py/tables/panel/datawrangler/actions/DSOpenDataWranglerAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getDWPanel", "Lcom/intellij/scientific/py/tables/panel/datawrangler/DataWranglerMainPanel;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "table", "Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;", "intellij.scientific.py.tables"})
public final class DSOpenDataWranglerAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DSTable table = (DSTable)e.getData(DSTableKt.getDS_TABLE_DATA_KEY());
        DSTable dSTable = table;
        boolean isDynamicTable = dSTable != null && (dSTable = dSTable.getTableDataRetrieverFromDataSource()) != null ? dSTable.isDynamicTable() : false;
        boolean isEnabledByRegistry = Registry.Companion.is("tables.datawrangler.show.internal.action");
        e.getPresentation().setEnabledAndVisible(isEnabledByRegistry && table != null && isDynamicTable && table instanceof DSTableWithStatistics && GridUtilKt.getOuterFileEditor((DataGrid)((DSTableWithStatistics)table).getGrid()) instanceof DSTableFileEditor);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DSTable dSTable = (DSTable)e.getData(DSTableKt.getDS_TABLE_DATA_KEY());
        if (dSTable == null) {
            return;
        }
        DSTable table = dSTable;
        DSTableWithStatistics dSTableWithStatistics = table instanceof DSTableWithStatistics ? (DSTableWithStatistics)table : null;
        if (dSTableWithStatistics == null || (dSTableWithStatistics = dSTableWithStatistics.getGrid()) == null) {
            return;
        }
        DSTableWithStatistics grid2 = dSTableWithStatistics;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataWranglerMainPanel dwPanel = this.getDWPanel(dataContext, (DataGrid)grid2, (DSTableWithStatistics)table);
        grid2.getPanel().putSideView((RemovableView)dwPanel, GridPanel.ViewPosition.RIGHT, null);
    }

    private final DataWranglerMainPanel getDWPanel(DataContext dataContext, DataGrid grid2, DSTableWithStatistics table) {
        DataWranglerMainPanel dwPanel = DataWranglerMainPanelKt.findDataWranglerMainPanel(dataContext);
        if (dwPanel == null) {
            dwPanel = new DataWranglerMainPanel(grid2, table);
            Disposer.register((Disposable)((Disposable)grid2), (Disposable)dwPanel);
        }
        return dwPanel;
    }
}

